; virtual.lsp              Gordon S. Novak Jr.              ; 12 Sep 06

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; derived from {DSK}<LISPFILES>VIRTUAL.CL;1 30-Aug-89 ; SAVE VIRTUAL STUFF 

; modify GLDOEXPR to call GLDOVIRTUAL.
; add  (codetuple (glcodetuplestrfn ind des deslist)) to case in glstrfn.

; 23 Dec 93; 05 Jan 95; 06 Jun 95; 02 Jan 97; 07 Jan 04

(defvar *glvirtualb-getf-value*)

; edited: 11-Sep-87
; Retrieve data from a CODETUPLE pseudo-structure 
(defun glcodetuplestrfn (ind des deslist)     (declare (ignore deslist))
  (let (tmp)
    (if (setq tmp (assoc ind (cdr des)))
	(if (atom (cadr tmp))
	    (cons (list 'prog1 (cadr tmp))
		  (cddr tmp))
	    (cdr tmp)))))


; edited: 11-Sep-87 -- old version, commented out:
; Process a statement of the form (VIRTUAL <type> WITH <prop> = <expr> ...) 
;(defun gldovirtual (*glexpr* *glcontext*)
;  (let (newtype)
;    (setq newtype (glgetvtype (cdr *glexpr*) *glcontext*))
;    (list nil newtype)))

; 22 Oct 90; 22 Dec 93; 23 Dec 93
; Process a statement of the form (VIRTUAL <type> WITH <prop> = <expr> ...) 
(defun gldovirtual (*glexpr* *glcontext*)
  (let (type)
    (setq type (glxtrtype (glevalstr (cadr *glexpr*) *glcontext*)))
    (gldoviewas (cons nil (cons nil (cons type (cddr *glexpr*))))
		*glcontext*) ))

; edited: 11-Sep-87
; Process the tail of an expression that describes a virtual type.
; A virtual type is a collection of property names and corresponding 
; expressions that are collectively to be viewed as being of the virtual type. 
; Syntax of expr is (... <type> WITH <prop> = <expr> ...) 
(defun glgetvtype (*glexpr* *glcontext*)
  (prog (newtype viewtype slot tmp pairs)
    (setq viewtype (glxtrtype (pop *glexpr*)))
    (if (eq (car *glexpr*) 'with) (pop *glexpr*))
 lp
    (if *glexpr* (if (symbolp (car *glexpr*))
		 (progn (setq slot (pop *glexpr*))
			(if (eq (car *glexpr*) '=) (pop *glexpr*))
			(setq tmp (gldoexpr nil *glcontext* t))
			(push (cons slot tmp) pairs)
			(go lp))
		 (progn (glerror 'glgetvtype
			  "Syntax error in view/virtual statement ~A" *glexpr*)
			(return))))
    (setq newtype (list 'glstructure
			(cons 'codetuple (nreverse pairs))
			'supers
			(list viewtype)))
    (return newtype)))


; 09 Oct 90; 10 Oct 90; 12 Oct 90; 17 Oct 90; 24 Oct 90
; Process an expression that describes a view.
; Syntax is (VIEWAS <var> <type> WITH <prop> = <expr> ...) 
; <var> will be put into context where it can be referenced, but it is
; virtual rather than a real variable.  <var> may be nil when the VIEWAS
; form is used as a property in a glisp type.
(defun gldoviewas (*glexpr* *glcontext*)
  (prog (var viewtype codes types code type)
    (pop *glexpr*)
    (unless (symbolp (setq var (pop *glexpr*)))
	    (glerror 'gldoviewas "Syntax error in VIEWAS: ~A" *glexpr*))
    (setq viewtype (glevalstr (pop *glexpr*) *glcontext*))
    (if (eq (car *glexpr*) 'with) (pop *glexpr*))
    (dolist (triple (glgetpairs *glexpr*))
      (push (kwote (first triple)) codes)
      (push (second triple) codes)
      (push (list (first triple) (third triple)) types))
    (setq code (cons 'list (cons (kwote (list 'virtual viewtype))
				 (nreverse codes))))
    (setq type (cons 'virtual (cons viewtype (nreverse types))))
    (return (if var (progn (gladdstr code var type *glcontext*)
			   '*nil*)
		    (list code type))) ))

; ***** 26 Sep 06: glvirtualvalueb does not look for views of a virtual datum

; 10 Oct 90; 03 Dec 93
; Get property PROP from CODE, which is described by the virtual type TYPE:
; Code = (LIST (QUOTE (VIRTUAL <type>)) (QUOTE <fieldname>) <value> ...)
; Type = (VIRTUAL <type> (<fieldname> <fieldtype>) ...)
(defun glvirtualvalueb (code prop type)
  (let (propl)
; first look for prop as a defined field of the type 
    (if (glvirtualb-getf (cddr code) prop)
	(list *glvirtualb-getf-value* (cadr (assoc prop (cddr type))))
	(and (setq propl (glstrprop (cadr type) 'prop prop nil))
	     (glcompmsgl (list code type) 'prop propl nil nil)) ) ))


; 10 Oct 90; 03 Dec 93
; like getf where the props are (QUOTE <prop>).
(defun glvirtualb-getf (lst prop)
  (if lst (if (and (consp (car lst))
		   (eq (caar lst) 'quote)
		   (eql (cadar lst) prop))
	      (progn (setq *glvirtualb-getf-value* (cadr lst)) t)
	      (glvirtualb-getf (cddr lst) prop) ) ) )


(gldefun rra ((b bowling-ball))
  (let ((c (virtual circle with radius = (radius b)))) (area c)))

; this messes up; probably it should materialize when an actual var
; is set to the virtual value.
(gldefun rrb ((b bowling-ball))
  (let ((c (virtual circle with radius = (radius b)))) c))

(gldefun rrc ((p person))
    (viewas v vector with x = (age p) y = (salary p))
    (magnitude v))

(gldefun rrd ((b bowling-ball))
  (viewas c circle with radius = (radius b))
  (area c))

(gldefun rre ((b bowling-ball))
  (viewas c circle with radius = (radius b))
  c)

(gldefun rrf ((b bowling-ball))
  (let (cc\:circle)
    (viewas c circle with radius = (radius b))
    (cc = c)))

(glispobjects (symbolv (atomobject (x integer)(y integer)) supers (vector)))

; Add two vectors of different types to produce a sum of a third type.
; Requires alternate version of vectorplus-v, invoked by ++ .
(gldefun rrg ((u vector) (v consv))
  (let ((sum symbolv))
    (sum = (++ u v))))

; One viewer used as part of another
(gldefun rrh ((i integer) (j integer) (r real))
  (viewas v vector x = i y = j)
  (viewas c circle radius = r center = v)
  (list (area c) (magnitude (center c)) (radius c) (y (center c))) )

; rri generates an intermediate vector; rrj did not but does now.
(gldefun rri ((u vector) (v vector)) (magnitude (+ u v)))
(gldefun rrj ((u vector) (v vector)) (magnitude (++ u v)))
     
; 24 Oct 90; 06 Jun 95
; Materializes the vector in making the circle
(gldefun rrl ((i integer) (j integer) (r real))
  (viewas v vector x = i y = j)
  (a circle with radius = r center = v))

; 26 Oct 90
; Materializes the vector as the consv type
(gldefun rrm ((i integer) (j integer))
  (let ((cv consv))
    (viewas v vector x = i y = j)
    (cv = v)))

; 01 Nov 90
; Verify materialization of C prior to call to closed function.
(gldefun rrn ((b bowling-ball))
  (viewas c circle with radius = (radius b))
  (print c))

; 02 Nov 90; 06 Jun 95
(gldefun rro ((i integer) (j integer) (r real))
  (viewas v vector x = i y = j)
  (viewas c circle radius = r center = v)
  (princ (center c)))
