/* picXalex.c
 * 30jan91
 */

#include "picX.h"
#include <Xm/TextP.h>


/* Prototypes */
static void xChildren(Display*,Window);
static pico xFamily(pico);
static pico isAncestor(pico);
static pico warpH(pico);
static pico warpV(pico);
static pico saveUnder(pico);
static pico stringWidth(pico);
static pico XKey(pico);
static pico txtLen(pico);
static pico txtPtr(pico);
static pico txtLin(pico);
static pico selStart(pico);
static pico selEnd(pico);
static pico penSize(pico);
static pico solid(pico);
static pico dotted(pico);
static pico drawRect(pico);
static pico drawArc(pico);
static pico fillRect(pico);
static pico portRect(pico);
static void picoCallBack(Widget,pico);
static pico callback(pico);
static pico call2back(pico);
static char *extrSeg(XmString);
static pico openOkProc(Widget,pico,XmFileSelectionBoxCallbackStruct*);
static pico verifyProc(Widget,pico,XmTextVerifyPtr);
static Boolean picoWorkProc(pico);
static pico addWorkProc(pico);
static pico addInput(pico);
static void picoTimeOut(pico);
static pico timeOut(pico);
static pico addHandler(pico);
static void postIt(Widget,Widget,XButtonEvent*);
static pico p_xtArgs(pico);

symInit XalexSyms[] = {
   {"X-FAMILY",       xFamily},
   {"ISANCESTOR",     isAncestor},
   {"WARP-H",         warpH},
   {"WARP-V",         warpV},
   {"SAVEUNDER",      saveUnder},
   {"STRINGWIDTH",    stringWidth},
   {"XKEY",           XKey},
   {"TXTLEN",         txtLen},
   {"TXTPTR",         txtPtr},
   {"TXTLIN",         txtLin},
   {"SELSTART",       selStart},
   {"SELEND",         selEnd},
   {"PENSIZE",        penSize},
   {"SOLID",          solid},
   {"DOTTED",         dotted},
   {"DRAWRECT",       drawRect},
   {"DRAWARC",        drawArc},
   {"FILLRECT",       fillRect},
   {"PORTRECT",       portRect},
   {"CALLBACK",       callback},
   {"CALL2BACK",      call2back},
   {"OPENOKPROC",     openOkProc},
   {"VERIFYPROC",     verifyProc},
   {"ADDWORKPROC",    addWorkProc},
   {"ADDINPUT",       addInput},
   {"TIMEOUT",        timeOut},
   {"ADDHANDLER",     addHandler},
   {"XTARGS",         p_xtArgs},
   NULL
};

pico xFamily(x)
pico x;
{
   Display *disp;
   Window win;

   disp = (Display*)nextNum(&x);
   push(newCell(boxNum(win = (Window)nextNum(&x)), nilSym));
   xChildren(disp,win);
   return pop();
}

static void xChildren(disp,win)
Display *disp;
Window win;
{
   Window root,parent;
   Window *children;
   int n;

   if (!XQueryTree(disp,win,&root,&parent,&children,&(unsigned int)n))
      err("X-children error");
   while (--n >= 0) {
      tos = newCell(boxNum(children[n]),tos);
      xChildren(disp,children[n]);
   }
   XFree(children);
}

pico isAncestor(x)
pico x;
{
   Display *disp;
   Window win1,win2;
   Window root,parent;
   Window *children;
   unsigned int n;

   disp = (Display*)nextNum(&x);
   win1 = (Window)nextNum(&x);
   win2 = (Window)nextNum(&x);
   while (win1 != win2) {
      if (!XQueryTree(disp,win2,&root,&parent,&children,&n))
         errObj(boxNum(win2), "XQueryTree failed");
      XFree(children);
      if ((win2 = parent) == root)
         return nilSym;
   }
   return tSym;
}

pico warpH(x)
pico x;
{
   Display *disp;

   disp = (Display*)nextNum(&x);
   return boxNum(XWarpPointer(disp,None,None,0,0,0,0,nextNum(&x),0));
}

pico warpV(x)
pico x;
{
   Display *disp;

   disp = (Display*)nextNum(&x);
   return boxNum(XWarpPointer(disp,None,None,0,0,0,0,0,nextNum(&x)));
}

pico saveUnder(x)
pico x;
{
   Display *disp;
   Window w;
   XSetWindowAttributes attr;

   disp = (Display*)nextNum(&x);
   w = (Window)nextNum(&x);
   attr.save_under = 1;
   return boxNum(XChangeWindowAttributes(disp,w,CWSaveUnder,&attr));
}

pico stringWidth(x)
pico x;
{
   Display *disp;
   GC gc;
   char buff[1024];
   XFontStruct *fs;

   disp = (Display*)nextNum(&x);
   gc = (GC)nextNum(&x);
   nextString(&x,buff,1024);
   if (!(fs = XQueryFont(disp,gc->gid)))
       return nilSym;
   return boxNum(XTextWidth(fs,buff,strlen(buff)));
}

pico XKey(x)
pico x;
{
   XKeyEvent *ev;
   char buff[65];
   KeySym keySym;
   XComposeStatus theComposeStatus;

   ev = (XKeyEvent*)nextNum(&x);
   XLookupString(ev, buff, 64, &keySym, &theComposeStatus);
   return boxNum(keySym);
}

pico txtLen(x)
pico x;
{
   return boxNum(((XmTextWidget)nextNum(&x))->text.source->data->length);
}

pico txtPtr(x)
pico x;
{
   return boxNum(((XmTextWidget)nextNum(&x))->text.source->data->ptr);
}

pico txtLin(x)
pico x;
{
   XmTextWidget w;
   register char *p;
   register number n1,n2;

   w = (XmTextWidget)nextNum(&x);
   n1 = n2  =  w->text.source->data->hasselection ?
         w->text.source->data->left : w->text.cursor_position;
   p = w->text.source->data->ptr;
   while (n1 > 0  &&  p[n1-1] != '\n')
      --n1;
   while (p[n2]  &&  p[n2] != '\n')
      ++n2;
   if (p[n2])
      ++n2;
   return newCell(boxNum(n1),boxNum(n2));
}

pico selStart(x)
pico x;
{
   register XmTextWidget w;

   w = (XmTextWidget)nextNum(&x);
   return boxNum(w->text.source->data->hasselection ?
         w->text.source->data->left : w->text.cursor_position );
}

pico selEnd(x)
pico x;
{
   register XmTextWidget w;

   w = (XmTextWidget)nextNum(&x);
   return boxNum(w->text.source->data->hasselection ?
         w->text.source->data->right : w->text.cursor_position );
}

pico penSize(x)
pico x;
{
   Display *disp;
   GC gc;

   disp = (Display*)nextNum(&x);
   gc = (GC)nextNum(&x);
   return boxBool(!XSetLineAttributes(disp, gc, (int)nextNum(&x),
      gc->values.line_style, gc->values.cap_style,
         gc->values.join_style ) );
}

pico solid(x)
pico x;
{
   Display *disp;
   GC gc;

   disp = (Display*)nextNum(&x);
   gc = (GC)nextNum(&x);
   return boxBool(!XSetLineAttributes(disp, gc, gc->values.line_width,
      LineSolid, gc->values.cap_style,
         gc->values.join_style ) );
}

pico dotted(x)
pico x;
{
   Display *disp;
   GC gc;

   disp = (Display*)nextNum(&x);
   gc = (GC)nextNum(&x);
   return boxBool(!XSetLineAttributes(disp, gc, gc->values.line_width,
      LineOnOffDash, gc->values.cap_style,
         gc->values.join_style ) );
}

pico drawRect(x)
pico x;
{
   Display *disp;
   Drawable draw;
   GC gc;
   rect r;

   disp = (Display*)nextNum(&x);
   draw = (Drawable)nextNum(&x);
   gc = (GC)nextNum(&x);
   nextRect(&x,&r);
   return boxNum(XDrawRectangle(disp, draw, gc,
           r.left, r.top, r.right - r.left, r.bottom - r.top ) );
}

pico drawArc(x)
pico x;
{
   Display *disp;
   Drawable draw;
   GC gc;
   rect r;
   int a;

   disp = (Display*)nextNum(&x);
   draw = (Drawable)nextNum(&x);
   gc = (GC)nextNum(&x);
   nextRect(&x,&r);
   a = nextAngle(&x);
   return boxNum(XDrawArc(disp, draw, gc,
      r.left, r.top, r.right - r.left, r.bottom - r.top,
      a, -nextNum(&x) ) );
}

pico fillRect(x)
pico x;
{
   Display *disp;
   Drawable draw;
   GC gc;
   rect r;

   disp = (Display*)nextNum(&x);
   draw = (Drawable)nextNum(&x);
   gc = (GC)nextNum(&x);
   nextRect(&x,&r);
   return boxBool(!XFillRectangle(disp, draw, gc,
           r.left, r.top, r.right - r.left, r.bottom - r.top ) );
}

pico portRect(x)
pico x;
{
   Display *disp;
   Drawable draw;
   Window root;
   unsigned int width, height, border, depth;
   rect r;

   disp = (Display*)nextNum(&x);
   draw = (Drawable)nextNum(&x);
   XGetGeometry(disp,draw,
      &root,&r.left,&r.top,&width,&height,&border,&depth);
   r.right = r.left + width;
   r.bottom = r.top + height;
   return boxRect(&r);
}

void picoCallBack(w,foo)
Widget w;
pico foo;
{
   apply1(foo,boxNum(w));
}

pico callback(x)
pico x;
{
  Widget w;
  char buff[64];

  w = (Widget) nextNum(&x);
  nextString(&x,buff,64);
  XtAddCallback(w,buff,picoCallBack,nextFun(&x));
  return tSym;
}

pico call2back(x)
pico x;
{
  Widget w;
  pico cFun;
  char buff[64];

  w = (Widget) nextNum(&x);
  nextString(&x,buff,64);
  cFun = nextFun(&x);
  NEEDNUM(cFun);
  XtAddCallback(w,buff,unBox(cFun),nextFun(&x));
  return tSym;
}

char *extrSeg(cs)
XmString cs;
{
  XmStringContext context;
  XmStringCharSet charset;
  XmStringDirection direction;
  Boolean separator;
  char *primitive_string;

  XmStringInitContext(&context,cs);
  XmStringGetNextSegment(context,&primitive_string,
      &charset,&direction,&separator);
  XmStringFreeContext(context);
  return(primitive_string);
}

pico openOkProc(w,foo,p)
Widget w;
pico foo;
XmFileSelectionBoxCallbackStruct *p;
{
   return apply2(foo,boxNum(w),unBufCString(extrSeg(p->value)));
}

pico verifyProc(w,foo,p)
Widget w;
pico foo;
register XmTextVerifyPtr p;
{
   register XmTextPosition pos;

   pos = p->startPos;
   return boxBool(
      p->doit =
         isNil(apply3(foo,
                  boxNum(pos),
                  unBufString(p->endPos - pos,
                     ((XmTextWidget)w)->text.source->data->ptr + pos ),
                  unBufString(p->text->length, p->text->ptr) ) )?
         NO : YES );
}

Boolean picoWorkProc(foo)
pico foo;
{
  applyProc(foo);
  return NO;
}

pico addWorkProc(x)
pico x;
{
   XtAppContext contxt;

   contxt = (XtAppContext)nextNum(&x);
   x = EVAL1(x);
   NEEDFUN(x);
   return boxNum(XtAppAddWorkProc(contxt,picoWorkProc,x));
}

void picoInputProc(foo,src,id)
pico foo;
int *src;
XtInputId *id;
{
   apply1(foo,boxNum(src));
}

pico addInput(x)
pico x;
{
   XtAppContext contxt;
   number src;

   contxt = (XtAppContext)nextNum(&x);
   src = nextNum(&x);
   x = EVAL1(x);
   NEEDFUN(x);
   return boxNum(XtAppAddInput(contxt,src,XtInputReadMask,picoInputProc,x));
}

void picoTimeOut(foo)
pico foo;
{
  applyProc(foo);
}

pico timeOut(x)
pico x;
{
   XtAppContext contxt;
   unsigned long msec;

   contxt = (XtAppContext)nextNum(&x);
   msec = nextNum(&x);
   x = EVAL1(x);
   NEEDFUN(x);
   return boxNum(XtAppAddTimeOut(contxt,msec,picoTimeOut,x));
}

pico addHandler(x)
pico x;
{
Widget a;

   a = (Widget)nextNum(&x);
   XtAddEventHandler(a, ButtonPressMask, False, postIt, (Widget)nextNum(&x));
   return tSym;
}

void postIt(w,popup,event)
Widget w;
Widget popup;
XButtonEvent *event;
{
   if(event->button == Button1) {
      XmMenuPosition(popup,event);
      XtManageChild(popup);
   }
}

pico p_xtArgs(x)
pico x;
{
   Widget w;

   w = (Widget) nextNum(&x);
   initArgs(x);
   XtSetValues(w,args,argCnt);
   return tSym;
}
