/* picXlib.c
 * 18dec90
 */

#include "picX.h"
/*#include <X11/keysym.h>      if you need put in appl.h
#include <X11/cursorfont.h>*/


/* Prototypes */
static pico p_evType(pico);
static pico p_evWin(pico);
static pico p_evTime(pico);
static pico p_evPos(pico);
static pico p_evCount(pico);
static pico p_evRect(pico);
static pico p_evButton(pico);
static pico p_evState(pico);
static pico p_evViState(pico);
static pico p_XLookupString(pico);
static pico p_XOpenDisplay(void);
static pico p_XCreateSimpleWindow(pico);
static pico p_XStoreName(pico);
static pico p_XSetWindowBackground(pico);
static pico p_XSetClipMask(pico);
static pico p_XSetClipRectangles(pico);
static pico p_DefaultRootWindow(pico);
static pico p_XCreateWindow(pico);
static pico p_XMoveWindow(pico);
static pico p_XMapWindow(pico);
static pico p_XUnmapWindow(pico);
static pico p_XMapRaised(pico);
static pico p_XFlush(pico);
static pico p_XDestroyWindow(pico);
static pico p_XCloseDisplay(pico);
static pico p_XSelectInput(pico);
static pico p_XNextEvent(pico);
static pico p_XCheckMaskEvent(pico);
static pico p_XCheckWindowEvent(pico);
static pico p_XCreateGC(pico);
static pico p_XFreeGC(pico);
static pico p_XSetFunction(pico);
static pico p_XSetForeground(pico);
static pico p_XSetBackground(pico);
static pico p_XSetInputFocus(pico);
static pico p_XDrawLine(pico);
static pico p_XDrawString(pico);
static pico p_XDrawImageString(pico);
static pico p_XReadBitmapFile(pico);
static pico p_XCopyPlane(pico);
static pico p_XCreateBitmapFromData(pico);
static pico p_XCreatePixmap(pico);
static pico p_XClearWindow(pico);
static pico p_XClearArea(pico);
static pico p_XCopyArea(pico);

symInit XLibSyms[] = {
   {"EV-TYPE",                 p_evType},
   {"EV-WIN",                  p_evWin},
   {"EV-TIME",                 p_evTime},
   {"EV-POS",                  p_evPos},
   {"EV-COUNT",                p_evCount},
   {"EV-RECT",                 p_evRect},
   {"EV-BUTTON",               p_evButton},
   {"EV-STATE",                p_evState},
   {"EV-VISTATE",              p_evViState},
   {"XLOOKUPSTRING",           p_XLookupString},
   {"XOPENDISPLAY",            p_XOpenDisplay},
   {"XCREATESIMPLEWINDOW",     p_XCreateSimpleWindow},
   {"XSTORENAME",              p_XStoreName},
   {"XSETWINDOWBACKGROUND",    p_XSetWindowBackground},
   {"XSETCLIPMASK",            p_XSetClipMask},
   {"XSETCLIPRECTANGLES",      p_XSetClipRectangles},
   {"DEFAULTROOTWINDOW",       p_DefaultRootWindow},
   {"XCREATEWINDOW",           p_XCreateWindow},
   {"XMOVEWINDOW",             p_XMoveWindow},
   {"XMAPWINDOW",              p_XMapWindow},
   {"XUNMAPWINDOW",            p_XUnmapWindow},
   {"XMAPRAISED",              p_XMapRaised},
   {"XFLUSH",                  p_XFlush},
   {"XDESTROYWINDOW",          p_XDestroyWindow},
   {"XCLOSEDISPLAY",           p_XCloseDisplay},
   {"XSELECTINPUT",            p_XSelectInput},
   {"XNEXTEVENT",              p_XNextEvent},
   {"XCHECKMASKEVENT",         p_XCheckMaskEvent},
   {"XCHECKWINDOWEVENT",       p_XCheckWindowEvent},
   {"XCREATEGC",               p_XCreateGC},
   {"XFREEGC",                 p_XFreeGC},
   {"XSETFUNCTION",            p_XSetFunction},
   {"XSETFOREGROUND",          p_XSetForeground},
   {"XSETBACKGROUND",          p_XSetBackground},
   {"XSETINPUTFOCUS",          p_XSetInputFocus},
   {"XDRAWLINE",               p_XDrawLine},
   {"XDRAWSTRING",             p_XDrawString},
   {"XDRAWIMAGESTRING",        p_XDrawImageString},
   {"XREADBITMAPFILE",         p_XReadBitmapFile},
   {"XCOPYPLANE",              p_XCopyPlane},
   {"XCREATEBITMAPFROMDATA",   p_XCreateBitmapFromData},
   {"XCREATEPIXMAP",           p_XCreatePixmap},
   {"XCLEARWINDOW",            p_XClearWindow},
   {"XCLEARAREA",              p_XClearArea},
   {"XCOPYAREA",               p_XCopyArea},
   NULL
};

#define L1   10

XEvent theEvent;

static XGCValues theGCValues;
static XGCValues theGCValues1;
static Pixmap thePixmap;
static char buf1[L1];



void initXSymbols()
{
   init1Sym("*EVENT",YES,boxNum(&theEvent));
   init1Sym("*GCVAL",YES,boxNum(&theGCValues));
   init1Sym("*GCVAL1",YES,boxNum(&theGCValues1));
   init1Sym("*PIXMAP",YES,boxNum(&thePixmap));
}

pico p_evType(x)
pico x;
{
   return boxNum(((XAnyEvent*)nextNum(&x))->type);
}

pico p_evWin(x)
pico x;
{
   return boxNum(((XAnyEvent*)nextNum(&x))->window);
}

pico p_evTime(x)
pico x;
{
   return boxNum(((XButtonEvent*)nextNum(&x))->time);
}

pico p_evPos(x)
pico x;
{
   XButtonEvent *ev;

   ev = (XButtonEvent*)nextNum(&x);
   return newCell(boxNum(ev->x),boxNum(ev->y));
}

pico p_evCount(x)
pico x;
{
   return boxNum(((XExposeEvent*)nextNum(&x))->count);
}

pico p_evRect(x)
pico x;
{
   register XExposeEvent *p;

   p = (XExposeEvent*)nextNum(&x);
   return newCell2(boxNum(p->x), boxNum(p->y),
                  boxNum(p->x + p->width), boxNum(p->y + p->height));
}

pico p_evButton(x)
pico x;
{
   return boxNum(((XButtonEvent*)nextNum(&x))->button);
}

pico p_evState(x)
pico x;
{
   return boxNum(((XButtonEvent*)nextNum(&x))->state);
}

pico p_evViState(x)
pico x;
{
   return boxNum(((XVisibilityEvent*)nextNum(&x))->state);
}

pico p_XLookupString(x)
pico x;
{
   XKeyEvent *ev;
   char buff[65];
   KeySym keySym;
   XComposeStatus theComposeStatus;

   ev = (XKeyEvent*)nextNum(&x);
   XLookupString(ev, buff, 64, &keySym, &theComposeStatus);
   val(nextVar(&x)) = boxNum(buff[0]);
   return boxNum(keySym);
}

pico p_XOpenDisplay()
{
   Display *disp;

   if ((disp=XOpenDisplay("")) == NULL)
      return nilSym;
   return boxNum(disp);
}

pico p_XCloseDisplay(x)
pico x;
{
   return boxBool(!XCloseDisplay(nextNum(&x)) == 0);
}

pico p_XCreateSimpleWindow(x)
pico x;
{
   Display *disp;
   Window parent;
   rect r;
   unsigned borderWidth;
   unsigned long border;

   disp = (Display*)nextNum(&x);
   parent = (Window)nextNum(&x);
   nextRect(&x,&r);
   borderWidth = (unsigned)nextNum(&x);
   border = nextColor(&x,disp);
   return boxPtr((void*)XCreateSimpleWindow(
           disp, parent, r.left, r.top, r.right - r.left, r.bottom - r.top,
           borderWidth, border, nextColor(&x,disp) ) );
}

pico p_XStoreName(x)
pico x;
{
   Display *disp;
   Window w;
   char buf[1024];

   disp = (Display*)nextNum(&x);
   w = (Window)nextNum(&x);
   return boxNum(XStoreName(disp,w,nextString(&x,buf,1024)));
}

pico p_XSetWindowBackground(x)
pico x;
{
   Display *disp;
   Window w;
   char buf[1024];

   disp = (Display*)nextNum(&x);
   w = (Window)nextNum(&x);
   return boxNum(XSetWindowBackground(disp,w,nextColor(&x,disp)));
}

pico p_XSetClipMask(x)
pico x;
{
   Display *disp;
   GC gc;

   disp = (Display*)nextNum(&x);
   gc = (GC)nextNum(&x);
   return boxNum(XSetClipMask(disp,gc,(Pixmap)nextNum(&x)));
}

pico p_XSetClipRectangles(x)
pico x;
{
   Display *disp;
   GC gc;
   int clip_x,clip_y;
   rect r;
   XRectangle rect[64];
   register int cnt = 0;

   disp = (Display*)nextNum(&x);
   gc = (GC)nextNum(&x);
   clip_x = nextNum(&x);
   clip_y = nextNum(&x);
   x = EVAL1(x);
   while (isCell(x)) {
      unBoxRect(car(x),&r);
      x = cdr(x);
      if (cnt >= 64)
         err("Too many clip-rects");
      rect[cnt].x = r.left;
      rect[cnt].y = r.top;
      rect[cnt].width = r.right - r.left;
      rect[cnt].height = r.bottom - r.top;
      ++cnt;
   }
   return boxNum(XSetClipRectangles(disp,gc,clip_x,clip_y,
                                               rect, cnt, 0 ));
}

pico p_DefaultRootWindow(x)
pico x;
{
   Display *disp;

   disp = (Display*)nextNum(&x);
   return boxNum(DefaultRootWindow(disp));
}

pico p_XCreateWindow(x)
pico x;
{
   Display *display;
   Window   parent;
   int    xos,yos;
   unsigned int width,height,border_width;
   int   depth;
   unsigned int class;
   Visual *visual;
   unsigned long valuemask;
   XSetWindowAttributes   atributes;

   unsigned long   mask;
   int   screen;
   Window  newWindow;


   display = (Display *)nextNum(&x);
   xos = nextNum(&x);
   yos = nextNum(&x);
   width = nextNum(&x);
   height = nextNum(&x);
   border_width = nextNum(&x);
   screen = DefaultScreen(display);
   depth = DefaultDepth(display,screen);
   mask = (CWBackPixel | CWBorderPixel | CWOverrideRedirect);
   atributes.border_pixel = BlackPixel(display,screen);
   atributes.background_pixel = WhitePixel(display,screen);
   atributes.override_redirect = True;
   if((newWindow = XCreateWindow(display,RootWindow(display,screen),
                     xos ,yos ,
                     width, height, border_width,
                     depth,InputOutput,CopyFromParent,
                     mask,&atributes)) == 0)

      return nilSym;
   return boxNum(newWindow);
}

pico p_XMoveWindow(x)
pico x;
{
   Display *disp;
   Window w;
   int h;

   disp = (Display*)nextNum(&x);
   w = (Window)nextNum(&x);
   h = (int)nextNum(&x);
   return boxNum(XMoveWindow(disp,w,h,(int)nextNum(&x)));
}

pico p_XMapWindow(x)
pico x;
{
   Display *disp;

   disp = (Display*)nextNum(&x);
   return boxBool(!XMapWindow(disp, (Window)nextNum(&x)));
}

pico p_XUnmapWindow(x)
pico x;
{
   Display *disp;

   disp = (Display*)nextNum(&x);
   return boxBool(!XUnmapWindow(disp, (Window)nextNum(&x)));
}

pico p_XFlush(x)
pico x;
{
   if(XFlush(nextNum(&x)) == 0)
      return nilSym;
   return boxBool(5);
}

pico p_XMapRaised(x)
pico x;
{
   Display *display;
   Window  newWindow;

        display = (Display *)nextNum(&x);
   newWindow = nextNum(&x);
   if(XMapRaised(display,newWindow) == 0)
      return nilSym;
   return boxBool(6);
}

pico p_XDestroyWindow(x)
pico x;
{
   Display *disp;

   disp = (Display*)nextNum(&x);
   return boxBool(!XDestroyWindow(disp,(Window)nextNum(&x)));
}

pico p_XSelectInput(x)
pico x;
{
   Display *display;
   Window  newWindow;

   display = (Display *)nextNum(&x);
   newWindow = nextNum(&x);
   XSelectInput(display,newWindow,nextNum(&x));
   return tSym;
}

pico p_XNextEvent(x)
pico x;
{
   Display *disp;

   disp = (Display*)nextNum(&x);
   XNextEvent(disp, (XEvent*)nextNum(&x));
   return tSym;
}

pico p_XCheckMaskEvent(x)
pico x;
{
   Display *disp;
   unsigned long msk;

   disp = (Display*)nextNum(&x);
   msk = nextNum(&x);
   return boxBool(XCheckMaskEvent(disp,msk,(XEvent*)nextNum(&x)));
}

pico p_XCheckWindowEvent(x)
pico x;
{
   Display *disp;
   Window win;
   long mask;

   disp = (Display*)nextNum(&x);
   win = (Window)nextNum(&x);
   mask = nextNum(&x);
   return boxBool(XCheckWindowEvent(disp,win,mask,(XEvent*)nextNum(&x)));
}

pico p_XCreateGC(x)
pico x;
{
   Display *disp;
   Drawable window;
   unsigned long val_mask;
   GC gc;

   disp = (Display *)nextNum(&x);
   window = nextNum(&x);
   val_mask = nextNum(&x);
   gc = XCreateGC(disp,window,val_mask,(XGCValues*)nextNum(&x));
   return boxPtr(gc);
}

pico p_XFreeGC(x)
pico x;
{
   Display *disp;
   GC gc;

   disp = (Display *)nextNum(&x);
   gc = (GC)nextNum(&x);
   return boxNum(XFreeGC(disp,gc));
}

pico p_XSetFunction(x)
pico x;
{
   Display *disp;
   GC gc;

   disp = (Display *)nextNum(&x);
   gc = (GC)nextNum(&x);
   XSetFunction(disp,gc,nextNum(&x));
   return tSym;
}

pico p_XSetForeground(x)
pico x;
{
   Display *disp;
   GC gc;

   disp = (Display*)nextNum(&x);
   gc = (GC)nextNum(&x);
   return boxBool(!XSetForeground(disp,gc,nextColor(&x,disp)));
}

pico p_XSetBackground(x)
pico x;
{
   Display *disp;
   GC gc;

   disp = (Display*)nextNum(&x);
   gc = (GC)nextNum(&x);
   return boxBool(!XSetBackground(disp,gc,nextColor(&x,disp)));
}

pico p_XSetInputFocus(x)
pico x;
{
   Display *disp;
   Window focus;
   int revert;

   disp = (Display*)nextNum(&x);
   focus = (Window)nextNum(&x);
   revert = (int)nextNum(&x);
   return boxNum(XSetInputFocus(disp,focus,revert,(Time)nextNum(&x)));
}

pico p_XDrawLine(x)
pico x;
{
   Display *display;
   Drawable draw;
   GC gc;
   int x1,y1,x2;

   display = (Display*)nextNum(&x);
   draw = (Drawable)nextNum(&x);
   gc = (GC)nextNum(&x);
   x1 = nextNum(&x);
   y1 = nextNum(&x);
   x2 = nextNum(&x);
   return boxNum(XDrawLine(display,draw,gc,x1,y1,x2,nextNum(&x)));
}

pico p_XDrawString(x)
pico x;
{
   Display *disp;
   Drawable draw;
   GC gc;
   int h,v;
   char buff[1024];

   disp = (Display*)nextNum(&x);
   draw = (Drawable)nextNum(&x);
   gc = (GC)nextNum(&x);
   h = nextNum(&x);
   v = nextNum(&x);
   nextString(&x,buff,1024);
   return boxNum(XDrawString(disp,draw,gc,h,v,buff,strlen(buff)));
}

pico p_XDrawImageString(x)
pico x;
{
   Display *disp;
   Drawable draw;
   GC gc;
   int h,v;
   char buff[1024];

   disp = (Display*)nextNum(&x);
   draw = (Drawable)nextNum(&x);
   gc = (GC)nextNum(&x);
   h = nextNum(&x);
   v = nextNum(&x);
   nextString(&x,buff,1024);
   return boxNum(XDrawImageString(disp,draw,gc,h,v,buff,strlen(buff)));
}

pico p_XReadBitmapFile(x)
pico x;
{
   Display *display;
   Window window;
   char *theFileName;
   unsigned int width,height;
   Pixmap *thePixmap;
   int xHot,yHot;

   display = (Display *)nextNum(&x);
   window = nextNum(&x);
   theFileName = (char *)nextString(&x,buf1,L1);
   width = nextNum(&x);
   height = nextNum(&x);
   thePixmap = (Pixmap*)nextNum(&x);
   xHot = nextNum(&x);
   yHot = nextNum(&x);

   if ( XReadBitmapFile(display,window,
                        theFileName,&width,&height,&thePixmap,
                        &xHot,&yHot) != BitmapSuccess)
        return nilSym;
   return tSym;

}

pico p_XCopyPlane(x)
pico x;
{
   Display *display;
   Window src,dest;
   GC gc;
   int src_x,src_y;
   unsigned int width,height;
   int dest_x,dest_y;
   unsigned long plane;

   display = (Display *)nextNum(&x);
   src = nextNum(&x);
   dest = nextNum(&x);
   gc = (GC) nextNum(&x);
   src_x = nextNum(&x);
   src_y = nextNum(&x);
   width = nextNum(&x);
   height = nextNum(&x);
   dest_x = nextNum(&x);
   dest_y = nextNum(&x);
   plane = nextNum(&x);

   XCopyPlane(display,src,dest,gc, src_x,src_y,width,height,
               dest_x,dest_y,plane);
   return tSym;

}

pico p_XCreateBitmapFromData(x)
pico x;
{
   Display *display;
   Window window;
   unsigned int width,height;
   char *Icon_bits;

   display = (Display *)nextNum(&x);
   window = (Window )nextNum(&x);
   Icon_bits = (char *)nextString(&x,buf1,L1);
   width = nextNum(&x);
   height = nextNum(&x);

   if ((Pixmap) XCreateBitmapFromData(display,window,
                                 Icon_bits,width,height) == 0)
      return nilSym;
   return tSym;

}

pico p_XCreatePixmap(x)
pico x;
{
   Display *display;
   Window window;
   unsigned int width,height;
   Pixmap a_pixmap;

   display = (Display *)nextNum(&x);
   window = (Window )nextNum(&x);
   width = nextNum(&x);
   height = nextNum(&x);

   if ((a_pixmap = XCreatePixmap(display,window,width,height,nextNum(&x))) == 0)
      return nilSym;
   return boxNum(a_pixmap);

}

pico p_XClearWindow(x)
pico x;
{
   Display *disp;

   disp = (Display*)nextNum(&x);
   XClearWindow(disp,(Window)nextNum(&x));
   return tSym;
}

pico p_XClearArea(x)
pico x;
{
   Display *disp;
   Window w;
   rect r;

   disp = (Display*)nextNum(&x);
   w = (Window)nextNum(&x);
   nextRect(&x,&r);
   return boxNum(XClearArea(disp,w,
         r.left, r.top, r.right - r.left, r.bottom - r.top, nextBool(&x) ) );
}

pico p_XCopyArea(x)
pico x;
{
   Display *disp;
   Drawable src,dst;
   GC gc;
   rect r;
   point pt;

   disp = (Display*)nextNum(&x);
   src = (Drawable)nextNum(&x);
   dst = (Drawable)nextNum(&x);
   gc = (GC)nextNum(&x);
   nextRect(&x,&r);
   nextPoint(&x,&pt);
   return boxNum(XCopyArea(disp, src, dst, gc,
         r.left, r.top, r.right - r.left, r.bottom - r.top, pt.h, pt.v ) );
}
