/* picXm.c
 * 14may91
 */

#include "picX.h"
#include <Xm/TextP.h>

/* Prototypes */
static pico p_XmAddTabGroup(pico);
static pico p_XmRemoveTabGroup(pico);
static pico p_XmCreateFormDialog(pico);
static pico p_XmCreateMessageDialog(pico);
static pico p_XmCreateScrolledText(pico);
static pico p_XmTextSetSelection(pico);
static pico p_XmTextReplace(pico);
static pico p_XmCreateScrolledWindow(pico);
static pico p_XmCreateMainWindow(pico);
static pico p_XmCreateDrawingArea(pico);
static pico p_XmCreateBulletinBoard(pico);
static pico p_XmCreateCommand(pico);
static pico p_XmCreateFileSelectionBox(pico);
static pico p_XmCreateRowColumn(pico);
static pico p_XmCreatePulldownMenu(pico);
static pico p_XmCreatePopupMenu(pico);
static pico p_XmCreateCascadeButton(pico);
static pico p_XmCreateCascadeButtonGadget(pico);
static pico p_XmCreatePushButton(pico);
static pico p_XmCreatePushButtonGadget(pico);
static pico p_XmCreateLabelGadget(pico);
static pico p_XmCreateToggleButton(pico);
static pico p_XmCreateToggleButtonGadget(pico);
static pico p_XmCreateFrame(pico);
static pico p_XmCreateForm(pico);
static pico p_XmCreateText(pico);
static pico p_XmCreateDrawnButton(pico);
static pico p_XmCreateSeparator(pico);
static pico p_XmCreateMenuShell(pico);
static pico p_XmCreateDialogShell(pico);
static pico p_XmMainWindowSetAreas(pico);
static pico p_XmTextClearSelection(pico);
static pico p_XmTextGetSelection(pico);
static pico p_XmTextGetString(pico);
static pico p_XmTextSetString(pico);
static pico p_XmSelectionBoxGetChild(pico);
static pico p_XmFileSelectionBoxGetChild(pico);

symInit XmSyms[] = {
   {"XMADDTABGROUP",               p_XmAddTabGroup},
   {"XMREMOVETABGROUP",            p_XmRemoveTabGroup},
   {"XMCREATEFORMDIALOG",          p_XmCreateFormDialog},
   {"XMCREATEMESSAGEDIALOG",       p_XmCreateMessageDialog},
   {"XMCREATESCROLLEDTEXT",        p_XmCreateScrolledText},
   {"XMTEXTSETSELECTION",          p_XmTextSetSelection},
   {"XMTEXTREPLACE",               p_XmTextReplace},
   {"XMCREATESCROLLEDWINDOW",      p_XmCreateScrolledWindow},
   {"XMCREATEMAINWINDOW",          p_XmCreateMainWindow},
   {"XMCREATEDRAWINGAREA",         p_XmCreateDrawingArea},
   {"XMCREATEBULLETINBOARD",       p_XmCreateBulletinBoard},
   {"XMCREATECOMMAND",             p_XmCreateCommand},
   {"XMCREATEFILESELECTIONBOX",    p_XmCreateFileSelectionBox},
   {"XMCREATEROWCOLUMN",           p_XmCreateRowColumn},
   {"XMCREATEPULLDOWNMENU",        p_XmCreatePulldownMenu},
   {"XMCREATEPOPUPMENU",           p_XmCreatePopupMenu},
   {"XMCREATEPUSHBUTTON",          p_XmCreatePushButton},
   {"XMCREATEPUSHBUTTONGADGET",    p_XmCreatePushButtonGadget},
   {"XMCREATECASCADEBUTTON",       p_XmCreateCascadeButton},
   {"XMCREATECASCADEBUTTONGADGET", p_XmCreateCascadeButtonGadget},
   {"XMCREATESEPARATOR",           p_XmCreateSeparator},
   {"XMCREATETOGGLEBUTTON",        p_XmCreateToggleButton},
   {"XMCREATETOGGLEBUTTONGADGET",  p_XmCreateToggleButtonGadget},
   {"XMCREATELABELGADGET",         p_XmCreateLabelGadget},
   {"XMCREATEMENUSHELL",           p_XmCreateMenuShell},
   {"XMCREATEDIALOGSHELL",         p_XmCreateDialogShell},
   {"XMCREATEFRAME",               p_XmCreateFrame},
   {"XMCREATETEXT",                p_XmCreateText},
   {"XMCREATEFORM",                p_XmCreateForm},
   {"XMCREATEDRAWNBUTTON",         p_XmCreateDrawnButton},
   {"XMMAINWINDOWSETAREAS",        p_XmMainWindowSetAreas},
   {"XMTEXTCLEARSELECTION",        p_XmTextClearSelection},
   {"XMTEXTGETSELECTION",          p_XmTextGetSelection},
   {"XMTEXTGETSTRING",             p_XmTextGetString},
   {"XMTEXTSETSTRING",             p_XmTextSetString},
   {"XMSELECTIONBOXGETCHILD",      p_XmSelectionBoxGetChild},
   {"XMFILESELECTIONBOXGETCHILD",  p_XmFileSelectionBoxGetChild},
   NULL
};


pico p_XmAddTabGroup(x)
pico x;
{
   XmAddTabGroup((Widget)nextNum(&x));
   return tSym;
}

pico p_XmRemoveTabGroup(x)
pico x;
{
   XmRemoveTabGroup((Widget)nextNum(&x));
   return tSym;
}

pico p_XmCreateFormDialog(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateFormDialog(parent, name, args, argCnt));
}

pico p_XmCreateMessageDialog(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateMessageDialog(parent, name, args, argCnt));
}

pico p_XmCreateScrolledText(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateScrolledText(parent, name, args, argCnt));
}

pico p_XmCreateText(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateText(parent, name, args, argCnt));
}

pico p_XmTextSetSelection(x)
pico x;
{
   register XmTextWidget w;
   XmTextPosition start,end;

   w = (XmTextWidget)nextNum(&x);
   start = (XmTextPosition)nextNum(&x);
   end = (XmTextPosition)nextNum(&x);
   XmTextSetSelection(w,start,end,(Time)nextNum(&x));
#if 0
   /* Patch (?) */
   w->text.source->data->hasselection = YES;
   w->text.source->data->left = start;
   w->text.source->data->right = end;
#endif
   return tSym;
}

pico p_XmTextReplace(x)
pico x;
{
Widget w;
XmTextPosition start,end;
char buff[20000];

   w = (Widget)nextNum(&x);
   start = (XmTextPosition)nextNum(&x);
   end = (XmTextPosition)nextNum(&x);
   XmTextReplace(w,start,end,nextString(&x,buff,20000));
   return tSym;
}

pico p_XmCreateScrolledWindow(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateScrolledWindow(parent, name, args, argCnt));
}

pico p_XmCreateDrawingArea(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateDrawingArea(parent, name, args, argCnt));

}
pico p_XmCreateMainWindow(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateMainWindow(parent, name, args, argCnt));
}

pico p_XmCreateFileSelectionBox(x)
pico x;
{
   char name[64];
   Widget parent;

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateFileSelectionBox(parent, name, args, argCnt));
}

pico p_XmCreateRowColumn(x)
pico x;
{
   char name[64];
   Widget parent;

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateRowColumn(parent, name, args, argCnt));
}

pico p_XmCreateCommand(x)
pico x;
{
char buff[256];
Widget parent;
String name;


   parent = (Widget)nextNum(&x);
   name = (String)nextString(&x,buff,256);
   return boxNum(XmCreateCommand( parent,name, NULL, 0));
}

pico p_XmCreateBulletinBoard(x)
pico x;
{
   Widget parent;
   char name[256];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,256);
   initArgs(x);
   return boxNum(XmCreateBulletinBoard(parent, name, args, argCnt));
}

pico p_XmCreatePulldownMenu(x)
pico x;
{
char buff[256];
Widget parent;
String name;

   parent = (Widget)nextNum(&x);
   name = (String)nextString(&x,buff,256);
   return boxNum(XmCreatePulldownMenu( parent,name, NULL, 0));
}

pico p_XmCreatePopupMenu(x)
pico x;
{
Widget parent;
char buff[256];
Arg args[5];
int n=0;

   parent = (Widget)nextNum(&x);
   nextString(&x,buff,256);
   XtSetArg(args[n],XmNheight, 100);n++;
   XtSetArg(args[n],XmNwidth, 100);n++;
   return boxNum((Widget)XmCreatePopupMenu(parent, buff, args, n));
}

pico p_XmCreateCascadeButton(x)
pico x;
{
char buff[256];
Widget parent;
Arg args[5];

   parent = (Widget)nextNum(&x);
   nextString(&x,buff,256);
   XtSetArg(args[0],XmNsubMenuId, nextNum(&x));
   return boxNum(XmCreateCascadeButton( parent,buff,args ,1));
}

pico p_XmCreateCascadeButtonGadget(x)
pico x;
{
char buff[256];
Widget parent;
Arg args[5];

   parent = (Widget)nextNum(&x);
   nextString(&x,buff,256);
   XtSetArg(args[0],XmNrowColumnType, XmMENU_POPUP);
   return boxNum(XmCreateCascadeButtonGadget( parent,buff,args ,1));
}

pico p_XmCreateToggleButton(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateToggleButton(parent, name, args, argCnt));
}

pico p_XmCreateToggleButtonGadget(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateToggleButtonGadget(parent, name, args, argCnt));
}

pico p_XmCreateLabelGadget(x)
pico x;
{
   char name[64];
   Widget parent;

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateLabelGadget(parent, name, args, argCnt));
}

pico p_XmCreateSeparator(x)
pico x;
{
Widget parent;
String name;
char buff[256];

Arg args[5];

   parent = (Widget)nextNum(&x);
   name = (String)nextString(&x,buff,256);
   XtSetArg(args[0],XmNmargin, nextNum(&x));
   return boxNum(XmCreateSeparator( parent,name,args ,1));
}

pico p_XmCreateMenuShell(x)
pico x;
{
Widget parent;
char buff[256];
Arg args[5];

   parent = (Widget)nextNum(&x);
   nextString(&x,buff,256);
   XtSetArg(args[0],XmNheight, 100);
   XtSetArg(args[1],XmNwidth, 100);
   return boxNum(XmCreateMenuShell( parent,buff,args ,2));
}

pico p_XmCreateDialogShell(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum((Widget)XmCreateDialogShell(parent, name, args, argCnt));
}

pico p_XmCreatePushButton(x)
pico x;
{
   Widget parent;
   char name[256];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,256);
   initArgs(x);
   return boxNum((Widget)XmCreatePushButton(parent, name, args, argCnt));
}

pico p_XmCreatePushButtonGadget(x)
pico x;
{
   Widget parent;
   char name[256];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,256);
   initArgs(x);
   return boxNum((Widget)XmCreatePushButtonGadget(parent, name, args, argCnt));
}

pico p_XmCreateForm(x)
pico x;
{
   char name[64];
   Widget parent;

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateForm(parent, name, args, argCnt));
}

pico p_XmCreateDrawnButton(x)
pico x;
{
char buff[256];
Widget parent;
String name;

   parent = (Widget)nextNum(&x);
   name = (String)nextString(&x,buff,256);
   return boxNum((Widget)(XmCreateDrawnButton( parent,name, NULL, 0)));
}

pico p_XmCreateFrame(x)
pico x;
{
   Widget parent;
   char name[64];

   parent = (Widget)nextNum(&x);
   nextString(&x,name,64);
   initArgs(x);
   return boxNum(XmCreateFrame(parent, name, args, argCnt));
}

pico p_XmMainWindowSetAreas(x)
pico x;
{
Widget main_window;
Widget menu_bar;
Widget command_window;
Widget hor_scroll;
Widget ver_scroll;
Widget work_region;

   main_window = (Widget)nextNum(&x);
   menu_bar = (Widget)nextNum(&x);
   command_window = (Widget)nextNum(&x);
   hor_scroll = (Widget)nextNum(&x);
   ver_scroll = (Widget)nextNum(&x);
   work_region = (Widget)nextNum(&x);
   XmMainWindowSetAreas( main_window,menu_bar,command_window,
               hor_scroll, ver_scroll ,work_region );
   return tSym;
}

pico p_XmTextClearSelection(x)
pico x;
{
Widget widget;

   widget = (Widget)nextNum(&x);
   XmTextClearSelection(widget, (Time)nextNum(&x));
   return tSym;
}

pico p_XmTextGetSelection(x)
pico x;
{
   char *s;

   if (!(s = (char*)XmTextGetSelection((Widget)nextNum(&x))))
      return nilSym;
   x = unBufCString(s);
   XtFree(s);
   return x;
}

pico p_XmTextGetString(x)
pico x;
{
   return boxPtr((char *)XmTextGetString((Widget)nextNum(&x)));
}

pico p_XmTextSetString(x)
pico x;
{
Widget widget;
char buf[1024];

   widget = (Widget)nextNum(&x);
   XmTextSetString(widget,
      isNum(x=EVAL1(x))? (char*)unBox(x) : bufString(x,buf,1024));
   return tSym;
}

pico p_XmSelectionBoxGetChild(x)
pico x;
{
Widget widget;

   widget = (Widget)nextNum(&x);
   XmSelectionBoxGetChild( widget ,XmDIALOG_LIST);
   return tSym;
}

pico p_XmFileSelectionBoxGetChild(x)
pico x;
{
Widget widget;
unsigned char child;

   widget = (Widget)nextNum(&x);
   child = (unsigned char)nextNum(&x);
   return boxNum(XmFileSelectionBoxGetChild( widget ,child));
}
