[click.l 08apr91]

(on $weg)
(off $pt $spot *butt1 *butt2 *a-key *c-key)

<de grid (n g)
   (sub
      ((if (minusp n) dec inc) n (div2 g))
      (mod n g) >

<de grid-h (h)
   (local (g)
      (if (and (flagp *job 'grid) (setq g (get *job 'grid-h)))
         (grid h g)
         h >

<de grid-v (v)
   (local (g)
      (if (and (flagp *job 'grid) (setq g (get *job 'grid-v)))
         (grid v g)
         v >

<de prSpot (s)
   (unless (equal s $spot)
      (patXor)
      (with *job
         (when $spot
            (XDrawString *display (slot draw) (slot gc) 6 14 $spot) )
         (XDrawString *display (slot draw) (slot gc) 6 14 (setq $spot s)) >

<de hvSpot (h v)
   (prSpot
      (append
         "X:"
         (format (div h 100) 2)
         "  Y:"
         (format (div v 100) 2) >

<de stiff (pt)
   (local (dh dv)
      (when (and clickAnchor *butt1)
         (setq
            dh (sub (car pt) (car clickAnchor))
            dv (sub (cdr pt) (cdr clickAnchor)) )
         (if (lessp (abs dh) (abs dv))
            (rplaca pt
               (if (lessp (mul 3 (abs dh)) (abs dv))
                  (car clickAnchor)
                  (add
                     (car clickAnchor)
                     (if (minusp dh)
                        (minus (abs dv))
                        (abs dv) ) ) ) )
            (rplacd pt
               (if (lessp (mul 3 (abs dv)) (abs dh))
                  (cdr clickAnchor)
                  (add
                     (cdr clickAnchor)
                     (if (minusp dv)
                        (minus (abs dh))
                        (abs dh) ) ) ) ) ) )
      pt >

<de clickDraw (pt)
   (setq pt (unScale pt))
   (when (ptInRect pt (portRect *display (get *job 'draw)))
      (gcNormal)
      (patXor)
      (toggle $weg)
      (if drawFun
         (drawFun
            (and clickAnchor (unScale clickAnchor))
            pt $weg )
         (putDot pt) >

<de clickPos (pt)
   [+ (SetCursor
      (if (inPort pt *port)
         (ptr (GetCursor crossCursor))
         *arrow ) ) +]
   (if *butt2
      (progn
         (rplaca pt (scale-h (car pt)))
         (rplacd pt (scale-v (cdr pt)))
         (when filterFun
            (setq pt (filterFun pt)) )
         (setq pt (doSnap clickAnchor pt)) )
      (progn
         (rplaca pt
            (grid-h
               (scale-h (car pt)) ) )
         (rplacd pt
            (grid-v
               (scale-v (cdr pt)) ) )
         (when filterFun
            (setq pt (filterFun pt)) ) ) )
   (when spotFun
      (spotFun (car pt) (cdr pt)) )
   pt >

[+++ Event handling +++]
<de clk-key (*job ev)
   (case (XKey ev)
      (#XK-Escape
         (and $pt (clickDraw $pt))
         (off $pt)
         (on *done) )
      (#XK-Left (warp-h *display -1))
      (#XK-Up (warp-v *display -1))
      (#XK-Right (warp-h *display +1))
      (#XK-Down (warp-v *display +1))
      (#XK-Return (on *done)) >

<de clk-button (*job ev)
   (local (n)
      (setq
         n (ev-state ev)
         *c-key (bit 2 n)
         *a-key (bit 3 n) )
      (and $pt (clickDraw $pt))
      (case (ev-button ev)
         (1 (on *done))
         (2 (on *butt1))
         (3 (on *butt2)) )
      (clickDraw (setq $pt (clickPos (ev-pos ev)))) >

<de clk-release (*job ev)
   (case (ev-button ev)
      (2
         (and $pt (clickDraw $pt))
         (off *butt1)
         (clickDraw (setq $pt (clickPos (ev-pos ev)))) )
      (3
         (and $pt (clickDraw $pt))
         (off *butt2)
         (clickDraw (setq $pt (clickPos (ev-pos ev)))) >

<de clk-motion (*job ev)
   (local (n)
      (and $pt (clickDraw $pt))
      (setq
         n (ev-state ev)
         *c-key (bit 2 n)
         *a-key (bit 3 n) )
      (clickDraw (setq $pt (clickPos (ev-pos ev)))) >

<de clk-expose (*job ev)
   (when (zerop (ev-count ev))
      (refresh)
      (gcNormal)
      (when $spot
         (with *job
            (XDrawString *display (slot draw) (slot gc) 6 14 $spot) ) )
      (when $pt
         (local (pt)
            (setq pt (unscale $pt))
            (if drawFun
               (drawFun
                  (and clickAnchor (unScale clickAnchor))
                  pt $weg )
               (putDot pt) >

<de clk-out (*job ev)
   (and $pt (clickDraw $pt))
   (off $pt)
   (on *done) >

[+++ CLICK entry point +++]
<de click (spotFun filterFun clickAnchor drawFun)
   (local (v-key v-button v-release v-motion v-expose v-out)
      (setq
         v-key clk-key
         v-button clk-button
         v-release clk-release
         v-motion clk-motion
         v-expose clk-expose
         v-out clk-out )
      (on $weg)
      (off $pt $spot *butt1 *butt2)
      (XSetInputFocus *display (get *job 'draw) #None #CurrentTime)
      (run)
      (and $pt (clickDraw $pt))
      (prSpot)
      $pt >

t
