[command.l 13jun91]

(setq $border -20000)

<de borderCmd (w)
   (catch 'error
      (local (d g)
         (when (setq d (borderDialog $border))
            (with *job
               (watch *display)
               (setq $border d)
               (if
                  (setq g
                     (whole
                        (or
                           (slot mark)
                           (slot strokes) )
                        '("eaa0" "e" "c") ) )
                  (progn
                     (appStmt "! +++ Border +++")
                     (proGraf (border g d)) )
                  (warn "Keine geschlossene Kontur") >

<de changeScale (s)
   (local (r h v)
      (with *job
         (setq
            r (portRect *display (slot draw))
            h (scale-h (div2 (right r)))
            v (scale-v (div2 (bottom r))) )
         (slot scale s)
         (dec h (scale1 (div2 (right r))))
         (inc v (scale1 (div2 (bottom r))))
         (slot org-h (sub h (mod h 10000)))
         (slot org-v (sub v (mod v 10000)))
         (reDraw t) >

<de zoomCmd (w)
   (local (pt1 pt2 r)
      (with *job
         (when
            (and
               (setq pt1 (click hvSpot))
               (setq pt2
                  (click hvSpot stiff pt1
                     (lambda (oldPt newPt)
                        (drawRect  *display (slot draw) (slot gc)
                           (bounds oldPt newPt) ) ) ) ) )
            (setq r (portRect *display (slot draw)))
            (slot scale
               (min
                  (muldiv
                     (slot scale)
                     (right r)
                     (dots
                        (abs (sub (car pt2) (car pt1)))
                        (slot scale) ) )
                  (muldiv
                     (slot scale)
                     (bottom r)
                     (dots
                        (abs (sub (cdr pt2) (cdr pt1)))
                        (slot scale) ) ) ) )
            (slot org-h (min (car pt1) (car pt2)))
            (slot org-v (max (cdr pt1) (cdr pt2)))
            (reDraw t) >

<de totalCmd (w)
   (local (r1 r2)
      (with *job
         (when
            (and
               (setq r1 (erweiter (total (slot strokes))))
               (lessp (left r1) (right r1))
               (lessp (top r1) (bottom r1)) )
            (slot org-h (left r1))
            (slot org-v (bottom r1))
            (setq r2 (portRect *display (slot draw)))
            (slot scale
               (min
                  (muldiv
                     (slot scale)
                     (right r2)
                     (dots
                        (sub (right r1) (left r1))
                        (slot scale) ) )
                  (muldiv
                     (slot scale)
                     (bottom r2)
                     (dots
                        (sub (bottom r1) (top r1))
                        (slot scale) ) ) ) )
            (if (zerop (slot scale))
               (slot scale 1)
               (progn
                  (slot org-h
                     (sub (slot org-h)
                        (div2
                           (sub
                              (scale1 (right r2))
                              (sub (right r1) (left r1)) ) ) ) )
                  (slot org-v
                     (add (slot org-v)
                        (div2
                           (sub
                              (scale1 (bottom r2))
                              (sub (bottom r1) (top r1)) ) ) ) ) ) )
            (reDraw t) >

<de erweiter (r)
   (when r
      (insetRect
         r
         (div (sub (left r) (right r)) 10)
         (div (sub (top r) (bottom r)) #(eye 10)) >

<de schieb (pt)
   (gcNormal)
   (local (d g r pt1 pt2)
      (with *job
         (setq
            d (slot draw)
            g (slot gc)
            r (portRect *display d)
            pt1 pt )
         (while (bit 9 (button *display d))
            (setq pt2 (getMouse *display d))
            (XCopyArea *display d d g
               (offsetRect r
                  (sub (car pt1) (car pt2))
                  (sub (cdr pt1) (cdr pt2)) )
               (0 . 0) )
            (setq pt1 pt2)
            (XFlush *display) )
         (slot org-h
            (sub
               (slot org-h)
               (scale1 (sub (car pt1) (car pt))) ) )
         (slot org-v
            (add
               (slot org-v)
               (scale1 (sub (cdr pt1) (cdr pt))) ) )
         (reDraw t) >

<de doAtari (pt)
   (local (s a)
      (with *job
         (setq
            pt (scale pt)
            s (slot strokes) )
         (loop
            (t (null s)
               (unMark *job) )
            (t (setq a (reverse (do atari (pop s) pt)))
               (setq s
                  (if (setq s (memq (car (slot mark)) a))
                     (or (cadr s) (car s))
                     (car a) ) )
               (unMark *job)
               (mark *job (list s))
               (setq s (get s 'statement))
               (when (get s 'text1)
                  (hiStmt s) >

<de mark (job l)
   (with job
      (if (flagp job 'hilite)
         (progn
            (hilite job)
            (all hilite l)
            (hilite job) )
         (all hilite l) )
      (slot mark (append l (slot mark))) >

<de unMark (job)
   (with job
      (when (flagp job 'hilite)
         (hilite job) )
      (mapc (slot hiPict)
         (lambda (x)
            (clrPict (ref (cdr x))) ) )
      (slot mark nil) >

t
