[file.l 03jan91]

<de exists (nm p)
   (local (fd)
      (and
         (setq fd (open (append p nm)))
         (close fd) >

<de doOpen (nm)
   (or
      (open nm)
      (cosyError #(str "Oeffnungsfehler ") nm) >

<de doCreate (nm)
   (or
      (create nm)
      (cosyError #(str "Datei Erstellungsfehler ") nm) >

<de readList (nm)
   (local (fd lst p x)
      (setq fd (doOpen nm))
      (unless (eq t (setq x (read fd)))
         (setq
            lst (cons x)
            p lst )
         (until (eq t (setq x (read fd)))
            (link p x) ) )
      (close fd)
      lst >

[++++++
<de readStrg (nm)
   (local (fd lst p x)
      (setq fd (doOpen nm))
      (when (setq lst (cons (getline fd)))
         (setq p lst)
         (while (setq x (getline fd))
            (link p x) ) )
      (close fd)
      lst >
++++++]

<de readData ()
   (catch 'error
      (setq
         *digi (tty (read1 "digi.dat"))
         *font1 (readList "font1.dat")
         *font2 (readList "font2.dat")
         *plot (readList "plotter.dat")
         *path (readList "path.dat")
         *home (read1 "home.dat")
         *stat (readList "status.dat")
         *strg (readList "string.dat") >

<de readFile (nm s)
   (local (fd n buf)
      (unless (setq fd (open nm))
         (cosyError nm s) )
      (setq n (fsize fd))
      (unless (setq buf (alloc (add1 n)))
         (cosyError #(str "Datei zu gross")) )
      (readBlock fd buf n)
      (close fd)
      (byte (add buf n) 0)
      (dynamo free buf) >

<de openJob (nm)
   (catch 'error
      (local (buf s)
         (setq
            buf (readFile nm #(str "Oeffnen Datei Fehler"))
            s nm )
         (while (memq \/ s)
            (pop s) )
         (when (assoc s *norm)
            (cut (assoc s *norm) *norm) )
         (XmTextSetString
            (get
               (setJob (new 'cad nm (dflt-h) (dflt-v) 5))
               'listener)
            (ref buf) )
         (remove *job 'dirty)
         (off *undo *redo)
         (compile)
         (totalCmd) >

<de writeJob (obj)
   (watch *display)
   (local (fd)
      (with *job
         (setq fd (doCreate (append (slot path) (slot name))))
         (writeBlock fd
            (txtPtr (slot listener))
            (txtLen (slot listener)) )
         (remove obj 'dirty)
         (close fd) >

t
