[graf.l 18feb91]

<de circBez (p q r s)
   (local (m b f n d)
      (and
         [(setq m (intsec p (normal q p) s (normal r s) t))]
         (setq
            b (midPt q r)
            f (midPt (midPt (midPt p q) b) (midPt b (midPt r s)))
            m (center p f s)
            n (distPt m f)
            d (div n 100) )
         (leq (abs (sub n (distPt m p))) d)
         (leq (abs (sub n (distPt m s))) d)
         (leq (abs (sub (distPt p f) (distPt f s))) d)
         (cons (rSyst m p q) m) >

[+ Progam a graf +]
<de proGraf (g)
   (catch 'error
      (local (n pt)
         (unMark *job)
         (mapc g
            (lambda (lst)
               (when (setq pt (pop lst))
                  (appStmt (append "grbeg " (setq n (mkGrp))))
                  (appStmt (code "s" (car pt) (cdr pt)))
                  (while lst
                     (appStmt
                        (if (pointp (car lst))
                           (cond
                              ((eq (caar lst) (car pt))
                                 (code "y" (cdr (setq pt (pop lst)))) )
                              ((eq (cdar lst) (cdr pt))
                                 (code "x" (car (setq pt (pop lst)))) )
                              (t
                                 (setq pt (pop lst))
                                 (code "xy" (car pt) (cdr pt)) ) )
                           (code "bezier"
                              (caaar lst) (cdaar lst)
                              (cadar lst) (cddr (pop lst))
                              (car (setq pt (pop lst))) (cdr pt) ) ) ) )
                  (appStmt (append "grend " n)) ) ) )
         (setq n (length (get *job 'strokes)))
         (dotPos)
         (compile)
         (reDraw) >

[+ Check if zug is a hole in graf +]
<de isHole (z g)
   (find g
      (lambda (l)
         (and
            (neq l z)
            (inside (car z) 10000 (list l)) >

<de secBez (n p q r s)
   (if (minusp (dec n))
      (sift
         (intsec pt1 pt2 p q)
         (intsec pt1 pt2 q r)
         (intsec pt1 pt2 r s) )
      (local (a b c d e f)
         (setq
            a (midPt p q)
            b (midPt q r)
            c (midPt r s)
            d (midPt a b)
            e (midPt b c)
            f (midPt d e) )
         (nconc
            (secBez n p a d f)
            (secBez n f e c s) >

[+ Intersect graf with a line +]
<de secGraf (g pt1 pt2)
   (mapcan g
      (lambda (lst)
         (local (l pt p)
            (setq l)
            (when (setq pt (pop lst))
               (while lst
                  (setq l
                     (nconc l
                        (if (pointp (car lst))
                           (when
                              (setq p
                                 (intsec pt1 pt2 pt (setq pt (pop lst))) )
                              (list p) )
                           (secBez 5
                              pt
                              (caar lst)
                              (cdr (pop lst))
                              (setq pt (pop lst)) ) ) ) ) ) )
            l >

[+ Reverse a zug +]
<de anti (z)
   (local (lst)
      (setq lst)
      (mapc z
         (lambda (x)
            (push
               (if (pointp x)
                  x
                  (cons (cdr x) (car x)) )
               lst ) ) )
      lst >

[+ Check for cyclonality +]
(setq $c-scl (sqr 10000))

<de area (lst)
   (local (n pt x)
      (zero n)
      (setq pt (pop lst))
      (while (setq x (pop lst))
         (if (pointp x)
            (setq
               n (add n
                  (sub
                     (muldiv (car pt) (cdr x) #$c-scl)
                     (muldiv (cdr pt) (car x) #$c-scl) ) )
               pt x )
            (setq
               n (add n
                  (sub
                     (muldiv (car pt) (cdar x) #$c-scl)
                     (muldiv (cdr pt) (caar x) #$c-scl) )
                  (sub
                     (muldiv (caar x) (cddr x) #$c-scl)
                     (muldiv (cdar x) (cadr x) #$c-scl) ) )
               pt (cdr x) ) ) )
      n >

<de cyclon (lst)
   (minusp (area lst)) >

[+ Low-level bezier-intersections +]
<de splitBez (pt p q r s)
   (local (a b c d e f m)
      (setq
         a (midPt p q)
         b (midPt q r)
         c (midPt r s)
         d (midPt a b)
         e (midPt b c)
         f (midPt d e)
         m (div (dist p s) 8) )
      (cond
         ((nearPt pt p m)
            (list (list pt) (list pt (cons q r))) )
         ((nearPt pt f m)
            (list (list (cons a d) pt) (list pt (cons e c))) )
         ((nearPt pt s m)
            (list (list (cons q r) pt) (list pt)) )
         (t
            (if (lessp (dist p pt) (dist pt s))
               (local (m w x)
                  (setq
                     m (midPt e c)
                     w (midPt
                        (midPt m (midPt f e))
                        (midPt m (midPt c s)) )
                     x (bezier
                        (car pt) (cdr pt)
                        (car f) (cdr f)
                        (car w) (cdr w)
                        (car s) (cdr s) ) )
                  [(if (nearPt pt (car x))
                     (break$ 1) )]
                  (list
                     (list pt)
                     (list pt x) ) )
               (local (m v x)
                  (setq
                     m (midPt a d)
                     v (midPt
                        (midPt m (midPt p a))
                        (midPt m (midPt d f)) )
                     x (bezier
                        (car p) (cdr p)
                        (car v) (cdr v)
                        (car f) (cdr f)
                        (car pt) (cdr pt) ) )
                  [(if (nearPt (cdr x) pt)
                     (break$ 2) )]
                  (list
                     (list x pt)
                     (list pt) >

[+ Connect two grafs +]
<de chain (g1 g2)
   (local (x)
      (mapc g2
         (lambda (l2)
            (cond
               ((setq x
                     (find g1
                        (lambda (l1) (nearPt (last l1) (car l2))) ) )
                  (nconc x (cdr l2)) )
               ((setq x
                     (find g1
                        (lambda (l1) (nearPt (last l1) (last l2))) ) )
                  (nconc x (cdr (anti l2))) )
               (t (setq g1 (nconc1 g1 l2))) ) ) )
      (map g1
         (lambda (g)
            (while
               (or
                  (and
                     (setq x
                        (find (cdr g)
                           (lambda (l)
                              (nearPt (last (car g)) (car l)) ) ) )
                     (nconc (car g) (cdr x)) )
                  (and
                     (setq x
                        (find (cdr g)
                           (lambda (l)
                              (nearPt (last (car g)) (last l))) ) )
                     (nconc (car g) (cdr (anti x))) ) )
               (cut x g) ) ) )
      g1 >

[+ Clean up graf zug +]
<de sauber (g)
   (local (res p pt x)
      (mapcan g
         (lambda (z)
            (when z
               (setq res (setq p (chop 1 z)))
               (while z
                  (setq pt (car p))
                  (if (pointp (setq x (pop z)))
                     (when (farPt pt x)
                        (link p x) )
                     (cond
                        ((nearPt (car x) (cdr x))
                           (when (farPt pt (car x))
                              (link p (car x)) ) )
                        ((nearPt pt (car x))
                           (link p (cdr x)) )
                        ((nearPt (cdr x) (car z))
                           (link p (car x))
                           (link p (pop z)) )
                        (t
                           (link p x)
                           (link p (pop z)) ) ) ) )
               (when (cdr res)
                  (list res) >

t
