[hpgl.l 01aug91]

(off $fd $aufl $pass)
(zero $cnt)
(setq $scl 10000)
(setq $style 'PLAIN)

<de plotIt (w)
   (local (l p)
      (catch 'error
         (when
            (setq l
               (dialog #(str "Plotfenster")
                  '(#(str "Plotter Name")
                     #(str "Horizontal")
                     #(str "Vertikal") )
                  (list
                     (caar *plot)
                     (usForm (cdr (assoc 'X (car *plot))))
                     (usForm (cdr (assoc 'Y (car *plot)))) )
                  (lambda (w)
                     (local (p)
                        (and
                           (eq w (cadr *editItems))
                           (setq p
                              (assoc
                                 (string (txtPtr (car *editItems)))
                                 *plot ) )
                           (XmTextSetString
                              (cadr *editItems)
                              (usForm (cdr (assoc 'X p))) )
                           (XmTextSetString
                              (caddr *editItems)
                              (usForm (cdr (assoc 'Y p))) ) ) ) ) ) )
            (unless (setq p (assoc (car l) *plot))
               (cosyError (car l) #(str "falscher Plotter-Name")) )
            (setq
               $aufl (cdr (assoc 'aufl p))
               $pass (cdr (assoc 'pass p)) )
            (mkHpgl (append *home "tmp/hpgl.plot")
               (number (cadr l) 4)
               (number (caddr l) 4) )
            (doSys (cdr (assoc 'DEVICE p))) >

<de doSys (s)
   (local (*a *b)
      (unless
         (match '(*a \$ \H \O \M \E \/ *b) s)    [look for "$HOME/" ]
         (cosyError #(str "Datei Erstellungsfehler ") s) )
      (system (append *a *home *b)) >

<de hpglCmd (w)
   (catch 'error
      (setq
         $aufl 1000
         $pass 100000 )
      (fileDialog "HPGL" mkHpgl) >

<de mkHpgl (nm x y)
   (local (r)
      (dupInit)
      (zero $pen $pos-h $pos-v $scl-h $scl-v)
      (setq
         r (total (get *job 'strokes))
         $scl (if x
            (min
               10000
               (muldiv 10000 x (right r))
               (muldiv 10000 y (bottom r)) )
            10000 )
         $fd (doCreate nm) )
      (passKreuz)
      (all hpgl (get *job 'strokes))
      (passKreuz)
      (prline "IN;" $fd)
      (close $fd) >

<de hpglScl (n)
   (div (muldiv n $scl 10000) $aufl) >

<de hpgl-h (n)
   (setq $pos-h n)
   (setq n (hpglScl n))
   (prog1
      (format (sub n $scl-h))
      (setq $scl-h n) >

<de hpgl-v (n)
   (setq $pos-v n)
   (setq n (hpglScl n))
   (prog1
      (format (sub n $scl-v))
      (setq $scl-v n) >

<de hpgl2 (pt)
   (append (hpgl-h (car pt)) "," (hpgl-v (cdr pt))) >

<de passKreuz ()
   (when $pass
      (local (n)
         (setq n (div2 $pass))
         (prin2 "PR PU" $fd)
         (prin2 (hpgl-h (minus n)) $fd)
         (prin2 "," $fd)
         (prin2 (hpgl-v 0) $fd)
         (prin2 "PD" $fd)
         (prin2 (hpgl-h n) $fd)
         (prin2 ",0PU" $fd)
         (prin2 (hpgl-h 0) $fd)
         (prin2 "," $fd)
         (prin2 (hpgl-v (minus n)) $fd)
         (prin2 "PD0," $fd)
         (prin2 (hpgl-v n) $fd)
         (prline ";" $fd) >

<de stChk (obj)
   (local (n)
      (with obj
         (setq n (cdr (assoc 'pen (slot status))))
         (unless (eq n $pen)
            (setq $pen n)
            (prline
               (append "SP" (and (numberp n) (format n)) ";")
               $fd ) )
         (setq n (cdr (assoc 'STYLE (slot status))))
         (unless (eq n $style)
            (setq $style n)
            (case n
               ('plain
                  (prline "LT;" $fd) )
               ('dotted
                  (prline "LT 2;"$fd) >

<de brChk (obj)
   (local (n)
      (with obj
         (setq n (cdr (assoc 'count (slot status))))
         (unless (eq n $cnt)
            (prline
               (case (setq $cnt n)
                  (0 "BR1;")
                  (1 "BR9;")
                  (t (append "BR" (format n) ";")) )
               $fd >

[+++ Stroke HPGL Methods +++]
<de hpglArc (pa m pe f)
   (unless (and (eq $pos-h (car pa)) (eq $pos-v (cdr pa)))
      (prin2 "PU" $fd)
      (prin2 (hpgl2 pa) $fd)
      (prin2 ";PD;" $fd) )
   (prin2 "AR " $fd)
   (prin2 (hpgl2 m) $fd)
   (setq
      $scl-h (hpglScl (setq $pos-h (car pe)))
      $scl-v (hpglScl (setq $pos-v (cdr pe))) )
   (prin2 "," $fd)
   (prin2
      (format
         (div
            (if f
               (minus (wDiff (winkl m pa) (winkl m pe)))
               (wDiff (winkl m pe) (winkl m pa)) )
            100 )
         2 )
      $fd )
   (prline ";" $fd) >

<to hpgl stroke (obj)
   (local (g f [x])
      (when (setq g (dupChk (get obj 'graf)))
         (stChk obj)
         (brChk obj)
         [(prin2 "PR " $fd)]
         (off f)
         (draw 1000 g
            (lambda (h1 v1 h2 v2)
               (if (and (eq h1 $pos-h) (eq v1 $pos-v))
                  [(and f (prin2 "," $fd))]
                  (prin2 (if f "," "PR ") $fd)
                  (progn
                     (prin2 "PU" $fd)
                     (prin2 (hpgl-h h1) $fd)
                     (prin2 "," $fd)
                     (prin2 (hpgl-v v1) $fd)
                     (prin2 "PD" $fd) ) )
               (prin2 (hpgl-h h2) $fd)
               (prin2 "," $fd)
               (prin2 (hpgl-v v2) $fd)
               (on f) )
            [(lambda (p q r s)
               (when (setq x (circBez p q r s))
                  (and f (prline ";" $fd))
                  (hpglArc p (cdr x) s (car x))
                  (off f)
                  t ) )] )
         (and f (prline ";" $fd)) >

(to hpgl s-set (obj))

<to hpgl s-circle (obj)
   (stChk obj)
   (brChk obj)
   (with obj
      (hpglArc
         (caar (slot graf))
         (slot pt)
         (last (last (slot graf)))
         (rSyst
            (slot pt)
            (caar (slot graf))
            (car (cadar (slot graf))) >

<to hpgl s-grp (obj)
   (all hpgl (get obj 'strokes)) >


[+++ Purup Autocad HPGL +++]

<de purupCmd (w)
   (catch 'error
      (setq
         $aufl 250
         $pass 100000 )
      (fileDialog "PURUP" mkPurup) >

<de mkPurup (nm)
   (local (r)
      (dupInit)
      (off $pos-h $pos-v)
      (setq
         r (total (get *job 'strokes))
         $scl 10000
         $fd (doCreate nm) )
      (prin2 "Autocad;" $fd)
      (purupKreuz)
      (all purup (get *job 'strokes))
      (purupKreuz)
      (prin2 "PU;" $fd)
      (close $fd) >

<de purupScl (n)
   (div (muldiv n $scl 10000) $aufl) >

<de purup-h (n)
   (setq $pos-h n)
   (format (purupScl n)) >

<de purup-v (n)
   (setq $pos-v n)
   (format (purupScl n)) >

<de purupKreuz ()
   (when $pass
      (local (n)
         (setq n (div2 $pass))
         (prin2
            (append "PU;PA" (purup-h 0) "," (purup-v 0) ";")
            $fd )
         (prin2
            (append "PD;PA" (purup-h n) "," (purup-v 0) ";")
            $fd )
         (prin2
            (append "PU;PA" (purup-h 0) "," (purup-v 0) ";")
            $fd )
         (prin2
            (append "PD;PA" (purup-h 0) "," (purup-v n) ";")
            $fd >

[+++ Stroke Purup Methods +++]
<to purup stroke (obj)
   (local (g)
      (when (setq g (dupChk (get obj 'graf)))
         (draw 1000 g
            (lambda (h1 v1 h2 v2)
               (unless (and (eq h1 $pos-h) (eq v1 $pos-v))
                  (prin2
                     (append "PU;PA"
                        (purup-h h1) ","
                        (purup-v v1) ";"
                        "PD;")
                     $fd ) )
               (prin2
                  (append "PA" (purup-h h2) "," (purup-v v2) ";")
                  $fd >

(to purup s-set (obj))

<to purup s-grp (obj)
   (all purup (get obj 'strokes)) >

t
