[main.l 10jul91]

<de init ()
   [# -eye
   (unless (hlInit $modAd)
      (prline "Hardlock Missing")
      (quit) )
   ]
   (XtToolkitInitialize)
   (setq *cont-a (XtCreateApplicationContext))
   (when (zerop (setq *display (XtOpenDisplay *cont-a "aa" "Cosy")))
      (error "Can't open X-disp") )
   (setq *screen
      (portRect *display (DefaultRootWindow *display)) )
   [(new 'showwin
      "XXXXX" (list "Alex & Gerd sind einfach gut") )]
   (timeOut *cont-a #period idle)
   (readData)
   (and *digi (initDG))
   (loadFonts)
   (setq *mkey)
   (setq *menu (cadMenu 0 0))
   (mkDlg)
   (mkFDlg)
   (mkConf)
   (do init 'statWin)
   [# -debug
   (crash #SIGFPE doCrash)
   (crash #SIGILL doCrash)
   (crash #SIGBUS doCrash)
   (crash #SIGSEGV doCrash)
   ]
   (run) >

<de *quit (x)
   (and
      (boundp '*display)
      (not (zerop *display))
      (XCloseDisplay *display) >

<de doCrash (n)
   (crash n doCrash)
   (sysError
      (case n
         (#SIGILL "Illegal instruction")
         (#SIGBUS "Bus error")
         (#SIGSEGV "Segment violation")
         (#SIGFPE "Floating point exception") >

[# -debug
   <define idleSave idle> [For background garbage collection]
]

<de idle ()
   [# -debug (check) ]
   (arrow *display)
   (mapc *jobs
      (lambda (*job)
         (hilite *job)
         ((if (flagp *job 'hilite) remove flag) *job 'hilite) ) )
   (timeOut *cont-a #period idle) >

<de menu (nm h v . lst)
   (local (m rc ps pu)
      (setq m (XtAppCreateShell nm "Cosy" Application *display))
      (XtManageChild
         (setq pu (XmCreateRowColumn m "popup")) )
      (while (atom (car lst))
         (push
            (list (pop lst) (pop lst) (eval (pop lst)))
            *mkey ) )
      (prog1
         (cons m (subMenu pu lst))
         (XtRealizeWidget m)
         (setPHint *display (XtWindow m) h v) >

<de subMenu (pu lst)
   (local (res wg pu2)
      (setq res)
      (while lst
         (if (eq 'str$ (caar lst)) [(stringp (car lst))]
            (local (s c)
               (setq s (eval (pop lst)))
               (when (setq c (pop lst))
                  (push
                     (list c (car lst) (eval (cadr lst)))
                     *mkey )
                  (setq s (append s " \^" (list c))) )
               (XtManageChild
                  (setq wg (XmCreatePushButtonGadget pu s)) )
               (push
                  (cons wg (pop lst))
                  res )
               (callBack wg "activateCallback" (eval (pop lst))) )
            (progn
               (XtManageChild
                  (setq wg
                     (XmCreateCascadeButton
                        pu
                        (eval (caar lst))
                        (setq pu2
                           (XmCreatePulldownMenu pu) ) ) ) )
               (callBack wg "cascadingCallback" able)
               (push
                  (cons wg (subMenu pu2 (cdr (pop lst))))
                  res ) ) ) )
      res >

<de findMenu (w m)
   (when (numberp (car m))
      (if (eq w (pop m))
         m
         (local (x)
            (loop
               (t (atom m))
               (t (atom (car m)))
               (t (setq x (findMenu w (pop m))) x) >

<de able (wg ev)
   (mapc (findMenu wg *menu)
      (lambda (x)
         (when (or (atom (cdr x)) (atom (cadr x)))
            (xtArgs (car x) "ancestorSensitive" (if (eval (cdr x)) 1 0) >


<de loadFonts ()
   (setq *fonts
      (createFont *display (read1 "font.dat")) >
   ["-adobe-courier-medium-r-normal--12-120-75-75-m-70-iso8859-1"]
   ["-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1"]

<de mkDlg ()
   (setq *dlgWg
      (XtAppCreateShell nil "Cosy" Transient *display
         "mappedWhenManaged" 0 [False] ) )
   (XtManageChild
      (setq *dlgPu
         (XmCreateBulletinBoard *dlgWg "dial") ) )
   (XtManageChild
      (setq *dlgP1
         (XmCreatePushButton *dlgPu "  OK  " "x" 50 "y" 250) ) )
   (XtManageChild
      (setq *dlgP2
         (XmCreatePushButton *dlgPu "Cancel" "x" 300 "y" 250) ) )
   (XtManageChild
      (setq *dlgSw (XmCreateScrolledWindow *dlgPu "scrwin"
            "scrollingPolicy" 0 [AUTOMATIC]
            "scrollBarDisplayPolicy" 1 [AS_NEEDED]
            "width" 400
            "height" 225 ) ) )
   (callBack *dlgP1 "activateCallback" dlgOk)
   (callBack *dlgP2 "activateCallback" dlgDone)
   (XtRealizeWidget *dlgWg)
   (setPSHint *display (XtWindow *dlgWg) 100 100 400 280)
   (d-widgets (setq *d-n 30)) >

<de mkFDlg ()
   (setq
      *fDlgWg (XmCreateDialogShell (car *menu))
      *fDlgPu (XmCreateFileSelectionBox *fDlgWg "fsel"
         "helpLabelString" "%Crash" ) )
   (addFDlgEsc
      (XmFileSelectionBoxGetChild *fDlgPu 6 [DIALOG_FILTER_TEXT])
      fdlgDone )
   (addFDlgEsc
      (XmFileSelectionBoxGetChild *fDlgPu 13 [DIALOG_TEXT])
      fdlgDone )
   (callBack *fDlgPu "helpCallback"
      (lambda (w)
         (XtRemoveAllCallbacks w "helpCallback")
         (print "Help" ) ))
   (callBack *fDlgPu "cancelCallback"
      (lambda (w)
         (XtRemoveAllCallbacks w "okCallback")
         (XtUnmanageChild w) ) )
   (XtRealizeWidget *fDlgWg)
   (XtDestroyWidget
      (XmFileSelectionBoxGetChild *fDlgPu 7 [DIALOG_HELP_BUTTON]) >

<de fdlgDone(w)
   (XtRemoveAllCallbacks *fDlgPu "okCallback")
   (XtUnmanageChild *fDlgPu) >

<de confDone (f)
   (setq *dlgResult f)
   (XtUnmanageChild *confPu)
   (on *done) >

<de mkConf ()
   (local (p1 p2)
      (setq *confWg
         (XmCreateDialogShell (car *menu) "" "x" 100  "y" 100) )
      (setq *confPu
         (XmCreateBulletinBoard *confWg "conf") )
      (XtManageChild
         (setq *confStr (XmCreateLabelGadget *confPu)) )
      (XtManageChild
         (setq p1
            (XmCreatePushButton *confPu
               "  OK  " "x" 10 "y" 40
               "showAsDefault" 1 ) ) )
      (XtManageChild
         (setq p2
            (XmCreatePushButton *confPu
               "  No  " "x" 90 "y" 44 ) ) )
      (callBack p1 "activateCallback"
         (lambda (w) (confDone t)) )
      (callBack p2 "activateCallback"
         (lambda (w) (confDone)) )
      (XtRealizeWidget *confWg)
      (XmAddTabGroup p2)
      (xtArgs *confPu "cancelButton" p2 "defaultButton" p1)
      [(setPSHint *display (XtWindow *confWg) 100 100 300 280)] >

t
