[menu.l 19jul91]

<de newCmd (w)
   (off *undo *redo)
   (new 'cad nil (dflt-h) (dflt-v) 5) >

<de openCmd (w)
   (catch 'error
      (memory 40000)
      (fileDialog #(str "Datei oeffnen") openJob) >

<de doSave (w)
   (fileDialog #(str "Save")
      (lambda (nm)
         (catch 'error
            (with *job
               (slot path nil)
               (while (memq \/ nm)
                  (slot path (nconc1 (slot path) (pop nm))) )
               (slot name nm)
               (writeJob *job)
               (XStoreName *display (XtWindow (slot shell)) nm)
               (XStoreName *display (XtWindow (slot transient)) nm) >

<de saveCmd (w)
   (catch 'error
      (with *job
         (if (slot name)
            (writeJob *job)
            (doSave w) >

<de revCmd (w)
   (off *undo *redo)
   (local (buf)
      (catch 'error
         (with *job
            (setq buf
               (readFile
                  (append (slot path) (slot name))
                  #(str "Can't revert")) )
            (XmTextSetString (slot listener) (ref buf))
            (remove *job 'dirty)
            (compile)
            (reDraw) >

<de closeCmd (w)
   (do zap *job) >

$nm

<de delCmd (w)
   (fileDialog #(str "Loeschen")
      (lambda (nm)
         (unless (zerop (erase nm))
            (warn #(str "Nicht loeschbar") nm) >

<de printCmd (w)
   (fileDialog
      #(str "Ausdrucken")
      (lambda (nm)
         (doPrint nm "print.dat" ) >

<de convCmd (w)
   (fileDialog #(str "Source")
      (lambda (nm)
         (setq $nm nm)
         (fileDialog #(str "Destination")
            (lambda (nm)
               (doConvert $nm nm) >

<de dosCmd (w)
   (fileDialog #(str "Copy to DOS")
      (lambda (nm)
         (unless (zerop (system (append "doscp " nm " a:")))
            (warn #(str "DOS Copy Fehler")) >

<de mkdirCmd (w)
   (fileDialog #(str "Create Directory")
      (lambda (nm)
         (unless (zerop (system (append "mkdir " nm)))
            (warn
               (append
                  #(str "Cannot Create Directory")
                  (-1)
                  nm  >

<de dirCmd (w)
   (fileDialog #(str "Destination Directory")
      (lambda (nm)
         (catch 'error
            (unless (eq \/ (last nm))
               (nconc1 nm \/) )
            (mapc (dosDir "a:")
               (lambda (s)
                  (unless
                     (zerop
                        (system
                           (append "doscp " s (-1) nm)  ) )
                     (cosyError #(str "Can't Copy Dos Directory")) >

<de statCmd (w)
   (statDlg) >

<de undoCmd (w)
   (local (*doit x)
      (off *doit)
      (push (setq x (pop *undo)) *redo)
      (XmTextReplace
         (get *job 'listener)
         (car x)
         (add (car x) (length (caddr x)))
         (cadr x) >

<de redoCmd (w)
   (local (*doit x)
      (off *doit)
      (push (setq x (pop *redo)) *undo)
      (XmTextReplace
         (get *job 'listener)
         (car x)
         (add (car x) (length (cadr x)))
         (caddr x) >

<de cutCmd (w)
   (setq *clip (XmTextGetSelection (get *job 'listener)))
   (txPaste) >

<de copyCmd (w)
   (setq *clip (XmTextGetSelection (get *job 'listener))) >

<de pastCmd (w)
   (txPaste *clip) >

<de clrCmd (w)
   (txPaste) >

<de saveSelCmd (w)
   (fileDialog #(str "Save Selection")
      (lambda (nm)
         (local (fd)
            (catch 'error
               (with *job
                  (setq fd (doCreate nm))
                  (writeBlock fd
                     (add
                        (txtPtr (slot listener))
                        (selStart (slot listener)) )
                     (sub
                        (selEnd (slot listener))
                        (selStart (slot listener)) ) )
                  (close fd) >

<de groupCmd (w)
   (catch 'error
      (local (g)
         (with *job
            (insLine
               (append "grbeg " (setq g (mkGrp)))
               (selStart (slot listener)) )
            (insLine
               (append "grend " g)
               (selEnd (slot listener)) )
            (compile)
            (redraw) >

<de dupCmd (w)
   (local (s c)
      (setq
         s (car (get *job 'mark))
         c (get s 'statement) )
      (appStmt
         (if (eq 'grb-stmt (car (class c)))
            (append "gruppe " (usForm (get c 'name)))
            (getStmtText c) ) )
      (program
         (if (get s 'trans)
            (transTrans (get s 'trans) 10000 0 400000 0 10000 400000)
            "trans 1,0,40,0,1,40" >

<de find1Cmd (w)
   (local (s)
      (when
         (setq s
            (dialog #(str "Find")
               '(#(str "Suchen nach:"))
               (list *find) ) )
         (doFind (car s)) >

<de find2Cmd (w)
   (doFind) >

<de showCmd (w)
   (do show (car (get *job 'mark))) >

<de varsCmd (w)
   (local (l)
      (off l)
      (mapc *vars
         (lambda (x)
            (push
               (nconc
                  (nameString (car x))
                  (list -1)
                  (usForm (cdr x)) )
               l ) ) )

      (mapc *merk
         (lambda (x)
            (push
               (nconc
                  (append #(str "Merkpunkt ") (usForm (car x)))
                  (list -1)
                  (usForm (cadr x))
                  (list \,)
                  (usForm (cddr x)) )
               l ) ) )
      (new 'showWin #(str "Variablen") l) >

<de calcCmd (w)
   (catch 'error
      (docalc) >

<de BoundsCmd (w)
   (local (a)
      (setq a (total (get *job 'strokes)))
      (new 'showWin #(str "Grenzen")
         (list
            (append
               #(str "links    ")
               (align (format  (div (left a) 1000) 1) 7) )
            (append
               #(str "rechts   ")
               (align (format  (div (right a) 1000) 1) 7) )
            (append
               #(str "unten    ")
               (align (format (div (top a) 1000) 1) 7) )
            (append
               #(str "oben     ")
               (align (format  (div (bottom a) 1000) 1) 7) >

<de helpCmd (w)
   (catch 'error
      (local (n *p p x l)
         (with *job
            (setq
               n (txtLin (slot listener))
               *p (add (car n) (txtPtr (slot listener))) )
            (when (setq p (parse))
               (setq x (pop p))
               (when
                  (setq l
                     (if (stringp x)
                        (getDialog x (normCode x) (delimComma p))
                        (and
                           (find *c-tab
                              (lambda (c)
                                 (and
                                    (eq x (caar c))
                                    (setq l (caddr c)) ) ) )
                           (helpDialog x l (delimComma p)) ) ) )
                  (insLine l (car n) (cdr n))
                  (hiText *job (add (car n) (length l) 1))
                  (compile)
                  (reDraw) >

<de singlCmd (w)
   (with *job
      (initExec *job)
      (hiStmt
         (car
            (slot step (cdr (slot code))) ) )
      (do setStat 'statWin (slot pos) (slot status1))
      (refresh) >

<de brkCmd (w)
   (catch 'error
      (local (n)
         (with *job
            (setq n (car (txtLin (slot listener))))
            (initExec *job)
            (slot step (cdr (slot code)))
            (while
               (and
                  (slot step)
                  (neq n (get (car (slot step)) 'text1)) )
               (do step (car (slot step))) )
            (do setStat 'statWin (slot pos) (slot status1))
            (reDraw) >

<de runCmd (w)
   (catch 'error
      (with *job
         (watch *display)
         (initExec *job)
         (all exec (cdr (slot code)))
         (do setStat 'statWin (slot pos) (slot status1))
         (reDraw) >

<de execCmd (w)
   (catch 'error
      (with *job
         (do step (car (slot step)))
         (do setStat 'statWin (slot pos) (slot status1))
         (reDraw) >

<de blkCmd (w)
   (catch 'error
      (with *job
         (if (listp (car (slot stack)))
            (progn
               (do exec (car (slot step)))
               (nextStep) )
            (do step (car (slot step))) )
         (do setStat 'statWin (slot pos) (slot status1))
         (reDraw) >

<de optCmd (w)
   (catch 'error
      (optDlg) >

<de pickCmd (w)
   (with *job
      (program
         (append "pick"
            (rplaca
               (mapcan
                  (findStroke (car (slot mark)) (slot strokes))
                  (lambda (s) (append "," (usForm s))) )
               -1 ) ) )
      (local (s)
         (setq s (lastStroke))
         (mark *job (list s))
         (hiStmt (get s 'statement)) >

<de movCmd (w)
   (catch 'error
      (doMove (car (get *job 'mark))) >

<de rotCmd (w)
   (catch 'error
      (doRotate (car (get *job 'mark))) >

<de sclCmd (w)
   (catch 'error
      (doScale (car (get *job 'mark))) >

<de mirCmd (w)
   (catch 'error
      (doMirror (car (get *job 'mark))) >

<de invCmd (w)
   (catch 'error
      (doInvert (car (get *job 'mark))) >

<de pastPt (w)
   (local (pt)
      (when (setq pt (click hvSpot))
         (txPaste
            (append (usForm (car pt)) "," (usForm (cdr pt))) >

<de pastX (w)
   (local (pt)
      (when (setq pt (click hvSpot))
         (txPaste (usForm (car pt))) >

<de pastY (w)
   (local (pt)
      (when (setq pt (click hvSpot))
         (txPaste (usForm (cdr pt))) >

<de pastLen (w)
   (local (pt1 pt2)
      (when
         (and
            (setq pt1 (click hvSpot))
            (setq pt2 (click hvSpot stiff pt1 line2)) )
         (txPaste (usForm (distPt pt1 pt2))) >

<de pastAng (w)
   (local (a)
      (when (setq a (rot1))
         (txPaste (usForm [(muldiv] a [10000 64]))) >

<de fitXCmd (w)
   (catch 'error
      (doFitX (get (car (get *job 'mark)) 'statement)) >

<de fitYCmd (w)
   (catch 'error
      (doFitY (get (car (get *job 'mark)) 'statement)) >

<de tglCmd (w)
   ((if (flagp *job 'grid) remove flag) *job 'grid)
   (refresh) >

<de gridCmd (w)
   (when (gridDialog)
      (reDraw t) >

<de urspCmd (w)
   (catch 'error
      (urspDlg) >

<de drehwCmd (w)
   (catch 'error
      (DrehwDlg) >

<de spglxCmd (w)
   (catch 'error
      (insLine "Spiegeln x" (selEnd (get *job 'listener)))
      (compile)
      (reDraw) >

<de spglyCmd (w)
   (catch 'error
      (insLine "Spiegeln y" (selEnd (get *job 'listener)))
      (compile)
      (reDraw) >

<de pumkCmd (w)
   (catch 'error
      (insLine "Punktumk" (selEnd (get *job 'listener)))
      (compile)
      (reDraw) >

<de vergCmd (w)
   (catch 'error
      (vergDlg) >

<de optDlgCmd (w)
   (catch 'error
      (optdlg) >

<de ntzCmd (w)
   (catch 'error
      (nuzzenDlg) >

[+++ Macros +++]
<de isMark get *job 'mark>
<de isText get (car (get *job 'mark)) 'statement 'text1>
<de isCode get *job 'code>
<de isStep get *job 'step>
<de isSlct
   and
   (setq $l (get *job 'listener))
   (neq (selStart $l) (selEnd $l)) >


[+++ Define main menu +++]
<de cadMenu (h v)
   (menu "cosyap" h v
      [# -debug #(XK-F 12) t (lambda (w) (*test w)) ]
      #(XK-F 11) t (lambda (w) (print (toggle *circles)))
      #XK-Return *job (lambda (w)
         (catch 'error
            (unMark *job)
            (compile)
            (redraw)
            (markSelection) ) )
      #(XK-F 1) *job helpCmd
      (#(str "FILE")
         #(str "NEW") \n t newCmd
         #(str "OPEN ..") \o t openCmd
         #(str "SAVE") \s (flagp *job 'dirty) saveCmd
         #(str "SAVE AS ..") nil *job doSave
         [# -debug
         #(str "SAVE LAYOUT ..") nil *job saveLyCmd
         ]
         #(str "REVERT") nil
         (and (get *job 'name) (flagp *job 'dirty)) revCmd
         #(str "CLOSE") \w *job closeCmd
         (#(str "SPECIAL")
            #(str "DELETE ..") nil t delCmd
            #(str "MKDIR ..") nil t mkdirCmd
            #(str "CONVERT ..") nil t convCmd
            #(str "COPY TO DOS..") nil t dosCmd
            #(str "COPY DOS-DIRECTORY ..") nil t dirCmd
            #(str "STATUS ..") nil t statCmd )
         (#(str "OUTPUT")
            #(str "PRINT ..") nil t printCmd
            #(str "LA1 ..") nil *job la1Cmd
            #(str "LA2 ..") nil *job la2Cmd
            #(str "HPGL ..") nil *job hpglCmd
            [# -wild
            #(str "WILD ..") nil t wildCmd
            ]
            [# -purup
            #(str "PURUP ..") nil *job purupCmd
            ]
            [# -postScript
            #(str "POSTSCRIPT ..") nil *job psCmd
            ]
            [# -quickStep
            #(str "QUICKSTEPPER ..") nil *job quickStepCmd
            ]
            #(str "PLOT IT") nil *job plotIt )
         #(str "QUIT") \q t
         (lambda (w)
            (when (confirm #(str "Sure to Quit?"))
               (on *done) ) ) )
      (#(str "EDIT")
         #(str "UNDO") \u *undo undoCmd
         #(str "REDO") \r *redo redoCmd
         #(str "CUT") \x #isSlct cutCmd
         #(str "COPY") \c #isSlct copyCmd
         #(str "PASTE") \v (and *job *clip) pastCmd
         #(str "CLEAR") nil #isSlct clrCmd
         #(str "SAVE") nil #isSlct saveSelCmd
         #(str "GROUP") \g #isSlct groupCmd
         #(str "DUPLICATE") \d #isText dupCmd
         #(str "FIND ..") \F *job find1Cmd
         #(str "FIND SAME") \f (and *job *find) find2Cmd )
      (#(str "GRAPHICS")
         #(str "SET") nil *job fix-set
         #(str "LINE") nil *job fix-line
         #(str "CIRCLE") nil *job fix-circle
         #(str "POLY") nil *job fix-poly
         #(str "BEZIER") nil *job fix-bez
         #(str "SPLINE") nil *job fix-spline
         #(str "RECTANGLE") nil *job fix-rect
         #(str "ELLIPSE") nil *job fix-ellipse
         (#(str "BEMASSEN")
            #(str "WINKEL") nil *job BemwCmd
            #(str "RADIUS") nil (get (car (get *job 'mark)) 'pt) bemrCmd
            #(str "LINE") nil *job bemlCmd
            #(str "X") nil (get *job 'strokes) bemxCmd
            #(str "XA") nil (get *job 'strokes) bemxaCmd
            #(str "Y") nil  (get *job 'strokes) bemyCmd
            #(str "YA") nil (get *job 'strokes) bemyaCmd )
         #(str "BORDER ..") nil *job borderCmd )
      (#(str "CONTROL")
         #(str "SHOW") nil #isMark showCmd
         #(str "VARIABLES") nil *vars varsCmd
         #(str "BOUNDS") nil (get *job 'strokes) boundsCmd
         #(str "HELP") \? *job helpCmd
         #(str "SINGLE STEP") nil #isCode singlCmd
         #(str "BREAKPOINT") nil #isCode brkCmd
         #(str "END") \E #isCode runCmd
         #(str "EXECUTE STEP") \e #isStep execCmd
         #(str "BLOCK SKIP") \b #isStep blkCmd
         (#(str "SCALE")
            #(str "ZOOM") \z *job zoomCmd
            #(str "TOTAL") \t #isCode totalCmd
            #(str "SCALE UP") \+ *job
            (lambda (w)
               (changeScale (mul2 (get *job 'scale))) )
            #(str "SCALE DOWN") \- (and *job (lessp 1 (get *job 'scale)))
            (lambda (w)
               (changeScale (div2 (get *job 'scale))) ) )
         #(str "CALC") nil (get *job 'strokes)  calcCmd
         #(str "GRID") nil (get *job 'grid-h) tglCmd
         #(str "GRID ..") nil *job gridCmd )
      (#(str "MODIFY")
         #(str "PICK") nil #isMark pickCmd
         #(str "MOVE") nil #isText movCmd
         #(str "ROTATE") nil #isText rotCmd
         #(str "SCALE") nil #isText sclCmd
         #(str "MIRROR") nil #isText mirCmd
         #(str "INVERT") nil #isText invCmd
         (#(str "PASTE")
            #(str "POINT") nil *job pastPt
            #(str "X") nil *job pastX
            #(str "Y") nil *job pastY
            #(str "LENGTH") nil *job pastLen
            #(str "ANGLE") nil *job pastAng )
         #(str "FIT X") nil #isText fitXCmd
         #(str "FIT Y") nil #isText fitYCmd )
      (#(str "OPTIONEN")
         #(str "URSPRUNG") nil (get *job 'strokes) urspCmd
         #(str "DREHWINKEL") nil (get *job 'strokes) drehwCmd
         (#(str "SPIEGELN")
            #(str "X") nil (get *job 'strokes) spglxCmd
            #(str "Y") nil (get *job 'strokes) spglyCmd )
         #(str "PUNKTUMKEHR") nil (get *job 'strokes) pumkCmd
         #(str "VERGROESSERUNG") nil (get *job 'strokes) vergCmd
         #(str "OPTIONEN ..") nil (get *job 'strokes) optdlgCmd
         #(str "NUTZEN ..") nil (get *job 'strokes) ntzCmd
         #(str "SPLIT") nil (get *job 'strokes) splitCmd )
      >

t
