[runlib.l 10jul91]

<de c-takeall (l)
   (when l
      (off *statlist)
      (with *job
         (mapc (slot strokes)
            (lambda (s)
               (do ww s l) ) )
         (slot strokes *statlist)
         (when (slot strokes)
            (unless (do setpos (last (slot strokes)))
               (setpos (0.0)) ) ) )
      (redraw t) >

<de c-bemsize (n)
   (put *job 'bemsize n) >

<de c-exit (s)
   (when (confirm (append  s " [OK=Exit]"))
      (warn #(str "Beendigung durch Exit !!"))
      (throw 'error) >

<de c-format (n a b . $l)
   (setq
      a (abs (div a 10000))
      b (abs (div b 10000))
      n (format n 4) )
   (while (leq (inc b) 4)
      (shift n) )
   (while (lessp (index \. n) a)
      (if (minusp (car n))
         (rplaca n (sub1 (car n)))
         (push 32 n) ) )
   (putStr n (car $l)) >

<de print$ (n)
   (prline (usForm n)) >

<de nameString (x)
   (if (eq x 'nil$)
      "nil"
      (local (s)
         (setq
            x (pname x)
            s )
         (while x
            (setq s
               (nconc1 s
                  (lowc
                     (case (car x)
                        (\- (pop x) \_)
                        (\$ (pop x) (sub (pop x) #(sub \A \1)))
                        (t (pop x)) >
<de formExpr (l)
   (if (isString l)
      (append "\"" (car l) "\"")
         (local (f)
            (off f)
            (mapcan l
               (lambda (x)
                  (cond
                     ((numberp x)
                        (prog1
                           (append (and f " ") (usForm x))
                           (on f) ) )
                     ((symbolp x)
                        (prog1
                           (append (and f " ") (nameString x))
                           (on f) ) )
                     (t (off f) (copy x)) >

<de getVal ($x)
   (or
      (cdr (assoc $x *vars))
      (execErr (nameString $x) #(str ": Variable nicht definiert")) >

<de get$ $x
   (getVal (car $x)) >

<de putVal (v $x)
   (local (x)
      (if (setq x (assoc $x *vars))
         (rplacd x v)
         (push (cons $x v) *vars) >

<de put$ (v . $l)
   (putVal v (car $l)) >

<de getStr ($x)
   (unless (assoc $x *strs)
      (execErr (nameString $x) #(str "String-Variable nicht definiert")) )
   (cdr (assoc $x *strs)) >

<de gets$ $x
   (getStr (car $x)) >

<de putStr (v $x)
   (local (x)
      (if (setq x (assoc $x *strs))
         (rplacd x v)
         (push (cons $x v) *strs) >

<de puts$ (v . $l)
   (putStr v (car $l)) >

<de default$ (v . $x)
   (setq $x (car $x))
   (unless (cdr (assoc $x *vars))
      (push (cons $x v) *vars) >

<de getStat (s)
   (or
      (assoc s *stat)
      (execErr s #(str ": Unbekannter Status")) >

<de stat$ (s)
   (put *job 'status (stat1$ s)) >

<de stat1$ (s)
   (put *job 'status1 (getStat s)) >

<de c-pick lst
   (local (s)
      (with *job
         (unless
            (and
               (setq lst (mapcar lst eval))
               (setq s (indStroke lst (slot strokes))) )
            (elemErr) )
         (put s 'statement *stmt)
         (setStat s)
         (slot strokes
            (nconc1 (cutStroke lst (slot strokes)) s) >

<de c-abszisse lst
   (with *job
      (while lst
         (slot abszisse
            (cons (eval (pop lst)) (slot abszisse)) >

<de c-ordinate lst
   (with *job
      (while lst
         (slot ordinate
            (cons (eval (pop lst)) (slot ordinate)) >

<de sel$ (n . $l)
   (local (l r)
      (setq
         l (cadr $l)
         r (caddr $l) )
      (while
         (and
            (pairp l)
            (lessp (eval (pop l)) n) )
         (pop r) )
      (putVal (eval (car r)) (car $l)) >

<de norm$ (s . a)
   (local (obj c *args *resv)
      (flag *job 'detail) [+ only for network version +]
      (setq obj (if (flagp *job 'detail) 's-grp 's-norm))
      [+  (remove *job 'detail) +] [+ comment for nwv +]
      (setq
         c (normCode s)
         *args )
      (reptn (sub (length a) (car c))
         (setq *args (nconc1 *args (eval (pop a)))) )
      (local (*vars *strs *grps *merk)
         (off *vars *strs *grps *merk *resv)
         (superStroke obj (cdr c)) )
      (when
         (or
            (neq (length a) (length *resv))
            (memq nil a)
            (find a (lambda (x) (nand (pairp x) (eq 'get$ (car x))))) )
         (execErr #(str "Falsche Anzahl von") #(str "Resultvariablen")) )
      (mapc2 a *resv
         (lambda (x v)
            (putVal v (cadr x)) >

<de resv$ $l
   (setq *resv (mapcar $l eval)) >

[++++++
<de into$ l
   (unless (eq (length l) (length *resv))
      (execErr #(str "Falsche Anzahl von") #(str "Resultvariablen")) )
   (mapc2 *resv l putVal) >
++++++]

<de mul$ (x . l)
   (local (n)
      (while l
         (setq n (eval (pop l)))
         (unless (mulchk x n 10000)
            (arithErr) )
         (setq x
            (muldiv x n 10000) >

<de div$ (x . l)
   (local (n)
      (while l
         (when (zerop (setq n (eval (pop l))))
            (execErr #(str "Div/0")) )
         (unless (mulchk x 10000 n)
            (arithErr) )
         (setq x
            (muldiv x 10000 n) >

<de eq$ (x y)
   (if (eq x y) -10000 0) >

<de ne$ (x y)
   (if (neq x y) -10000 0) >

<de lt$ (x y)
   (if (lessp x y) -10000 0) >

<de le$ (x y)
   (if (leq x y) -10000 0) >

[+++ Point Constructors +++]
<de lw$ (l w)
   (with *job
      (cosyLW (slot pos1) l w) >

<de xw$ (x w)
   (with *job
      (cosyXW (slot pos1) x w) >

<de yw$ (y w)
   (with *job
      (cosyYW (slot pos1) y w) >

[+++ Gruppen-Aufruf +++]
<de c-grp (x)
   (local (l)
      (unless (setq l (assoc x *grps))
         (execErr (usForm x) #(str "Gruppe nicht gefunden")) )
      (new 's-grp (mapcar (cdr l) (lambda (x) (do dup x)))) >

[+++ Merkpunkte +++]
<de c-merk $x
   (setq $x (car $x))
   (when (assoc $x *merk)
      (execErr (usForm $x) #(str "Merkpunkt bereits definiert")) )
   (push (cons $x (get *job 'pos)) *merk) >

<de getMerk ($x)
   (setq $x (car $x))
   (local (m)
      (unless (setq m (assoc $x *merk))
         (execErr (usForm $x) #(str "Merkpunkt nicht gefunden")) )
      (cdr m) >

<de mx$ $x
   (car (getMerk $x)) >

<de my$ $x
   (cdr (getMerk $x)) >

[+++ Actual Pseudo-Variables +++]
<de xa$ ()
   (car (get *job 'pos1)) >

<de ya$ ()
   (cdr (get *job 'pos1)) >

<de la$ ()
   (local (s l n)
      (if (setq s (get *job 'strokes))
         (progn
            (off l)
            (setq n (length s))
            (until
               (or
                  (zerop n)
                  (setq l (do gib-la (nth (dec n) s))) ) )
            l )
         0 >

<de wa$ ()
   (local (s w n)
      (if (setq s (get *job 'strokes))
         (progn
            (off w)
            (setq n (length s))
            (until
               (or
                  (zerop n)
                  (setq w (do gib-wa (nth (dec n) s))) ) )
            w )
         0 >

t
