[statement.l 30jan91]

<de appStmt (s)
   (local (txt n)
      (with *job
         (setq
            txt (txtPtr (slot listener))
            n (txtLen (slot listener)) )
         (or
            (zerop n)
            (eq ^J (byte (add txt (sub1 n))))
            (setq s (cons ^J s)) )
         (insLine s n) >

<de insStmt (c s)
   (insLine s (text2 c)) >

<de rplStmt (c s)
   (with c
      (insLine s (slot text1) (text2 c))
      (hiText *job (slot text1) (add 1 (strlen s) (slot text1))) >

<de hiStmt (c)
   (with c
      (hiText *job (slot text1) (text2 c)) >

<de getStmtText (c)
   (with c
      (hiText *job (slot text1) (sub1 (text2 c)))
      (XmTextGetSelection (get *job 'listener)) >

<de initExec1 (obj)
   (unMark obj)
   (with obj
      (slot step nil)
      (slot stack nil) >

<de initExec (obj)
   (initExec1 obj)
   (off *vars *strs *grps *merk)
   (with obj
      (slot strokes nil)
      (slot stPict nil)
      (slot status
         (slot status1 (car *stat)) )
      (slot abszisse nil)
      (slot ordinate nil)
      (slot ur-x 0)
      (slot ur-y 0)
      (setPos (0.0)) >

<de nextStep ()
   (with *job
      (slot step
         (or
            (cdr (slot step))
            (when (slot stack)
               [(until (pairp (car (slot stack)))
                  (slot stack (cdr (slot stack))) )]
               (prog1
                  (car (slot stack))
                  (slot stack (cdr (slot stack))) ) ) ) )
      (when (slot step)
         (hiStmt (car (slot step))) >

<de singleStep (lst)
   (when lst
      (with *job
         (when (slot step)
            (slot stack
               (cons (slot step) (slot stack)) ) )
         (hiStmt (car (slot step lst))) >

<de text2 (c)
   (with *job
      (min
         (get c 'text2)
         (txtLen (get *job 'listener)) >

<de popTx2 ()
   (slot text2
      (or
         (cadr (pop *parse))
         *max >

(object statement)

<to t (obj n1 n2 [p] c)
   (with obj
      (slot text1 n1)
      (slot text2 n2)
      [(slot parse p)]
      (slot code c) >

<to exec (*stmt)
   (eval (get *stmt 'code)) >

<to step (*stmt)
   (do exec *stmt)
   (nextStep) >


(object get-stmt statement)

<to t (obj n1 n2 [p] c x s v)
   (from statement t obj n1 n2 [p] c)
   (with obj
      (slot var x)
      (slot text s)
      (slot data v) >

<to exec (*stmt)
   (with *stmt
      (putVal
         (if *args
            (pop *args)
            (eval (slot code)) )
         (slot var) >

(object gets-stmt get-stmt)

<to exec (*stmt)
   (with *stmt
      (putStr
         (if *args
            (pop *args)
            (eval (slot code)) )
         (slot var) >


(object if-stmt statement)

<to t (obj n1 n2 [p] a)
   (from statement t obj n1 n2 [p] (evExpr a))
   (with obj
      (slot t nil)
      (slot nil nil)
      (until
         (or
            (null *parse)
            (equal '(ELSE) (cddar *parse))
            (equal '(ENDIF) (cddar *parse)) )
         (slot t (nconc1 (slot t) (compile1))) )
      (when (equal '(ELSE) (cddar *parse))
         (pop *parse)
         (until
            (or
               (null *parse)
               (equal '(ENDIF) (cddar *parse)) )
            (slot nil (nconc1 (slot nil) (compile1))) ) )
      (popTx2) >

<to exec (*stmt)
   (with *stmt
      (all exec
         (if (zerop (eval (slot code)))
            (slot nil)
            (slot t) >

<to step (obj)
   (nextStep)
   (with obj
      (singleStep
         (if (zerop (eval (slot code)))
            (slot nil)
            (slot t) >


(object while-stmt statement)

<to t (obj n1 n2 [p] a)
   (from statement t obj n1 n2 [p] (evExpr a))
   (with obj
      (slot body nil)
      (until
         (or
            (null *parse)
            (equal '(REPEAT) (cddar *parse)) )
         (slot body (nconc1 (slot body) (compile1))) )
      (popTx2) >

<to exec (*stmt)
   (with *stmt
      (until (zerop (eval (slot code)))
         (all exec (slot body)) >

<to step (obj)
   (with obj
      (if (zerop (eval (slot code)))
         (nextStep)
         (singleStep (slot body)) >


(object for-stmt statement)

<to t (obj n1 n2 [p] a b c d)
   (unless (isSymbol a) (syntax))
   (from statement t obj n1 n2 [p]
      (list 'put$ (evExpr b) (car a)) )
   (with obj
      (slot cond
         (list 'leq
            (list 'get$ (car a))
            (evExpr c) ) )
      (slot inc
         (list
            'put$
            (list 'add (list 'get$ (car a)) (evExpr d))
            (car a) ) )
      (slot body nil)
      (until
         (or
            (null *parse)
            (equal '(NEXT) (cddar *parse)) )
         (slot body (nconc1 (slot body) (compile1))) )
      (popTx2) >

<to exec (*stmt)
   (with *stmt
      (eval (slot code))
      (while (eval (slot cond))
         (all exec (slot body))
         (eval (slot inc)) >

<to step (obj)
   (with *job
      (if (eq obj (car (slot stack)))
         (with obj
            (eval (slot inc))
            (if (eval (slot cond))
               (singleStep (slot body))
               (with *job
                  (slot stack (cdr (slot stack)))
                  (nextStep) ) ) )
         (with obj
            (eval (slot code))
            (if (eval (slot cond))
               (progn
                  (with *job
                     (slot stack (cons obj (slot stack))) )
                  (singleStep (slot body)) )
               (nextStep) >


[++ GRUPPEN ++]
(object grb-stmt statement)

<to t (obj n1 n2 [p] x)
   (from statement t obj n1 n2 [p])
   (with obj
      (slot name x)
      (until
         (or
            (null *parse)
            (eq 'GREND (car (cddar *parse))) )
         (slot code (nconc1 (slot code) (compile1))) )
      (or
         (null *parse)
         (eq x (eval (evExpr (cdr (cddar *parse)))))
         (compError #(str "GREND mismatch")) )
      (popTx2) >

<to exec (*stmt)
   (with *stmt
      (push
         (cons
            (slot name)
            (mapcar (get (superStroke 's-grp (slot code)) 'strokes)
               (lambda (x) (do dup x)) ) )
         *grps >

<to step (*stmt)
   (with *job
      (if (eq *stmt (car (slot stack)))
         (local (n x)
            (setq
               n (cadr (slot stack))
               x (new 's-grp (nthcdr n (slot strokes))) )
            (push
               (cons
                  (get *stmt 'name)
                  (mapcar (get x 'strokes)
                     (lambda (x) (do dup x)) ) )
               *grps )
            (if (zerop n)
               (slot strokes (list x))
               (rplacd
                  (nthcdr (sub1 n) (slot strokes))
                  (list x) ) )
            (slot stack (cddr (slot stack)))
            (nextStep) )
         (progn
            (slot stack
               (cons *stmt
                  (cons
                     (length (slot strokes))
                     (slot stack) ) ) )
            (singleStep (get *stmt 'code)) >

t
