/* cosy.c
 * 01aug91gr
 */

#include "../src/pico.h"
#include "cosy.h"

/* Globals */
symInit cosySyms[] = {
   {"ARCLEN",        ArcLen},
   {"BZBEZ",         BzBez},
   {"BZLIN",         BzLin},
   {"COSYSIN",       CosySin},
   {"COSYCOS",       CosyCos},
   {"COSYTAN",       CosyTan},
   {"COSYATAN",      Cosyatan},
   {"COSYASIN",      Cosyasin},
   {"COSYACOS",      Cosyacos},
   {"COSYGXY",       Cosygxy},
   {"COSYKXY",       Cosykxy},
   {"COSYLW",        CosyLw},
   {"COSYCOTAN",     CosyCoTan},
   {"COSYKRINBO",    Cosykrinbo},
   {"COSYSPGK",      Cosyspgk},
   {"COSYSPKK",      Cosyspkk},
   {"COSYSQRT",      Cosysqrt},
   {"FARPT",         FarPt},
   {"HLINIT",        HlInit},
   {"K-EYE",         KEye},
   {"LOTPOINT",      LotPoint},
   {"MPT",           mpt},
   {"NEARPT",        NearPt},
   {"PENETRAT",      Penetrat},
   {"PTANGLE",       ptangle},
   {"QUADGL",        quadgl},
   {"RDBR",          RdBr},
   {"RDGRAF",        RdGraf},
   /* {"RNDPT",         RndPt}, */
   {"ROTZ",          Rotz},
   {"RSYST",         rSyst},
   {"SNAP",          Snap},
   {"TANGENTE",      tangente},
   {"TM",            tm},
   {"WINKL",         Winkl},
   {"WIS",           wis},
   {"WRBR",          WrBr},
   {"WRGRAF",        WrGraf},
   {"ZIPPEL",        Zippel},
   NULL
};


void initApplication()
{
   extern symInit applSyms[];
   extern symInit XLibSyms[], XtSyms[], XmSyms[], XalexSyms[];
   extern symInit cosySyms[];

   initSymTab(applSyms);
   initSymTab(XLibSyms);
   initSymTab(XtSyms);
   initSymTab(XmSyms);
   initSymTab(XalexSyms);
   initSymTab(cosySyms);
}

void initAppVars()
{
   extern void initXSymbols(void);

   initXSymbols();
}

void stopApplication()
{
}
