/* graf.c
 * 08may91abu
 */

#include "../src/pico.h"
#include "cosy.h"

/* Globals */
static point thePt,thePt1,thePt2;

/* Prototypes */
static bool bzBez(point,point,point,point,point,point,point,point);
static bool bzLin(int,point,point,point,point);


pico WrBr(x)
register pico x;
{
   register pico y;
   Afile *f;
   long count;

   push(EVAL1(x)); /* BR-list */
   x = EVAL1(cdr(x));
   NEEDNUM(x);
   f = (Afile*)unBox(x); /* Channel */
   count = length(x = tos);
   if (write(f->fd, (char*)&count, sizeof(long)) < 0)
      return nilSym;
   while (--count >= 0) {
      y = car(x);
      x = cdr(x);
      if (write(f->fd, (char*)&car(y), sizeof(long)) < 0)
         return nilSym;
      y = cdr(y);
      if (write(f->fd, (char*)&car(y), sizeof(long)) < 0 ||
                       write(f->fd, (char*)&cdr(y), sizeof(long)) < 0 )
         return nilSym;
   }
   return pop();
}

pico RdBr(x)
register pico x;
{
   register pico y;
   Afile *f;
   long count, buffer[3];

   x = EVAL1(x);
   NEEDNUM(x);
   f = (Afile*)unBox(x); /* Channel */
   if (read(f->fd, (char*)&count, sizeof(long)) < sizeof(long) || !count)
      return nilSym;
   if (read(f->fd, buffer, 3*sizeof(long)) < 3*sizeof(long))
      return nilSym;
   push(x = newCell(
      newCell((pico)buffer[0], newCell((pico)buffer[1],(pico)buffer[2])),
      nilSym ) );
   while (--count > 0) {
      if (read(f->fd, buffer, 3*sizeof(long)) < 3*sizeof(long))
         return nilSym;
      cdr(x) = newCell(
         newCell((pico)buffer[0], newCell((pico)buffer[1],(pico)buffer[2])),
         nilSym );
      x = cdr(x);
   }
   return pop();
}

pico WrGraf(x)
register pico x;
{
   register pico y,z;
   Afile *f;
   long count, buffer[4];

   push(z = EVAL1(x)); /* Graf */
   x = EVAL1(cdr(x));
   NEEDNUM(x);
   f = (Afile*)unBox(x); /* Channel */
   while (isCell(z)) {
      y = car(z);
      z = cdr(z);
      while (isCell(y)) {
         x = car(y);
         y = cdr(y);
         if (isNum(car(x))) {
            count = 2*sizeof(long);
            buffer[0] = (long)car(x);
            buffer[1] = (long)cdr(x) & ~3;
         }
         else {
            count = 4*sizeof(long);
            buffer[0] = (long)car(car(x)) | 1; /* Bezier flag */
            buffer[1] = (long)cdr(car(x)) & ~3;
            buffer[2] = (long)car(cdr(x));
            buffer[3] = (long)cdr(cdr(x));
         }
         if (!isCell(y)) {
            buffer[1] |= 1; /* End of zug */
            if (!isCell(z))
               buffer[1] |= 2; /* End of graf */
         }
         if (write(f->fd, (char*)buffer, count) < 0)
            return nilSym;
      }
   }
   return pop();
}

pico RdGraf(x)
register pico x;
{
   register pico y;
   Afile *f;
   long buffer[2];

   x = EVAL1(x);
   NEEDNUM(x);
   f = (Afile*)unBox(x); /* Channel */
   if (read(f->fd, buffer, 2*sizeof(long)) < 2*sizeof(long))
      return nilSym;
   push(newCell((pico)buffer[0], (pico)(buffer[1] & ~3 | 2)));
   x = tos = newCell(y = newCell(tos,nilSym), nilSym);
   loop {
      while (!(buffer[1] & 1)) {
         if (read(f->fd, buffer, 2*sizeof(long)) < 2*sizeof(long)) {
            drop();
            return nilSym;
         }
         if (!(buffer[0] & 1)) {
            cdr(y) = newCell(
                       newCell((pico)buffer[0], (pico)(buffer[1] & ~3 | 2)),
                       nilSym );
            y = cdr(y);
         }
         else {
            push(newCell((pico)(buffer[0] & ~1), (pico)(buffer[1] & ~3 | 2)));
            if (read(f->fd, buffer, 2*sizeof(long)) < 2*sizeof(long)) {
               drop2();
               return nilSym;
            }
            cdr(y) = newCell(
                       newCell(tos, newCell((pico)buffer[0], (pico)buffer[1])),
                       nilSym ) ;
            drop();
            y = cdr(y);
         }
      }
      if (buffer[1] & 2)
         break;
      if (read(f->fd, buffer, 2*sizeof(long)) < 2*sizeof(long)) {
         drop();
         return nilSym;
      }
      cdr(x) = newCell(y = newCell(
                     newCell((pico)buffer[0], (pico)(buffer[1] & ~3 | 2)),
                     nilSym ),
               nilSym );
      x = cdr(x);
   }
   return pop();
}

pico Snap(x)
register pico x;
{
   register pico last,z,pz,p,pt,y,g;
   register number pzh,pzv,ph,pv,pth,ptv;

   y = g = EVAL1(x);
   while (isCell(g)) {
      p = (car(last = car(g)));
      ph = unBox(car(p));
      pv = unBox(cdr(p));
      while (isCell(cdr(last)))
         last = cdr(last);
      pt = (car(last));
      pth = unBox(car(pt));
      ptv = unBox(cdr(pt));
      if (dist(ph, pv, pth, ptv) <= 250) {
         car(car(g)) = p = pt;
         ph = pth;
         pv = ptv;
      }
      x = g = cdr(g);
      while (isCell(x)) {
         z = car(x);
         pz = car(z);
         pzh = unBox(car(pz));
         pzv = unBox(cdr(pz));
         if (dist(pzh, pzv, ph, pv) <= 250)
            car(z) = p;
         else if (dist(pzh, pzv, pth, ptv) <= 250)
            car(z) = pt;
         last = z;
         while (isCell(cdr(last)))
            last = cdr(last);
         pz = car(last);
         pzh = unBox(car(pz));
         pzv = unBox(cdr(pz));
         if (dist(pzh, pzv, ph, pv) <= 250)
            car(last) = p;
         else if (dist(pzh, pzv, pth, ptv) <= 250)
            car(last) = pt;
         x = cdr(x);
      }
   }
   return y;
}

pico Zippel(x)
register pico x;
{
   register pico z1,z2,last1,last2,f1,f2,g,y;
   pico sym;

   g = y = EVAL1(x);
   sym = NULL;
   if (isCell(x = cdr(x))) {
      sym = car(x);
      NEEDSYM(sym);
      CHECKSYM(sym);
   }
   while (isCell(g)) {
      z1 = car(g);
      last1 = z1;
      while (isCell(cdr(last1)))
         last1 = cdr(last1);
      last1 = car(last1);
      if (!EQCELL(car(z1),last1)) {
         f1 = f2 = NULL;
         x = y;
         loop {
            z2 = car(x);
            if (z1 != z2) {
               last2 = z2;
               while (isCell(cdr(last2)))
                  last2 = cdr(last2);
               last2 = car(last2);
               if (EQCELL(car(z1),car(z2)) || EQCELL(car(z1),last2))
                  f1 = z2;
               if (EQCELL(last1,car(z2)) || EQCELL(last1,last2))
                  f2 = z2;
            }
            if (f1 && f2)
               break;
            if (!isCell(x = cdr(x))) {
               if (sym)
                  val(sym) = f1? f1 : (f2? f2 : nilSym);
               return z1;
            }
         }
      }
      g = cdr(g);
   }
   return nilSym;
}

pico Penetrat(x)
pico x;
{
   register pico y;
   register long n;
   point pt;
   point a,b,c,d;

   nextPoint(&x,&pt);
   if (isNil(y = EVAL1(x)))
      return nilSym;
   unBoxPoint(isNum(car(y))? y : cdr(y), &a);
   x = cdr(x);
   if (isNil(y = EVAL1(x)))
      return nilSym;
   unBoxPoint(isNum(car(y))? y : car(y), &b);
   x = cdr(x);
   if (isNil(y = EVAL1(x)))
      return nilSym;
   unBoxPoint(isNum(car(y))? y : cdr(y), &c);
   x = cdr(x);
   if (isNil(y = EVAL1(x)))
      return nilSym;
   unBoxPoint(isNum(car(y))? y : car(y), &d);

   if (!(n = pythag(a.h -= pt.h, a.v -= pt.v)))
      return nilSym;
   a.h = muldiv(a.h, 1000000, n);
   a.v = muldiv(a.v, 1000000, n);
   if (!(n = pythag(b.h -= pt.h, b.v -= pt.v)))
      return nilSym;
   b.h = muldiv(b.h, 1000000, n);
   b.v = muldiv(b.v, 1000000, n);
   if (!(n = pythag(c.h -= pt.h, c.v -= pt.v)))
      return nilSym;
   c.h = muldiv(c.h, 1000000, n);
   c.v = muldiv(c.v, 1000000, n);
   if (!(n = pythag(d.h -= pt.h, d.v -= pt.v)))
      return nilSym;
   d.h = muldiv(d.h, 1000000, n);
   d.v = muldiv(d.v, 1000000, n);
   return boxBool(intsec(&a, &b, &c, &d, NO, &pt));
}

pico NearPt(x)
pico x;
{
   point pt1,pt2;

   nextPoint(&x,&pt1);
   nextPoint(&x,&pt2);
   return boxBool(dist(pt1.h,pt1.v,pt2.h,pt2.v) <=
      (isCell(x)? nextNum(&x) : 250) );
}

pico FarPt(x)
pico x;
{
   point pt1,pt2;

   nextPoint(&x,&pt1);
   nextPoint(&x,&pt2);
   return boxBool(dist(pt1.h,pt1.v,pt2.h,pt2.v) >
      (isCell(x)? nextNum(&x) : 250) );
}

bool bzBez(p1,q1,r1,s1,p2,q2,r2,s2)
point p1,q1,r1,s1,p2,q2,r2,s2;
{
   point pt1,pt2;
   point a1,b1,c1,d1,e1,f1,a2,b2,c2,d2,e2,f2;

   pt1 = pt2 = p1;
   BOUNDS(q1,pt1,pt2);
   BOUNDS(r1,pt1,pt2);
   BOUNDS(s1,pt1,pt2);
   if (p2.h<pt1.h && q2.h<pt1.h && r2.h<pt1.h && s2.h<pt1.h  ||
       p2.h>pt2.h && q2.h>pt2.h && r2.h>pt2.h && s2.h>pt2.h  ||
       p2.v<pt1.v && q2.v<pt1.v && r2.v<pt1.v && s2.v<pt1.v  ||
       p2.v>pt2.v && q2.v>pt2.v && r2.v>pt2.v && s2.v>pt2.v )
         return NO;
   if (pt2.h-pt1.h < 6  &&  pt2.v-pt1.v < 6) {
      thePt = p1;
      return YES;
   }
   d1.h = ((a1.h = (p1.h+q1.h)/2) + (b1.h = (q1.h+r1.h)/2)) / 2;
   d1.v = ((a1.v = (p1.v+q1.v)/2) + (b1.v = (q1.v+r1.v)/2)) / 2;
   e1.h = (b1.h + (c1.h = (r1.h+s1.h)/2)) / 2;
   e1.v = (b1.v + (c1.v = (r1.v+s1.v)/2)) / 2;
   f1.h = (d1.h+e1.h)/2;
   f1.v = (d1.v+e1.v)/2;
   d2.h = ((a2.h = (p2.h+q2.h)/2) + (b2.h = (q2.h+r2.h)/2)) / 2;
   d2.v = ((a2.v = (p2.v+q2.v)/2) + (b2.v = (q2.v+r2.v)/2)) / 2;
   e2.h = (b2.h + (c2.h = (r2.h+s2.h)/2)) / 2;
   e2.v = (b2.v + (c2.v = (r2.v+s2.v)/2)) / 2;
   f2.h = (d2.h+e2.h)/2;
   f2.v = (d2.v+e2.v)/2;
   return
      bzBez(p1,a1,d1,f1,p2,a2,d2,f2) ||
      bzBez(p1,a1,d1,f1,s2,c2,e2,f2) ||
      bzBez(s1,c1,e1,f1,p2,a2,d2,f2) ||
      bzBez(s1,c1,e1,f1,s2,c2,e2,f2);
}

pico BzBez(x)
pico x;
{
   point p1,q1,r1,s1,p2,q2,r2,s2;

   nextPoint(&x,&p1);
   nextPoint(&x,&q1);
   nextPoint(&x,&r1);
   nextPoint(&x,&s1);
   nextPoint(&x,&p2);
   nextPoint(&x,&q2);
   nextPoint(&x,&r2);
   nextPoint(&x,&s2);
   return bzBez(p1,q1,r1,s1,p2,q2,r2,s2)? boxPoint(&thePt):nilSym;
}

bool bzLin(n,p,q,r,s)
register int n;
point p,q,r,s;
{
   point a,b,c,d,e,f;

   if (--n < 0)
      return intsec(&thePt1, &thePt2, &p, &s, NO, &thePt);
   d.h = ((a.h = (p.h+q.h)/2) + (b.h = (q.h+r.h)/2)) / 2;
   d.v = ((a.v = (p.v+q.v)/2) + (b.v = (q.v+r.v)/2)) / 2;
   e.h = (b.h + (c.h = (r.h+s.h)/2)) / 2;
   e.v = (b.v + (c.v = (r.v+s.v)/2)) / 2;
   f.h = (d.h+e.h)/2;
   f.v = (d.v+e.v)/2;
   return bzLin(n,p,a,d,f) || bzLin(n,f,e,c,s);
}

pico BzLin(x)
pico x;
{
   point p,q,r,s;

   nextPoint(&x,&p);
   nextPoint(&x,&q);
   nextPoint(&x,&r);
   nextPoint(&x,&s);
   nextPoint(&x,&thePt1);
   nextPoint(&x,&thePt2);
   if (thePt1.h==p.h && thePt1.v==p.v || thePt1.h==s.h && thePt1.v==s.v)
      return boxPoint(&thePt1);
   if (thePt2.h==p.h && thePt2.v==p.v || thePt2.h==s.h && thePt2.v==s.v)
      return boxPoint(&thePt2);
   return bzLin(4,p,q,r,s)? boxPoint(&thePt):nilSym;
}
