/*******************************************************************/
/*                                                                 */
/*                       HARDLOCK E-Y-E                            */
/*                        Demo Program                             */
/*                                                                 */
/*                (c) 1989 by ///FAST Electronic                   */
/*                                                                 */
/*                                                                 */
/*       Computer: IBM PC or compatible                            */
/*       OS      : MS-PC/DOS 2.0 - 4.0                             */
/*       Language: C, (MSC, TURBO C)                               */
/*       Author  : Thomas Schroeter                                */
/*       Version : 1.0                                             */
/*       Date    : August 4, 1989                                  */
/*                                                                 */
/*******************************************************************/


#include <stdio.h>
#include <string.h>
#include "keye.h"

char CryptStr[33] = {0xEE, 0x36, 0x4B, 0xE3, 0xC5, 0x74, 0x61, 0xAF,
                     0xE4, 0x19, 0xF4, 0x17, 0xA0, 0xEB, 0x3F, 0xA9,
                     0x6E, 0x0F, 0x6A, 0x0D, 0x5E, 0x07, 0x70, 0x64,
                     0x04, 0x63, 0xEF, 0xD3, 0x42, 0xEC, 0x94, 0xB4,
                     0x00};

Word  PrgVars[4] = {0x23AC, 0x3A5E, 0x8F27, 0x4A67};


Word Hl_Port();


main()
{
     Byte  Text[130];
     Word  n, ModAd, Reg, Val, Port;

     ModAd = 29809;
     Port = Hl_Port(ModAd);

     if(!Port){
       printf(" Sorry, no HARDLOCK E-Y-E found!!\n");
       return -1;
       }

     printf("\n HARDLOCK E-Y-E with Moduleaddress %d found. Port Address is: $%3X.\n\n", ModAd, Port);

     strncpy(Text, CryptStr, 8);
     HL_ON(Port, ModAd);
     K_EYE(Port, Text, 2);

     if(strncmp(Text, "HARDLOCK", 8))
 	printf(" The connected HARDLOCK E-Y-E is not the test device!\n");
     else{
 	printf(" The connected HARDLOCK E-Y-E is identified as the test device.\n");

 	K_EYE(Port, (char *) PrgVars, 2);

 	for(n = PrgVars[1]; n < PrgVars[3]; n += PrgVars[0]){
		K_EYE(Port, &CryptStr[n], 2);
		}

       printf(" The decrypted message is: %s.\n", CryptStr);
       } 

     Val = HL_RD(Port, 48);

     if(Val = 0x4841){                                /* $4841 = "HA" !! */
       printf("\n HARDLOCK E-Y-E Memory found.\n");

       strcpy(Text, "HARDLOCK E-Y-E with Memory.     ");
       for(n = 0, Reg = 48; Reg < 64; Reg++){
          Val =  (Word) Text[n++];
          Val <<= 8;
          Val |= (Word) Text[n++];
          HL_WR(Port, Reg, Val);
          }

       for(n = 0, Reg = 48; Reg < 64; Reg++){
          Val = HL_RD(Port, Reg);
          Text[n++] = (Byte) (Val >> 8);
          Text[n++] = (Byte) (Val & 255);
          }

       Text[n] = '\0';

       printf(" The memory contents string is: %s.\n", Text);
       } 

     HL_OFF(Port);
     return 0;
}


/************************************************************************/
/*		Hl_Port liefert die Portadresse des Hardlocks		*/
/*		HL_Port returns the port address of the Hardlock	*/
/*		HL_Port fournit l'adresse de port du Hardlock		*/
/************************************************************************/

Word Hl_Port(ModAd)
Word ModAd;
{
     Byte  Dummy[10];
     Word  n, PortAdr[3];

     PortAdr[0] = 0x3BC;
     PortAdr[1] = 0x378;
     PortAdr[2] = 0x278;

     for(n = 0; n < 3; n++){
        strcpy(Dummy, "HARDLOCK");
        HL_ON(PortAdr[n], ModAd);
        if(K_EYE(PortAdr[n], Dummy, 2))
          if(K_EYE(PortAdr[n], Dummy, 2))
            if(!strncmp("HARDLOCK", Dummy, 8)){
              HL_OFF(PortAdr[n]);
              return PortAdr[n];
              }
	HL_OFF(PortAdr[n]);
        }
     return 0;
}

