#define HLON 1
#define HLOFF 2
#define HLRD 3
#define HLWR 4
#define HLKEYE 5

#define BUFSIZE 1100
#define DEV "/dev/keye"

typedef unsigned char byte;
typedef unsigned short word;

byte hlcall[BUFSIZE];
int keye;

K_EYE(port,adr,cnt)
word port,cnt;
byte *adr;
{
  short bc,i,m;

  if (cnt * 4 > BUFSIZE - 20)
    return 0;
  hlcall[0] = HLKEYE;
  *(word*)(hlcall + 1) = get_keye_port(port);
  *(word*)(hlcall + 3) = cnt;
  bc = cnt * 4;
  for (i = 0; i < bc; i++)
    hlcall[5+i] = adr[i];
  bc += 5;
  m = write(keye,hlcall,bc);
  read(keye,hlcall,bc);
  bc = cnt * 4;
  for (i = 0; i < bc; i++)
    adr[i] = hlcall[i];
  return (m != 0);
}

HL_RD(port,adr)
word port,adr;
{
  hlcall[0] = HLRD;
  *(word*)(hlcall + 1) = get_keye_port(port);
  *(word*)(hlcall + 3) = adr;
  write(keye,hlcall,7);
}

HL_WR(port,adr,val)
word port,adr,val;
{
  hlcall[0] = HLWR;
  *(word*)(hlcall + 1) = get_keye_port(port);
  *(word*)(hlcall + 3) = adr;
  *(word*)(hlcall + 5) = val;
  write(keye,hlcall,7);
}

HL_ON(port,mod)
word port,mod;
{
  keye = open (DEV,2);
  hlcall[0] = HLON;
  *(word*)(hlcall + 1) = get_keye_port(port);
  *(word*)(hlcall + 3) = mod;
  write(keye,hlcall,7);
}
  
HL_OFF(port)
word port;
{
  hlcall[0] = HLOFF;
  *(word*)(hlcall + 1) = get_keye_port(port);
  write(keye,hlcall,7);
  close(keye);
}

get_keye_port(port)
word port;
{
  if (port == 0x3bc) return 0;
  if (port == 0x378) return 1;
  if (port == 0x278) return 2;
  return 0;
}
