/********************************************************/
/*        Hardlock E-Y-E TestProgramm 			*/
/*	  Hardlock E-Y-E test program			*/
/*       Programme test Hardlock E-Y-E			*/
/********************************************************/

#include "keye.h"
#include <string.h>
#include <stdio.h>

#define ModulAdresse 0x7471
Word PortAdr;

#define Testwort "HARDLOCK"
#define TestCode "\xee\x36\x4b\xe3\xc5\x74\x61\xaf"     /* "HARDLOCK" codiert / "HARDLOCK" coded / "HARDLOCK" cod */


/*****************************************************************/
/* Hl_Port liefert den Port, an dem EYE angeschlossen ist,	 */
/* wird kein Hardlock gefunden, so wird 0 geliefert 		 */
/*****************************************************************/
/* HL_Port returns the port, to which EYE ist connected,	 */
/* 0 is returned if no Hardlock is found			 */
/*****************************************************************/
/* Hl_Port fournit le port sur lequel EYE est connect, 	 */
/* 0 est retourn lorsqu'aucun Hardlock n'est trouv 		 */
/*****************************************************************/

short Hl_Port(ModAd)
short ModAd;
{
     char Dummy[10];
     short  n, PortAdre[3];

     PortAdre[0] = 0x3BC;
     PortAdre[1] = 0x378;
     PortAdre[2] = 0x278;

     for(n = 0; n < 3; n++){
        strcpy(Dummy, "HARDLOCK");
        HL_ON(PortAdre[n], ModAd);
        if(K_EYE(PortAdre[n], Dummy, 2))
          if(K_EYE(PortAdre[n], Dummy, 2))
            if(!strncmp("HARDLOCK", Dummy, 8)){
              HL_OFF(PortAdre[n]);
              return PortAdre[n];
              }
	  HL_OFF(PortAdre[n]);
	  }
     return 0;
}

main()
{
	int		i;
	unsigned short  p;
	unsigned short 	n;
	unsigned char	buf[20];
	printf("\nHardlock Test Program \n");

	PortAdr = Hl_Port(ModulAdresse);
	if(PortAdr == 0) {
		printf("No Hardlock EYE found!\n");
		exit();
		}

	printf("HardLock found at Port $%x (=%u)!\n", PortAdr, PortAdr);

	HL_ON(PortAdr, ModulAdresse);

 	printf("Reading 64 words from the EEProm.\n");

	for (i=0; i<=63; i++)
	{
		n = HL_RD(PortAdr, i);
		printf("%4x ", n);
	}

	printf("\nWriting into the EEProm (with 99xx, xx=30..3f). \n");

	for (i=48; i<=63; i++)
	{
		HL_WR(PortAdr, i, i+0x9900 );
	}

 	printf("Reading from the EEProm (words 48..63). \n");

	for (i=48; i<=63; i++)
	{
		n = HL_RD(PortAdr, i);
		printf("%4x ", n);
	}

	printf("\nErasing the EEProm with '1' (words 48..63). \n");

	for (i=48; i<=63; i++)
	{
		HL_WR(PortAdr, i, 1);
	}

 	printf("Reading from the EEProm (words 48..63). \n");

	for (i=48; i<=63; i++)
	{
		n = HL_RD(PortAdr, i);
		printf("%4x ", n);
	}

	printf("\nEncrypting the test word 'HARDLOCK' with K_EYE. \n");

	strcpy(buf, Testwort);
	printf("previous: %2c %2c %2c %2c %2c %2c %2c %2c \n",
			  buf[0], buf[1], buf[2], buf[3],
			  buf[4], buf[5], buf[6], buf[7]);
	printf("          %2x %2x %2x %2x %2x %2x %2x %2x \n",
			  buf[0], buf[1], buf[2], buf[3],
			  buf[4], buf[5], buf[6], buf[7]);

	K_EYE (PortAdr, buf, 2); 

 	printf("now   : %2c %2c %2c %2c %2c %2c %2c %2c \n",
			buf[0], buf[1], buf[2], buf[3],
			buf[4], buf[5], buf[6], buf[7]);
	printf("          %2x %2x %2x %2x %2x %2x %2x %2x \n",
			buf[0], buf[1], buf[2], buf[3],
			buf[4], buf[5], buf[6], buf[7]);

        HL_OFF(PortAdr);

	printf("\n Ende of the test. \n");

	exit(0); 
}
