/* picoMap.c
 * 17dec90abu
 */

#include "pico.h"

pico Map(x)
register pico x;
{
   register pico y;

   push(y = EVAL1(x));
   push(EVAL1(cdr(x)));
   while (isCell(y)) {
      apply1(tos,y);
      y = cdr(y);
   }
   drop2();
   return nilSym;
}

pico Map2(x)
register pico x;
{
   register pico y,z;

   push(y = EVAL1(x));
   x = cdr(x);
   push(z = EVAL1(x));
   push(EVAL1(cdr(x)));
   while (isCell(y)) {
      apply2(tos,y,z);
      y = cdr(y);
      if (!isCell(z = cdr(z)))
         z = nos;
   }
   drop3();
   return nilSym;
}

pico Mapc(x)
register pico x;
{
   register pico y;

   push(y = EVAL1(x));
   push(EVAL1(cdr(x)));
   while (isCell(y)) {
      apply1(tos,car(y));
      y = cdr(y);
   }
   drop2();
   return nilSym;
}

pico Mapc2(x)
register pico x;
{
   register pico y,z;

   push(y = EVAL1(x));
   x = cdr(x);
   push(z = EVAL1(x));
   push(EVAL1(cdr(x)));
   while (isCell(y)) {
      apply2(tos,car(y),car(z));
      y = cdr(y);
      if (!isCell(z = cdr(z)))
         z = nos;
   }
   drop3();
   return nilSym;
}

pico Mapcan(x)
register pico x;
{
   register pico y;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y);
   push(EVAL1(cdr(x)));
   while (!isCell(x = apply1(tos,car(y))))
      if (!isCell(y = cdr(y))) {
         drop2();
         return y;
      }
   push(x);
   while (isCell(y = cdr(y)))
      nconc(x,apply1(nos,car(y)));
   drop3();
   return x;
}

pico Mapcan2(x)
register pico x;
{
   register pico y,z;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y);
   x = cdr(x);
   if (!isCell(z = EVAL1(x)))
      return z;
   push(z);
   push(EVAL1(cdr(x)));
   while (!isCell(x = apply2(tos,car(y),car(z)))) {
      if (!isCell(y = cdr(y))) {
         drop3();
         return y;
      }
      if (!isCell(z = cdr(z)))
         z = nos;
   }
   push(x);
   while (isCell(y = cdr(y))) {
      if (!isCell(z = cdr(z)))
         z = tros;
      nconc(x,apply2(nos,car(y),car(z)));
   }
   drop4();
   return x;
}

pico Mapcar(x)
register pico x;
{
   register pico y;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y);
   push(EVAL1(cdr(x)));
   push(x = newCell(apply1(tos,car(y)),nilSym));
   while (isCell(y = cdr(y))) {
      cdr(x) = newCell(apply1(nos,car(y)),nilSym);
      x = cdr(x);
   }
   x = pop();
   drop2();
   return x;
}

pico Mapcar2(x)
register pico x;
{
   register pico y,z;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y);
   x = cdr(x);
   if (!isCell(z = EVAL1(x)))
      return z;
   push(z);
   push(EVAL1(cdr(x)));
   push(x = newCell(apply2(tos,car(y),car(z)),nilSym));
   while (isCell(y = cdr(y))) {
      if (!isCell(z = cdr(z)))
         z = tros;
      cdr(x) = newCell(apply2(nos,car(y),car(z)),nilSym);
      x = cdr(x);
   }
   x = pop();
   drop3();
   return x;
}

pico Mapcon(x)
register pico x;
{
   register pico y;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y);
   push(EVAL1(cdr(x)));
   while (!isCell(x = apply1(tos,y)))
      if (!isCell(y = cdr(y))) {
         drop2();
         return y;
      }
   push(x);
   while (isCell(y = cdr(y)))
      nconc(x,apply1(nos,y));
   drop3();
   return x;
}

pico Mapcon2(x)
register pico x;
{
   register pico y,z;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y);
   x = cdr(x);
   if (!isCell(z = EVAL1(x)))
      return z;
   push(z);
   push(EVAL1(cdr(x)));
   while (!isCell(x = apply2(tos,y,z))) {
      if (!isCell(y = cdr(y))) {
         drop3();
         return y;
      }
      if (!isCell(z = cdr(z)))
         z = nos;
   }
   push(x);
   while (isCell(y = cdr(y))) {
      if (!isCell(z = cdr(z)))
         z = tros;
      nconc(x,apply2(nos,y,z));
   }
   drop4();
   return x;
}

pico Maplist(x)
register pico x;
{
   register pico y;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y);
   push(EVAL1(cdr(x)));
   push(x = newCell(apply1(tos,y),nilSym));
   while (isCell(y = cdr(y))) {
      cdr(x) = newCell(apply1(nos,y),nilSym);
      x = cdr(x);
   }
   x = pop();
   drop2();
   return x;
}

pico Maplist2(x)
register pico x;
{
   register pico y,z;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y);
   x = cdr(x);
   if (!isCell(z = EVAL1(x)))
      return z;
   push(z);
   push(EVAL1(cdr(x)));
   push(x = newCell(apply2(tos,y,z),nilSym));
   while (isCell(y = cdr(y))) {
      if (!isCell(z = cdr(z)))
         z = tros;
      cdr(x) = newCell(apply2(nos,y,z),nilSym);
      x = cdr(x);
   }
   x = pop();
   drop3();
   return x;
}

pico Filter(x)
register pico x;
{
   register pico y;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y); /* List */
   push(EVAL1(cdr(x))); /* Foo */
   while (isNil(apply1(tos,car(y))))
      if (!isCell(y = cdr(y))) {
         drop2();
         return y;
      }
   push(x = newCell(car(y),nilSym));
   while (isCell(y = cdr(y)))
      if (!isNil(apply1(nos,car(y)))) {
         cdr(x) = newCell(car(y),nilSym);
         x = cdr(x);
      }
   x = pop();
   drop2();
   return x;
}

pico Delim(x)
register pico x;
{
   register pico y,z;

   push(z = EVAL1(x)); /* List */
   push(EVAL1(cdr(x))); /* Foo */
   push(x = nilSym); /* Result */
   push(y = nilSym); /* Sublist */
   while (isCell(z)) {
      if (isNil(apply1(tros,car(z)))) {
         if (isNil(y))
            y = tos = newCell(car(z),nilSym);
         else {
            cdr(y) = newCell(car(z),nilSym);
            y = cdr(y);
         }
      }
      else {
         if (isNil(x))
            x = nos = newCell(tos,nilSym);
         else {
            cdr(x) = newCell(tos,nilSym);
            x = cdr(x);
         }
         y = tos = nilSym;
      }
      z = cdr(z);
   }
   y = newCell(tos,nilSym);
   drop();
   if (isNil(x)) {
      drop3();
      return y;
   }
   cdr(x) = y;
   x = pop();
   drop2();
   return x;
}

pico Find(x)
register pico x;
{
   register pico y;

   push(y = EVAL1(x));
   push(EVAL1(cdr(x)));
   while (isCell(y)) {
      if (!isNil(apply1(tos,car(y)))) {
         drop2();
         return car(y);
      }
      y = cdr(y);
   }
   drop2();
   return nilSym;
}

pico Amount(x)
register pico x;
{
   register pico y;
   register number n;

   push(EVAL1(x));
   push(EVAL1(cdr(x)));
   n = 0;
   x = nos;
   while (isCell(x)) {
      if (isNum(y = apply1(tos,car(x)))) {
         n += unBox(y);
      }
      x = cdr(x);
   }
   drop2();
   return boxNum(n);
}

pico Best(x)
register pico x;
{
   register pico y;
   register number n,m;

   push(y = EVAL1(x));
   push(EVAL1(cdr(x)));
   n = MAXNEG;
   x = nilSym;
   while (isCell(y)) {
      if (isNum(m = (number)(apply1(tos,car(y))))  &&  unBox(m) > n) {
         n = unBox(m);
         x = car(y);
      }
      y = cdr(y);
   }
   drop2();
   return x;
}

pico Worst(x)
register pico x;
{
   register pico y;
   register number n,m;

   push(y = EVAL1(x));
   push(EVAL1(cdr(x)));
   n = MAXNUM;
   x = nilSym;
   while (isCell(y)) {
      if (isNum(m = (number)(apply1(tos,car(y))))  &&  unBox(m) < n) {
         n = unBox(m);
         x = car(y);
      }
      y = cdr(y);
   }
   drop2();
   return x;
}
