; picopp.s 19dec90

   TITLE   $picopp

   .386
DGROUP   GROUP   CONST, _BSS, _DATA

PUBLIC  _DUMMY
PUBLIC  _PUSH
PUBLIC  _POP
PUBLIC  _xPOP
PUBLIC  _drop
PUBLIC  _drop2
PUBLIC  _drop3
PUBLIC  _drop4
PUBLIC  _muldiv
PUBLIC  _mulchk
PUBLIC  _pythag

EXTRN  _stkPtr:dword

_DATA SEGMENT  DWORD USE32 PUBLIC 'DATA'
   jmp_adr   dd   ?
   x_item    dd   ?
_DATA ENDS
_BSS SEGMENT  DWORD USE32 PUBLIC 'BSS'
_BSS ENDS
CONST SEGMENT  DWORD USE32 PUBLIC 'CONST'
CONST ENDS
_TEXT SEGMENT  DWORD USE32 PUBLIC 'CODE'
   ASSUME   CS: _TEXT, DS: DGROUP, SS: DGROUP, ES: DGROUP

_DUMMY   PROC NEAR
   ret
_DUMMY   ENDP

_PUSH   PROC NEAR
   pop eax            ;  return addr (data is already on stack)
   push _stkPtr
   mov _stkPtr,esp    ; put link into stack
   jmp eax            ; return
_PUSH   ENDP

_POP   PROC NEAR
   pop jmp_adr        ; get return addr
   pop _stkPtr        ; restore data stack pointer
   pop eax            ; get data as return value
   jmp  ds:[jmp_adr]  ; return
_POP   ENDP

_xPOP   PROC NEAR
   pop jmp_adr         ; get return addr
   pop x_item
   pop _stkPtr         ; restore data stack pointer
   pop eax             ; get data as return value
   push x_item
   jmp  ds:[jmp_adr]   ; return
_xPOP   ENDP

_drop   PROC NEAR
   pop eax              ; get return addr
   pop _stkPtr          ; restore data stack pointer
   add esp,4            ; drop data
   jmp eax              ; return
_drop   ENDP

_drop2   PROC NEAR
   pop eax        ; get return addr
   add esp,8
   pop _stkPtr    ; restore data stack pointer
   add esp,4      ; drop data
   jmp eax        ; return
_drop2   ENDP

_drop3   PROC NEAR
   pop eax        ; get return addr
   add esp,16
   pop _stkPtr    ; restore data stack pointer
   add esp,4      ; drop data
   jmp eax        ; return
_drop3   ENDP

_drop4   PROC NEAR
   pop eax       ; get return addr
   add esp,24
   pop _stkPtr   ; restore data stack pointer
   add esp,4     ; drop data
   jmp eax       ; return
_drop4   ENDP

_muldiv   PROC NEAR
   push ebp
   mov ebp,esp
   mov eax,[ebp+8]        ; multiplicand
   imul dword ptr[ebp+12] ; multiplicator
   idiv dword ptr[ebp+16] ; divide
   mov ecx,eax            ; round
   mov eax,edx
   add eax,eax
   cdq
   idiv dword ptr[ebp+16] ; divide
   add eax,ecx
   pop ebp                ; return
   ret
_muldiv   ENDP

_mulchk   PROC NEAR
   push ebp
   mov ebp,esp
   mov eax,[ebp+8]        ; multiplicand
   mov edx,[ebp+12]       ; multiplicator
   sal eax,1              ; Compensate for 30-bit range
   sal edx,1
   imul edx
   or edx,edx
   jns mc10
   neg eax                ; abs
   adc edx,0
   neg edx
mc10:
   shld edx,eax,1         ; get sign of eax into edx
   mov eax,edx            ; result high
   mov ecx,[ebp+16]
   or ecx,ecx
   jns mc20
   neg ecx                ;abs
mc20:
   rept 30
   shr ecx,1              ; Done?
   jz mc30                ; Yes
   shr eax,1              ; Else shift high dword
   endm
mc30:
   pop ebp                ; return
   ret
_mulchk   ENDP

_pythag   PROC NEAR
   push ebp
   mov ebp,esp
   sub esp,4*8
   mov eax,[ebp+8]           ; h
   imul eax                  ; h**2
   mov [ebp-4],edx
   mov [ebp-8],eax           ; in n
   mov eax,[ebp+12]          ; v
   imul eax                  ; v**2
   add [ebp-8],eax
   adc [ebp-4],edx           ; h**2 + v**2 in n
   ; 64-bit Square root
   xor eax,eax               ;   r = 0;
   mov [ebp-16],eax
   mov [ebp-12],eax
   mov [ebp-24],eax          ;   a = 1L << 62;
   mov dword ptr[ebp-20],40000000h
pt10:                        ;   do {
   mov eax,[ebp-16]          ;      b = r + a;
   add eax,[ebp-24]
   mov [ebp-32],eax
   mov eax,[ebp-12]
   adc eax,[ebp-20]
   mov [ebp-28],eax
   sar dword ptr[ebp-12],1   ;      r >>= 1;
   rcr dword ptr[ebp-16],1
   mov eax,[ebp-28]          ;      if (b <= n) {
   cmp eax,[ebp-4]
   ja pt30
   jb pt20
   mov eax,[ebp-32]
   cmp eax,[ebp-8]
   ja pt30
pt20:
   mov eax,[ebp-32]          ;         n -= b;
   sub [ebp-8],eax
   mov eax,[ebp-28]
   sbb [ebp-4],eax
   mov eax,[ebp-24]          ;         r += a;
   add [ebp-16],eax
   mov eax,[ebp-20]
   adc [ebp-12],eax
pt30:                        ;      }
   sar dword ptr[ebp-20],1   ;   } while (a >>= 2);
   rcr dword ptr[ebp-24],1
   sar dword ptr[ebp-20],1
   rcr dword ptr[ebp-24],1
   mov eax,[ebp-24]
   or eax,[ebp-20]
   jnz pt10
   mov eax,[ebp-12]          ; if (r < n) /* Round */
   cmp eax,[ebp-4]
   ja pt50
   jb pt40
   mov eax,[ebp-16]
   cmp eax,[ebp-8]
   jae pt50
pt40:
   inc dword ptr[ebp-16]      ; ++r;
pt50:
   mov eax,[ebp-16]           ;   return r;
   add esp,4*8
   pop ebp
   ret
_pythag   ENDP

_TEXT   ENDS
END
