[edit.l 03apr91abu]
[+++ PENTI Line Editor +++]

[++ Global variables ++]
(off $dirty $dirty2)    [Dirty flag]
(setq $line 1)          [Position in text]
(setq $line2 1)
(zero $col $col2)       [Current line position]
(off $macro)            [Editor macro]
(setq $scrap nil)       [Cut/Paste scrap]
(setq $find nil)        [Search buffer]
(setq $found nil)
(setq $rplc nil)        [Replace buffer]

[SEARCH files for a pattern]
<de search (pat d f)
   (setq pat (append "?" pat "?"))
   (default f "?.l")
   (local (fd n f lin)
      (mapc (filter (dir d) (lambda (x) (wild f x)))
         (lambda (nm)
            (setq nm (append d nm))
            (unless (setq fd (open nm))
               (error "Can't open " nm) )
            (zero n)
            (off f)
            (while (setq lin (getLine fd))
               (inc n)
               (when (wild pat lin)
                  (unless f
                     (on f)
                     (prin2 nm)
                     (putc \:)
                     (terpri) )
                  (prin1 n)
                  (putc \.)
                  (prLine lin) ) )
            (close fd) >

[EDIT symbol or file]
<de edit ($e $c)
   (local ($cnt)
      (when (doEdit $e $c)
         (zero $cnt)
         (prCurr)
         (loop
            (setq $c ($key))
            (when (leq \1 $c \9)
               (repeat
                  (setq $cnt (add (mul 10 $cnt) (sub $c \0)))
                  (setq $c ($key))
                  (not (leq \0 $c \9)) ) )
            (when (eq $c \*)
               (catch t
                  (local (col lin)
                     (setq col $col lin $line)
                     ($rPar t)
                     (setq $cnt (sub lin $line -1)) ) )
               (setq $c ($key)) )
            (when (eq $c \-)
               (setq $cnt (max 1 (sub $cnt $line -1)))
               (setq $c ($key)) )
            (while (eq $c \+)
               (inc $cnt)
               (setq $c ($key)) )
            (t (eq $c \:))
            (reptn (add (if (zerop $col) 5 6) (strLen (nth $line *edit)))
               (putc 8) )
            (case $c
               (\# (setq *macro $macro))
               ((\i) ($rght))
               (\n
                  (while (plusp (access *edit $line $col))
                     ($rght) )
                  ($rght) )
               ((-1 ^H) ($left))
               (\b
                  (until
                     (or
                        (not ($left))
                        (minusp (access *edit $line (sub1 $col))) ) ) )
               ((\s ^J) (edMove 1))
               (\e (edMove -1))
               (\w (terpri) (edIns (getLine)))
               (\/ (terpri) (edFind (getLine)))
               (\f
                  ($rght)
                  (setq $c ($key))
                  (while
                     (and
                        (access *edit $line $col)
                        (neq $c (access *edit $line $col)) )
                     ($rght) ) )
               (\a (edFind))
               (\c (terpri) (edRepl (getLine)))
               (\. (edRepl))
               (\x (edDel))
               (\K (edDel 9999))
               (\X (unless (zerop $col) (dec $col) (edDel)))
               (\t (edIns (cons ($key))) ($rght))
               (\r
                  (store ($key) *edit $line $col)
                  (touch) )
               (^X (edCut $cnt))
               (^C (local ($dirty) (edCut $cnt) (edPast $scrap 0)))
               (^V (edPast $scrap 0))
               (\o (terpri) (enter nil 1))
               (\O (terpri) (enter nil 0))
               (\D (dateStamp))
               (\S (edSplt))
               (\J (edJoin))
               (\< ($blkl $cnt))
               (\> ($blkr $cnt))
               (\0 (zero $col))
               (\$ (setq $col (length (nth $line *edit))))
               (\g (edLine $cnt))
               (\G (edLine (if (zerop $cnt) (length *edit) $cnt)))
               (\(
                  (catch t
                     (local (col lin)
                        (setq col $col lin $line)
                        ($lPar (eq \> (access *edit lin col)))
                        (setq $col col $line lin) ) ) )
               (\)
                  (catch t
                     (local (col lin)
                        (setq col $col lin $line)
                        ($rPar t)
                        (setq $col col $line lin) ) ) )
               (\I (indent))
               (\[ (on *log))
               (\] (setq $macro (reverse (cdr *log))) (off *log))
               (^U (edMove -22) ($view 22))
               (^D (edMove 22) ($view 22))
               (\v
                  (if (zerop $cnt)
                     ($view 4 3)
                     ($view (mod $cnt 10) (div $cnt 10)) ) )
               (^M ($view (if (zerop $cnt) 22 $cnt)))
               (\F
                  (terpri)
                  (terpri)
                  (showLines $line 22 (mul 3 (minus $cnt))) )
               (\E
                  (terpri)
                  (xchg *edit *edit2)
                  (xchg $line $line2)
                  (xchg $col $col2)
                  (xchg $dirty $dirty2)
                  (prLine (car *edit)) )
               (\h (local (l s)
                     (setq
                        l (nthcdr $col (nth $line *edit))
                        s )
                     (unless (or (letter (car l)) (memq (car l) "12$*-"))
                        (pop l) )
                     (while (or (letter (car l)) (memq (car l) "12$*-"))
                        (setq s (nconc1 s (pop l))) )
                     (when (and s (get (symbol s) '*src))
                        (terpri)
                        (doEdit (symbol s)) ) ) )
               (\% (setq  $find $rplc  $rplc $found))
               (\m (zero $col) (edMove 1) (terpri))
               (\M (zero $col) (reptn 22 (prCurr) (edMove 1) (terpri)))
               (\~ ($case))
               (\! (save))
               (\@ (terpri) (load))
               (27 )
               (t (bell)) )
            (zero $cnt)
            (prCurr) )
         (terpri)
         t >

<de doEdit ($e $c)
   (catch t
      (when $e
         (if (stringp $e)
            (progn
               (setq
                  *edit2 *edit
                  $line2 $line
                  $col2 $col
                  $dirty2 $dirty )
               (edOpen $e)
               (edLine 1) )
            (progn
               (unless (setq $c (if $c (get $c $e) (get $e '*src)))
                  (throw t) )
               (setq
                  *edit2 *edit
                  $line2 $line
                  $col2 $col
                  $dirty2 $dirty )
               (unless (equal (car *edit) (cdr $c))
                  (edOpen (cdr $c)) )
               (edLine (car $c)) ) ) )
      (prLine (car *edit)) >

<de $view (n m)
   (default n 1)
   (terpri)
   (terpri)
   (if m (showLines (sub $line m) m -9999))
   (showLines $line n -9999)
   (terpri) >

<de enter (file offs)
   (default offs 0)
   (local (n lin text)
      (setq text)
      (if file
         (setq file (open file)) )
      (setq n $line)
      (while
         (progn
            (unless file (prLineNo (add offs n)))
            (setq lin (getLine file)) )
         (inc n)
         (push lin text) )
      (setq text (reverse text))
      (edPast text offs)
      (if file (close file) )
      (if text (touch)) >

<de touch () (on $dirty) >

<de save (nm bk)
   (local (*edit fd ok)
      (off ok)
      (when (eq nm t)
         (off nm)
         (on bk) )
      (default nm (car *edit))
      (when (or $dirty (not (equal nm (car *edit))))
         (on ok)
         (rplaca *edit nm)
         (when bk
            (erase (setq bk (append nm "-")))
            (rename nm bk) )
         (unless (setq fd (create nm))
            (error "Can't create") )
         (while (setq *edit (cdr *edit))
            (prLine (car *edit) fd) )
         (close fd) )
      (off $dirty)
      ok >

<de rid ()
   (off *edit *edit2 $dirty $macro)
   (setq  $line 1  $col 0) >

(de sl () (and (save t) (load)))

<de edOpen (f)
   (setq *edit)
   (local (fd l)
      (if (setq fd (open f))
         (progn
            (while (setq l (getLine fd))
               (setq *edit (nconc1 *edit l)) )
            (close fd) )
         (setq *edit (cons (cons -1))) ) )
   (push f *edit)
   (zero $col)
   (off $dirty) >

<de $case ()
   (local (c)
      (when (setq c (access *edit $line $col))
         (store
            ((if (leq \a c \z) upc lowc) c)
            *edit $line $col)
         ($rght)
         (touch) >

<de $key ()
   (local (c)
      (if (eq 32 (setq c (hitKey))) -1 c) >

<de edLine (n)
   (setq $line
      (limit n 1 (sub1 (length *edit))) )
   (zero $col) >

<de edMove (n)
   (setq $line
      (limit (add n $line) 1 (sub1 (length *edit))) )
   (setq $col (min $col (length (nth $line *edit)))) >

<de $rght ()
   (unless (eq $col (length (nth $line *edit))) (inc $col)) >

<de $left ()
   (unless (zerop $col) (dec $col)) >

<de $blkr (n)
   (if (zerop n) (setq n 1))
   (zero $col)
   (local ($line)
      (reptn n
         (edIns "   ")
         (inc $line) ) )
   (touch) >

<de $blkl (n)
   (if (zerop n) (setq n 1))
   (zero $col)
   (local ($line lin)
      (reptn n
         (setq lin (nth $line *edit))
         (when (minusp (car lin))
            (rplaca lin (add 3 (car lin)))
            (unless (minusp (car lin))
               (edDel) ) )
         (inc $line) ) )
   (touch) >

<de $lScan ()
   (when (minusp (dec col))
      (setq col (sub1 (length (nth (dec lin) *edit))))
      (when (zerop lin)
         (bell)
         (throw t) >

<de $rScan ()
   (unless (access *edit lin (inc col))
      (zero col)
      (unless (nth (inc lin) *edit)
         (bell)
         (throw t) >

<de indent ()
   (local (lin n1 n2 l s c)
      (setq
         n1 (car (nth $line *edit))
         lin $line
         l )
      (unless (minusp n1)
         (zero n1) )
      (setq n2 n1)
      (loop
         (setq s (nth lin *edit))
         (while s
            (cond
               ((eq \\ (setq c (pop s)))
                  (pop s) )
               ((eq \" c)
                  (while (and s (neq \" (setq c (pop s))))
                     (when (eq \\ c)
                        (pop s) ) ) )
               (t
                  (case c
                     (\( (dec n2 3))
                     (\) (inc n2 3))
                     (\< (push n2 l) (dec n2 3))
                     (\> (setq n2 (pop l))) ) ) ) )
         (t (not n2))
         (t (not (lessp n2 n1)))
         (t (not (nth (inc lin) *edit)))
         (when (neq n2 (access *edit lin 0))
            (touch)
            (if (minusp (access *edit lin 0))
               (rplaca (nth lin *edit) n2)
               (rplaca (nthcdr lin *edit)
                  (cons n2 (nth lin *edit)) >

<de $lPar (super)
   ($lScan)
   (loop
      (setq c
         (access *edit lin col))
      (t (and (not super) (eq c \()))
      (t (eq c \<))
      (if (and (not super) (eq c \)))
         ($lPar)
         (if (eq c \>)
            ($lPar t) ) )
      ($lScan)) >

<de $rPar (top)
   ($rScan)
   (loop
      (when (eq \\ (setq c (access *edit lin col)))
         ($rScan)
         ($rScan)
         (setq c (access *edit lin col)) )
      (t (eq c \)) (if (not top) ($rScan)))
      (t (eq c \>))
      (cond
         ((eq c \() ($rPar))
         ((eq c \<) ($rPar) ($rScan))
         (t ($rScan)) >

<de edFind (s)
   (and s (setq $find s))
   (when $find
      (local (pos lin text)
         (setq
            lin $line
            text (nthcdr $line *edit) )
         (if <setq pos (matchLine (nthcdr (add1 $col) (car text>
            (setq pos (add 1 pos $col))
            (progn
               (inc lin)
               (pop text)
               (until
                  (or
                     (null text)
                     (setq pos (matchLine (car text))) )
                  (inc lin)
                  (pop text) ) ) )
         (when text
            (setq $line lin)
            (setq $col pos) >

<de edRepl (s)
   (when $found
      (and s (setq $rplc s))
      (edDel (length $found))
      (edIns $rplc) >

<de edIns (s)
   (local (lin)
      (setq lin (nth $line *edit))
      (if (zerop $col)
         (rplaca
            (nthcdr $line *edit)
            (append s lin) )
         (rplacd
            (nthcdr (sub1 $col ) lin)
            (append s (nthcdr $col lin)) ) )
      (collps)
      (if s (touch)) >

<de edDel (n)
   (default n 1)
   (local (lin)
      (setq lin (nth $line *edit))
      (if
         (and
            (eq n 1)
            (numberp (nth $col lin))
            (lessp (nth $col lin) -1) )
         (rplaca
            (nthcdr $col lin)
            (add1 (nth $col lin)) )
         (if (zerop $col)
            (rplaca
               (nthcdr $line *edit)
               (nthcdr n lin) )
            (rplacd
               (nthcdr (sub1 $col ) lin)
               (nthcdr (add n $col) lin) ) ) ) )
   (touch) >

<de datStr ()
   (local (d)
      (setq d (date))
      (append
         (if (lessp (low d) 10) "0")
         (format (low d))
         <nth (sub1 (middle d)) '(
               "jan" "feb" "mar" "apr" "may" "jun"
               "jul" "aug" "sep" "oct" "nov" "dec" >
         (format (high d)) >

<de dateStamp ()
   (edDel 7)
   (edIns (datStr))
   (touch) >

<de edCut (n)
   (if (zerop n) (setq n 1))
   (local (*edit)
      (setq *edit (nthcdr (sub1 $line) *edit))
      (setq $scrap (cdr *edit))
      (when (cdr (rplacd *edit (nthcdr n $scrap)))
         (rplacd (nthcdr (sub1 n) $scrap)) )
      (touch) >

<de edPast (text offs)
   (local (*edit)
      (setq *edit (nthcdr (add -1 offs $line) *edit))
      (rplacd *edit (nconc (copy text) (cdr *edit)))
      (touch) >

<de edSplt ()
   (local (lin rest)
      (setq
         lin (nth $line *edit)
         rest (nthcdr $col lin) )
      (if (minusp (car lin))
         (push (add -3 (car lin)) rest) )
      (unless (or (null rest) (zerop $col))
         (rplacd (nthcdr (sub1 $col) lin))
         (rplacd (nthcdr $line *edit)
            (nconc (cons rest) (nthcdr (add1 $line) *edit)) )
         (touch) >

<de edJoin ()
   (local (lin)
      (setq lin (nth (add1 $line) *edit))
      (nconc
         (nth $line *edit)
         (if (minusp (car lin))
            (cdr lin)
            lin ) )
      (rplacd
         (nthcdr $line *edit)
         (nthcdr (add2 $line) *edit) )
      (collps)
      (touch) >

<de prCurr ()
   (local (lin len)
      (prLineNo $line)
      (putc (if $dirty \! \.))
      (setq lin (nth $line *edit))
      (unless (zerop $col)
         (setq lin (insert \^ $col lin)) )
      (prin2 lin)
      (setq len
         (limit (sub 73 (strLen lin)) 0 8) )
      (reptn len (putc 32))
      (reptn len (putc 8)) >

<de showLines (lin n f)
   (when (lessp lin 1)
      (setq n (add n -1 lin))
      (setq lin 1) )
   (local (l)
      (setq l (nthcdr lin *edit))
      (until (or (null l) (zerop n))
         (unless (and (numberp (caar l)) (lessp (caar l) f))
            (prLineNo lin)
            (putc \:)
            (prLine (car l))
            (dec n) )
         (inc lin)
         (pop l) >

<de prLineNo (n)
   (if (lessp n 1000)
      (space) )
   (if (lessp n 100)
      (space) )
   (if (lessp n 10)
      (space) )
   (prin1 n) >

[++ Pattern matching ++]
<de matchLine (lin)
   (local (pos n)
      (catch t
         (zero pos)
         (reptn (sub (length lin) (length $find) -2)
            (when (setq n (wild $find lin t))
               (setq $found (chop n lin))
               (throw t pos) )
            (inc pos)
            (pop lin) )
         nil >

[++ Collapse white space ++]
<de collps ()
   (local (lin)
      (setq lin (nth $line *edit))
      (while lin
         (when (and (minusp (car lin)) (minusp (cadr lin)))
            (rplaca
               lin
               (add (car lin) (cadr lin)) )
            (rplacd lin (cddr lin)) )
         (pop lin) >

t [ledit.l]
