[prolog.l 17feb91abu]

[Assert a fact]
<de fact cl
   (learn cl) >

<de learn (cl)
   (with (caar cl)
      (if (slot prolog)
         (nconc1 (slot prolog) cl)
         (slot prolog (cons cl)) >

<de forget (cl)
   (with cl
      (prog1
         (car (slot prolog))
         (slot prolog (cdr (slot prolog))) >

[Question]
<de is cl
   (quest cl) >

<de quest (cl)
   (refute cl (cons) (cons) nil) >

<de refute (clause new-subst old-subst cue)
   (if clause
      (local (undo-list definitions)
         (setq undo-list)
         (if (setq definitions (get (caar clause) 'prolog))
            (resolve definitions)
            (if
               (and
                  (try-sys (car clause) old-subst)
                  (refute (cdr clause) (cons) old-subst cue) )
               'Yes
               (undo undo-list) ) ) )
      (if (null cue)
         'Yes
         (refute (caar cue) (cons) (cdar cue) (cdr cue)) >

<de resolve (definitions)
   (cond
      ((null definitions) nil)
      ((and
         (unify (car clause) old-subst (caar definitions) new-subst)
         (refute
            (cdar definitions)
            (cons)
            new-subst
            (cons (cons (cdr clause) old-subst) cue) ) )
         'Yes )
      (t (undo undo-list) (resolve (cdr definitions))) >

<de undo (u)
   (if u
      (progn
         (rplacd (car u) (cddar u))
         (undo (cdr u)) )
      (setq undo-list) >

<de try-sys (form subst)
   (if (eq (car form) 'not)
      (not (refute (cdr form) (cons) subst nil))
      (if (eq (car form) 'call)
         (unify
            (apply
               (eval (fetch-value (caadr form) subst))
               (mapcar (cdadr form)
                  (lambda (x)
                     (fetch-value x subst) ) ) )
            subst
            (caddr form)
            subst ) >

<de unify (x x-subst y y-subst)
   (cond
      ((varp x)
         (if (assoc x (cdr x-subst)) [assigned?]
            (unify (fetch x x-subst) *subst y y-subst)
            (or
               (and (eq x y) (eq x-subst y-subst)) [link]
               (push
                  (rplacd x-subst
                     (cons
                        (cons
                           x
                           (cons (fetch y y-subst) *subst) )
                        (cdr x-subst) ) )
                  undo-list ) ) ) )
      ((varp y) (unify y y-subst x x-subst))
      ((atom x) (equal x y))
      ((atom y) nil)
      ((unify (car x) x-subst (car y) y-subst)
                  (unify (cdr x) x-subst (cdr y) y-subst) >

<de fetch (x subst)
   (setq *subst subst)
   (if (varp x)
      (local (v)
         (if (null (setq v (assoc x (cdr subst))))
            x
            [+ (progn +]
               [+ (setq *subst (cddr v)) +]
               (fetch (cadr v) (cddr v)) [)] ) )
      x >

<de fetch-value (x subst)
   (cond
      ((varp x)
         (local (v)
            (setq v (assoc x (cdr subst)))
            (if (not v)
               x
               (fetch-value (cadr v) (cddr v)) ) ) )
      ((atom x) x)
      (T
         (cons
            (fetch-value (car x) subst)
            (fetch-value (cdr x) subst) >

<de facts (k)
   (mapc (oblist)
      (lambda (x)
         (with x
            (and
               (slot prolog)
               (or (not k) (eq x k))
               (mapc (slot prolog) print>

[Forget all clauses]
<mapc (oblist)
   (lambda (x)
      (with x
         (when (slot prolog)
            (slot prolog nil) >

(fact (out *L) (call (print *L) *X))
(fact (sum *X *Y *Z) (call (add *X *Y) *Z))
(fact (diff *X *Y *Z) (call (sub *X *Y) *Z))
(fact (prod *X *Y *Z) (call (mul *X *Y) *Z))
(fact (quot *X *Y *Z) (call (div *X *Y) *Z))
(fact (same *X *X))

(fact (likes john mary))
(fact (likes mary *X) (has *X money))
(fact (has john money))
(fact (has alex money))
(fact (append () *X *X))
(fact (append (*A . *X) *Y (*A . *Z)) (append *X *Y *Z))
(fact (factorial 0 1))
(fact (factorial *X *Z)
   (diff *X 1 *A)
   (factorial *A *Y)
   (prod *X *Y *Z) )

<fact (sister *x *y)
   (female *x)
   (parent *x *m *f)
   (parent *y *m *f)
   [(other *x *y)] >
<fact (parent *c *m *f)
   (mother *c *m) (father *c *f) >
<fact (female mary)>
<fact (mother mary ann)>
<fact (father mary tom)>
<fact (mother john ann)>
<fact (father john tom)>

t [prolog.l]
