[neuro.l 07oct92]

[+ Size in longwords +]
<de neuroSize (a b c)
   (add 10 a (mul 2 b) (mul 2 c) (mul a b) (mul b c)) >

<de connections (a b c)
   (add (mul a b) (mul b c)) >

<de estimate (a b c)
   (prLine
      (append
         "Size: "
         (format (div (neuroSize a b c) #(muldiv 1024 256 10)) 1)
         " MB" ) )
   (prLine
      (append
         "Time: "
         (format (div (connections a b c) 17000) 1)
         " sec" ) )
   T >

[+ Find max and min values +]
<de maxNeuro (nr)
   (local (p m n)
      (setq p (add nr 40))
      (zero m)
      (reptn (div (sub (GetPtrSize nr) 40) 4)
         (setq n (abs (muldiv 100 (ptr p) 65536)))
         [(prin1 n) (space)]
         (when (lessp m n)
            (setq m n) )
         (inc p 4) )
      m >

<de rnd1 ()
   (bitAnd (bitr 8 (random)) 0FFFF) >

[+ Learn addition +]
<de trainAdd (nr n)
   (local (a b)
      (reptn n
         (train nr 2
            (list (setq a (rnd1)) (setq b (rnd1)))
            (list (add a b)) >

[+ Train a list pattern +]
<de trainPat (s lst n)
   (local (nr len l)
      (random s)
      (setq
         nr (neuro (pop lst) (pop lst) (pop lst))
         len (length lst) )
      (reptn n
         (setq l
            (nth
               (bitAnd (rnd1) (sub1 len))
               lst ) )
         (train nr
            '((i) (nth i (car l)))
            '((i) (nth i (cdr l))) ) )
      (prog1
         (mapcar lst
            '((l) (cons (cdr l) (solve nr '((i) (nth i (car l)))))) )
         (free nr) >

<de truth (l)
   (mapcar l
      '((x) (not (xor (leq 32768 (caar x)) (leq 32768 (cdr x))))) >

[+ Binary numbers +]
<de Test1
   4 4 1
   ((    0     0     0     0) 0)
   ((    0     0     0 65536) #(mul 1 4096))
   ((    0     0 65536     0) #(mul 2 4096))
   ((    0     0 65536 65536) #(mul 3 4096))
   ((    0 65536     0     0) #(mul 4 4096))
   ((    0 65536     0 65536) #(mul 5 4096))
   ((    0 65536 65536     0) #(mul 6 4096))
   ((    0 65536 65536 65536) #(mul 7 4096))
   ((65536     0     0     0) #(mul 8 4096))
   ((65536     0     0 65536) #(mul 9 4096))
   ((65536     0 65536     0) #(mul 10 4096))
   ((65536     0 65536 65536) #(mul 11 4096))
   ((65536 65536     0     0) #(mul 12 4096))
   ((65536 65536     0 65536) #(mul 13 4096))
   ((65536 65536 65536     0) #(mul 14 4096))
   ((65536 65536 65536 65536) #(mul 15 4096)) >

[+ XOR Test +]
<de Test2
   2 2 1
   ((    0     0)     0)
   ((    0 65536) 65536)
   ((65536     0) 65536)
   ((65536 65536)     0) >

[+ Parity Problem +]
<de Test3
   4 4 1
   ((    0     0     0     0)      0)
   ((    0     0     0 65536)  65536)
   ((    0     0 65536     0)  65536)
   ((    0     0 65536 65536)      0)
   ((    0 65536     0     0)  65536)
   ((    0 65536     0 65536)      0)
   ((    0 65536 65536     0)      0)
   ((    0 65536 65536 65536)  65536)
   ((65536     0     0     0)  65536)
   ((65536     0     0 65536)      0)
   ((65536     0 65536     0)      0)
   ((65536     0 65536 65536)  65536)
   ((65536 65536     0     0)      0)
   ((65536 65536     0 65536)  65536)
   ((65536 65536 65536     0)  65536)
   ((65536 65536 65536 65536)      0) >

T
