/* msdosLib.c
 * 29nov92abu
 */

#include "pico.h"
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <malloc.h>
#include <memory.h>
#include <time.h>
#include <string.h>

extern int rawIO(int);
extern void initCom(void);
extern void stopCom(void);
extern int comIn(void);
extern void comOut(int);
extern void deLocSubr(pico*);
extern void reLocSubr(pico*);

static int TheChar = 0;
static bool Xon = NO;

int comDev = 0;


void libStartUp(argc,argv)
int argc;
char *argv[];
{
   while (--argc > 0) {
      if (**++argv == '-') {
         switch(argv[0][1]) {
	         case 'f':
	            if (argv[0][2] == '\0') {
	               --argc, ++argv;
	               frzFd = open(argv[0], O_RDONLY|O_BINARY);
	            }
	            else
	               frzFd = open(argv[0] + 2, O_RDONLY|O_BINARY);
					if (frzFd < 0)
						giveup("Can't open FREEZE file");
	            break;
	         default:
	   			giveup("Usage: pico [-f<file>] [+any <any>] [<files>]");
	            break;
         }
      }
      else {
         if (loadCnt >= ARGMAX-1)
            giveup("Too many source files");
         else
            fileNames[loadCnt++] = (uchar*)argv[0];
      }
   }
}

void libExit(f)
bool f;
{
	if (comDev)
		stopCom();
   exit(f? 0:1);
}

void libError(s)
uchar *s;
{
   fprintf(stderr,"%s\n",s);
}

char *libAlloc(size)
unsigned long size;
{
   return (char*)malloc((int)size);
}

void libFree(ptr)
char *ptr;
{
   free(ptr);
}

char *libRealloc(ptr,size)
char *ptr;
unsigned long size;
{
   return (char*)realloc(ptr, (int)size);
}

void libBlock(src,dst,size)
char *src,*dst;
unsigned long size;
{
   memcpy(dst,src,(int)size);
}

long libTick()
{
	return 60 * time(NULL);
}

void libDate(y,m,d)
number *y,*m,*d;
{
   struct tm *p;
   long clock;

   time(&clock);
   p = localtime(&clock);
   *y = (number)p->tm_year;
	*m = (number)(p->tm_mon+1);
	*d =(number)p->tm_mday;
}

void libTime(h,m,s)
number *h,*m,*s;
{
   struct tm *p;
   long clock;

   time(&clock);
   p = localtime(&clock);
   *h = (number)p->tm_hour;
	*m = (number)p->tm_min;
	*s = (number)p->tm_sec;
}

int libRdOpen(fName)
uchar *fName;
{
   return open(fName, O_RDONLY);
}

int libWrOpen(fName,flgs)
uchar *fName;
long flgs;
{
   return open(fName,
	   flgs? O_CREAT|O_TRUNC|O_RDWR|O_BINARY : O_CREAT|O_TRUNC|O_RDWR,
		S_IREAD|S_IWRITE );
}

int libRdWrOpen(fName)
uchar *fName;
{
   return open(fName, O_RDWR);
}

int libRead(fd,buf,cnt)
int fd;
char *buf;
long cnt;
{
	return read(fd,buf,(unsigned int)cnt);
}

int libWrite(fd,buf,cnt)
int fd;
char *buf;
long cnt;
{
	return write(fd,buf,(unsigned int)cnt);
}

bool libSeek(fd,pos)
int fd;
long pos;
{
	return lseek(fd,pos,0) >= 0;
}

long libFPos(fd)
int fd;
{
	return lseek(fd,0L,1);
}

long libFSize(fd)
int fd;
{
	return filelength(fd);
}

bool libClose(fd)
int fd;
{
	return close(fd) >= 0;
}

pico libDir(s)
register uchar *s;
{
	struct find_t rec;
	cell c1;

	strcat(s,"*.*");
	push(nilSym,c1);
	if (_dos_findfirst(s, 16, &rec) == 0) {
		do {
			if (rec.name[0] != '.') {
				for (s = rec.name; *s; ++s)
					if (*s >= 'A' && *s <= 'Z')
						*s += 32;
				tos(c1) = newCell(unBufString(rec.name), tos(c1));
				if (rec.attrib & 16)
					nconc(car(tos(c1)), newCell(boxNum('\\'), nilSym));
			}
		} while (_dos_findnext(&rec) == 0);
	}
   return pop(c1);
}

bool libLink(old,new)
uchar *old,*new;
{
	return rename(old,new) == 0;
}

bool libUnlink(s)
uchar *s;
{
	return unlink(s) == 0;
}

void initConsole()
{
}

bool initSerial(s)
uchar *s;
{
	if (comDev)
		stopCom();
	if (s[0]!='C' || s[1]!='O' || s[2]!='M' || s[4]!=':' || s[5]!='\0')
		return NO;
	comDev = (int)s[3] - '1';
	return initCom();
}

void initSysSyms()
{
}

void initSysVars()
{
}

void ttyOut(c)
int c;
{
	ttyAvail();
	if (Xon) {
		while (!rawIO(-1));
		Xon = NO;
	}
	rawIO(c);
}

bool ttyAvail()
{
	int c;

	if (TheChar)
		return YES;
	if (!(c = rawIO(-1)))
		return NO;
	if (c == ctrl('Q'))
		return  Xon = NO;
	if (c == ctrl('S')) {
		Xon = YES;
		return NO;
	}
	TheChar = c;
	return YES;
}

int waitTTY()
{
	int c;

	if (TheChar) {
		c = TheChar;
		TheChar = 0;
		return c;
	}
	while (!(c = rawIO(-1)));
	return c;
}

void deLocate(adr1,adr2)
pico *adr1, *adr2;
{
	register pico x;
	register heap *h;
	register long offs;

	do {
		if (isNum(x = *adr1)) {
			if (num(x) & 1)
				deLocSubr(adr1);
		}
		else {
			h = heaps;
			offs = 0;
			while (x < h->cells  ||  x >= h->cells+CELLS) {
				offs += CELLS*sizeof(cell);
				h = h->next;
			}
			*adr1 = (pico)(num(x) - num(h->cells) + offs);
		}
	} while (++adr1 < adr2);
}

void reLocate(adr1,adr2)
pico *adr1, *adr2;
{
	register pico x;
	register heap *h;

	do {
		if (isNum(x = *adr1)) {
			if (num(x) & 1)
				reLocSubr(adr1);
		}
		else {
			h = heaps;
			while (num(x) >= CELLS*sizeof(cell)) {
				x = (pico)(num(x) - CELLS*sizeof(cell));
				h = h->next;
			}
			*adr1 = (pico)(num(x) + num(h->cells));
		}
	} while (++adr1 < adr2);
}

number libSystem(s)
uchar *s;
{
   return system(s);
}
