/* picoAI.c
 * 03nov92abu
 */

#pragma segment picoAI

#include "pico.h"

#define RATE 3 /* Learning Rate */

typedef struct neuro {
	long cnt1,cnt2,cnt3;
	long *value1, *value2, *value3;
	long *bias2, *bias3;
	long *weight12, *weight23;
	long data[1];
} neuro;

static number activTab[] = {
	    0,  1024,  2045,  3063,  4075,  5079,  6073,  7056,  8025,  8980,
	 9919, 10840, 11743, 12625, 13486, 14326, 15143, 15936, 16706, 17452,
	18173, 18870, 19542, 20189, 20813, 21411, 21986, 22538, 23066, 23571,
	24054, 24516, 24956, 25376, 25776, 26157, 26519, 26864, 27191, 27502,
	27797, 28076, 28341, 28592, 28830, 29055, 29268, 29470, 29660, 29840,
	30010, 30170, 30322, 30465, 30600, 30727, 30847, 30960, 31067, 31167,
	31262, 31351, 31435, 31515, 31589, 31659, 31726, 31788, 31846, 31901,
	31953, 32002, 32048, 32091, 32132, 32170, 32206, 32240, 32271, 32301,
	32329, 32356, 32381, 32404, 32426, 32447, 32466, 32484, 32501, 32517,
	32532, 32547, 32560, 32573, 32584, 32596, 32606, 32616, 32625, 32634,
	32642, 32649, 32657, 32663, 32670, 32676, 32681, 32686, 32691, 32696,
	32700, 32704, 32708, 32712, 32715, 32718, 32721, 32724, 32727, 32729,
	32732, 32734, 32736, 32738, 32740, 32741, 32743, 32745, 32746, 32747,
	32749, 32750, 32751, 32752, 32753, 32754, 32755, 32755, 32756, 32757,
	32758, 32758, 32759, 32759, 32760, 32760, 32761, 32761, 32762, 32762,
	32762, 32763, 32763, 32763, 32764, 32764, 32764, 32764, 32765, 32765,
	32765, 32765, 32765, 32766, 32766, 32766, 32766, 32766, 32766, 32766,
	32766, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
	32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32768
};

/* Prototypes */
static bool unify(pico,pico,pico,pico);
static pico look(pico,pico,pico);
static number act1(number);
static number activation(number);
pico propagate(neuro*,pico);
void backPropagate(neuro*,pico);

/*** Pattern Matching ***/
bool match(p,d)
register pico p,d;
{
   register pico x;

   loop {
      if (!isCell(p) && !isCell(d))
         return p == d;
      if (!isCell(p))
         return NO;
      x = car(p);
      if (!isNum(x) && isSym(x) && firstChar(x) == DASH) {
         if (!isCell(d)) {
            if (d == cdr(p)) {
               val(x) = nilSym;
               return YES;
            }
            return NO;
         }
         if (match(cdr(p),cdr(d))) {
            val(x) = newCell(car(d),nilSym);
            return YES;
         }
         if (match(cdr(p),d)) {
            val(x) = nilSym;
            return YES;
         }
         if (match(p,cdr(d))) {
            val(x) = newCell(car(d),val(x));
            return YES;
         }
      }
      if (!isCell(d) || !(match(x,car(d))))
         return NO;
      p = cdr(p);
      d = cdr(d);
   }
}

pico Match(x)
register pico x;
{
	cell c1,c2;

   push(EVAL1(x),c1);   /* Pattern */
   x = cdr(x);
   push(EVAL1(x),c2);   /* Data */
   x  =  match(tos(c1),tos(c2))? tSym : nilSym;
   drop(c1);
   return x;
}

/*** Declarative Programming ***/
bool unify(n1,x1,n2,x2)
register pico n1,x1,n2,x2;
{
	register pico x;
	pico env;

	look1:
	if (!isNum(x1) && isSym(x1) && !isNil(x1) && firstChar(x1) <= DASH) {
		x = tos(*stkPtr);
		while (isCell(car(x))) {
			if (n1 == car(car(car(x))) && x1 == cdr(car(car(x)))) {
				n1 = car(cdr(car(x)));
				x1 = cdr(cdr(car(x)));
				goto look1;
			}
			x = cdr(x);
		}
	}
	look2:
	if (!isNum(x2) && isSym(x2) && !isNil(x2) && firstChar(x2) <= DASH) {
		x = tos(*stkPtr);
		while (isCell(car(x))) {
			if (n2 == car(car(car(x))) && x2 == cdr(car(car(x)))) {
				n2 = car(cdr(car(x)));
				x2 = cdr(cdr(car(x)));
				goto look2;
			}
			x = cdr(x);
		}
	}
	if (n1 == n2 && x1 == x2)
		return YES;
	if (!isNum(x1) && isSym(x1) && !isNil(x1) && firstChar(x1) <= DASH) {
		if (x1 != dashSym)
			tos(*stkPtr) = newCell(newCell2(n1,x1,n2,x2),tos(*stkPtr));
		return YES;
	}
	if (!isNum(x2) && isSym(x2) && !isNil(x2) && firstChar(x2) <= DASH) {
		if (x2 != dashSym)
			tos(*stkPtr) = newCell(newCell2(n2,x2,n1,x1),tos(*stkPtr));
		return YES;
	}
	if (!isCell(x1) || !isCell(x2))
		return x1 == x2;
	env = tos(*stkPtr);
	if (unify(n1,car(x1),n2,car(x2)) && unify(n1,cdr(x1),n2,cdr(x2)))
		return YES;
	tos(*stkPtr) = env;
	return NO;
}

pico Unify(x)
register pico x;
{
   pico n1,x1,n2,x2;
	cell c1,c2,c3;

	n1 = EVAL1(x); /* Level 1 */
	x = cdr(x);
	push(x1 = EVAL1(x), c1); /* Clause 1 */
	x = cdr(x);
	n2 = EVAL1(x); /* Level 2 */
	x = cdr(x);
	push(x2 = EVAL1(x), c2); /* Clause 2 */
	x = cdr(x);
	push(EVAL1(x),c3); /* Environment */
	if (unify(n1,x1,n2,x2)) {
		drop(c1);
		return tos(c3);
	}
	drop(c1);
	return nilSym;
}

pico look(n,x,env)
register pico n,x;
pico env;
{
	register pico y;

	look:
	if (!isNum(x) && isSym(x) && !isNil(x) && firstChar(x) <= DASH) {
		y = env;
		while (isCell(car(y))) {
			if (n == car(car(car(y))) && x == cdr(car(car(y)))) {
				n = car(cdr(car(y)));
				x = cdr(cdr(car(y)));
				goto look;
			}
			y = cdr(y);
		}
	}
	if (isCell(x))
		return newCell(look(n,car(x),env),look(n,cdr(x),env));
	return x;
}

pico Look(x)
register pico x;
{
	pico n;
	cell c1;

	n = EVAL1(x);
	x = cdr(x);
	push(EVAL1(x),c1);
	x = cdr(x);
	x = EVAL1(x);
	return look(n,pop(c1),x);
}

/*** Neural Net ***/
pico Neuro(x)
pico x;
{
	register neuro *p;
	register number i,j,cnt1,cnt2,cnt3;

	cnt1 = nextNum(&x);
	cnt2 = nextNum(&x);
	cnt3 = nextNum(&x);
	if (!(p = (neuro*)libAlloc(sizeof(neuro) + sizeof(long) *
				(cnt1 + 2*cnt2 + 2*cnt3 + cnt1*cnt2 + cnt2*cnt3 - 1) ) ) )
		return nilSym;
	p->cnt1 = cnt1;
	p->cnt2 = cnt2;
	p->cnt3 = cnt3;
	p->value1 = p->data;
	p->value2 = p->value1 + cnt1;
	p->value3 = p->value2 + cnt2;
	p->bias2 = p->value3 + cnt3;
	p->bias3 = p->bias2 + cnt2;
	p->weight12 = p->bias3 + cnt3;
	p->weight23 = p->weight12 + cnt1*cnt2;
	for (i = 0; i < cnt2; ++i)
		p->bias2[i] = rnd32() >> 16; /* -0.5 .. +0.5 */
	for (i = 0; i < cnt3; ++i)
		p->bias3[i] = rnd32() >> 16;
	for (i = 0; i < cnt1; ++i)
		for (j = 0; j < cnt2; ++j)
			p->weight12[i*cnt2+j] = rnd32() >> 16;
	for (i = 0; i < cnt2; ++i)
		for (j = 0; j < cnt3; ++j)
			p->weight23[i*cnt3+j] = rnd32() >> 16;
	return boxPtr(num(p));
}

number act1(a)
register number a;
{
	register number b,c;

	if (a >= (sizeof(activTab)/sizeof(number) - 1) * 65536/16)
		return 0x8000;
	c = activTab[b = a >> 12];
	return c + muldiv(activTab[b+1] - c, a & (65536/16-1), 65536/16);
}

/* Activation function (Max abs error: 4) */
number activation(n)
register number n;
{
	if (n < 0)
		return 0x8000 - act1(-n);
	return 0x8000 + act1(n);
}

pico propagate(p,x)
register neuro *p;
register pico x;
{
	register number i,j,n;
	cell c;

	push(EVAL1(x),c);
	NEEDFUN(tos(c));
   for (i = 0; i < p->cnt1; ++i)
	   p->value1[i] = unBox(apply1(tos(c),boxNum(i)));
	drop(c);
	for (i = 0; i < p->cnt2; ++i) {
		n = p->bias2[i];
		for (j = 0; j < p->cnt1; ++j)
			n += fixmul(p->value1[j], p->weight12[j*p->cnt2+i]);
		p->value2[i] = activation(n);
	}
	for (i = 0; i < p->cnt3; ++i) {
		n = p->bias3[i];
		for (j = 0; j < p->cnt2; ++j)
			n += fixmul(p->value2[j], p->weight23[j*p->cnt3+i]);
		p->value3[i] = activation(n);
	}
   return cdr(x);
}

void backPropagate(p,x)
register neuro *p;
register pico x;
{
	register number i,j,n;
	cell c;

	push(EVAL1(x),c);
	NEEDFUN(tos(c));
   for (i = 0; i < p->cnt3; ++i) {
		x = apply1(tos(c),boxNum(i));
		NEEDNUM(x);
		n = p->value3[i];
		p->value3[i] = fixmul(unBox(x) - n, fixmul(n, 65536 - n));
	}
	drop(c);
	for (i = 0; i < p->cnt3; ++i) {
		p->bias3[i] += p->value3[i] >> RATE;
		for (j = 0; j < p->cnt2; ++j)
			p->weight23[j*p->cnt3+i] +=
						fixmul(p->value3[i], p->value2[j]) >> RATE;
	}
	for (i = 0; i < p->cnt2; ++i) {
		n = 0;
		for (j = 0; j < p->cnt3; ++j)
			n += fixmul(p->value3[j], p->weight23[i*p->cnt3+j]);
		p->value2[i] = fixmul(n, fixmul(p->value2[i], 65536 - p->value2[i]));
	}
	for (i = 0; i < p->cnt2; ++i) {
		p->bias2[i] += p->value2[i] >> RATE;
		for (j = 0; j < p->cnt1; ++j)
			p->weight12[j*p->cnt2+i] +=
						fixmul(p->value2[i], p->value1[j]) >> RATE;
	}
}

pico Solve(x)
register pico x;
{
	register neuro *p;
	register long i;
	cell c1;

	p = (neuro*)EVAL1(x);
	NEEDNUM(p);
	p = (neuro*)unBoxPtr((pico)p);
	propagate(p, cdr(x));
	if (p->cnt3 == 1)
		return boxNum(p->value3[0]);
	push(x = newCell(boxNum(p->value3[0]), nilSym), c1);
	i = 1;
	do {
		cdr(x) = newCell(boxNum(p->value3[i]), nilSym);
		x = cdr(x);
	} while (++i < p->cnt3);
	return pop(c1);
}

pico Train(x)
register pico x;
{
	register neuro *p;

	p = (neuro*)EVAL1(x); /* Neuro Structure */
	NEEDNUM(p);
	p = (neuro*)unBoxPtr((pico)p);
	backPropagate(p, propagate(p, cdr(x))); /* Data, Result */
	return tSym;
}
