/* picoMain.c
 * 25nov94abu
 */

#pragma segment picoMain

#include "pico.h"

/* Global objects */
pico applyList, mapCell, mapSym;
pico mapCell2, mapSym2, mapCell3, mapSym3, mapCell4, mapSym4;
pico nilSym, voidSym, tSym, itSym, quoteSym, shareFlg;
pico objectSym, classSym, metaSym;
pico dashSym, dash2Sym, dash3Sym, dash4Sym, dash5Sym;
pico topSym, fkeySym, againSym, quitSym;
pico fileSym, argvSym, loadSym, editSym;
pico queueSym, srcFlg, logFlg, printFlg;

picoEnv env;

/* Globals */
heap *heaps;
pico avail;
pico stkPtr;               /* Stack pointer */
bindFrame *bindPtr;			/* Bindings pointer */
catchFrame *catchPtr;		/* Catch frame pointer */
pico *withPtr;             /* Current WITH-pointer */

pico dynamos;              /* Dynamic memory objects */
jmp_buf errRst;            /* Error restart longjump */
pico loadPos;              /* Start of definition in source file */
pico loadName;
pico theMessage;           /* Current message */

int frzFd;                 /* libStartUp return values */
int loadCnt;
uchar *fileNames[ARGMAX];

uchar *lbp;
picoFile *stream;          /* The current input stream */
int traceLevel;            /* Trace recursion level */
int revaLevel;             /* Nesting level of read-eval-loops */
bool fresh;                /* Fresh start or loading freeze file */
uchar lBuff[LBSIZE] = "[(c) Alexander Burger 1987 .. 1993]";

/* Prototypes */
static void applyErr(pico);
static void init(bool);
void main(int,char*[]);

/* Initialization */
void reset()
{
   lbp = lBuff;
   while (*lbp)
      ++lbp;
   stream = NULL;
   traceLevel = 0;
	MathSP = -1;
}

void closeAll()
{
   while (isCell(val(fileSym)))
      closeFile((picoFile*)unBoxPtr(car(car(val(fileSym)))));
}

void unwind()
{
   register long cnt;

   while (bindPtr) {
      cnt = bindPtr->cnt;
      while (--cnt >= 0)
			val(bindPtr->bnd[cnt].sym) = bindPtr->bnd[cnt].val;
      bindPtr = bindPtr->link;
   }
   stkPtr = NULL;
   catchPtr = NULL;
   withPtr = &nilSym;
}

/* Error processing */
void doError()
{
   uchar buf[FILENAME];

   if (isNum(loadPos)) {
      prString("\n[Line ");
      prNumber(unBox(loadPos));
      prString(" in ");
      prString(bufString(loadName, buf, (long)FILENAME));
      chrOut(']');
   }
   crlf();
   revalo(nilSym);
   unwind();
   closeAll();
   longjmp(errRst,-1);
}

void error(s,t)
uchar *s,*t;
{
   reset();
   prString(s);
   if (t)
      prString(t);
   doError();
}

void err(s)
uchar *s;
{
   error(s,NULL);
}

void cBreak()
{
   picoFile *sSave;

   val(logFlg) = nilSym;
   val(queueSym) = nilSym;
   sSave = stream;
   setStream(NULL);
   prString("\nCONSOLE BREAK\n");
   revalo(nilSym);
   stream = sSave;
}

/* Print the error object */
void errObj(x,s)
pico x;
uchar *s;
{
   reset();
   prin0(x);
   error(" -- ",s);
}

void errStrObj(x,s)
pico x;
uchar *s;
{
   uchar msg[1024];

   reset();
   if (strLength(x) >= 1024)
      err(s);
   prString(bufString(x,msg,1024L));
   error(" -- ",s);
}

void numberError(x)
pico x;
{
   errObj(x, "Number expected");
}

void cellError(x)
pico x;
{
   errObj(x, "Cell expected");
}

void symbolError(x)
pico x;
{
   errObj(x, "Symbol expected");
}

void objError(x)
pico x;
{
   errObj(x, "Cell or Symbol expected");
}

void listError(x)
pico x;
{
   errObj(x, "List expected");
}

void strError(x)
pico x;
{
   errObj(x, "String expected");
}

void funError(x)
pico x;
{
   errObj(x, "Function expected");
}

void dynamoError(x)
pico x;
{
   errObj(x, "Dynamo expected");
}

void protErr(x)
pico x;
{
   errObj(x, "Protected symbol");
}

void stackError()
{
   err("Stack overflow");
}

void circError()
{
   err("Circular list");
}

void divError()
{
   err("Division by Zero");
}

void internErr(s)
uchar *s;
{
   error("Internal error: ",s);
}

/* Evaluate a list */
pico evList(x)
register pico x;
{
   register pico y,z;

   if (isNum(y = car(x)))
      return x;
   if (!isSym(y)) {
      if (isNum(y = evList(y)))
         return evSubr(y,cdr(x));
      if (isCell(y))
         return evExpr(y,cdr(x),y);
   }
   if (isNum(z = val(y)))
      return evSubr(z,cdr(x));
   if (!isCell(z))
      errObj(y, "Undefined");
	return evExpr(z,cdr(x),y);
}

static void applyErr(x)
pico x;
{
   errObj(x,"Can't apply");
}

pico apply1(x,arg)
register pico x;
pico arg;
{
   if (isNum(x)) {
      val(mapSym) = arg;
      x = evSubr(x,mapCell);
      val(mapSym) = nilSym;
      return x;
   }
   if (!isCell(x))
      applyErr(x);
	return apExpr(x,1,&arg,nilSym,x);
}

pico apply2(x,arg1,arg2)
register pico x;
pico arg1,arg2;
{
   if (isNum(x)) {
      val(mapSym2) = arg1;
      val(mapSym) = arg2;
      x = evSubr(x,mapCell2);
      val(mapSym2) = nilSym;
      val(mapSym) = nilSym;
      return x;
   }
   if (!isCell(x))
      applyErr(x);
	return apExpr(x,2,&arg1,nilSym,x);
}

pico apply3(x,arg1,arg2,arg3)
register pico x;
pico arg1,arg2,arg3;
{
   if (isNum(x)) {
      val(mapSym3) = arg1;
      val(mapSym2) = arg2;
      val(mapSym) = arg3;
      x = evSubr(x,mapCell3);
      val(mapSym3) = nilSym;
      val(mapSym2) = nilSym;
      val(mapSym) = nilSym;
      return x;
   }
   if (!isCell(x))
      applyErr(x);
	return apExpr(x,3,&arg1,nilSym,x);
}

pico apply4(x,arg1,arg2,arg3,arg4)
register pico x;
pico arg1,arg2,arg3,arg4;
{
   if (isNum(x)) {
      val(mapSym4) = arg1;
      val(mapSym3) = arg2;
      val(mapSym2) = arg3;
      val(mapSym) = arg4;
      x = evSubr(x,mapCell4);
      val(mapSym4) = nilSym;
      val(mapSym3) = nilSym;
      val(mapSym2) = nilSym;
      val(mapSym) = nilSym;
      return x;
   }
   if (!isCell(x))
      applyErr(x);
	return apExpr(x,4,&arg1,nilSym,x);
}

pico Apply(x)
register pico x;
{
   register pico y, foo;
	cell c1;

   push(EVAL1(x),c1);
   x = cdr(x);
   x = EVAL1(x);
   foo = pop(c1);
   if (isNum(foo)) {
      register pico p;

      if (!isCell(y = x))
         return evSubr(foo,nilSym);
      p = mapCell;
      while (isCell(y = cdr(y)))
         if ((p += 2) > applyList)
            errObj(x, "Too long list for APPLY");
      y = p;
      p = car(y);
      do {
         val(p) = car(x);
         p -= 2;
      } while (isCell(x = cdr(x)));
      x = evSubr(foo,y);
      p = car(y);
      do {
         val(p) = nilSym;
         p -= 2;
      } while (p >= mapSym);
      return x;
   }
   if (!isCell(foo))
      applyErr(foo);
	return apExpr(foo,0,NULL,x,foo);
}

pico evalBody(x)
register pico x;
{
   register pico y;

   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   return y;
}

/* Program termination */
void giveup(s)
uchar *s;
{
   libError(s);
   exitPico(FAIL);
}

void revalo(expr)
pico expr;
{
   register pico x;
   pico hidden;
	pico stkSave;
   bindFrame *bindSave;
   catchFrame *catchSave;
	cell c1,c2,c3;

   ++revaLevel;
   hidden = env.threads[THREADS];
   push(val(classSym),c1);
   push(val(topSym),c2);
   val(topSym) = expr;
	stkSave = stkPtr;
   bindSave = bindPtr;
   catchSave = catchPtr;
   while ((x = read0(YES)) != tSym) {
      chrIn();
      push(x,c3);
      tos(c3) = EVAL(x);
      if (!stream) {
         val(dash5Sym) = val(dash4Sym);
         val(dash4Sym) = val(dash3Sym);
         val(dash3Sym) = val(dash2Sym);
         val(dash2Sym) = val(dashSym);
         val(dashSym) = tos(c3);
         prompt('=');
         prin0(tos(c3));
         crlf();
      }
      drop(c3);
      if (stkPtr != stkSave)
         internErr("Stack");
      if (bindPtr != bindSave)
         internErr("BindFrame");
      if (catchPtr != catchSave)
         internErr("CatchFrame");
   }
   val(topSym) = tos(c2);
   val(classSym) = pop(c1);
   x = env.threads[THREADS];
   while (x != hidden)
      doZap(car(x)), x = cdr(x);
   env.threads[THREADS] = x;
   --revaLevel;
}

static void init(flg)
bool flg;
{
   fresh = flg;
   initSymbols();
   reset();
}

heap *heapAlloc(prev)
heap *prev;
{
	register heap *h;

	if (h = (heap*)libAlloc(sizeof(heap) + sizeof(cell))) {
		h = (heap*)((long)h + (sizeof(cell)-1) & ~(sizeof(cell)-1));
		h->next = NULL;
		h->prev = prev;
	}
	return h;
}

void main(argc,argv)
int argc;
char *argv[];
{
   register pico p;

   frzFd = 0;
   loadCnt = 0;
   initConsole();
   libStartUp(argc,argv);
   if (!(heaps = heapAlloc(NULL)))
      giveup("Can't allocate memory");

   /* Init PICO environment */
   stkPtr = NULL;
	bindPtr = NULL;
   catchPtr = NULL;
   withPtr = &nilSym;
   loadPos = NULL;
   dynamos = NULL;

   /* Error Entry */
   if (setjmp(errRst)) {
      val(topSym) = nilSym;
      val(loadSym) = nilSym;
   }
   else {
		long n;

      if (frzFd) {
         if (!unFreeze(frzFd))
            giveup("Can't UNFREEZE\r");
			libClose(frzFd);
			frzFd = 0;
         init(NO);
         n = loadCnt;
      	while (--n >= 0)
				val(argvSym) = newCell(unBufString(fileNames[n]),val(argvSym));
      }
      else {
         /* Init empty heap */
         avail = NULL;
         p = heaps->cells + CELLS-1;
         do {
            p->link = avail;
            avail = p;
         } while (--p >= heaps->cells);
         init(YES);
         env.genSeed[0] = 'A';
         env.genSeed[1] = env.genSeed[2] = env.genSeed[3] = '0';
         env.genSeed[4] = '0'-1;
         env.genSeed[5] = '\0';
         env.run = nilSym;
         revaLevel = 0;
      	for (n = 0; n < loadCnt; ++n)
         	Load(newCell(unBufString(fileNames[n]),nilSym));
      }
      evalBody(env.run);
   }
   do {
      revaLevel = -1;
      revalo(nilSym);
      prString("Exit Pico");
      revaLevel = 0;
   } while (read0(YES) != tSym);
   exitPico(SUCCESS);
}
