/* picoSym.c
 * 18oct92abu
 */

#pragma segment picoSym

#include "pico.h"

pico Record(x)
register pico x;
{
   x = EVAL1(x);
   NEEDSYM(x);
   record(x,srcFlg);
   return x;
}

pico Pname(x)
register pico x;
{
   register pico y;
   register uchar *s;
   uchar buf[8];
	cell c1,c2;

   x = EVAL1(x);
   NEEDSYM(x);
   push(x = getPname(x), c1);
   if (isNum(x)) {
      s = expShort(unBox(x), buf);
      push(y = newCell(boxNum(*s++), nilSym), c2);
      while (*s) {
         cdr(y) = newCell(boxNum(*s++), nilSym);
         y = cdr(y);
      }
   }
   else {
      s = expShort(unBox(car(x)), buf);
      x = cdr(x);
      push(y = newCell(boxNum(*s++), nilSym), c2);
      while (*s) {
         cdr(y) = newCell(boxNum(*s++), nilSym);
         y = cdr(y);
      }
      while (!isNum(x)) {
         s = expShort(unBox(car(x)), buf);
         x = cdr(x);
         while (*s) {
            cdr(y) = newCell(boxNum(*s++), nilSym);
            y = cdr(y);
         }
      }
      s = expShort(unBox(x), buf);
      while (*s) {
         cdr(y) = newCell(boxNum(*s++), nilSym);
         y = cdr(y);
      }
   }
   drop(c1);
   return tos(c2);
}

pico Set(x)
register pico x;
{
   register pico sym;
	cell c1;

	push(EVAL1(x),c1);
	x = cdr(x);
	x = EVAL1(x);
	sym = pop(c1);
   NEEDSYM(sym);
   CHECKSYM(sym);
   return val(sym) = x;
}

pico Setq(x)
register pico x;
{
   register pico sym;

   do {
      sym = car(x);
      x = cdr(x);
      NEEDSYM(sym);
      CHECKSYM(sym);
      val(sym) = EVAL1(x);
   } while (isCell(x = cdr(x)));
   return val(sym);
}

pico Xchg(x)
register pico x;
{
   register pico sym1,sym2,temp;

	do {
		sym1 = car(x);
		NEEDSYM(sym1);
		CHECKSYM(sym1);
		x = cdr(x);
		sym2 = car(x);
		NEEDSYM(sym2);
		CHECKSYM(sym2);
		temp = val(sym1);
		val(sym1) = val(sym2);
		val(sym2) = temp;
	} while (isCell(x = cdr(x)));
	return temp;
}

pico Value(x)
register pico x;
{
   x = EVAL1(x);
   NEEDSYM(x);
   return val(x);
}

pico Off(x)
register pico x;
{
   register pico sym;

   do {
      sym = car(x);
      NEEDSYM(sym);
      CHECKSYM(sym);
      val(sym) = nilSym;
   } while (isCell(x = cdr(x)));
   return nilSym;
}

pico On(x)
register pico x;
{
   register pico sym;

   do {
      sym = car(x);
      NEEDSYM(sym);
      CHECKSYM(sym);
      val(sym) = tSym;
   } while (isCell(x = cdr(x)));
   return tSym;
}

pico Toggle(x)
register pico x;
{
   register pico sym;
   register pico res;

   do {
      sym = car(x);
      NEEDSYM(sym);
      CHECKSYM(sym);
      val(sym) =  res = (val(sym) == nilSym)? tSym : nilSym;
   } while (isCell(x = cdr(x)));
   return res;
}

pico Default(x)
register pico x;
{
   register pico sym;

   do {
      sym = car(x);
      NEEDSYM(sym);
      CHECKSYM(sym);
      x = cdr(x);
      if (isNil(val(sym)) || val(sym)==voidSym)
         val(sym) = EVAL1(x);
   } while (isCell(x = cdr(x)));
   return val(sym);
}

pico Push(x)
register pico x;
{
   register pico sym;

   sym = car(cdr(x));
   NEEDSYM(sym);
   CHECKSYM(sym);
   x = EVAL1(x);
   return val(sym) = newCell(x,val(sym));
}

pico Push1(x)
register pico x;
{
   register pico y, sym;

   sym = car(cdr(x));
   NEEDSYM(sym);
   CHECKSYM(sym);
   x = EVAL1(x);
   y = val(sym);
   while (isCell(y)) {
      if (equal(x, car(y)))
         return val(sym);
      y = cdr(y);
   }
   return val(sym) = newCell(x,val(sym));
}

pico Pop(x)
register pico x;
{
   register pico sym;

   sym = car(x);
   NEEDSYM(sym);
   if (isCell(x = val(sym))) {
      val(sym) = cdr(val(sym));
      return car(x);
   }
	val(sym) = nilSym;
   return x;
}

pico Shift(x)
register pico x;
{
   register pico y, sym;
   register number n;

   sym = car(x);
   NEEDSYM(sym);
   if (!isCell(x = val(sym)))
      return x;
   if (!isCell(cdr(x))) {
      val(sym) = cdr(x);
      return car(x);
   }
   n = MAXLIST;
   do {
      if (--n <= 0)
         circError();
      y = x;
   } while (isCell(cdr(x = cdr(x))));
   cdr(y) = cdr(x);
   return car(x);
}

pico Chop(x)
register pico x;
{
   register number n;
   register pico y, sym;
	cell c1;

   n = num(EVAL1(x));
   NEEDNUM(n);
   if (!(n = unBox(n)))
      return nilSym;
   sym = car(cdr(x));
   NEEDSYM(sym);
   x = val(sym);
   NEEDCELL(x);
   push(y = newCell(car(x),nilSym), c1);
   while (isCell(x = cdr(x))  &&  --n > 0) {
      cdr(y) = newCell(car(x),nilSym);
      y = cdr(y);
   }
   val(sym) = x;
   return pop(c1);
}

pico Link(x)
register pico x;
{
   register pico sym1,sym2;

   sym1 = car(x);
   NEEDSYM(sym1);
   CHECKSYM(sym1);
   x = cdr(x);
   sym2 = car(x);
   NEEDSYM(sym2);
   CHECKSYM(sym2);
   x = newCell(EVAL1(cdr(x)),nilSym);
   if (!isCell(val(sym1)))
      val(sym1) = val(sym2) = x;
   else {
      cdr(val(sym2)) = x;
      val(sym2) = x;
   }
   return val(sym1);
}

pico put(x,key,prop)
pico x,key,prop;
{
   register pico y;

   NEEDSYM(x);
   CHECKSYM(x);
   if (isNum(y = tail(x)) || !isCell(car(y))) {
      y = newCell(key,prop);
      tail(x) = newCell(y,tail(x));
      return prop;
   }
   do {
      if (car(car(y)) == key)
         return cdr(car(y)) = prop;
      x = y;
   } while (!isNum(y = cdr(x)) && isCell(car(y)));
   y = newCell(key,prop);
   cdr(x) = newCell(y,cdr(x));
   return prop;
}

pico Put(x)
register pico x;
{
	cell c1,c2;

   push(EVAL1(x),c1); /* Sym */
   x = cdr(x);
   push(EVAL1(x),c2); /* Key */
   x = put(tos(c1),tos(c2),EVAL1(cdr(x)));
   drop(c1);
   return x;
}

pico Flag(x)
register pico x;
{
   register pico y, f;
	cell c1;

   push(EVAL1(x),c1); /* Sym */
   f = EVAL1(cdr(x));
   x = tos(c1);
   NEEDSYM(x);
   CHECKSYM(x);
   NEEDSYM(f);
   if (isNum(y = tail(x)) || isNum(car(y))) {
      tail(x) = newCell(f,y);
      drop(c1);
      return f;
   }
   while (!isNum(x = cdr(y)) && isCell(car(x)))
      y = x;
   while (!isNum(x = cdr(y)) && !isNum(car(x))) {
      if (car(x) == f) {
         drop(c1);
         return f;
      }
      y = x;
   }
   cdr(y) = newCell(f,x);
   drop(c1);
   return f;
}

pico get(x,key)
register pico x,key;
{
   NEEDSYM(x);
   x = tail(x);
   while (!isNum(x) && isCell(car(x))) {
      if (car(car(x)) == key)
         return cdr(car(x));
      x = cdr(x);
   }
   return nilSym;
}

pico Get(x)
register pico x;
{
   register pico y;
	cell c1;

   push(EVAL1(x),c1);
   x = cdr(x);
   y = EVAL1(x);
   while (isCell(x = cdr(x))) {
      tos(c1) = get(tos(c1),y);
      y = EVAL1(x);
   }
   return get(pop(c1),y);
}

pico Flagp(x)
register pico x;
{
   register pico f;
	cell c1;

   push(EVAL1(x),c1);
   f = EVAL1(cdr(x));
   x = pop(c1);
   NEEDSYM(x);
   NEEDSYM(f);
   x = tail(x);
   while (!isNum(x) && isCell(car(x)))
      x = cdr(x);
   while (!isNum(x) && !isNum(car(x))) {
      if (car(x) == f)
         return tSym;
      x = cdr(x);
   }
   return nilSym;
}

pico Is(x)
register pico x;
{
   register pico f;

   f = car(x);
	x = cdr(x);
   x = EVAL1(x);
   NEEDSYM(f);
   NEEDSYM(x);
   x = tail(x);
   while (!isNum(x) && isCell(car(x)))
      x = cdr(x);
   while (!isNum(x) && !isNum(car(x))) {
      if (car(x) == f)
         return tSym;
      x = cdr(x);
   }
   return nilSym;
}

pico plist(x)
register pico x;
{
   register pico y;
	cell c1,c2;

   NEEDSYM(x);
   if (isNum(x = tail(x)) || !isCell(car(x)))
      return nilSym;
   push(x,c1);
   push(y = newCell(car(x),nilSym), c2);
   while (!isNum(x = cdr(x)) && isCell(car(x))) {
      cdr(y) = newCell(car(x),nilSym);
      y = cdr(y);
   }
   drop(c1);
   return tos(c2);
}

pico Plist(x)
pico x;
{
   return plist(EVAL1(x));
}

pico Flags(x)
register pico x;
{
   register pico y;
	cell c1,c2;

   x = EVAL1(x);
   NEEDSYM(x);
   x = tail(x);
   while (!isNum(x) && isCell(car(x)))
      x = cdr(x);
   if (isNum(x) || isNum(car(x)))
      return nilSym;
   push(x,c1);
   push(y = newCell(car(x),nilSym), c2);
   while (!isNum(x = cdr(x)) && !isNum(car(x))) {
      cdr(y) = newCell(car(x),nilSym);
      y = cdr(y);
   }
   drop(c1);
   return tos(c2);
}

void setPlist(x,list)
register pico x,list;
{
   register pico y;
	cell c1;

   NEEDSYM(x);
   CHECKSYM(x);
   NEEDLIST(list);
   push(list,c1);
   list = copy(list);
   drop(c1);
   y = tail(x);
   while (!isNum(y) && isCell(car(y)))
      y = cdr(y);
   if (!isCell(list))
      tail(x) = y;
   else {
      tail(x) = list;
      while (isCell(cdr(list)))
         list = cdr(list);
      cdr(list) = y;
   }
}

pico SetPlist(x)
register pico x;
{
   register pico list;
	cell c1;

   push(EVAL1(x),c1); /* Symbol */
   x = cdr(x);
   list = EVAL1(x);   /* Plist */
   setPlist(tos(c1),list);
   drop(c1);
   return list;
}

void setFlags(x,list)
register pico x,list;
{
   register pico y;
	cell c1;

   NEEDSYM(x);
   CHECKSYM(x);
   NEEDLIST(list);
   push(list,c1);
   list = copy(list);
   drop(c1);
   if (isNum(y = tail(x)) || isNum(car(y))) {
      if (isCell(list)) {
         tail(x) = list;
         while (isCell(cdr(list)))
            list = cdr(list);
         cdr(list) = y;
      }
      return;
   }
   while (!isNum(x = cdr(y)) && isCell(car(x)))
      y = x;
   while (!isNum(x) && !isNum(car(x)))
      x = cdr(x);
   if (!isCell(list))
      cdr(y) = x;
   else {
      cdr(y) = list;
      while (isCell(cdr(list)))
         list = cdr(list);
      cdr(list) = x;
   }
}

pico SetFlags(x)
register pico x;
{
   register pico list;
	cell c1;

   push(EVAL1(x),c1); /* Symbol */
   x = cdr(x);
   list = EVAL1(x);   /* Flags */
   setFlags(tos(c1),list);
   drop(c1);
   return list;
}

pico Remove(x)
register pico x;
{
   register pico y,z;
	cell c1;

   push(EVAL1(x),c1);
   y = EVAL1(cdr(x));
   x = pop(c1);
   NEEDSYM(x);
   if (isNum(z = tail(x)) || isNum(car(z)))
      return nilSym;
   if (car(z) == y) {
      tail(x) = cdr(z);
      return y;
   }
   while (!isNum(x = cdr(z)) && !isNum(car(x))) {
      if (car(x) == y) {
         cdr(z) = cdr(x);
         return y;
      }
      z = x;
   }
   return nilSym;
}
