/* border.c
 * 07feb90gr
 */ 
 
#include "HD:picoSources:pico.h"
#include "HD:picoSources:stack.h"
#include "HD:picoSources:mac.h"
#include "bez.h"
#include "isar.h"

#define CROSSEPS	0.001
#define TGEPS		0.001
#define SPLITABS	0.01

/* Prototypes */
static void doSchnipp(Dxy,Dxy,Dxy,Dxy,Dxy*,Dxy*,Dxy*,double,double,double,double);
static bool doX2seg(Dxy,Dxy,Dxy,Dxy,Dxy,Dxy,Dxy,Dxy);
static bool getnextline(Dxy*,Dxy*,pico);
static bool int2Sec(pico,pico,Dxy*,Dxy*,Dxy*);
static bool intsecall(Dxy,Dxy,pico,Dxy*,Dxy*);
static bool kannSein(Dxy,Dxy,Dxy,Dxy,Dxy,Dxy,Dxy,Dxy);
static void lineParallel(Dxy*,Dxy*,double);
static pico ParSeg(pico);
static pico par1Seg(pico*,Dxy*,double,Dxy*);
/*static pico Schnippel(pico);*/
void schnippl(Dxy,Dxy,Dxy,Dxy,Dxy*,Dxy*,Dxy*,double);
static void schnippel(Dxy*,Dxy*,Dxy*,Dxy*,Dxy*,Dxy*,Dxy*,double);
static void segPt(Dxy,Dxy,Dxy,Dxy, double, Dxy*);
static double suchT(Dxy,Dxy,Dxy,Dxy,Dxy);
static pico X2seg(pico);

symInit borderSyms[] = {
	{"PARSEG",			ParSeg},
	{"X2SEG",			X2seg},
	NULL
};


/* reads two points from list	*/
bool getnextline(p1,p2,x)
Dxy *p1, *p2;
pico x;
{
	bool f;
	f = NO;	
	if (isCell(car(x))) {
		unBoxBezPoint(car(x),p1);
		x = cdr(x);
	}
	if (isCell(car(x))) {
		unBoxBezPoint(car(x),p2);
		f = YES;
	}
	
	return f;
}

/* searches intersection of two dim-3 curves out of graf-points	*/
bool int2Sec(x,y,erg,tx, ty)
register pico x, y;
Dxy *erg, *tx,*ty;
{
	Dxy x1,x2,y1,y2;
	Dxy tergy;		/* tangente im Schnittpoint bei curve y	*/
	
	while (getnextline(&x1,&x2,x)){
		if (intsecall(x1,x2,y,erg,&tergy)){
			*ty = tergy;
			tx->dx = x1.dx - x2.dx;
			tx->dy = x1.dy - x2.dy;
			return YES;
		}
		x = cdr(x);
	}	

	return NO;
}

/* intersection of line x1-x2 with all lines from y	*/
bool intsecall(x1,x2,y,erg,tergy)
Dxy x1,x2;
pico y;
Dxy *erg,*tergy;
{
	bool f;
	Dxy y1,y2;
	
	while (getnextline(&y1,&y2,y)){
#if 0
		if (Intsec(x1,x2,y1,y2,erg)){	/* founded intersection	*/
			tergy->dx = y2.dx - y1.dx;
			tergy->dy = y2.dy - y2.dy;
			return YES;
		}
#endif
		y = cdr(y);
	}	
	return NO;
}

void lineParallel(p1,p2,d)
Dxy *p1,*p2;
double d;
{
	double dh,dv,a,b;

	if (d != 0.0) {
		dh = p2->dx - p1->dx;
		dv = p2->dy - p1->dy;
		a = sqrt(dh*dh + dv*dv) / d;
		if (a != 0.0) {
			b = dv / a;
			p1->dx += b;
			p2->dx += b;
			b = dh / a;
			p1->dy -= b;
			p2->dy -= b;
		}
	}
}

/* Paralles shift of one bezier segment */
pico par1Seg(p,nxp,d,lastr)
register pico *p;
Dxy *nxp, *lastr;
double d;
{
	Dxy p1,p2,q,r;
	double pp, v;

	unBoxBezPoint(car(*p),&p1);
	*p = cdr(*p);
	unBoxBezPoint(car(*p),&q);
	*p = cdr(*p);
	unBoxBezPoint(car(*p),&r);
	*p = cdr(*p);
	if (isCell(*p))
		unBoxBezPoint(car(*p),&p2);
	else {
		p2 = *nxp;
		*lastr = r;			/* needed for last p 	*/
	}
	pp = distPt(p1.dx, p1.dy, p2.dx, p2.dy);
	lineParallel(&p1,&q,d);
	lineParallel(&r,&p2,d);
	v = distPt(p1.dx, p1.dy, p2.dx, p2.dy) / pp;
	q.dx = p1.dx*(1-v) + q.dx*v;
	q.dy = p1.dy*(1-v) + q.dy*v;
	r.dx = p2.dx*(1-v) + r.dx*v;
	r.dy = p2.dy*(1-v) + r.dy*v;
	push(newCell(boxBezPoint(&r),nilSym));
	tos = newCell(boxBezPoint(&q),tos);
	tos =  newCell(boxBezPoint(&p1), tos);
	return pop();
}

/* one segment of bezlist is bordered , need one bezsegment (dim-1 or dim-3)	*/
/* with next point	*/
pico ParSeg(x)
pico x;
{
	register pico y;
	Dxy p,nxp,r;
	double d,h,v,dh,dv,a;

	push(EVAL1(x));			/* Segment */
	x = cdr(x);
	nextBezPoint(&x,&nxp);	/* Next point */
	d = nextDouble(&x); 	/* Displacement */
	x = pop();
	if (isNum(car(x))) {
		unBoxBezPoint(x,&p);
		lineParallel(&p,&nxp,d);
		push(boxBezPoint(&p));
		tos = newCell(boxBezPoint(&nxp), tos);
		return pop();
	}
	push(y = par1Seg(&x,&nxp,d,&r));
	while (isCell(x)) {
		y = cdr(cdr(y));
		setCdr(y, par1Seg(&x,&nxp,d,&r));
		y = cdr(y);
	}
	lineParallel(&r,&nxp,d);		/* last point of curve dim-3	*/

	tos = newCell(boxBezPoint(&nxp), tos);
	return pop();
}

#if DEBUG
void showBezPt(Dxy);

void showBezPt(p)
Dxy p;
{
	integer h,v;
	file *sSave;

	sSave = stream;
	stream = NULL;
	h = (integer)(ROUND + p.dx);
	v = (integer)(ROUND + p.dy);
	PenSize(3,3);
	MoveTo(h,v);
	LineTo(h,v);
	PenNormal();
	HitKey();
	stream = sSave;
}
#endif

void segPt(p,q,r,np,t,pt)
Dxy p,q,r,np;
double t;
Dxy *pt;
{
	Dxy a,b,c;

	a.dx = -p.dx + 3 * q.dx - 3 * r.dx + np.dx;
	a.dy = -p.dy + 3 * q.dy - 3 * r.dy + np.dy;
	b.dx = 3 * p.dx - 6 * q.dx + 3 * r.dx;
	b.dy = 3 * p.dy - 6 * q.dy + 3 * r.dy;
	c.dx = -3 * p.dx + 3 * q.dx;
	c.dy = -3 * p.dy + 3 * q.dy;
	pt->dx = (t * (t * (a.dx * t + b.dx) + c.dx) + p.dx);
	pt->dy = (t * (t * (a.dy * t + b.dy) + c.dy) + p.dy);
}

bool kannSein(p1,q1,r1,np1,p2,q2,r2,np2)
Dxy p1,q1,r1,np1,p2,q2,r2,np2;
{
	double h1,v1,h2,v2;

	h1 = p1.dx < np1.dx ?  p1.dx : np1.dx;
	v1 = p1.dy < np1.dy ?  p1.dy : np1.dy;
	h2 = p1.dx > np1.dx ?  p1.dx : np1.dx;
	v2 = p1.dy > np1.dy ?  p1.dy : np1.dy;
	if (q1.dx < h1)  h1 = q1.dx;
	if (r1.dx < h1)  h1 = r1.dx;
	if (q1.dy < v1)  v1 = q1.dy;
	if (r1.dy < v1)  v1 = r1.dy;
	if (q1.dx > h2)  h2 = q1.dx;
	if (r1.dx > h2)  h2 = r1.dx;
	if (q1.dy > v2)  v2 = q1.dy;
	if (r1.dy > v2)  v2 = r1.dy;

	if (h1 > p2.dx  &&  h1 > np2.dx  &&  h1 > q2.dx  &&  h1 > r2.dx)
		return NO;
	if (h2 < p2.dx  &&  h2 < np2.dx  &&  h2 < q2.dx  &&  h2 < r2.dx)
		return NO;
	if (v1 > p2.dy  &&  v1 > np2.dy  &&  v1 > q2.dy  &&  v1 > r2.dy)
		return NO;
	if (v2 < p2.dy  &&  v2 < np2.dy  &&  v2 < q2.dy  &&  v2 < r2.dy)
		return NO;

	return YES;
}

#define P1				0.25
#define P2				0.5
#define P3				0.75

double bezier(double,double,double,double,double);

double bezier(t,a,b,c,p)
register double t;
double a,b,c,p;
{
	return t * (t* (t * a + b) + c) + p;
}

#if 0
pico Schnippel(x)
pico x;
{
	Dxy p,q,r,np;
	Dxy xq, xr, xnp;
	double t;
	
	nextBezPoint(&x,&p);
	nextBezPoint(&x,&q);
	nextBezPoint(&x,&r);
	nextBezPoint(&x,&np);
	t = nextDouble(&x);
	
	schnippl(p,q,r,np,&xq,&xr,&xnp,t);

	push(newCell(boxBezPoint(&xnp),nilSym));
	tos = newCell(boxBezPoint(&xr),tos);
	tos = newCell(boxBezPoint(&xq),tos);
	tos = newCell(boxBezPoint(&p),tos);
	
	schnippl(np,r,q,p,&xq,&xr,&xnp,1-t);

	tos = newCell(boxBezPoint(&np),tos);
	tos = newCell(boxBezPoint(&xq),tos);
	tos = newCell(boxBezPoint(&xr),tos);
	tos = newCell(boxBezPoint(&xnp),tos);

	return pop();
}
#endif

void doSchnipp(p,q,r,np,xnp,bp,cp,t,t1,t2,t3)
Dxy p,q,r,np;
Dxy *xnp,*bp,*cp;
double t,t1,t2,t3;
{
	Dxy a,b,c;
	Dxy pt1,pt2,pt3;
	double n1,n2;
	double p1_2,p1_3,p2_2,p2_3,p3_2,p3_3;

	a.dx = -p.dx + 3 * q.dx - 3 * r.dx + np.dx;
	a.dy = -p.dy + 3 * q.dy - 3 * r.dy + np.dy;
	b.dx = 3 * p.dx - 6 * q.dx + 3 * r.dx;
	b.dy = 3 * p.dy - 6 * q.dy + 3 * r.dy;
	c.dx = -3 * p.dx + 3 * q.dx;
	c.dy = -3 * p.dy + 3 * q.dy;

	pt1.dx = bezier(t1, a.dx, b.dx, c.dx, p.dx);
	pt1.dy = bezier(t1, a.dy, b.dy, c.dy, p.dy);
	pt2.dx = bezier(t2, a.dx, b.dx, c.dx, p.dx);

	pt2.dy = bezier(t2, a.dy, b.dy, c.dy, p.dy);
	pt3.dx = bezier(t3, a.dx, b.dx, c.dx, p.dx);
	pt3.dy = bezier(t3, a.dy, b.dy, c.dy, p.dy);

	xnp->dx = bezier(t, a.dx, b.dx, c.dx, p.dx);
	xnp->dy = bezier(t, a.dy, b.dy, c.dy, p.dy);

	p1_2 = P1*P1;
	p1_3 = P1 * p1_2;
	p2_2 = P2*P2;
	p2_3 = P2 * p2_2;
	p3_2 = P3*P3;
	p3_3 = P3 * p3_2;
	n1 = (P1*P2*P3*( p1_2 *P2 -  p1_2 *P3 - P1* p2_2  + P1* p3_2   +  p2_2 *P3 - P2* p3_2 ));
	n2 = (P1*P2*P3*( p1_2 *P2 -  p1_2 *P3 - P1* p2_2  + P1* p3_2  +  p2_2 *P3 - P2* p3_2 ));
	bp->dx = (-pt1.dx * p2_3 * P3 + pt1.dx * P2 *  p3_3  + pt2.dx * p1_3 * P3
			- pt2.dx * P1 * p3_3  - pt3.dx * p1_3 * P2
			+ pt3.dx * P1 * p2_3  + p.dx * p1_3 * P2 - p.dx * p1_3 * P3
			- p.dx * P1 * p2_3   + p.dx * P1 * p3_3 
			+ p.dx * p2_3 * P3 - p.dx * P2 * p3_3)
			/ n1;
	cp->dx = (pt1.dx* p2_3 * p3_2  - pt1.dx* p2_2 * p3_3 
			- pt2.dx* p1_3 * p3_2  + pt2.dx* p1_2 * p3_3 
			+ pt3.dx* p1_3 * p2_2  - pt3.dx* p1_2 * p2_3  - p.dx* p1_3 * p2_2 
			+ p.dx* p1_3 * p3_2  + p.dx* p1_2 * p2_3 
			- p.dx* p1_2 * p3_3  - p.dx* p2_3 * p3_2  + p.dx* p2_2 * p3_3 )
			/ n2;
	bp->dy = (-pt1.dy* p2_3 *P3 + pt1.dy*P2* p3_3  + pt2.dy* p1_3 *P3
			- pt2.dy*P1* p3_3  - pt3.dy* p1_3 *P2
			+ pt3.dy*P1* p2_3  + p.dy* p1_3 *P2 - p.dy* p1_3 *P3
			- p.dy*P1* p2_3   + p.dy*P1* p3_3 
			+ p.dy* p2_3 *P3 - p.dy*P2* p3_3)
			/ n1;
	cp->dy = (pt1.dy* p2_3 * p3_2  - pt1.dy* p2_2 * p3_3 
			- pt2.dy* p1_3 * p3_2  + pt2.dy* p1_2 * p3_3 
			+ pt3.dy* p1_3 * p2_2  - pt3.dy* p1_2 * p2_3  - p.dy* p1_3 * p2_2 
			+ p.dy* p1_3 * p3_2  + p.dy* p1_2 * p2_3 
			- p.dy* p1_2 * p3_3  - p.dy* p2_3 * p3_2  + p.dy* p2_2 * p3_3)
			/ n2;
}

/* Return value for doX2seg() */
static Dxy crossPt;

void schnippel(p,q,r,np,xp,xq,xr,t)
Dxy *p,*q,*r,*np,*xp,*xq,*xr;
double t;
{
	Dxy pp,qq,rr,npp;
	
	pp = *p;
	qq = *q;
	rr= *r;
	npp = *np;
	
	schnippl(pp,qq,rr,npp,q,xr,xp,t);
	schnippl(npp,rr,qq,pp,r,xq,xp,1-t);
}

void schnippl(p,q,r,np,xq,xr,xnp,t)
Dxy p,q,r,np,*xnp,*xq,*xr;
double t;
{
	Dxy b,c;

	doSchnipp(p,q,r,np,xnp,&b,&c,t,P1*t,P2*t,P3*t);
	xq->dx = p.dx + c.dx/3.0;
	xq->dy = p.dy + c.dy/3.0;
	xr->dx = b.dx/3.0 - p.dx + 2.0*xq->dx;
	xr->dy = b.dy/3.0 - p.dy + 2.0*xq->dy;
}

/* searching for crosspoint of two segments */
bool doX2seg(p1,q1,r1,np1,p2,q2,r2,np2)
Dxy p1,q1,r1,np1,p2,q2,r2,np2;
{
	Dxy xp1,xp2,xq1,xq2,xr1,xr2;

	if (!kannSein(p1,q1,r1,np1,p2,q2,r2,np2))
		return NO;
	segPt(p1,q1,r1,np1, 0.5, &xp1);
	segPt(p2,q2,r2,np2, 0.5, &xp2);
	if (DIS(xp1,xp2) < CROSSEPS) {
		crossPt = xp1;
		return YES;
	}
	schnippel(&p1,&q1,&r1,&np1,&xp1,&xq1,&xr1, 0.5);
	schnippel(&p2,&q2,&r2,&np2,&xp2,&xq2,&xr2, 0.5);
	if (doX2seg(p1,q1,xr1,xp1, p2,q2,xr2,xp2))
		return YES;
	if (doX2seg(p1,q1,xr1,xp1, xp2,xq2,r2,np2))
		return YES;
	if (doX2seg(xp1,xq1,r1,np1, p2,q2,xr2,xp2))
		return YES;
	if (doX2seg(xp1,xq1,r1,np1, xp2,xq2,r2,np2))
		return YES;
	return NO;
}

/* searching for matching parameter t for point pt (crosspoint) of segment */
double suchT(p,q,r,np,pt)
Dxy p,q,r,np,pt;
{
	register double t,dt;
	register int i;
	Dxy pt1,pt2;

	t = 0.5;
	dt = 0.25;
	for (i = 0; i < 20; ++i) {
		segPt(p,q,r,np,t+dt,&pt1);
		segPt(p,q,r,np,t-dt,&pt2);
		if (DIS(pt,pt1) < DIS(pt,pt2))
			t += dt;
		else
			t -= dt;
		if (DIS(pt1,pt2) < CROSSEPS)
			break;
		dt /= 2;
	}
	return t;
}


/* searching crosspoint of two segments */
pico X2seg(x)
register pico x;
{
	register pico y;
	Dxy p1,q1,r1,np1,p2,q2,r2,np2,xq,xr;
	bool linef1,linef2;
	
	y = EVAL1(x);
	NEEDCELL(y);
	x = cdr(x);
	x = EVAL1(x);
	NEEDCELL(x);
	unBoxBezPoint(car(y), &np1);
	y = cdr(y);
	if (linef1 = isNum(car(y))) {
		unBoxBezPoint(y, &p1);
		q1.dx = r1.dx  =  (p1.dx + np1.dx)/2; /* Force to dim 3 */
		q1.dy = r1.dy  =  (p1.dy + np1.dy)/2;
	}
	else {
#if 0
		while (isCell(cdr(cdr(cdr(y)))))
			y = cdr(cdr(cdr(y)));
#endif
		unBoxBezPoint(car(y), &p1);
		y = cdr(y);
		unBoxBezPoint(car(y), &q1);
		y = cdr(y);
		unBoxBezPoint(car(y), &r1);
	}
	unBoxBezPoint(car(x), &np2);
	x = cdr(x);
	if (linef2 = isNum(car(x))) {
		unBoxBezPoint(x, &p2);
		q2.dx = r2.dx  =  (p2.dx + np2.dx)/2;
		q2.dy = r2.dy  =  (p2.dy + np2.dy)/2;
	}
	else {
		unBoxBezPoint(car(x), &p2);
		x = cdr(x);
		unBoxBezPoint(car(x), &q2);
		x = cdr(x);
		unBoxBezPoint(car(x), &r2);
	}

	if (!doX2seg(p1,q1,r1,np1,p2,q2,r2,np2))
		return nilSym;
	if (DIS(crossPt,np1) < SPLITABS  ||  DIS(crossPt,np2) < SPLITABS)
		return nilSym;
	schnippel(&p1,&q1,&r1,&np1,&crossPt,&xq,&xr,suchT(p1,q1,r1,np1,crossPt));
	if (linef1) {
		push(boxBezPoint(&p1));
		tos = newCell(boxBezPoint(&crossPt),tos);
	}
	else {
		push(newCell(boxBezPoint(&xr), nilSym));
		tos = newCell(boxBezPoint(&q1), tos);
		tos = newCell(boxBezPoint(&p1), tos);
		tos = newCell(boxBezPoint(&crossPt),tos);
	}
	schnippel(&p2,&q2,&r2,&np2,&crossPt,&xq,&xr,suchT(p2,q2,r2,np2,crossPt));
	if (linef2) {
		push(boxBezPoint(&crossPt));
		tos = newCell(boxBezPoint(&np2),tos);
	}
	else {
		push(newCell(boxBezPoint(&r2), nilSym));
		tos = newCell(boxBezPoint(&xq), tos);
		tos = newCell(boxBezPoint(&crossPt), tos);
		tos = newCell(boxBezPoint(&np2), tos);
	}
	x = pop();
	return newCell(pop(),x);
}
