/* isarGerd.c
 * 30jan90gr
 */ 
 
#include "HD:picoSources:pico.h"
#include "HD:picoSources:stack.h"
#include "HD:picoSources:mac.h"
#include "bez.h"
#include "isar.h"

/*   #define TOLFLP 50.0	*/	/*  ??? */
#define ABSPT  1.0				/* minimum distance between two points in 1/100 mm */

static Dxy srect[2];			/* source rect */
static Dxy drect[2];			/* dest. rect */
static double xfaktor, yfaktor;

/* Prototypes */
static pico araCalc(pico);
static pico areaCalc(pico);
static double arcTan(double,double);
static pico boxDPoint(Dxy*);
static pico BezPlot(pico);
static pico BezRgn(pico);
static pico bzCirc(pico);
static pico bzElli(pico);
static pico bzHybrid(pico);
static pico bzRect(pico);
static pico centre(pico);
static pico copy1bez(pico);
static pico copy1pt(pico);
static pico copybez(pico);
static pico drawBez(pico,double,bool);
static pico DrawBez(pico);
static void nextDPoint(pico*,Dxy*);
static pico nudel(Dxy,Dxy,Dxy,Dxy);
static pico newarc(pico);
static bool pcentre(Dxy,Dxy,Dxy,Dxy*);
static void plotArc(pico,pico,double,bool,pico*);
static pico RndPt(pico);
static pico Rotz(pico);
static void rrr(Dxy,Dxy,Dxy,Dxy*,Dxy*,double);
/* static pico toBezPoint(pico); */
static void unBoxDPoint(pico,Dxy*);
static double winkel(Dxy, Dxy, Dxy, Dxy);

symInit gerdSyms[] = {
	{"AREACALC",		areaCalc},
	{"BZCIRC",			bzCirc},
	{"BZELLI",			bzElli},
	{"BZHYBRID",		bzHybrid},
	{"BZRECT",			bzRect},
	{"BEZPLOT",			BezPlot},
	{"BEZRGN",			BezRgn},
	{"CENTRE",			centre},
	{"COPYBEZ",			copybez},
	{"DRAWBEZ",			DrawBez},
	{"RNDPT",			RndPt},
	{"NEWARC",			newarc},
	{"ROTZ",			Rotz},
	NULL
};

/* calculate from inputpoints area, if result negativ, change bezlist to reverse */
pico araCalc(z)
pico z;
{	
    register pico x;
    Dxy p0, p1, p2, first;
    register double erg;
    
	x = z;
	unBoxDPoint(car(x),&p0);
	first = p0;
	erg = 0.0;
	
	do {
		if (isCell(car(car(x)))) {		/* list of points describing curve	*/
			unBoxDPoint(car(car(x)), &p1);
			erg += VPR(p0,p1);
			x = cdr(x);
			unBoxDPoint(car(x), &p2);
			x = cdr(x);
			erg += VPR(p1,p2);
			p0 = p2;
		}
		else {
			unBoxDPoint(car(x), &p1);
 			erg += VPR(p0,p1);
   			x = cdr(x);
			p0 = p1;
		}
	} while (isCell(x));
	
	erg += VPR(p0,first);
	if (erg > 0.0)
		return z;
    x = nilSym;
	while (isCell(z)) {
		x = newCell(car(z),x);
		z = cdr(z);
	}
	return x;
}

pico areaCalc(x)
pico x;
{
	x = EVAL1(x);
	NEEDCELL(x);
	return araCalc(x);
}

double arcTan(y,x)
register double x;  /* X-coordinate */
register double y;  /* Y-coordinate */
{
	double dval;

    if	(fabs(x) < EPS)
		return  y > 0.0 ?  PI2 : -PI2;
    dval = atan(y / x);
    if	(x > 0.0)
		return (dval);
	return y > 0.0 ?  dval+PI : dval-PI;
}

pico BezPlot(x)
register pico x;
{
	register pico bz;

	push(EVAL1(x));
	x = EVAL1(cdr(x));
	bz = pop();
	NEEDNUM(x);
	return drawBez(bz, (double)unBox(x), NO);
}

pico BezRgn(x)
register pico x;
{
	register pico bz;
	RgnHandle rgn;

	push(EVAL1(x));
	x = EVAL1(cdr(x));
	bz = pop();
	NEEDNUM(x);
	OpenRgn();
	drawBez(bz, (double)unBox(x), YES);
	CloseRgn(rgn = NewRgn());
	return boxPtr(rgn);
}

pico boxBezPoint(p)
register Dxy *p;
{
	return newCell(boxDouble(p->dx * SCAL), boxDouble(p->dy * SCAL));
}

pico boxDPoint(p)
register Dxy *p;
{
	return newCell(boxDouble(p->dx * PREC), boxDouble(p->dy * PREC));
}

pico bzCirc(x)
pico x;
{	
    register int i;
    Dxy pc;
	Dxy wfp[2];
    double gm;
    double th,dth;
    double r;
    Dxy p;

	nextDPoint(&x,wfp);
    wfp[1].dx = nextDouble(&x);
    pc.dx = wfp[0].dx;
    pc.dy = wfp[0].dy;
    r = wfp[1].dx;
    dth = PI4;
    gm = (4.0 * cos(dth / 2.0) - 2 * cos(dth) - 2.0) / (1.5 * dth * sin(dth));
    th = 2.25 * PI;

	push(nilSym);
    i = NSCIRC-1;
    do {
    	/* R */
		p.dx = r * cos(th + dth) + pc.dx + gm * r * dth * sin(th + dth);
		p.dy = r * sin(th + dth) + pc.dy - gm * r * dth * cos(th + dth);
    	tos = newCell(boxBezPoint(&p), tos);
    	/* Q */
		p.dx = r * cos(th) + pc.dx - gm * r * dth * sin(th);
		p.dy = r * sin(th) + pc.dy + gm * r * dth * cos(th);
    	tos = newCell(boxBezPoint(&p), tos);
    	/* P */
		p.dx = r * cos(th) + pc.dx;
		p.dy = r * sin(th) + pc.dy;
    	tos = newCell(boxBezPoint(&p), tos);
		th -= dth;
	} while (--i >= 0);
	return newCell(pop(),nilSym);
}

/* input three points first left side, right side , high point */
pico bzElli(x)
pico x;
{
    register int i;
	Dxy wfp[3];
    Dxy pc, p0, p1, p2,  w;   
    double a11,a12,a21,a22;
    double ra,rb;
    double th,dth;
    double wh,gm;
    Dxy p,q,r;

    nextDPoint(&x,wfp);
    nextDPoint(&x,wfp+1);
    nextDPoint(&x,wfp+2);
  
    /* set work point */
    pc.dx = (wfp[0].dx + wfp[1].dx) / 2;
    pc.dy = (wfp[0].dy + wfp[1].dy) / 2;
    
    ra = DIS(pc,wfp[1]);
    rb = DIS(pc,wfp[2]);
    
    p0.dx = pc.dx + ra;
    p0.dy = pc.dy;
    p2 = p1 = wfp[1];
	wh = winkel(pc,p0,p1,p2);
   										 /* make curve */
    dth = PI4;
    gm = (4.0 * cos(dth / 2.0) - 2.0 * cos(dth) - 2.0) / (1.5 * dth * sin(dth));
    a11 =  cos(wh);						/* set rotation matrix */
    a12 = -sin(wh);
    a21 =  sin(wh);
    a22 =  cos(wh);

    th =  2.25 * PI;
	push(nilSym);
    i = NSCIRC-1;
    do {
		w.dx = ra * cos(th);
		w.dy = rb * sin(th);
		p.dx = a11 * w.dx + a12 * w.dy + pc.dx;
		p.dy = a21 * w.dx + a22 * w.dy + pc.dy;

		w.dx = -gm * ra * dth * sin(th);
		w.dy =	gm * rb * dth * cos(th);
		q.dx = p.dx + a11 * w.dx + a12 * w.dy;
		q.dy = p.dy + a21 * w.dx + a22 * w.dy;

		w.dx = ra * cos(th + dth);
		w.dy = rb * sin(th + dth);
		r.dx = a11 * w.dx + a12 * w.dy + pc.dx;
		r.dy = a21 * w.dx + a22 * w.dy + pc.dy;
		w.dx = -gm * ra * dth * sin(th + dth);
		w.dy =	gm * rb * dth * cos(th + dth);
		r.dx -= a11 * w.dx + a12 * w.dy;
		r.dy -= a21 * w.dx + a22 * w.dy;

    	tos = newCell(boxBezPoint(&r), tos);
    	tos = newCell(boxBezPoint(&q), tos);
    	tos = newCell(boxBezPoint(&p), tos);
		th -= dth;
	} while (--i >= 0);
	return newCell(pop(),nilSym);
}

#if 1
pico bzHybrid(x)
register pico x;
{
	register pico y;
	register Dxy p0, p1, p2, pc,np;
	Dxy startpt;
	bool first;
	
	x = EVAL1(x);
	NEEDCELL(x);
	x = araCalc(x);
	unBoxDPoint(car(x),&p0);
	startpt = p0;
	
	if (!isCell(x = cdr(x))) return nilSym;

	first = YES;
	do {
		if (isCell(car(car(x)))) {		/* list of points describing curve	*/
			unBoxDPoint(car(car(x)), &p1);
			x = cdr(x);
			unBoxDPoint(car(x), &p2);
			x = cdr(x);
			if (DIS(p0,p1) > ABSPT && DIS(p1,p2) > ABSPT && DIS(p0,p2) > ABSPT) {
							/*	if (!pcentre(p0,p1,p2,&pc)) return nilSym;	*/
				pcentre(p0,p1,p2,&pc);	
				if (first) {
					push(y = newCell(nudel(pc,p0,p1,p2), nilSym));
					first = NO;
				}
				else {
					setCdr(y, newCell(nudel(pc,p0,p1,p2), nilSym));
					y = cdr(y);
				}
			}
			p0 = p2;
		}
		else {
			if (isCell(car(car(x))))
				unBoxDPoint(car(car(x)), &np);
			else 
				unBoxDPoint(car(x), &np);
			if (DIS(np,p0) > ABSPT) {
				if (first) {
	    			push(y = newCell(boxBezPoint(&p0), nilSym));
	    			first = NO;
	    		}
	    		else {
	    			setCdr(y, newCell(boxBezPoint(&p0), nilSym));
	    			y = cdr(y);
	    		}
	    	}
			unBoxDPoint(car(x), &p0);
    		x = cdr(x);
		}
	} while (isCell(x));
	
    setCdr(y, newCell(boxBezPoint(&p0), nilSym));
/*
    if (DIS(startpt,p0) > ABSPT)
        setCdr(y, newCell(boxBezPoint(&startpt), nilSym));
*/
	return pop();
}

#else
pico bzHybrid(x)
register pico x;
{
	register pico y;
	register Dxy p0, p1, p2, pc;
	bool first;
	
	x = EVAL1(x);
	NEEDCELL(x);
	x = araCalc(x);
	unBoxDPoint(car(x),&p0);
	
	if (!isCell(x = cdr(x))) return nilSym;

	first = YES;
	do {
		if (isCell(car(car(x)))) {		/* list of points describing curve	*/
			unBoxDPoint(car(car(x)), &p1);
			x = cdr(x);
			unBoxDPoint(car(x), &p2);
			x = cdr(x);
			if (!pcentre(p0,p1,p2,&pc)) return nilSym;
			if (first) {
				push(y = newCell(nudel(pc,p0,p1,p2), nilSym));
				first = NO;
			}
			else {
				setCdr(y, newCell(nudel(pc,p0,p1,p2), nilSym));
				y = cdr(y);
			}
			p0 = p2;
		}
		else {
			if (first) {
    			push(y = newCell(boxBezPoint(&p0), nilSym));
    			first = NO;
    		}
    		else {
    			setCdr(y, newCell(boxBezPoint(&p0), nilSym));
    			y = cdr(y);
    		}
			unBoxDPoint(car(x), &p0);
    		x = cdr(x);
		}
	} while (isCell(x));
    setCdr(y, newCell(boxBezPoint(&p0), nilSym));
	return pop();
}
#endif

pico bzRect(x)
pico x;
{
    register int i;
	Dxy wfp[2];
    Dxy wp[4];

    nextDPoint(&x,wfp);
    nextDPoint(&x,wfp+1);
    /* set work point */
    wp[2].dx = MIN(wfp[0].dx, wfp[1].dx);
    wp[2].dy = MIN(wfp[0].dy, wfp[1].dy);
    wp[0].dx = MAX(wfp[0].dx, wfp[1].dx);
    wp[0].dy = MAX(wfp[0].dy, wfp[1].dy);
    wp[1].dx = wp[2].dx;
    wp[1].dy = wp[0].dy;
    wp[3].dx = wp[0].dx;
    wp[3].dy = wp[2].dy;

	push(nilSym);
    i = NSRECT-1;
    do
    	tos = newCell(boxBezPoint(wp + i), tos);
	while (--i >= 0);
	return pop();
}

pico centre(x)
pico x;
{
	Dxy p[4];
	
    nextDPoint(&x,p);		
    nextDPoint(&x,p+1);
    nextDPoint(&x,p+2);
    if (!pcentre(p[0], p[1], p[2], p+3))
    	return nilSym;
	return newCell((boxDouble(p[3].dx * PREC)),(boxDouble(p[3].dy * PREC)));
}

/* bezstruct in source-rectangle transform to bezstruct in destination-rectangle */
pico copy1bez(x)
register pico x;
{
	register pico y;

	if (!isCell(car(x)))
		return copy1pt(x);
	push(y = newCell(copy1bez(car(x)), cdr(x)));
	while (isCell(x = cdr(x))) {
		setCdr(y, newCell(copy1bez(car(x)), cdr(x)));
		y = cdr(y);
	}
	return pop();
}

pico copy1pt(x)
pico x;
{
	Dxy p;

	unBoxBezPoint(x,&p);
	p.dx = drect[0].dx + xfaktor*(p.dx - srect[0].dx);
	p.dy = drect[0].dy + yfaktor*(p.dy - srect[0].dy);
	return boxBezPoint(&p);
}

pico copybez(x)
pico x;
{
	register pico bz;

	push(EVAL1(x));
	x = cdr(x);
	nextDPoint(&x,srect);			/* get source-rect */
	nextDPoint(&x,srect+1);
	nextDPoint(&x,drect);			/* get dest-rect */
	nextDPoint(&x,drect+1);
	bz = pop();
	xfaktor = (drect[1].dx - drect[0].dx) / (srect[1].dx - srect[0].dx);
	yfaktor = (drect[1].dy - drect[0].dy) / (srect[1].dy - srect[0].dy);
	return copy1bez(bz);
}

pico drawBez(bz,scale,draw)
register pico bz;
double scale;
bool draw;
{
	register pico x,y;
	pico z;
	Point pt, startPt;

	SetCursor(*GetCursor(watchCursor));
	y = car(bz);
	x = cdr(bz);
	if (isNum(car(y))) {
		needPoint(y);
		startPt.h = (int)(ROUND + unBox(car(y)) * scale / SCAL);
		startPt.v = (int)(ROUND + unBox(cdr(y)) * scale / SCAL);
		if (draw)
			MoveTo(startPt.h, startPt.v);
		else
			push(z = newCell(newCell(boxNum(startPt.h), boxNum(startPt.v)), nilSym));
	}
	else {
		startPt.h = (int)(ROUND + unBox(car(car(y))) * scale / SCAL);
		startPt.v = (int)(ROUND + unBox(cdr(car(y))) * scale / SCAL);
		if (draw)
			MoveTo(startPt.h, startPt.v);
		else
			push(z = newCell(newCell(boxNum(startPt.h), boxNum(startPt.v)), nilSym));
		plotArc(y, isCell(x)? car(x):car(bz), scale, draw, &z);
	}
	while (isCell(x)) {
		y = car(x);
		x = cdr(x);
		if (isNum(car(y))) {
			needPoint(y);
			pt.h = (int)(ROUND + unBox(car(y)) * scale / SCAL);
			pt.v = (int)(ROUND + unBox(cdr(y)) * scale / SCAL);
			if (draw)
				LineTo(pt.h, pt.v);
			else {
				setCdr(z, newCell(newCell(boxNum(pt.h), boxNum(pt.v)), nilSym));
				z = cdr(z);
			}
		}
		else
			plotArc(y, isCell(x)? car(x):car(bz), scale, draw, &z);
	}
	if (draw) {
		LineTo(startPt.h, startPt.v);
		return nilSym;
	}
	else {
		setCdr(z, newCell(newCell(boxNum(startPt.h), boxNum(startPt.v)), nilSym));
		return pop();
	}
}

pico DrawBez(x)
pico x;
{
	Dxy p,q,r,np;
	double scale;
	Dxy a,b,c;
    double t,dt;

	nextBezPoint(&x,&p);
	nextBezPoint(&x,&q);
	nextBezPoint(&x,&r);
	nextBezPoint(&x,&np);
	x = EVAL1(x);
	NEEDNUM(x);
	scale = (double)unBox(x);
	a.dx = -p.dx + 3 * q.dx - 3 * r.dx + np.dx;
	a.dy = -p.dy + 3 * q.dy - 3 * r.dy + np.dy;
	b.dx = 3 * p.dx - 6 * q.dx + 3 * r.dx;
	b.dy = 3 * p.dy - 6 * q.dy + 3 * r.dy;
	c.dx = -3 * p.dx + 3 * q.dx;
	c.dy = -3 * p.dy + 3 * q.dy;
	dt = 0.02;
	MoveTo((int)(scale * p.dx), (int)(scale * p.dy));
    for (t = dt; t <= 1.0+EPS; t += dt)
	    LineTo(
	    	(int)(ROUND + scale * (t * (t * (a.dx * t + b.dx) + c.dx) + p.dx)),
	    	(int)(ROUND + scale * (t * (t * (a.dy * t + b.dy) + c.dy) + p.dy)) );
	return tSym;
}

double nextDouble(p)
register pico *p;
{
	register pico x;

	x = EVAL1(*p);
	*p = cdr(*p);
	NEEDNUM(x);
	return ((double)unBox(x) / PREC);
}

void nextBezPoint(p,wfp)
register pico *p;
Dxy *wfp;
{
	register pico x;

	x = EVAL1(*p);
	*p = cdr(*p);
	needPoint(x);
	wfp->dx = ((double)unBox(car(x)) / SCAL);
	wfp->dy = ((double)unBox(cdr(x)) / SCAL);
}

void nextDPoint(p,wfp)
register pico *p;
Dxy *wfp;
{
	register pico x;

	x = EVAL1(*p);
	*p = cdr(*p);
	needPoint(x);
	wfp->dx = ((double)unBox(car(x)) / PREC);
	wfp->dy = ((double)unBox(cdr(x)) / PREC);
}

/* for border makes half-circle if no intersection point			*/
/* and no intersection of tangenten is found  parms are 3 points	*/
/* first p0 , 2. is r from first segment (for angle determing) 		*/
/* 3. is endpoint											 		*/
pico newarc(x)
pico x;
{
	Dxy p0,p1,p2,pc,r;
	double d;

	nextBezPoint(&x,&r);	/* Next point */
	nextBezPoint(&x,&p0);	/* Next point */
	nextBezPoint(&x,&p2);	/* Next point */
	
	pc.dx = (p0.dx + p2.dx) / 2.0;
	pc.dy = (p0.dy + p2.dy) / 2.0;
	p1.dx = p0.dx + (p0.dx - r.dx);
	p1.dy = p0.dy + (p0.dy - r.dy);
	
	push(nudel(pc,p0,p1,p2));
	return pop();
}


/* makes segment with dim=3  */
pico nudel(pc,p0,p1,p2)
Dxy  pc, p0, p1, p2;
{
	register pico x;
    register int k, np;
	double r1, th, dth, thw, gm;
    Dxy q,r;
	
	thw = winkel(pc,p0,p1,p2);
	th = arcTan(p0.dy - pc.dy, p0.dx - pc.dx);
	r1 = DIS(p0, pc);

	/* make curve */
	np = MAX((int)(ROUND + fabs(thw / PI4)), 2);
	dth = thw / np;
	gm = (4 * cos(dth / 2.0) - 2 * cos(dth) - 2.0)
			/ (1.5 * dth * sin(dth));

	push(x = newCell(boxBezPoint(&p0), nilSym));
	for (k = 0; k < np; k++) {
		if (k != 0) {
			p0.dx = r1 * cos(th) + pc.dx;
			p0.dy = r1 * sin(th) + pc.dy;
			setCdr(x, newCell(boxBezPoint(&p0), nilSym));
			x = cdr(x);
   		}
		q.dx = p0.dx - gm * r1 * dth * sin(th);
       	q.dy = p0.dy + gm * r1 * dth * cos(th);
		setCdr(x, newCell(boxBezPoint(&q), nilSym));
		x = cdr(x);
        r.dx = r1 * cos(th + dth) + pc.dx
   					+ gm * r1 * dth * sin(th + dth);
      	r.dy = r1 * sin(th + dth) + pc.dy
  					- gm * r1 * dth * cos(th + dth);
		setCdr(x, newCell(boxBezPoint(&r), nilSym));
		x = cdr(x);
       	th += dth;
	}
	return pop();	
} 

/* input three points: point point point(= 2 lines), search centre  */
bool pcentre(p0,p1,p2,cntr)
Dxy p0,p1,p2,*cntr;
{
	Dxy p[5];
	double a1,a2, nenner, z1x, z1y, z2x, z2y;

	p[0]= p0;    
	p[1]= p1;    
	p[2]= p2;    
    z1x = p[1].dy - p[0].dy;
    z1y = p[0].dx - p[1].dx;
    z2x = p[2].dy - p[1].dy;
    z2y = p[1].dx - p[2].dx;
    p[3].dx = (p[0].dx + p[1].dx)/2;
    p[3].dy = (p[0].dy + p[1].dy)/2;
    p[4].dx = (p[2].dx + p[1].dx)/2;
    p[4].dy = (p[2].dy + p[1].dy)/2;
	nenner = z1y * z2x - z1x * z2y;
	a1 = (p[0].dx-p[2].dx) / (p[3].dx - p[0].dx);
	a2 = (p[0].dy-p[2].dy) / (p[3].dy - p[0].dy);

	if ((nenner == 0) || (a1 == a2))
		return NO;

    if (z1x == 0){
	    a1 = ( (p[4].dy - p[3].dy + (z2y/z2x)*(p[3].dx-p[4].dx)) * z2x )/ nenner;
		cntr->dx = p[3].dx  + a1 * z1x;
		cntr->dy = p[3].dy  + a1 * z1y;
    }
    else {	
		a2 =( (p[4].dy - p[3].dy - (z1y/z1x)*(p[4].dx-p[3].dx)) * z1x )/nenner;
		cntr->dx = p[4].dx + a2 * z2x;
		cntr->dy = p[4].dy  + a2 * z2y;
	}
	return YES;
}

void plotArc(x,next,scale,draw,z)
register pico x,next;
double scale;
register bool draw;
register pico *z;
{
	Dxy p,q,r,np;
	Dxy a,b,c;
    double t,dt;
	Point pt;

	unBoxBezPoint(car(x),&np);
	x = cdr(x);
	while (isCell(x)) {
		p = np;
		unBoxBezPoint(car(x),&q);
		x = cdr(x);
		unBoxBezPoint(car(x),&r);
		x = cdr(x);
		if (isCell(x)) {
			unBoxBezPoint(car(x),&np);
			x = cdr(x);
		}
		else
			unBoxBezPoint(isNum(car(next))? next:car(next), &np);
		a.dx = -p.dx + 3 * q.dx - 3 * r.dx + np.dx;
		a.dy = -p.dy + 3 * q.dy - 3 * r.dy + np.dy;
		b.dx = 3 * p.dx - 6 * q.dx + 3 * r.dx;
		b.dy = 3 * p.dy - 6 * q.dy + 3 * r.dy;
		c.dx = -3 * p.dx + 3 * q.dx;
		c.dy = -3 * p.dy + 3 * q.dy;
#if 0
		dt = 1.0 / (int)(scale * (fabs(p.dx - np.dx) + fabs(p.dy - np.dy)));
#else
		dt = 0.04;
#endif
	    for (t = 0.0; t < 1.0 - EPS; t += dt) {
		    pt.h = (int)(ROUND + scale * (t * (t * (a.dx * t + b.dx) + c.dx) + p.dx));
		    pt.v = (int)(ROUND + scale * (t * (t * (a.dy * t + b.dy) + c.dy) + p.dy));
		    if (draw)
		    	LineTo(pt.h, pt.v);
		    else if (car(car(*z)) != boxNum(pt.h) || cdr(car(*z)) != boxNum(pt.v)) {
		    	setCdr(*z, newCell(newCell(boxNum(pt.h),boxNum(pt.v)), nilSym));
		    	*z = cdr(*z);
		    }
		}
	}
}

pico RndPt(x)
pico x;
{
	Dxy p0,p1,p2;
	double r;
	Dxy pc,p3,p4,temp;

	nextBezPoint(&x,&p0);
	nextBezPoint(&x,&p1);
	nextBezPoint(&x,&p2);
	r = nextDouble(&x);
	if (r == 0.0)
		return newCell(boxBezPoint(&p1),nilSym);
	rrr(p0,p1,p2,&p3,&p4,abs(r));
	p0.dx = p1.dx + 2*(p3.dx-p1.dx);
	p0.dy = p1.dy + 2*(p3.dy-p1.dy);
	p2.dx = p1.dx + 2*(p4.dx-p1.dx);
	p2.dy = p1.dy + 2*(p4.dy-p1.dy);
	if (!pcentre(p0,p1,p2,&pc))
		return newCell(boxBezPoint(&p1),nilSym);
	if (r < 0.0)
		temp = pc,  pc = p1,  p1 = temp;
	push(newCell(boxBezPoint(&p4), nilSym));
	x = nudel(pc,p3,p1,p4);
	return newCell(x,pop());
}

pico Rotz(p)
pico p;
{
	Dxy pc, p1,x,w;
	double wh;
    register double i;
    register double r;
    double a11,a12,a21,a22;
    
	nextBezPoint(&p,&p1);			/* Point to rotate */
	nextDPoint(&p,&pc);				/* Center of rotation */
	wh = nextDouble(&p) * PI /180.0;	/* Angle */
	
    if (pc.dx==p1.dx && pc.dy==p1.dy)
    	return boxBezPoint(&pc);
	
    a11 =  cos(wh);						/* set rotation matrix */
    a12 = -sin(wh);
    a21 =  sin(wh);
    a22 =  cos(wh);
    
	w.dx = p1.dx - pc.dx;
	w.dy = p1.dy - pc.dy;
	x.dx = a11 * w.dx + a12 * w.dy + pc.dx;
	x.dy = a21 * w.dx + a22 * w.dy + pc.dy;
	
    return boxBezPoint(&x);
}

/* from points p0, p1, p2 of polygon and radius r (rounded corner)
	determines center pc and starting points of curve-segment
	at p3 laying on line p0,p1 and endpoint p4 laying on p1,p2	*/
void rrr(p0,p1,p2,p3,p4,r)
Dxy p1, p2, p0, *p3, *p4;
double r;
{
	Dxy p[6];
	double a1,a2, z1x, z1y, z2x, z2y;
	Dxy v1,v2;
	
	p[0]=p0;
	p[1]=p1;
	p[2]=p2;
	if (DIS(p0,p1)-2.0  <  r)
		r = DIS(p0,p1)-2.0;
	if (DIS(p1,p2)-2.0  <  r)
		r = DIS(p1,p2)-2.0;
    z1x = p[0].dx - p[1].dx;
    z1y = p[0].dy - p[1].dy;
    z2x = p[2].dx - p[1].dx;
    z2y = p[2].dy - p[1].dy;
    a1 = 1.0 / (sqrt (z1x*z1x + z1y*z1y));
    a2 = 1.0 / (sqrt (z2x*z2x + z2y*z2y));
    v1.dx = r * a1 * z1x;
    v1.dy = r * a1 * z1y;
    v2.dx = r * a2 * z2x;
    v2.dy = r * a2 * z2y;
    p[3].dx = p[1].dx + 2*v1.dx;
    p[3].dy = p[1].dy + 2*v1.dy;
    p[4].dx = p[1].dx + 2*v2.dx;
    p[4].dy = p[1].dy + 2*v2.dy;
    p3->dx = p[1].dx + v1.dx;
    p3->dy = p[1].dy + v1.dy;
    p4->dx = p[1].dx + v2.dx;
    p4->dy = p[1].dy + v2.dy;
}

#if 0
pico toBezPoint(x)
register pico x;
{
	needPoint(x);
	return newCell(
			boxNum((SCAL / PREC) * unBox(car(x))),
			boxNum((SCAL / PREC) * unBox(cdr(x))) );
}
#endif

void unBoxBezPoint(x,p)
register pico x;
register Dxy *p;
{
	needPoint(x);
	p->dx = ((double)unBox(car(x)) / SCAL);
	p->dy = ((double)unBox(cdr(x)) / SCAL);
}

void unBoxDPoint(x,p)
register pico x;
register Dxy *p;
{
	needPoint(x);
	p->dx = ((double)unBox(car(x)) / PREC);
	p->dy = ((double)unBox(cdr(x)) / PREC);
}

/* extract angle from centrepoint c and two circle points p0 and p1 */
double winkel(pc,p0,p1,p2)
Dxy pc, p0, p2, p1;
{
	double w1, w2, w0, arc;
	
    w0 = arcTan(p0.dx-pc.dx, pc.dy-p0.dy);
    w2 = arcTan(p2.dx-pc.dx, pc.dy-p2.dy);
    w1 = arcTan(p1.dx-pc.dx, pc.dy-p1.dy);
    w1 = w1 >= 0.0? w1 : (2*PI) + w1;
    w2 = w2 >= 0.0? w2 : (2*PI) + w2;
    w0 = w0 >= 0.0? w0 : (2*PI) + w0;
    if (w2 > w0) {
    	if ( (w1>w2 && w1<=(2*PI)) || (w1<w0 && w1>=0.0) )
    		return -(2*PI) + w2 - w0;
	}
	else if ( (w1>w0 && w1<=(2*PI)) || (w1<w2 && w1>=0.0) )
    	return (2*PI) - w0 + w2;
    return w2 - w0;
}

/************************/
void initGerd()
{
	initSymTab(gerdSyms);
	initSymTab(borderSyms);
}

void stopGerd()
{
}
