/* isarPrim.c
 * 27nov89abu
 */

#include "HD:picoSources:pico.h"
#include "HD:picoSources:stack.h"
#include "HD:picoSources:mac.h"

#define RTDYNAMO	NO

#define TFHEAD		4						/* 4 bytes TileFileHeader: h v */
#define TILE		32						/* Tile: 32*32 pixels */
#define NTILES		20						/* 20*20 tiles per retouch window */
#define WINSIZE		((long)(TILE*NTILES))	/* 640*640 pixel per retouch window */
#define TILEBUFF	(4*TILE*TILE)			/* Size of one tile */
#define MAXBLOT		16

#define inCmyk(x)		(0<=x && x<640)
#define blend(x,y,w)	((x*w + y*(255-w))/255)

typedef struct {
	bool isLine;
	long h1,v1,h2,v2;
	int color[4];
	double dist, weight;
} grad;

/* Prototypes */
static unsigned long dMean(number,number,number);
static void nearLinePt(long,long,long,long,long,long,long*,long*);
static void nearCircPt(long,long,long,long,long,long*,long*);
static bool sected(long,long,long,long,grad*,int,int);
static unsigned char gradate(grad*,int,int,double);
static pico Gradat(pico);
static pico MeanColor(pico);
static pico colEdge1(pico);
static pico colEdge2(pico);
static pico PixPtr(pico);
static pico PxCopy(pico);
static pico PxSave(pico);
static pico PxUndo(pico);
static pico ColSet(pico);
static pico ChgCol(pico);
static unsigned char pxLo(unsigned char*);
static pico PixLo(pico);
static pico WixLo(pico);
static pico PixHi(pico);
static pico PxHand(pico);
static pico HandPx(pico);
static pico ClTile(pico);
static pico RdTile(pico);
static pico WrTile(pico);
static pico MvTile(pico);
#if 0
static pico rtLeft(pico);
static pico rtRght(pico);
static pico rtUp(pico);
static pico rtDown(pico);
#endif

static unsigned char colorTables[4][256];
static unsigned long meanCnt,mean[4];

symInit isarSyms[] = {
	{"GRADAT",		Gradat},
	{"MEANCOLOR",	MeanColor},
	{"COLEDGE1",	colEdge1},
	{"COLEDGE2",	colEdge2},
	{"PIXPTR",		PixPtr},
	{"PXCOPY",		PxCopy},
	{"PXSAVE",		PxSave},
	{"PXUNDO",		PxUndo},
	{"COLSET",		ColSet},
	{"CHGCOL",		ChgCol},
	{"PIXLO",		PixLo},
	{"WIXLO",		WixLo},
	{"PIXHI",		PixHi},
	{"PXHAND",		PxHand},
	{"HANDPX",		HandPx},
	{"CLTILE",		ClTile},
	{"RDTILE",		RdTile},
	{"WRTILE",		WrTile},
	{"MVTILE",		MvTile},
#if 0
	{"RTLEFT",		rtLeft},
	{"RTRGHT",		rtRght},
	{"RTUP",		rtUp},
	{"RTDOWN",		rtDown},
#endif
	NULL
};


void nearLinePt(h,v,h1,v1,h2,v2,ph,pv)
register long h,v,h1,v1,h2,v2;
register long *ph,*pv;
{
	register double a,b,c,n;

	c = (double)((h2-h1)*(h2-h1) + (v2-v1)*(v2-v1));
	if (c == 0.0)
		*ph = h1,  *pv = v1;
	else {
		a = (double)((h1-h)*(h1-h) + (v1-v)*(v1-v));
		b = (double)((h2-h)*(h2-h) + (v2-v)*(v2-v));
		n = (a - b + c) / (2*c);
		if (n <= 0.0)
			*ph = h1,  *pv = v1;
		else if (n >= 1.0)
			*ph = h2,  *pv = v2;
		else {
			*ph = h1 + (integer)(n*(h2-h1));
			*pv = v1 + (integer)(n*(v2-v1));
		}
	}
}

void nearCircPt(h,v,ch,cv,r,ph,pv)
register long h,v,ch,cv,r;
register long *ph,*pv;
{
	register double d;

	if ((d = distPt(h,v,ch,cv)) == 0.0) {
		*ph = h + r;
		*pv = v;
	}
	else {
		*ph = ch + (long)((double)(h - ch) / d * r);
		*pv = cv + (long)((double)(v - cv) / d * r);
	}
}

bool sected(h1,v1,h2,v2,p,n,self)
register long h1,v1,h2,v2;
register grad *p;
register int n,self;
{
	long dy,nenn,ph,pv;
	double m;

	p += n;
	while (--n >= 0) {
		--p;
		if (n == self)
			continue;
		if (p->isLine) {
			dy = p->v2 - p->v1;
			if ((nenn = (h2 - h1) * dy - (p->h2 - p->h1) * (v2 - v1)) == 0)
				continue;
			m = (double)(dy * (p->h1 - h1) + (p->h2 - p->h1) * (v1 - p->v1));
			m /= (double)nenn;
			if (0.0 <= m  &&  m <= 1.0) {
				if (dy == 0)
					continue;
				m = ((double)(v1 - p->v1) + m * (double)(v2 - v1)) / (double)dy;
				if (0.0 <= m  &&  m <= 1.0)
					return YES;
			}
		}
		else {
			nearLinePt(p->h2,p->v2,h1,v1,h2,v2,&ph,&pv);
			if ((long)distPt(p->h2,p->v2,ph,pv) <= p->h1 &&
					((long)distPt(p->h2,p->v2,h1,v1) > p->h1 ||
						(long)distPt(p->h2,p->v2,h2,v2) > p->h1 ) )
				return YES;
		}
	}
	return NO;
}

/* Generate Gradation */
unsigned char gradate(p,n,col,w)
register grad *p;
register int n,col;
register double w;
{
	register unsigned char c;

	c = 0;
	while (--n >= 0) {
		if (p->dist >= 0.0)
			c += (unsigned char)(minNumber(100, p->color[col] + p->color[3]) * p->weight / w);
		++p;
	}
	return c;
}

pico Gradat(x)
pico x;
{
	register pico y,z;
	register grad **g;
	unsigned char **base, *p;
	register long i,j,k,n,h,v;
	long ph,pv;
	double d,dSum,wSum;

	/* SetCursor(*GetCursor(watchCursor)); */
	push(EVAL1(x)); /* Progress function */
	x = cdr(x);
	base = (unsigned char**)nextDynamo(&x);
	h = nextNum(&x);
	v = nextNum(&x);
	x = EVAL1(x);
	g = (grad**)NewHandle(0);
	n = 0;
	while (isCell(x)) {				/* Read grad list into handle */
		y = car(x);
		SetHandleSize((Handle)g, GetHandleSize((Handle)g) + sizeof(grad));
		if (isCell(car(z = car(y)))) {
			(*g)[n].isLine = YES;
			(*g)[n].h1 = unBox(car(car(z)));
			(*g)[n].v1 = unBox(cdr(car(z)));
		}
		else {
			(*g)[n].isLine = NO;
			(*g)[n].h1 = unBox(car(z));	/* Circle's radius */
		}
		(*g)[n].h2 = unBox(car(cdr(z)));
		(*g)[n].v2 = unBox(cdr(cdr(z)));
		y = cdr(y),  (*g)[n].color[0] = unBox(car(y)); /* Yellow */
		y = cdr(y),  (*g)[n].color[1] = unBox(car(y)); /* Magenta */
		y = cdr(y),  (*g)[n].color[2] = unBox(car(y)); /* Cyan */
		y = cdr(y),  (*g)[n].color[3] = unBox(car(y)); /* Key */
		++n;
		x = cdr(x);
	}
	apply2(tos,boxNum(v),unBufCString("Calculating Gradation"));
	for (i = 0; i < v; ++i) {
		for (j = 0; j < h; ++j) {
			dSum = 0.0;
			for (k = 0; k < n; ++k) {
				if ((*g)[k].isLine)
					nearLinePt(j, i, (*g)[k].h1, (*g)[k].v1, (*g)[k].h2, (*g)[k].v2, &ph, &pv);
				else
					nearCircPt(j, i, (*g)[k].h2, (*g)[k].v2, (*g)[k].h1, &ph, &pv);
				if (sected(j,i,ph,pv,*g,n,k))
					(*g)[k].dist = -1;
				else
					dSum += (*g)[k].dist = distPt(j,i,ph,pv);
			}
			wSum = 0.0;
			for (k = 0; k < n; ++k)
				if ((d = (*g)[k].dist) >= 0.0)
					wSum  +=  (*g)[k].weight  =  (d == 0.0)? 1e9 : dSum/d;
			wSum = wSum * 100.0/255.0;
			p = *base + i*h + j;
			*p = gradate(*g,n,2,wSum);				/* Cyan */
			*(p + h*v) = gradate(*g,n,1,wSum);		/* Magenta */
			*(p + 2*h*v) = gradate(*g,n,0,wSum);	/* Yellow */
		}
		if (isNil(apply1(tos,nilSym))) {
			DisposHandle((Handle)g);
			drop();
			return nilSym;
		}
	}
	DisposHandle((Handle)g);
	drop();
	return tSym;
}

pico MeanColor(x)
pico x;
{
	register pico y;
	register unsigned char *p;
	register number h1,h2;

	y = EVAL1(x);
	x = cdr(x);
	if (isNil(y)) {
		meanCnt = 0;
		mean[0] =  mean[1] =  mean[2] =  mean[3] = 0;
	}
	else if (y == tSym) {
		mean[0] /= meanCnt;
		mean[1] /= meanCnt;
		mean[2] /= meanCnt;
		mean[3] /= meanCnt;
		return newCell(boxNum(mean[0]),
					newCell(boxNum(mean[1]),
						newCell(boxNum(mean[2]),
							newCell(boxNum(mean[3]), nilSym) ) ) );
	}
	else {
		p = *(unsigned char **)unBox(y);
		p += nextNum(&x) * WINSIZE;
		h1 = nextNum(&x);
		p += h1;
		h2 = nextNum(&x);
		meanCnt += h2 - h1;
		while (h1++ < h2) {
			mean[0] += *p;
			mean[1] += *(p + WINSIZE*WINSIZE);
			mean[2] += *(p + 2*WINSIZE*WINSIZE);
			mean[3] += *(p + 3*WINSIZE*WINSIZE);
			++p;
		}
	}
	return tSym;
}

/* Return measure for the color gradient */
pico colEdge1(x)
pico x;
{
	register unsigned char *p,*q;
	integer h1,v1,h2,v2;
	register bool xchg;
	register number  w,sh,sv,i,e,dh,dv,j,temp;

#if RTDYNAMO
	p = *(unsigned char**)nextDynamo(&x); /* base */
#else
	p = *(unsigned char**)nextNum(&x); /* base */
#endif
	h1 = (integer)nextNum(&x);
	v1 = (integer)nextNum(&x);
	h2 = (integer)nextNum(&x);
	v2 = (integer)nextNum(&x);
	dh = h2 - h1;
	dv = v2 - v1;
	sh = 0;
	if (dh > 0)
		sh = 1;
	else if (dh < 0) {
		dh = -dh;
		sh = -1;
	}
	sv = 0;
	if (dv > 0)
		sv = WINSIZE;
	else if (dv < 0) {
		dv = -dv;
		sv = -WINSIZE;
	}
	xchg = NO;
	if (dv > dh) {
		xchg = YES;
		temp = dh,  dh = dv,  dv = temp;
	}
	e = 2*dv - dh;
	w = 0;
	for (j = 0; j < 4; ++j) {
		q  =  p + h1 + v1 * WINSIZE;
		for (i = 0; i < dh; ++i) {
			if (xchg)
				w += abs(q[-3] + 2*q[-2] + 3*q[-1] - 3*q[0] - 2*q[1] - q[2]);
			else
				w += abs(q[-3*WINSIZE] + 2*q[-2*WINSIZE] + 3*q[-WINSIZE]
										- 3*q[0] - 2*q[WINSIZE] - q[2*WINSIZE]);
			if (e >= 0) {
				q += xchg? sh:sv;
				e -= 2*dh;
			}
			q += xchg? sv:sh;
			e += 2*dv;
		}
		p += WINSIZE*WINSIZE;
	}
	return  dh?  boxNum(w/dh) : boxNum(0);
}

unsigned long dMean(c,m,y)
register number c,m,y;
{
	c -= mean[0];
	m -= mean[1];
	y -= mean[2];
	return (unsigned long)sqrt((double)(c*c + m*m + y*y));
}

pico colEdge2(x)
pico x;
{
	register unsigned char *p;
	integer h1,v1,h2,v2;
	register bool xchg;
	register number  w,e,sh,sv,i,dh,dv,temp;

#if RTDYNAMO
	p = *(unsigned char**)nextDynamo(&x); /* base */
#else
	p = *(unsigned char**)nextNum(&x); /* base */
#endif
	h1 = (integer)nextNum(&x);
	v1 = (integer)nextNum(&x);
	h2 = (integer)nextNum(&x);
	v2 = (integer)nextNum(&x);
	dh = h2 - h1;
	dv = v2 - v1;
	sh = 0;
	if (dh > 0)
		sh = 1;
	else if (dh < 0) {
		dh = -dh;
		sh = -1;
	}
	sv = 0;
	if (dv > 0)
		sv = WINSIZE;
	else if (dv < 0) {
		dv = -dv;
		sv = -WINSIZE;
	}
	xchg = NO;
	if (dv > dh) {
		xchg = YES;
		temp = dh,  dh = dv,  dv = temp;
	}
	e = 2*dv - dh;
	p += h1 + v1 * WINSIZE;
	w = 0;
	for (i = 0; i < dh; ++i) {
		if (xchg) {
			if (sv > 0)
#if 1
				w += 2*dMean(p[0], p[WINSIZE*WINSIZE], p[2*WINSIZE*WINSIZE])
					+ dMean(p[1], p[WINSIZE*WINSIZE+1], p[2*WINSIZE*WINSIZE+1])
					- 2*dMean(p[-1], p[WINSIZE*WINSIZE-1], p[2*WINSIZE*WINSIZE-1])
					- dMean(p[-2], p[WINSIZE*WINSIZE-2], p[2*WINSIZE*WINSIZE-2]);
#else
				{
					number n1,n2,n3,n4;
					n1 = 2*dMean(p[0], p[WINSIZE*WINSIZE], p[2*WINSIZE*WINSIZE]);
					n2 = dMean(p[1], p[WINSIZE*WINSIZE+1], p[2*WINSIZE*WINSIZE+1]);
					n3 = 2*dMean(p[-1], p[WINSIZE*WINSIZE-1], p[2*WINSIZE*WINSIZE-1]);
					n4 = dMean(p[-2], p[WINSIZE*WINSIZE-2], p[2*WINSIZE*WINSIZE-2]);
					prNumber(n1), space();
					prNumber(n2), space();
					prNumber(n3), space();
					prNumber(n4), crlf();
					w += n1 + n2 - n3 - n4;
				}
#endif
			else
				w += 2*dMean(p[-1], p[WINSIZE*WINSIZE-1], p[2*WINSIZE*WINSIZE-1])
					+ dMean(p[-2], p[WINSIZE*WINSIZE-2], p[2*WINSIZE*WINSIZE-2])
					- 2*dMean(p[0], p[WINSIZE*WINSIZE], p[2*WINSIZE*WINSIZE])
					- dMean(p[1], p[WINSIZE*WINSIZE+1], p[2*WINSIZE*WINSIZE+1]);
		}
		else {
			if (sh > 0)
				w += 2*dMean(p[-WINSIZE], p[WINSIZE*WINSIZE-WINSIZE], p[2*WINSIZE*WINSIZE-WINSIZE])
					+ dMean(p[-2*WINSIZE], p[WINSIZE*WINSIZE-2*WINSIZE], p[2*WINSIZE*WINSIZE-2*WINSIZE])
					- 2*dMean(p[0], p[WINSIZE*WINSIZE], p[2*WINSIZE*WINSIZE])
					- dMean(p[WINSIZE], p[WINSIZE*WINSIZE+WINSIZE], p[2*WINSIZE*WINSIZE+WINSIZE]);
			else
				w += 2*dMean(p[0], p[WINSIZE*WINSIZE], p[2*WINSIZE*WINSIZE])
					+ dMean(p[WINSIZE], p[WINSIZE*WINSIZE+WINSIZE], p[2*WINSIZE*WINSIZE+WINSIZE])
					- 2*dMean(p[-WINSIZE], p[WINSIZE*WINSIZE-WINSIZE], p[2*WINSIZE*WINSIZE-WINSIZE])
					- dMean(p[-2*WINSIZE], p[WINSIZE*WINSIZE-2*WINSIZE], p[2*WINSIZE*WINSIZE-2*WINSIZE]);
		}
		if (e >= 0) {
			p += xchg? sh:sv;
			e -= 2*dh;
		}
		p += xchg? sv:sh;
		e += 2*dv;
	}
	return  dh?  boxNum(w/dh) : boxNum(0);
}

/* Set C, M, Y, and K pointers to pixel */
pico PixPtr(x)
pico x;
{
	register char *p;
	pico c,m,y,k;
	long h,v;

	c = nextVar(&x);
	m = nextVar(&x);
	y = nextVar(&x);
	k = nextVar(&x);
#if RTDYNAMO
	p = *(Handle)nextDynamo(&x);
#else
	p = *(Handle)nextNum(&x);
#endif
	h = v = 0;
	if (isCell(x)) {
		if ((h = nextNum(&x)) < 0 || h >= WINSIZE)
			return nilSym;
		p += h;
	}
	if (isCell(x)) {
		if ((v = nextNum(&x)) < 0 || v >= WINSIZE)
			return nilSym;
		p += v * WINSIZE;
	}
	setVal(c, boxNum(p));
	setVal(m, boxNum(p + WINSIZE*WINSIZE));
	setVal(y, boxNum(p + 2*WINSIZE*WINSIZE));
	setVal(k, boxNum(p + 3*WINSIZE*WINSIZE));
	return tSym;
}

/* Copy one blot */
pico PxCopy(x)
pico x;
{
	register pico l;
	register unsigned char *p, *q;
	register number i,j,lines,w,size;
	pico blot;
	unsigned char *base;
	number h1,v1,h2,v2,srcH,srcV,dstH,dstV;
	integer cnt[2*MAXBLOT];
	unsigned char weight[2*MAXBLOT][2*MAXBLOT];
	unsigned char *ptr[2*MAXBLOT];
	number h[2*MAXBLOT];
	number v[2*MAXBLOT];
	number hinc, vinc;

#if RTDYNAMO
	base = *(unsigned char **)nextDynamo(&x);
#else
	base = *(unsigned char **)nextNum(&x);
#endif
	srcH = nextNum(&x);
	srcV = nextNum(&x);
	dstH = nextNum(&x);
	dstV = nextNum(&x);
	blot = EVAL1(x);
	
	size = i = 0;
	while (isCell(blot)) {
		l = car(blot),  blot = cdr(blot);
		h[i] = unBox(car(l)),  l = cdr(l);
		v[i] = unBox(car(l)),  l = cdr(l);
		for (cnt[i] = 0, p = weight[i]; isCell(l); l = cdr(l)) {
			++cnt[i];
			*p++ = (unsigned char)unBox(car(l));
			++size;
		}
		ptr[i] = p-1;
		++i;
	}
	lines = i;

	if (dstH > srcH)
		hinc = -1;
	else {
		hinc = 1;
		for (j = 0; j < lines; ++j)
			ptr[j] = weight[j];
	}
	if (dstV > srcV) {
		vinc = -1;
		i = lines-1;
	}
	else {
		vinc = 1;
		i = 0;
	}

	while (--lines >= 0) {
		h1 = srcH + h[i];
		v1 = srcV + v[i];
		h2 = dstH + h[i];
		v2 = dstV + v[i];
		if (inCmyk(v1) && inCmyk(v2)) {
			j = cnt[i];
			p = base + h1 + v1*WINSIZE;
			q = base + h2 + v2*WINSIZE;
			if (hinc < 0) {
				p += j-1, q += j-1;
				h1 += j-1, h2 += j-1;
			}
			while (--j >= 0) {
				if (inCmyk(h1) && inCmyk(h2)) {
					w = *ptr[i];
					*q = blend(*p,*q,w);
					*(q + WINSIZE*WINSIZE) =
						blend(*(p + WINSIZE*WINSIZE),*(q + WINSIZE*WINSIZE),w);
					*(q + 2*WINSIZE*WINSIZE) =
						blend(*(p + 2*WINSIZE*WINSIZE),*(q + 2*WINSIZE*WINSIZE),w);
					*(q + 3*WINSIZE*WINSIZE) =
						blend(*(p + 3*WINSIZE*WINSIZE),*(q + 3*WINSIZE*WINSIZE),w);
				}
				p += hinc, q += hinc;
				h1 += hinc, h2 += hinc; /* For region check */
				ptr[i] += hinc;
			}
		}
		i += vinc;
	}
	return tSym;
}

/* Backup one blot */
pico PxSave(x)
pico x;
{
	register pico l;
	register unsigned char *p, *q;
	register number i,j,lines,size;
	pico blot;
	unsigned char *base;
	number dstH,dstV;
	integer cnt[2*MAXBLOT];
	number h[2*MAXBLOT];
	number v[2*MAXBLOT];
	Handle hndl;

#if RTDYNAMO
	base = *(unsigned char **)nextDynamo(&x);
#else
	base = *(unsigned char **)nextNum(&x);
#endif
	dstH = nextNum(&x);
	dstV = nextNum(&x);
	blot = EVAL1(x);
	
	size = i = 0;
	while (isCell(blot)) {
		l = car(blot),  blot = cdr(blot);
		h[i] = unBox(car(l)),  l = cdr(l);
		v[i] = unBox(car(l)),  l = cdr(l);
		for (cnt[i] = 0; isCell(l); l = cdr(l)) {
			++cnt[i];
			++size;
		}
		++i;
	}
	lines = i;
	hndl = NewHandle(4*size);
	if (MemError())
		return nilSym;
	q = *(unsigned char **)hndl;
	for (i = 0; i < lines; ++i) {
		p = base + dstH + h[i] + (dstV + v[i])*WINSIZE;
		for (j = 0; j < cnt[i]; ++j) {
			*q++ = *(p + j);
			*q++ = *(p + j + WINSIZE*WINSIZE);
			*q++ = *(p + j + 2*WINSIZE*WINSIZE);
			*q++ = *(p + j + 3*WINSIZE*WINSIZE);
		}
	}
	return dynHandle(hndl);
}

/* Restore blot from backup */
pico PxUndo(x)
pico x;
{
	register unsigned char *p, *q;
	register pico l, blot;
	register number h1, v1, h2, v2;
	unsigned char *base;

#if RTDYNAMO
	base = *(unsigned char **)nextDynamo(&x);
#else
	base = *(unsigned char **)nextNum(&x);
#endif
	h1 = nextNum(&x);
	v1 = nextNum(&x);
	p = (unsigned char *)nextDynamo(&x); /* First keep the Handle */
	blot = EVAL1(x);
	p = *(unsigned char **)p; /* Then deref it */
	while (isCell(blot)) {
		l = car(blot),  blot = cdr(blot);
		h2 = h1 + unBox(car(l)), l = cdr(l);
		v2 = v1 + unBox(car(l)), l = cdr(l);
		if (inCmyk(v2)) {
			while (isCell(l)) {
				if (inCmyk(h2)) {
					q = base + h2 + v2*WINSIZE;
					*q = *p++;
					*(q + WINSIZE*WINSIZE) = *p++;
					*(q + 2*WINSIZE*WINSIZE) = *p++;
					*(q + 3*WINSIZE*WINSIZE) = *p++;
				}
				++h2;
				l = cdr(l);
			}
		}
	}
	return tSym;
}

/* Set the color tables */
pico ColSet(x)
register pico x;
{
	register pico y;
	register int i,j;

	y = EVAL1(x);
	if (!isCell(y))
		return nilSym;
	for (i = 0; i < 4; ++i) {
		x = car(y);
		for (j = 0; j < 256; ++j) {
			NEEDNUM(car(x));
			colorTables[i][j] = (unsigned char)unBox(car(x));
			x = cdr(x);
		}
		y = cdr(y);
	}
	return boxNum(colorTables);
}

pico ChgCol(x)
pico x;
{
	register unsigned char *p;
	register number i, j, len;

	if ((len = nextNum(&x)) <= 0)
		return nilSym;
	i = 0; do {
		p = (unsigned char*)nextNum(&x);
		for (j = 0; j < len; ++j) {
			*p = colorTables[i][*p];
			++p;
		}
	} while (++i < 4);
	return tSym;
}

unsigned char pxLo(p)
register unsigned char *p;
{
	register number n;

	n = ((*p * 10 + *(p-1) + *(p+1) + *(p-WINSIZE) + *(p+WINSIZE)) * 2
			+ *(p-WINSIZE-1) + *(p-WINSIZE+1) + *(p+WINSIZE-1) + *(p+WINSIZE+1)) / 32;
	return  n > 255? 255:n;
}

pico PixLo(x)
pico x;
{
	register unsigned char *p, *q;
	register Handle h;
	register number i, j, len;
	long size;

	h = (Handle)nextNum(&x);
	if ((len = nextNum(&x)) <= 0)
		return nilSym;
	size = GetHandleSize(h);
	SetHandleSize(h, 4*len + size);
	HLock(h);
	q = (unsigned char*)(*h) + size;
	j = 4; do {
		p = (unsigned char*)nextNum(&x);
		i = len; do
			*q++ = pxLo(p++);
		while (--i);
	} while (--j);
	HUnlock(h);
	return tSym;
}

pico WixLo(x)
pico x;
{
	register unsigned char *p, *q;
	register pico y,z;
	Handle h;
	register number i,w;
	long size;

	h = (Handle)nextNum(&x);
	z = EVAL1(x);
	x = cdr(x);
	w = nextNum(&x);
	size = GetHandleSize(h);
	SetHandleSize(h, 4*length(z) + size);
	HLock(h);
	q = (unsigned char*)(*h) + size;
	i = 4; do {
		p = (unsigned char*)nextNum(&x);
		y = z; do {
			if (unBox(car(y)) >= w)
				*q++ = pxLo(p++);
			else
				*q++ = *p++;
		} while (isCell(y = cdr(y)));
	} while (--i);
	HUnlock(h);
	return tSym;
}

pico PixHi(x)
pico x;
{
	register unsigned char *p, *q;
	register Handle h;
	register number n, i, j, len;
	long size;

	h = (Handle)nextNum(&x);
	if ((len = nextNum(&x)) <= 0)
		return nilSym;
	size = GetHandleSize(h);
	SetHandleSize(h, 4*len + size);
	HLock(h);
	q = (unsigned char*)(*h) + size;
	j = 4; do {
		p = (unsigned char*)nextNum(&x);
		i = len; do {
			n = (((long)*p * (-22) + (long)*(p-1) + (long)*(p+1)
								+ (long)*(p-WINSIZE) + (long)*(p+WINSIZE) ) * 2
					+ (long)*(p-WINSIZE-1) + (long)*(p-WINSIZE+1)
								+ (long)*(p+WINSIZE-1) + (long)*(p+WINSIZE+1) ) / -32;
			if (n < 0)
				n = 0;
			else if (n > 255)
				n = 255;
			*q = n;
			++p;
			++q;
		} while (--i);
	} while (--j);
	HUnlock(h);
	return tSym;
}

pico PxHand(x)
pico x;
{
	register Handle h;
	register number i, len;

	h = (Handle)nextNum(&x);
	if ((len = nextNum(&x)) <= 0)
		return nilSym;
	i = 4; do
		PtrAndHand((char*)nextNum(&x), h, len);
	while (--i);
	return tSym;
}

pico HandPx(x)
pico x;
{
	register Handle h;
	register number i, len;
	static long ix;

	if (!isCell(x))
		ix = 0;
	else {
		h = (Handle)nextNum(&x);
		if ((len = nextNum(&x)) <= 0)
			return nilSym;
		HLock(h);
		i = 0; do
			BlockMove(*h + ix + i*len, (char*)nextNum(&x), len);
		while (++i < 4);
		HUnlock(h);
		ix += 4*len;
	}
	return tSym;
}

/* Clear tile */
pico ClTile(x)
pico x;
{
	register long *p;
	register int i,j;
	long h,v;

#if RTDYNAMO
	p = *(long**)nextDynamo(&x);
#else
	p = *(long**)nextNum(&x);
#endif
	h = (int)nextNum(&x);
	v = (int)nextNum(&x);
	p = (long*)((char*)p + (v*WINSIZE + h)*TILE);
	i = 4; do {
		j = TILE; do {
			p[0] = 0;
			p[1] = 0;
			p[2] = 0;
			p[3] = 0;
			p[4] = 0;
			p[5] = 0;
			p[6] = 0;
			p[7] = 0;
			p += WINSIZE/sizeof(long);
		} while (--j);
		p += (WINSIZE*WINSIZE - WINSIZE*TILE)/sizeof(long);
	} while (--i);
	return tSym;
}

/* Read tile */
pico RdTile(x)
pico x;
{
	register long *p, *q;
	register int i, j;
	long tile, h, v, tiles;
	file *f;
	long count;
	char tileBuff[TILEBUFF];
	char *buf;

	if (!(tiles = nextNum(&x)))
		return tSym;
	f = (file*)nextNum(&x);
	tile = nextNum(&x);
#if RTDYNAMO
	p = *(long**)nextDynamo(&x);
#else
	p = *(long**)nextNum(&x);
#endif
	h = nextNum(&x);
	v = nextNum(&x);
	count = tiles*TILEBUFF;
	if (tiles == 1)
		buf = tileBuff;
	else if (!(buf = NewPtr(count)))
		return nilSym;
	if (SetFPos(f->fd, fsFromStart, tile*TILEBUFF + TFHEAD) || FSRead(f->fd, &count, buf))
		return nilSym;
	p = (long*)((char*)p + (v*WINSIZE + h)*TILE);
	q = (long*)buf;
	do {
		i = 4; do {
			j = TILE; do {
				p[0] = q[0];
				p[1] = q[1];
				p[2] = q[2];
				p[3] = q[3];
				p[4] = q[4];
				p[5] = q[5];
				p[6] = q[6];
				p[7] = q[7];
				p += WINSIZE/sizeof(long);
				q += 8;
			} while (--j);
			p += (WINSIZE*WINSIZE - WINSIZE*TILE)/sizeof(long);
		} while (--i);
		p -= (4*WINSIZE*WINSIZE - TILE)/sizeof(long);
	} while (--tiles);
	if (buf != tileBuff)
		DisposPtr(buf);
	return tSym;
}

/* Write tile */
pico WrTile(x)
pico x;
{
	return nilSym;
}

/* Move tile */
pico MvTile(x)
pico x;
{
	register long *p, *q;
	register int i,j;
	long h,v,dh,dv;

#if RTDYNAMO
	p = *(long**)nextDynamo(&x);
#else
	p = *(long**)nextNum(&x);
#endif
	h = (int)nextNum(&x);
	v = (int)nextNum(&x);
	dh = (int)nextNum(&x);
	dv = (int)nextNum(&x);
	p = (long*)((char*)p + (v*WINSIZE + h)*TILE);
	q = (long*)((char*)p + (dv*WINSIZE + dh)*TILE);
	i = 4; do {
		j = TILE; do {
			q[0] = p[0];
			q[1] = p[1];
			q[2] = p[2];
			q[3] = p[3];
			q[4] = p[4];
			q[5] = p[5];
			q[6] = p[6];
			q[7] = p[7];
			p += WINSIZE/sizeof(long);
			q += WINSIZE/sizeof(long);
		} while (--j);
		p += (WINSIZE*WINSIZE - WINSIZE*TILE)/sizeof(long);
		q += (WINSIZE*WINSIZE - WINSIZE*TILE)/sizeof(long);
	} while (--i);
	return tSym;
}

#if 0
/* Scroll rtMap */
pico rtLeft(x)
pico x;
{
	register long *p;
	register int i, j;

	p = *(long**)nextDynamo(&x);
	i = 4*WINSIZE; do {
		j = WINSIZE/sizeof(long)-8; do {
			*p = *(p+8);
			++p;
		} while (--j);
		p += 8;
	} while (--i);
	return tSym;
}

pico rtRght(x)
pico x;
{
	register long *p;
	register int i, j;

	p = *(long**)(nextDynamo(&x) + 4*WINSIZE*WINSIZE);
	i = 4*WINSIZE; do {
		j = WINSIZE/sizeof(long)-8; do {
			--p;
			*p = *(p-8);
		} while (--j);
		p -= 8;
	} while (--i);
	return tSym;
}

pico rtUp(x)
pico x;
{
	register long *p;
	register int i, j;

	p = *(long**)nextDynamo(&x);
	i = WINSIZE/sizeof(long); do {
		j = 4*WINSIZE-TILE; do {
			*p = *(p + TILE*WINSIZE/sizeof(long));
			p += WINSIZE/sizeof(long);
		} while (--j);
		p += 1 - (4*WINSIZE-TILE)*(WINSIZE/sizeof(long));
	} while (--i);
	return tSym;
}

pico rtDown(x)
pico x;
{
	register long *p;
	register int i, j;

	p = *(long**)(nextDynamo(&x) + 4*WINSIZE*WINSIZE);
	i = WINSIZE/sizeof(long); do {
		j = 4*WINSIZE-TILE; do {
			p -= WINSIZE/sizeof(long);
			*p = *(p - TILE*WINSIZE/sizeof(long));
		} while (--j);
		p -= 1 - (4*WINSIZE-TILE)*(WINSIZE/sizeof(long));
	} while (--i);
	return tSym;
}
#endif
