[align.l 17oct89]

[++ Order the coordinates of a baseline in top left, bottom right ++]

<de orderpoints (p1 p2 )
   (cons
      (cons
         (min (car p1) (car p2))
         (min (cdr p1) (cdr p2)) )
      (cons
         (max (car p1) (car p2))
         (max (cdr p1) (cdr p2)) >

[++returns the centerpoint of a circle or a ellipse++]
<de centerp (fig)
   (local (pt1 pt2 hptx hpty )
      (setq pt1 (scale (car (get fig 'RgnBBox))))
      (setq pt2 (scale (cdr (get fig 'RgnBBox))))
      (case (cadr (class fig))
         ((circle)
            (setq pt2 (cons (car pt2) (add (sub (car pt2)(car pt1))(cdr pt1))) )
            (setq hptx (add (car pt1) (div (sub (car pt2) (car pt1)) 2)) )
            (setq hpty (add (cdr pt1) (div (sub (cdr pt2) (cdr pt1)) 2)) )
            (setq pt1 (cons hptx hpty)) )
         ((ellipse)
            (cons (add (car pt1) (div (sub (car pt2) (car pt1)) 2) ) (add (cdr pt1)(div (sub (cdr pt2)(cdr pt1)) 2))) ) )
 >

[++returns the radius of a circle+]]
<de radius (fig)
   (local (pt1 pt2)
      (setq pt1 (scale (car (get fig 'RgnBBox))))
      (setq pt2 (scale (cdr (get fig 'RgnBBox))))
      (div (sub (car  pt2) (car pt1))2) >

[+++ Base Line Deletion +++]
<de zapBline (bl)
   (when (eq t (car bl))
      (make
         "Delete Bline"
			(list bl)
            '((x)
               (InvalRect
               (InsetRect
                  (orderpoints (unScale (cadr x)) (unScale (cddr x)))
                  -1 -1 ) )
               (put *app 'baseLines
                  (cons x (get *app 'baseLines)) ) )
			(list bl)
				'((y)
      			(InvalRect
         			(InsetRect
            			(orderpoints (unScale (cadr y)) (unScale (cddr y)))
            			-1 -1 ) )
      			(put *app 'baseLines (delete y (get *app 'baseLines))) ) ) >
			
             

<de doDelBline ()
   (local (pt bl)
      (SetCursor (ptr (GetCursor crossCursor)))
      (while (setq bl (findBline))
         (if (and bl (eq t (car bl)))
            (zapBline bl)
            (SysBeep 8) >

<de findBline ()
   (local (pt f)
      (SetCursor (ptr (GetCursor crossCursor)))
      (setq f (remove *app 'grid))
      (prog1
         (when (setq pt (click))
            (setq pt (scale pt))
            (find (get *app 'baselines)
               '((bl)
                  (local (lpt)
                     (and
                        (setq lpt (lotPoint (cadr bl) (cddr bl) pt))
                        (lessp (distPt pt lpt) 100) ) ) ) ) )
         (and f (flag *app 'grid)) >


<de moveBline ()
   (local (b1 b2 pt bp1 bp2 h v)
      (while (and (setq b1 (findBline)) (car b1))
         (cond
            ((lessp (distpt (cadr b1) (scale (GetMouse))) 200)
               (setq
                  pt (unscale (cddr b1))
                  pt
                  (drag pt
                     '((oldpt newpt)
                        (line2 pt oldPt)
                        (line2 pt newpt) ) )
                  b2 (cons t (cons (scale pt) (cddr b1))) ) )
            ((lessp (distpt (cddr b1) (scale (GetMouse))) 200)
               (setq
                  pt (unscale (cadr b1))
                  pt
                  (drag pt
                     '((oldpt newpt)
                        (line2 pt oldPt)
                        (line2 pt newpt) ) )
                  b2 (cons t (cons (cadr b1) (scale pt))) ) )
            (t
               (setq bp1 (unscale (cadr b1)))
               (setq bp2 (unscale (cddr b1)))
               (drag (GetMouse)
                  '((oldPt newPt)
                     (line2 bp1 bp2)
                     (setq
                        h (sub (car newpt) (car oldpt))
                        v (sub (cdr newpt) (cdr oldpt))
                        bp1 (cons (add h (car bp1)) (add v (cdr bp1)))
                        bp2 (cons (add h (car bp2)) (add v (cdr bp2))) )
                     (line2 bp1 bp2) ) )
               (setq b2 (cons t (cons (scale bp1) (scale bp2)))) ) )
         (make
            "Move Line"
				(list (cons b1 b2))
            	'((x)
              	   (invalBline (cdr x))
               	(subst (car x) (cdr x) (get *app 'baseLines))
               	(invalBline (car x)) )
             (list b1 b2)
					'((y z)
         			(invalBline y)
         			(subst z y (get *app 'baseLines))
         			(invalBline z) ) ) >

<de invalBline (bl)
   (InvalRect
      (InsetRect
         (orderpoints (unScale (cadr bl)) (unScale (cddr bl)))
         -1 -1 >

<de dupBline ()
   (local (bl pt newbl d)
   (while (setq bl (findBline))
      (if (car bl)
         (progn
            (setq d (parall (cadr bl) (cddr bl) 3000))
            (setq newbl (cons t (OffsetRect (cdr bl) (car d) (cdr d))))
            (make
               "Duplicate Bline"
					(list (cons newbl (get *app 'baseLines)))
                  '((x)
                  	(invalBline (car x))
                  	(put *app 'baseLines (cdr x)) )
               (list newbl)
						'((y)
            			(invalBline y)
            			(put *app 'baseLines
               			(cons y (get *app 'baseLines)) ) ) ) )
        (SysBeep 8) )  )[** end if **]
>

<de disableBline ()
    (local (bl)
    (while (setq bl (findBline))
        (if (and bl (eq t (car bl)))
            (progn
                (setq bl (cdr bl))
                (make
                   "Disable Bline"
						  (list bl)	
                    	  '((x)
                       		(put *app 'baseLines
                              (delete (cons Nil x)
                                 (get *app 'baseLines) ) )
                           (put *app 'baseLines
                              (cons (cons t x)
                                 (get *app 'baseLines) ) )
                           (InvalRect
                              (InsetRect
                                 (orderpoints (unscale (car x)) (unscale (cdr x)))
                                -1 -1 ) ) ) 
							(list bl)
							   '((y)
               			   (put *app 'baseLines
                    		      (delete (cons t y)
                       	         (get *app 'baseLines) ) )
                			   (put *app 'baseLines
                    			   (cons (cons nil y)
                         		   (get *app 'baseLines) ) )
                			   (invalBline (cons t y)) ) ) )

            (SysBeep 8) ) )
>

<de enableBline ()
    (local (bl)
    (while (setq bl (findBline))
        (if (and bl (eq Nil (car bl)))
            (progn
               (invalBline bl)
               (setq bl (cdr bl))
                (make
                    "enable Bline"
							(list bl)
                    		'((x)
                       		(put *app 'baseLines
                              (delete (cons t x)
                                 (get *app 'baseLines) ) )
                           (put *app 'baseLines
                              (cons (cons Nil x)
                                 (get *app 'baseLines) ) )
                           (InvalRect
                              (InsetRect
                                 (orderpoints (unscale (car x)) (unscale (cdr x)))
                                -1 -1 ) ) )
							(list bl)
								'((y)
               				(put *app 'baseLines
                    				(delete (cons Nil y)
                        			(get *app 'baseLines) ) )
                				(put *app 'baseLines
                    				(cons (cons t y)
                        			(get *app 'baseLines) ) )
									(InvalBline (cons t y)) ) ) )

            (SysBeep 8)  )
>

<de extendBline ()
   (local (bl b1 b2 s r newbl)
      (setq
         s (get *app 'size)
         r
            (cons2
               (minus (car s))
               (minus (cdr s))
               (mul2 (car s))
               (mul2 (cdr s)) ) )
      (while (setq bl (findBline))
         (if (car bl)
            (progn
               (setq
                  b1 (cadr bl)
                  b2 (cddr bl)
                  newbl
                     (cons
                        t
                        (cons
                           (or
                              (intSec b1 b2
                                 (car r)
                                 (cons (left r) (bottom r)) t)
                              (intSec b1 b2
                                 (car r)
                                 (cons (right r) (top r)) t) )
                           (or
                              (intSec b1 b2
                                 (cons (right r) (top r))
                                 (cdr r) t)
                              (intSec b1 b2
                                 (cons (left r) (bottom r))
                                 (cdr r) t) ) ) ) )
               (make
                  "Extend Bline"
						(list (cons bl newbl))
                  	'((x)
                     	(subst (car x) (cdr x) (get *app 'baseLines))
                     	(invalBline (cdr x)) )
						(list bl newbl)
                   	'((y z)
               			(subst z y (get *app 'baseLines))
               			(invalBline z) ) ) )
            (SysBeep 8) >

[+++ Create new Base Lines +++]
<de mouseBline (pt)
   (local (pt1 pt2 oldPt newPt reg)
      (when
         (and
            (setq pt1 (or pt (click)))
            (setq pt2
               (click
                  pt1
                  '((oldPt newPt)
                     (MoveTo  (car oldPt)(cdr oldPt))
                     (LineTo  (car newPt)(cdr newPt) ) )
                  nil t  ) ) )
         (make
            "Base Line"
            (list (cons t (cons (scale pt1) (scale pt2))))
            '((x)
               (InvalRect
                  (InsetRect
                     (orderpoints (unScale (cadr x)) (unScale (cddr x)))
                     -1 -1 ) )
               (put *app 'baseLines (delete x (get *app 'baseLines))) )
            (list pt1 pt2)
            '((pt1 pt2)
               (InvalRect
                  (InsetRect  (orderpoints pt1 pt2) -1 -1) )
               (put *app 'baseLines
                  (cons (cons t (cons (scale pt1) (scale pt2)))
                     (get *app 'baseLines)) >

<de digiBline (pt)
   (local (pt1 pt2)
		(setq *press *enterkey)
      (setq pt1)
      (setq pt2)
      (unless pt
         (setq pt (coord)) )
      (if (eq *press *enterkey)
         (setq pt1 pt) )
      (setq pt (coord pt))
      (if (or (eq *press *orthokey) (eq *press *enterkey))
         (setq pt2 pt) )
      (setq pt (coord))
      (when (and pt1 pt2 (eq *press *termkey))
         (make
            "Base Line"
            (list (cons t (cons pt1 pt2)))
            '((x)
               (InvalRect
                  (InsetRect
                     (orderpoints (unscale (cadr x))  (unscale (cddr x)))
                     -1 -1 ) )
               (put *app 'baseLines (delete x (get *app 'baseLines))) )
            (list pt1 pt2)
            '((pt1 pt2)
         		(InvalRect
            		(InsetRect  (orderpoints (unscale pt1) (unscale pt2)) -1 -1) )
         		(put *app 'baseLines
            		(cons (cons t (cons pt1 pt2)) (get *app 'baseLines)) ) >


[++ calculates the intersectionpoints of the Baselines, returns a list++]

<de crossBpoints ()
   (local (l pt)
      (setq l)
      (mapc (get *app 'baselines)
         '((b1)
            (when (car b1)
               (mapc (get *app 'baseLines)
                  '((b2)
                     (and
                        (car b2)
                        (setq pt
                           (intsec
                              (cadr b1)
                              (cddr b1)
                              (cadr b2)
                              (cddr b2) ) )
                        (push1 pt l) ) ) ) ) ) )
      l >

[++ Align single point ++]
<de align (pt cl bl)
   (local (lpt)
      (or
         (worst
            (filter cl '((x) (nearCorner x pt)))
            '((x) (distPt x pt)) )
         (worst
            (filter bl '((x) (nearCorner x pt)))
            '((x) (distPt x pt)) )
         (worst
            (mapcan (get *app 'baseLines)
               '((bl)
                  (and
                     (setq lpt (lotPoint (cadr bl) (cddr bl) pt))
                     (nearCorner lpt pt)
                     (list lpt) ) ) )
            '((x) (distPt x pt)) )
         pt >


[++ Align all selected figures ++]
<de alignSelection ()
   (local (lst crosspl basepl pt pt1)
      (setq
         crosspl (crossBpoints)
         basepl
         (mapcan
            (get *app 'baseLines)
            '((bl) (list (cadr bl) (cddr bl))) ) )
      (setq lst
         (mapcar *mark
            '((fig)
               (case (get fig 'type)
                  ((circle ellipse)
                     (setq pt (pt-bez (centerp fig)))
                     (setq pt1
                        (pt-bez
                           (align (centerp fig) crosspl basepl) ) )
                     (offsetBez
                        (get fig 'bezier)
                        (sub (car pt1) (car pt))
                        (sub (cdr pt1) (cdr pt)) ) )
                  (t
                     (mapcar (bezPoints fig)
                        '((x)
                           (if (pointp x)
                              (pt-bez (align x crosspl basepl))
                              (mapcar
                                 (cons
                                    (align (car x) crosspl basepl)
                                    (cdr x) )
                                 pt-bez ) ) ) ) ) ) ) ) )
      (when *mark
         (make
            "Align"
            (list
               (mapcar *mark
                  '((fig)
                     (cons
                        (get fig 'type)
                        (get fig 'bezier) ) ) ) )
            '((lst)
               (mapc2 *mark lst
                  '((fig x)
                     (InvalFig fig)
                     (put fig 'type (car x))
                     (adjBez fig (cdr x)) ) ) )
            (list lst)
            '((lst)
               (mapc2 *mark lst
                  '((fig bz)
                     (invalFig fig)
                     (adjBez fig bz)
                     [(put fig 'type (figType fig))] >

<de bezpoints (fig)
   (mapcar (get fig 'bezier)
         '((x)
            (if (pointp x)
               (bez-pt x)
               (mapcar x bez-pt) ) ) ) >


[++ test, if list of points is a rectangle++]
[++ Order of points: botright,botleft,topleft,topright++]

<de recttest (points)
	(if (and
			(ptest (nth 0 points)(nth 1 points)(nth 2 points)(nth 3 points))
			(ptest (nth 3 points)(nth 0 points)(nth 2 points)(nth 1 points)) )
		 t )	>
			 

[+++<de rectTest (points)
   (and
      (eq (caar points) (car (last points)))
      (eq (caadr points) (car (caddr points)))
      (eq (cdr(caddr points)) (cdr (last points)))
      (eq (cdadr points) (cdar points)) >+++]

<de calcOblpoints (fig)
   (local (lst)
      (setq lst (get fig 'bezier))
         (if (flagp fig 'invObl)
            (list (bez-pt (nth 0 (car lst)))
               (list (bez-pt (nth 3 (car lst))))
               (bez-pt (cadr lst)) (bez-pt (nth 0 (caddr lst)))
               (list (bez-pt (nth 3 (caddr lst)))) (bez-pt (last lst)))
            (list (bez-pt (nth 0 (car lst)))
               (list (bez-pt (nth 6 (car lst))))
               (bez-pt (cadr lst)) (bez-pt (nth 0 (caddr lst)))
               (list (bez-pt (nth 6 (caddr lst)))) (bez-pt (last lst))) )>

<de nearcorner (figpt alpt)
   (lessp (distPt figpt alpt) (get *app 'allow)) >

t [align.l]
