[click.l 05dec89]

(setq $point (0 . 0))
(list $pt1 $pt2 $oldPt $newPt $foo)

[++++++
(setq $spotRight (sub (cadr (rect (add 6 *screenBits))) 12))
++++++]

<de getKey ()
   (until
      (and
         (getEvent)
         (memq (ev-what *event) (#keyDown #autoKey)) )
      (SystemTask)
      (case (ev-what *event)
         (#updateEvt (doEvent))
         ((#mouseDown #app1Evt) (SysBeep 8)) ) )
   (bitAnd charCodeMask (ev-message *event)) >

<de mouse (pt)
   (until (equal pt (GetMouse $point))
      (if (lessp (car $point) (car pt))
         (word 2090 (add1 (word 2090)))
         (if (lessp (car pt) (car $point))
            (word 2090 (sub1 (word 2090))) ) )
      (if (lessp (cdr $point) (cdr pt))
         (word 2088 (add1 (word 2088)))
         (if (lessp (cdr pt) (cdr $point))
            (word 2088 (sub1 (word 2088))) ) )
      (byte 2254 (byte 2255))
      (reptn (div 2000 (distPt pt $point)))
      (word (add 10 *event) (word 2088))
      (word (add 12 *event) (word 2090)) >

<de dMouse (dh dv)
   (when (eq autoKey (ev-what *event))
      (setq
         dh (mul 3 dh)
         dv (mul 3 dv) ) )
   (word 2090 (add dh (word 2090)))
   (word 2088 (add dv (word 2088)))
   (byte 2254 (byte 2255)) >

<de grid (n)
   (local (g)
      (setq g
         (if (and *grid (flagp *app 'grid))
            (max
               1
               (mul
                  (get *app 'grid)
                  (get *app 'scale) ) )
            1 ) )
      (inc n (div2 g))
      (sub n (mod n g)) >

<de defaultSpot (h v)
   (do print 'spot
      (append
         "H:"
         (format (scale1 h) 2)
         "  V:"
         (format (scale1 v) 2) >

[++++++
<de initSpot ()
   (setq *spotWindow
      (NewWindow
         nil
         '((920 . 22) 1020 . 42)
      nil nil altDBoxProc) >

<de prSpot (s1 s2)
   (local (len)
      (setq len (add 16 (StringWidth s1) (StringWidth s2)))
      (MoveWindow *spotWindow (sub #$spotRight len) 22)
      (SizeWindow *spotWindow len 20)
      (localPort *spotWindow
         (BringToFront *spotWindow)
         (ptr 0A84 [GhostWindow] *spotWindow)
         (ShowHide *spotWindow t)
         (MoveTo 8 15)
         (EraseRect (portRect *spotWindow))
         (DrawString s1)
         (DrawString s2)
         (ValidRect (portRect *spotWindow)) >
++++++]

<de updateSpot (pt)
   (when
      (and
         *spot
         (or
            (neq $spot-h (car pt))
            (neq $spot-v (cdr pt)) ) )
      (*spot
         (setq $spot-h (car pt))
         (setq $spot-v (cdr pt)) )
      t >

<de hideSpot ()
   (setq $spot-h)
   (do hide 'spot) >

[+++ Check if last mouse-down event was a double click +++]
<de isDoubleClick ()
   (and
      (memq (ev-what *event) (#mouseDown #app1Evt))
      (lessp
         (sub (ev-when *event) *lastWhen)
         (ptr 02F0) ) [DoubleTime global variable]
      (lessp (abs (sub *lastV (word (add 10 *event)))) 3)
      (lessp (abs (sub *lastH (word (add 12 *event)))) 3) >

[+++ Recieve mouse-click input +++]
[Get mouse, possibly with shift key]
<de clickMouse ()
   (local (pt dh dv flg ratio)
      (setq pt (GetMouse))
      (rplaca pt (grid (car pt)))
      (rplacd pt (grid (cdr pt)))
      (SetCursor
         (if (inView pt *port)
            (ptr (GetCursor crossCursor))
            *arrow ) )
      (when (and clickAnchor (or shift-f (s-key)))
         (setq dh (sub (car pt) (car clickAnchor)))
         (setq dv (sub (cdr pt) (cdr clickAnchor)))
         (setq flg (lessp (abs dh) (abs dv)))
         (setq ratio
            (if flg
               (if (zerop dh) 999 (div (abs dv) (abs dh)))
               (if (zerop dv) 999 (div (abs dh) (abs dv))) ) )
         (if (and line-f (lessp 2 ratio))
            (if flg
               (rplaca pt (car clickAnchor))
               (rplacd pt (cdr clickAnchor)) )
            (progn
               (if flg
                  (setq dh (if (minusp dh) (minus (abs dv)) (abs dv)))
                  (setq dv (if (minusp dv) (minus (abs dh)) (abs dh))) )
               (rplaca pt (add dh (car clickAnchor)))
               (rplacd pt (add dv (cdr clickAnchor))) ) ) )
      (updateSpot pt)
      pt >

[Redraw temporary figure]
<de clickFun ($pt1 $pt2 hin-f)
   (when (and $foo (inView $pt2 *port))
      (PenNormal)
      (PenMode patXor)
      (if line-f
         (if hin-f
            (if (and o-foo (setq *click (o-key)))
               (o-foo $pt1 $pt2)
               ($foo $pt1 $pt2) )
            (if (and o-foo *click)
               (o-foo $pt1 $pt2)
               ($foo $pt1 $pt2) ) )
         ($foo
            (cons
               (min (car $pt1) (car $pt2))
               (min (cdr $pt1) (cdr $pt2)) )
            (cons
               (max (car $pt1) (car $pt2))
               (max (cdr $pt1) (cdr $pt2)) >

[+++ Edit the spot window +++]
<de editSpot (c)
   (local (h v var lim limH limV f)
      (setq
         h (if (neq c 9) 0 (scale1 (car pt)))
         v (if (eq c 9) 0 (scale1 (cdr pt)))
         var 'h
         limH (sub1 (car (get *app 'size)))
         limV (sub1 (cdr (get *app 'size)))
         lim 'limH
         f 100 )
      (loop
         (t (eq c 27) [ESC]
            (*spot (car pt) (cdr pt))
            t )
         (t (memq c (29 30 28 31)) t) [Arrows]
         (t (memq c (\^C \^M)) [Return, Enter]
            (rplaca pt (dots h))
            (rplacd pt (dots v))
            (mouse pt)
            nil )
         (case c
            (8
               (set var 0)
               (setq f 100) )
            ((9 32)
               (setq
                  var (if (eq var 'h) 'v 'h)
                  lim (if (eq var 'h) 'limH 'limV)
                  f 100 )
               (set var 0) )
            ((\. \,) (setq f 10))
            (t
               (when (lessp \/ c \:)
                  (set var
                     (min (eval lim)
                        (add
                           (mul (abs (eval var))
                              (if (eq f 100) 10 1) )
                           (mul f (sub c \0)) ) ) )
                  (setq f (if (eq f 100) 100 (div f 10))) ) ) )
         (*spot (dots h) (dots v))
         (setq c (getKey)) >

[+++ Get next click-event +++]
[Return true if next event should be processed by main loop]
<de clickEvent ()
   (local (win mPt c)
      (clickFun clickAnchor (setq pt (clickMouse)) t)
      (until (getEvent)
         (or *spot (delay 2))
         (when (not (equal pt (setq mPt (clickMouse))))
            (clickFun clickAnchor pt)
            (clickFun clickAnchor (setq pt mPt) t) )
         (SystemTask) )
      (clickFun clickAnchor pt)
      (case (ev-what *event)
         ((#nullEvent #mouseUp #keyUp #updateEvt #activateEvt) t)
         ((#mouseDown #app1Evt)
            (or
               (memq
                  (FindWindow (ev-where *event) win)
                  (#inDrag #inGrow #inZoomIn #inZoomOut) )
               (may clickSpecial *app win pt) ) )
         ((#keyDown #autoKey)
            (case (setq c (bitand charCodeMask (ev-message *event)))
               ((\^M \^C))
               (28 (dMouse -1 0))
               (29 (dMouse 1 0))
               (30 (dMouse 0 -1))
               (31 (dMouse 0 1))
               ((8 9 32 \. \, \0 \1 \2 \3 \4 \5 \6 \7 \8 \9)
                  (and
                     (eq *spot defaultSpot)
                     (editSpot c) ) )
               [(mouse pt) ) )]
         (t t) >

[+++ Return a point +++]
<de click (clickAnchor $foo o-foo line-f shift-f)
   (local (pt win thePart theControl obj)
      (prog1
         (loop
            (while (clickEvent)
               (doEvent) )
            (t
               (not
                  (memq
                     (ev-what *event)
                     (#mouseDown #keyDown #app1Evt) ) ) )
            (t (isDoubleClick))
            (t
               (neq
                  inContent
                  (FindWindow (ev-where *event) win) ) )
            (t (neq win (FrontWindow)))
            (setq
               thePart (FindControl pt win theControl)
               obj (GetWRefCon win) )
            (t
               (or
                  (not theControl)
                  (and
                     (neq (get obj 'hSBar) theControl)
                     (neq (get obj 'vSBar) theControl) ) )
               pt )
            [Process control]
            (doEvent) )
         (hideSpot) >

<de drag ($oldPt $foo)
   (PenNormal)
   (PenMode patXor)
   (setq $oldPt
      (cons
         (grid (car $oldPt))
         (grid (cdr $oldPt)) ) )
   (while (StillDown)
      (setq $newPt (GetMouse))
      (rplaca $newPt (grid (car $newPt)))
      (rplacd $newPt (grid (cdr $newPt)))
      (unless (updateSpot $newPt)
         (delay 2) )
      (when $foo
         ($foo $oldPt $newPt) )
      (setq $oldPt $newPt) )
   (hideSpot)
   $oldPt >

t [click.l]
