[draw.l 28jun90]

<de dPoly (points)
   (while (lessp 1 (length points))
      (if (numberp (caadr points))
         (line2 (unScale (cadr points)) (unScale (pop points)))
         (hybArc
            (pop points)
            (car (pop points))
            (car points) >

<de dMask (points)
   (rtMoveTo (caar points) (cdr (pop points)))
   (while points
      (rtLineTo (caar points) (cdr (pop points))) >

<de dots (n)
   (div
      (mul (get *app 'scale) n)
      100 >

<de unscale1 (n)
   (dots n) >

<de unScale (pt)
   (cons
      (dots (car pt))
      (dots (cdr pt)) >

<de unScaleRct (rct)
   (cons
      (unScale (car rct))
      (unScale (cdr rct)) >

<de putDot (pt)
   (PenSize dotSiz dotSiz)
   (line2 pt pt) >

<de knoedel (pt)
   (PenNormal)
   (FrameArc (sqRect pt dotSiz) 0 360) >

<de doMark (fig)
   (invalCorner fig)
   (local (rgn1 rgn2)
      (setq
         rgn1 (NewRgn)
         rgn2 (NewRgn) )
      (RectRgn rgn1 (get fig 'frame2))
      (RectRgn rgn2 (get fig 'rgnBBox))
      (DiffRgn rgn1 rgn2 rgn2)
      (InvalRgn rgn2)
      (DisposeRgn rgn1)
      (DisposeRgn rgn2) >

<de mark (fig)
   (unless (memq fig *mark)
      (push fig  *mark)
      (doMark fig) >

<de unMark (fig)
   (when (memq fig *mark)
      (setq *mark (delete fig *mark))
      (doMark fig) >

<de dotLine(fig)
   (PenNormal)
   (PenMode patXor)
   (FrameRect (get fig 'frame1)) >

<de showText (l)
   (local (l)
      (while l
         (setq s (pop l))
         (cond
            ((numberp s)
               (textAttr s)
               (RGBForeColor (pop l)) )
            ((pointp s)
               (MoveTo (car s) (cdr s)) )
            ((DrawString s)) ) )
      (textAttr 0)
      (RGBForeColor 0) >

<de drawFigure (fig)
   (PenNormal)
   (do draw fig)
   (with fig
      (when (slot rule)
         (PenNormal)
         (RGBForeColor (apply rgb (slot rTint)))
         (PaintRgn (ref (slot rRgn)))
         (resetColor) >

<de drawPage (p)
   (local (rgn)
      (setq rgn (NewRgn))
      (when (flagp p 'grid)
         (pustel
				#(pack 0 0 0)
            *port
            (viewRect *port)
            (mul (get p 'grid) (get p 'scale)) ) )
      (mapc (get p 'figures)
         '((fig)
            (if (get fig 'rule)
               (UnionRgn
                  (getFigRgn fig)
                  (ref (get fig 'rRgn))
                  rgn )
               (CopyRgn (getFigRgn fig) rgn) )
            (SectRgn rgn (visRgn *port) rgn)
            (unless (EmptyRgn rgn) (drawFigure fig))
            (when
               (and
                  (memq fig *mark)
                  (RectInRgn
                     (get fig 'frame2)
                     (visRgn *port) ) )
               (PenMode patXor)
               (when (get fig 'corner)
                  (knoedel
                     (unScale
                        (bez-pt
                           (getCorner
                              (get fig 'corner)
                              (get fig 'bezier) ) ) ) ) )
               (mapc (get fig 'mark) putDot)
               (dotLine fig) ) ) )
      (when (flagp p 'showBline)
         (PenNormal)
         (RGBForeColor
            (pack
               1023
               (div
                  (mul 1023 (cadr (get p 'backColor)))
                  100 )
               (div
                  (mul 1023 (car (get p 'backColor)))
                  100 ) ) )
         (mapc (get p 'baseLines)
            '((l)
               (PenNormal)
               (unless (car l)
                  (PenPat *blPat) )
               (MoveTo (dots (caadr l)) (dots (cdadr l)))
               (LineTo (dots (caddr l)) (dots (cdddr l))) ) )
         (resetColor) )
      (DisposeRgn rgn) >

<de printPage (p)
   (local (h x)
      (PrOpen)
      (setq h (NewHandle 120))
      (when (and (PrJobDialog h) (PrStlDialog h))
         (setq x (PrOpenDoc h))
         (PrOpenPage x)
         (drawPage p)
         (PrClosePage x)
         (PrCloseDoc x)
         (PrPicFile h) )
      (DisposHandle h)
      (PrClose)
      (PrError) >

<de rtLocal (pt)
   (with *app
      (cons
         (mul
            (sub (car pt) (mul 32 (slot* pos-h)))
            (slot zoom) )
         (mul
            (sub (cdr pt) (mul 32 (slot* pos-v)))
            (slot zoom) >

<de rtGlobal (pt)
   (with *app
      (cons
         (add
            (mul 32 (slot* pos-h))
            (div (car pt) (slot zoom)) )
         (add
            (mul 32 (slot* pos-v))
            (div (cdr pt) (slot zoom)) >

<de rtMoveTo (h v)
   (with *app
      (MoveTo
         (mul
            (sub h (mul 32 (slot* pos-h)))
            (slot zoom) )
         (mul
            (sub v (mul 32 (slot* pos-v)))
            (slot zoom) >

<de rtLineTo (h v)
   (with *app
      (LineTo
         (mul
            (sub h (mul 32 (slot* pos-h)))
            (slot zoom) )
         (mul
            (sub v (mul 32 (slot* pos-v)))
            (slot zoom) >

<de maskDot (pt)
   (PenSize dotSiz dotSiz)
   (rtMoveTo (car pt) (cdr pt))
   (Move #(minus (div2 dotSiz)) #(minus (div2 dotSiz)))
   (Line 0 0) >

<de hiGraf (g)
   (localClip (viewRect *port)
      (PenMode patXor)
      (for (i 0 (length (cdr g)))
         (for (j 1 (length (nth i (cdr g))))
                  (maskDot (grafPt i j g)) >

<de drawMask (g)
   (localClip (viewRect *port)
      (PenNormal)
      (PenMode patXor)
      (with *app
         (draw
            g
            (slot zoom)
            (mul -32 (slot zoom) (slot* pos-h))
            (mul -32 (slot zoom) (slot* pos-v)) >

<de drawHiMask (g)
   (drawMask g)
   (hiGraf g) >

t [draw.l]
