[file.l 06mar90abugrrf]

<de openJournal ()
   (unless (boundp '*drvr)
      (OpenDriver ".isar" *drvr)
      (word 08E8 *drvr) [JournalRef] >

<de record (s)
   (openJournal)
   (setq *jFile (create s "iJnl"))
   (control *drvr 18 *jFile) [+ Set refNum +]
   (word 08DE 1) >

<de stop ()
   (word 08DE 0) [+ JournalFlag off +]
   (close *jFile)
   (setq *jFile) >

<de doPlay ()
   (openJournal)
   (local (nm vol)
      (when *jFile
         (close *jFile)
         (off *jFile) )
      (setq vol (GetVol))
      (when (setq nm (getFile "iJnl" "TEXT"))
         (if (equal "iJnl" (fType nm))
            (setq
               *jFile (open nm)
               *batch )
            (setq
               *batch (cons (GetVol) (open nm))
               *jFile (open (getline (cdr *batch))) ) )
         (SetVol vol)
         (control *drvr 18 *jFile)
         (word 08DE -1) >

<de imgErr (nm)
   (error "Can't open image " nm) >

[++ Create a new Pixel Map ++]
<de newOffMap (h v)
   (local (pm rb p)
      (setq pm (NewPixMap))
      (setq rb (bitAnd -4 (add 3 h))) [+ rowBytes +]
      (ptr
         (setq p (HLock pm))
         (alloc (mul v rb) [0]) ) [+ baseAdr +]
      (word (add 4 p) [+ rowBytes +]
         (bitOr 08000 rb) )
      (rect (add 6 p) [+ bounds +]
         (cons2 0 0 h v) )
      (DisposHandle (ptr (add 42 p))) [Color Table]
      (ptr (add 42 p) (GetResource "clut" clut1))
      (HUnlock pm) >

[++ Dispose of an offscreen pixel map ++]
<de zapMap (pm)
   (ptr (add 42 (ptr pm))
      (NewHandle 1))
   (DisposPixMap pm) >

[++ Read a pixel map from file ++]
<de readPixMap (file)
   (local (fd pm rows cols dh dv p q)
      (SetCursor (ptr (GetCursor watchCursor)))
      (unless (setq fd (open file))
         (imgErr file) )
      (setq
         rows (add (mul 256 (getc fd)) (getc fd))
         cols (add (mul 256 (getc fd)) (getc fd))
         dh (bitand -16 (add 15 cols))
         dv (bitand -16 (add 15 rows)) )
      (seek 4 fd)
      (setq pm (newOffMap dh dv))
      (readBlock fd (ptr (ptr pm)) (mul cols rows))
      (close fd)
      (setq
         p (add (ptr (ptr pm)) (mul cols rows))
         q (add (ptr (ptr pm)) (mul dh rows)) )
      (reptn rows
         (dec p cols)
         (dec q dh)
         (block p q cols) )
      pm >

<de readPict (nm fig)
   (local (pm temp tb th tv rbbox rh rv h v p)
      (setq temp (readPixMap nm))
      (setq
         tb (rect (add 6 (ptr temp)))
         th (right tb)
         tv (bottom tb)
         rbbox (get fig 'rgnBBox)
         rh (sub (right rbbox) (left rbbox))
         rv (sub (bottom rbbox) (top rbbox)) )
      (if (lessp (div (mul 100 tv) rv) (div (mul 100 th) rh))
         (setq
            v rv
            h (div (mul th rv) tv) )
         (setq
            h rh
            v (div (mul tv rh) th) ) )
      (setq
         h  (div (mul 120 h) 100)
         v  (div (mul 120 v) 100) )
      (setq pm (newOffMap h v))
      (CopyBits
         (ptr temp)
         (ptr pm)
         tb
         (rect (add 6 (ptr pm)))
         srcCopy )
      (free (ptr (ptr temp)))
      (zapMap temp)
      (rplaca (class fig) 'pictured)
      (with fig
         (slot picture nm)
         (slot pScale (cons2 h th v tv))
         (slot freeLine)
         (slot base
            (dynamo
               DisposHandle
               (PtrToHand
                  (setq p (ptr (ptr pm)))
                  (GetPtrSize p) ) ) )
         (free p)
         (slot pixMap (dynamo DisposHandle pm))
         (slot pixBox
            (cons2
               (scale1 (left rbbox))
               (scale1 (top rbbox))
               (scale1 (add h (left rbbox)))
               (scale1 (add v (top rbbox))) >

[++++++++
<de mkPage (scale size grid allow backColor showBline)
   (local (i page)
      [+ Find unique page +]
      (setq i \A)
      (while
         (member
            (setq page
               (symbol (append "PAGE-" (list i)) t) )
            *pages )
         (inc i) )
      (put page 'scale scale)
      (put page 'size size)
      (put page 'grid grid)
      (put page 'allow allow)
      (put page 'backColor backColor)
      (if showBline
         (flag page 'showBline) )
      page >
++++++++]

<de loadPage (nm)
   (local (*app f y n)
      (unless (setq f (open nm))
         (error "Can't open " nm) )
      (setq *app
         (new 'page
            (list
               (read f) [scale]
               (read f) [size]
               nm
               (read f) [digi]
               (read f) [backColor]
               (read f) [allow]
               (read f) [grid] ) ) )
      (with *app
         (slot showBline (read f))
         (slot figures nil) )
      (reptn (read f)
         (with *app
            (slot figures
               (cons
                  (setq y
                     (new
                        (list
                           (nth (read f) fContents)
                           (nth (read f) fTypes) ) ) )
                  (slot figures) ) ) )
         (adjBez y (read f))
         (with y
            (case (car (class y))
               (texted )
               (pictured
                  (readPict (read f) y)
                  (slot freeLine (read f)) )
               (tinted (slot tint (read f)))
               (gradated
                  (local (r)
                     (setq r (read f))
                     (slot gradation
                        (new 'gradation
                           (right r)
                           (bottom r)
                           (read f) ) )
                     (slot gRes (read f)) ) ) )
            (when (setq n (read f))
               (slot rule n)
               (slot rRgn
                  (dynamo
                     DisposeRgn
                     (bezRgn
                        (slot rBez (border (slot bezier) n))
                        (get *app 'scale) ) ) )
               (slot rTint (read f))
               (XorRgn
                  (getFigRgn y)
                  (ref (slot rRgn))
                  (ref (slot rRgn)) ) ) ) )
      (with *app
         (mapc2 (read f) (slot figures)
            '((f fig)
               (when f
                  (slot mark (cons fig (slot mark))) ) ) )
         (slot baseLines (read f)) )
      (close f)
      *app >

<de savePage (obj nm)
   (local (vol f x)
      (setq vol (GetVol))
      (when
         (or
            nm
            (setq nm (putFile "Save Page" (get obj 'name))) )
         (unless (setq f (create nm "page"))
            (error "Can't create " nm) )
         (with obj
            (slot vol (GetVol))
            (SetWTitle
               (slot winPtr)
               (slot name nm) )
            (comment nm f) (terpri f)
            (comment "Scale" f)
            (print (slot scale) f)
            (comment "Size" f)
            (print (slot size) f)
            (comment "Digi" f)
            (print (slot digi) f)
            (comment "Background" f)
            (print (slot backColor) f)
            (comment "Allowance" f)
            (print (slot allow) f)
            (comment "Grid" f)
            (print (slot grid) f)
            (comment "Show base lines" f)
            (print (flagp obj 'showBline) f)
            (comment "Figures" f)
            (print (length (slot figures)) f) )
         (mapc (reverse (get obj 'figures))
            '((fig)
               (with fig
                  (comment (pname (car (class fig))) f)
                  (prin1 (index (car (class fig)) fContents) f)
                  (space f)
                  (comment (pname (cadr (class fig))) f)
                  (prin1 (index (cadr (class fig)) fTypes) f)
                  (space f)
                  (print (slot bezier) f)
                  (case (car (class fig))
                     (texted )
                     (pictured
                        (print (slot picture) f)
                        (comment "Freeline" f)
                        (print (slot freeLine) f) )
                     (tinted (print (slot tint) f))
                     (gradated
                        (print (get (slot gradation) 'rect) f)
                        (print (get (slot gradation) 'grad) f)
                        (print (slot gRes) f) ) )
                  (comment "Rule" f)
                  (when (print (slot rule) f)
                     (print (slot rTint) f) ) ) ) )
         (with obj
            (comment "Select" f)
            (print
               (mapcar (slot figures)
                  '((x) (if (memq x *mark) t)) )
               f )
            (comment "Base lines" f)
            (print (slot baseLines) f) )
         (remove obj 'dirty)
         (close f)
         (SetVol vol) >

<de saveCmyk ()
>

<de readTiles (obj h v c1 r1 c2 r2)
   (default
      h 0
      v 0
      c1 0
      r1 0
      c2 20
      r2 20 )
   (local (cols rows tile b)
      (SetCursor (ptr (GetCursor watchCursor)))
      (with obj
         (setq
            cols (slot* cols)
            rows (slot* rows)
            tile (add h c1 (mul cols (add v r1)))
            b (slot* base) )
         (local (tile)
            (for (row r1 (min r2 rows))
               (rdTile
                  (sub (min c2 cols) c1)
                  (slot* fd)
                  tile
                  b
                  c1
                  row )
               (inc tile cols) ) )
         (for (row r1 r2)
            (local (tile)
               (for (col c1 c2)
                  (unless (and (lessp col cols) (lessp row rows))
                     (clTile b col row) )
                  (store
                     (bitoff
                        col
                        (access (slot* dirty) row) )
                     (slot* dirty)
                     row )
                  (inc tile) ) )
            (inc tile cols) >

<de showTiles (obj)
   (local (z h v r1 r2 b rgn1 rgn2)
      (with obj
         (setq
            z (slot zoom)
            h (div (GetCtlValue (slot hSBar)) z)
            v (div (GetCtlValue (slot vSBar)) z) )
         (off rgn1)
         (when
            (and
               (slot* showCut)
               (slot* mask) )
            (setq rgn1 (NewRgn))
            (mapc (slot* mask)
               '((x)
                  (setq rgn2 (freeMaskRgn x))
                  (UnionRgn rgn1 rgn2 rgn1)
                  (DisposeRgn rgn2) ) )
            (EraseRect (viewRect *port)) )
         (localClip (viewRect *port)
            (setq r1
               (cons2
                  h
                  v
                  (add h (div (dots-h *port) z))
                  (add v (div (dots-v *port) z)) ) )
            (setq r2 (viewRect *port))
            (setq b (slot* base))
            (ptr (ptr (slot* c-map)) (ptr b))
            (CopyBits
               (ptr (slot* c-map))
               (portMap *port)
               r1
               r2
               srcCopy
               rgn1 )
            (ptr
               (ptr (slot* m-map))
               (add (ptr b) #(mul 640 640)) )
            (CopyBits
               (ptr (slot* m-map))
               (portMap *port)
               r1
               r2
               addOver
               rgn1 )
            (ptr
               (ptr (slot* y-map))
               (add (ptr b) #(mul2 (mul 640 640))) )
            (CopyBits
               (ptr (slot* y-map))
               (portMap *port)
               r1
               r2
               addOver
               rgn1 )
            (when (slot* showMask)
               (mapc (slot* mask)
                  '((g)
                     (drawMask g)
                     (when (memq g *mark)
                        (hiGraf g) ) ) ) ) )
         (and rgn1 (DisposeRgn rgn1)) >

<de newRtMap (ps h v ctab)
   (local (pm p)
      (setq pm (NewPixMap))
      (setq p (HLock pm))
      (word (add 4 p) (bitor 08000 h)) [+ rowBytes bitor 08000+]
      (rect (add 6 p) [+ bounds +]
         (cons2 0 0 h v) )
      (word (add 18 p) 08000) [packSize] [?]
      (word (add 20 p) ps)
      (DisposHandle (ptr (add 42 p))) [Color Table]
      (ptr (add 42 p) (GetResource "clut" ctab))
      (HUnlock pm) >

[++++++++
<de zapFigure (fig)
   [(if (memq fig *mark)
      (cut fig *mark) )]
   [(DisposeRgn (getFigRgn fig))]
   [(when (get fig 'rRgn)
      (DisposeRgn (get fig 'rRgn)) )]
   [(when (get fig 'pixMap)
      (DisposHandle (get fig 'base))
      (zapMap (get fig 'pixMap)) )] >

<de zapFigures (lst)
   (mapc lst zapFigure) >
++++++++]

[# $debug
<de *quit (h)
   (when h
      (local (f)
         (setq f (create "History"))
         (print $$$ f)
         (close f) >
]

t [file.l]
