[fixMenu.l 09mar90]

[FixMenu commands]
(de *fixCmds
   fix-baseLine fix-rect fix-circle fix-ellipse
   fix-oblong fix-poly fix-fan fix-line
   fix-divide fix-split fix-round fix-rule
   fix-text fix-pict fix-tint fix-gradation )

(de *pictRect (0.0) 160 . 100)
(de fixRect (0 . 0) #fmColSize . #fmRowSize)

[FixWindow rectangle]
(de *fixWinRect
   (#fmLeft . #fmTop) #(add fmLeft fmWidth) . #(add fmTop fmHeight) )

[Put the *fixCmds RECT-properties]
<local (*fixCmds)
   (for (row 0 fmRows)
      (for (col 0 fmCols)
         (put
            (pop *fixCmds)
            'rect
            (OffsetRect fixRect (mul col fmColSize) (mul row fmRowSize)) >

[Put the *fixCmds PICT-properties]
<de putPict (sym args)
   (ClipRect (portRect *port))  [For OpenPicture]
   (put sym 'pict (OpenPicture *pictRect))
   (mapc args eval)
   (ClosePicture)
   (car args) >

<de rsrcStr (s)
   (local (h)
      (setq h (GetNamedResource "STR " s))
      (DrawString (string (ptr h)))
      (ReleaseResource h) >

<de picTitle (s)
   (MoveTo 16 20)
   (rsrcStr s) >

<de initFixMenu ()
   (TextSize 24)
   <putPict 'fix-baseLine '(
      (MoveTo 12 40)
      (rsrcStr "align")
      (MoveTo 12 80)
      (rsrcStr "bline") >
   (TextSize 12)
   <putPict 'fix-rect '(
      (picTitle "rect")
      (FrameRect '((50 . 35) 130 . 85))
      (MoveTo 32 90) (DrawChar \1)
      (MoveTo 140 40) (DrawChar \2)
      (MoveTo 134 90) (DrawString "(3)") >
   <putPict 'fix-circle '(
      (picTitle "circ")
      (FrameOval '((70 . 30) 130 . 90)) >
   <putPict 'fix-ellipse '(
      (picTitle "elli")
      (FrameOval '((50 . 35) 130 . 85)) >
   <putPict 'fix-oblong '(
      (picTitle "obl")
      (FrameRoundRect '((40 . 40) 140 . 80) 40 40) >
   <putPict 'fix-poly '(
      (picTitle "poly")
      (MoveTo 50 90)
      (LineTo 60 40)
      (LineTo 110 30)
      (LineTo 150 50)
      (LineTo 50 90) >
   <putPict 'fix-fan '(
      (picTitle "fan")
      (MoveTo 140 20)
      (LineTo 140 90)
      (LineTo 70 90)
      (FrameArc '((110 . 60) 170 . 120) 0 -90)
      (FrameArc '((70 . 20) 210 . 160) 0 -90) >
   <putPict 'fix-line '(
      (picTitle "line")
      (MoveTo 40 70)
      (LineTo 130 70)>
   (TextSize 24)
   <putPict 'fix-divide '(
      (MoveTo 12 60)
      (rsrcStr "divd") >
   <putPict 'fix-split '(
      (MoveTo 12 60)
      (rsrcStr "linon") >
   (TextSize 12)
   <putPict 'fix-round '(
      (picTitle "rnd1")
      (MoveTo 16 40) (rsrcStr "rnd2")
      (MoveTo 140 30)
      (LineTo 140 80)
      (LineTo 90 80)
      (FrameArc '((90 . 30) 190 . 130) 0 -90) >
   <putPict 'fix-rule '(
      (picTitle "rule")
      (local (h)
         (setq h (NewRgn))
         (OpenRgn)
         (ShowPen)
         (MoveTo 50 90)
         (LineTo 60 40)
         (LineTo 120 30)
         (LineTo 150 90)
         (LineTo 50 90)
         (HidePen)
         (CloseRgn h)
         (InsetRgn h 5 5)
         (FrameRgn h)
         (DisposeRgn h) >
   (TextSize 24)
   <putPict 'fix-text '(
      (MoveTo 40 56)
      (rsrcStr "text") >
   <putPict 'fix-pict '(
      (MoveTo 20 56)
      (rsrcStr "pict") >
   <putPict 'fix-tint '(
      (MoveTo 40 56)
      (rsrcStr "tint") >
   <putPict 'fix-gradation '(
      (MoveTo 12 56)
      (rsrcStr "grad") >
   (TextSize 0) >

[++ FixMenu commands ++]
<de fix-baseLine (pt)
   (setq *lastFix fix-baseLine)
   (if (get *app 'digi)
         (digibline pt)
         (mousebline pt) >

<de fix-divide ()
   (local (f m)
      (setq f (get *app 'figures))
      (setq m)
      (mapc *mark '((fig) (may initDiv fig)))
      <mapc *mark
         '((fig)
            (local (l)
               (when (setq l (may divide fig))
                  (setq m (append l m))
                  (setq f
                     (mapcan f
                        '((x)
                           (if (eq x fig)
                              l
                              (list x) >
      (when m
         (make
            "Divide"
            (list *mark (get *app 'figures))
            '((om of)
               (mapc *mark invalFig)
               (mapc
                  (setq *mark om)
                  invalFig )
               (put *app 'figures of) )
            (list m f)
            '((m f)
               (mapc *mark invalFig)
               (mapc
                  (setq *mark m)
                  invalFig )
               (put *app 'figures f) >

<de fix-split (pt)
   (setq *lastFix fix-split)
   (local (*poly fig1 fig2 bz f m b nm)
      (when *mark
         (polyLine pt)
         (dPoly *poly)
         (when (lessp 1 (length *poly))
            (setq m *mark)
            (setq   b (bzHybrid *poly))
            (setq f (get *app 'figures))
            (mapc *mark
               '((fig)
                  (unMark fig)
                  (invalFig fig)
                  (setq
                     fig1 (new (list 'empty 'polygon))
                     fig2 (new (list 'empty 'polygon)) )

                  (when (setq bz (doSplit (get fig 'bezier) b))
                     (adjBez fig1 (car bz))
                     (adjBez fig2 (cdr bz))
                     (setq f
                        (mapcan f
                           '((x)
                              (if (eq x fig)
                                 (list fig1 fig2)
                                 (list x) ) ) ) )
                     (mark fig1)
                     (mark fig2) ) ) )
            (setq nm *mark)
            (make
               "Split"
               (list m (get *app 'figures))
               '((m of)
                  (mapc *mark invalFig)
                  (mapc (setq *mark m) invalFig)
                  (put *app 'figures of) )
               (list nm f)
               '((nm f)
                  (mapc *mark invalFig)
                  (mapc (setq *mark nm) invalFig)
                  (put *app 'figures f) ) >

<de fix-round (c)
   (local (r)
      (when
         (and
            *mark
            (setq r
               (editNumber
                  (or (get (car *mark) 'radius) 0)
                  "Radius: "
                  c ) ) )
         (make
            "Rounded Corner"
            (list
               (mapcar *mark
                  '((fig)
                     (list
                        (get fig 'radius)
                        (get fig 'bezier)
                        (cadr (class fig)) ) ) ) )
            '((lst)
               (mapc2 *mark lst
                  '((fig x)
                     (put fig 'radius (nth 0 x))
                     (store (nth 2 x) (class fig) 1)
                     (adjBez fig (nth 1 x)) ) ) )
            (list r)
            '((r)
               (mapc *mark
                  '((fig)
                     (local (bz)
                        (setq bz (get fig 'bezier))
                        (put fig 'radius r)
                        (InvalFig fig)
                        (if (get fig 'corner)
                           (progn
                              (adjBez
                                 fig
                                 (rndBez bz r (get fig 'corner)) )
                              (store 'Shape (class fig) 1) )
                           (progn
                              (for (i 0 (mul2 (length bz)))
                                 (when (setq c (getCorner i bz))
                                    (setq bz (rndBez bz r i)) ) )
                              (adjBez fig bz)
                              (store 'Shape (class fig) 1) >

<de rulePt1 (siz)
   (local (d1 d2)
      (setq
         d1 (parall a b siz)
         d2 (parall b c siz) )
      (intSec
         (cons (add (car d1) (car a)) (add (cdr d1) (cdr a)))
         (cons (add (car d1) (car b)) (add (cdr d1) (cdr b)))
         (cons (add (car d2) (car b)) (add (cdr d2) (cdr b)))
         (cons (add (car d2) (car c)) (add (cdr d2) (cdr c)))
         t >

<de rulePt (a b c g)
   (local (pt)
      (if (minusp rSiz)
         (if (and (setq pt (rulePt1 rSiz)) (inGraf pt g))
            pt
            (and
               (setq pt (rulePt1 (minus rSiz)))
               (inGraf pt g)
               pt ) )
         (if (and (setq pt (rulePt1 rSiz)) (not (inGraf pt g)))
            pt
            (and
               (setq pt (rulePt1 (minus rSiz)))
               (not (inGraf pt g))
               pt >

<de fix-rule ()
   (local (w c)
      (when
         (and
            *mark
            (setq w (editNumber 0 "Rule: "))
            (setq c (tintDialog (0 0 0 100))) )
         (SetCursor (ptr (GetCursor watchCursor)))
         (make
            "Rule"
            (list
               (mapcar *mark
                  '((fig)
                     (list
                        (get fig 'rule)
                        (get fig 'rBez)
                        (get fig 'rRgn)
                        (get fig 'rTint) ) ) ) )
            '((lst)
               (mapc2 *mark lst
                  '((fig x)
                     (invalFig fig)
                     (put fig 'rule (pop x))
                     (put fig 'rBez (pop x))
                     (put fig 'rRgn (pop x))
                     (put fig 'rTint (car x))
                     (invalFig fig) ) ) )
            (list w c)
            '((w c)
               (mapc *mark
                  '((fig)
                     (invalFig fig)
                     (put fig 'rule w)
                     (put fig 'rRgn
                        (dynamo
                           DisposeRgn
                           (bezRgn
                              (put fig 'rBez
                                 (border (get fig 'bezier) w) )
                              (get *app 'scale) ) ) )
                     (put fig 'rTint c)
                     (XorRgn
                        (getFigRgn fig)
                        (ref (get fig 'rRgn))
                        (ref (get fig 'rRgn)) )
                     (invalFig fig) >

<de fix-text ()
   (local (txt)
      (when (and *mark *texte)
         (mapc (reverse *mark)
            '((fig)
               (rplaca (class fig) 'texted)
               (put fig 'graf
                  (graf
                     (list
                        (bezPlot (get fig 'bezier) (get *app 'scale)) ) ) )
               (invalFig fig) ) )
         (put (car *mark) 'text
            (if *texte
               (do make (car *texte))
               [ ... Get file ... ] ) )
         (formText (car *mark)) >

<de fix-pict ()
   (local (fig vol nm)
      (setq
         fig (car *mark)
         vol (GetVol)
			nm (getFile "INX8") )
      (when (and *mark nm  (needmem nm) )
         (setq nm (nconc (path) nm))
         (SetVol vol)
         (make
            "Picture"
            (list
               (mapcar *mark '((fig) (car (class fig))))
               (mapcar *mark '((fig) (copy (plist fig)))) )
            '((c x)
               (mapc2 *mark c
                  '((fig c) (rplaca (class fig) c)) )
               (mapc2 *mark x
                  '((fig l)
                     (setplist fig l)
                     (invalFig fig) ) ) )
            (list nm fig)
            '((nm fig)
               (readPict nm fig)
               (InvalRgn (getFigRgn fig))
               (mapc (cdr *mark)
                  '((x)
                     (InvalRgn (getFigRgn x))
                     (rplaca (class x) 'pictured)
                     (with x
                        (slot picture nm)
                        (slot pScale (get fig 'pScale))
                        (slot freeLine)
                        (slot base (get fig 'base))
                        (slot pixMap (get fig 'pixMap))
                        (slot pixBox
                           (OffsetRect
                              (get fig 'pixBox)
                              (scale1
                                 (sub
                                    (left (slot rgnBBox))
                                    (left (get fig 'rgnBBox)) ) )
                              (scale1
                                 (sub
                                    (top (slot rgnBBox))
                                    (top (get fig 'rgnBBox)) >

<de doTint (c)
   (when *mark
      (make
         "Tint"
         (list
            (mapcar *mark
               '((fig)
                  (cons
                     (car (class fig))
                     (get fig 'tint) ) ) ) )
         '((lst)
            (mapc2 *mark lst
               '((fig x)
                  (rplaca (class fig) (car x))
                  (put fig 'tint (cdr x))
                  (InvalRgn (getFigRgn fig)) ) ) )
         (list c)
         '((c)
            (mapc *mark
               '((fig)
                  (rplaca (class fig) 'tinted)
                  (put fig 'tint c)
                  (InvalRgn (getFigRgn fig)) >

<de fix-tint ()
   (local (c)
      (when
         (setq c
            (tintDialog (or (get (car *mark) 'tint) (car *tints))) )
         (doTint c)
         (doYMCK c) >

<de fix-gradation ()
   (local (fig x grad gRes)
      (setq fig (car *mark))
      (when
         (and
            *mark
            (setq grad
               (gradDialog
                  fig
                  (get fig 'gRes)
                  (get (get fig 'gradation) 'grad)) )
            (setq gRes (pop grad))
            (setq x
               (new 'gradation
                  (right (car grad))
                  (bottom (car grad))
                  (cdr grad) ) ) )
         (make
            "Gradation"
            (list
               (mapcar *mark
                  '((fig)
                     (cons
                        (car (class fig))
                        (copy (plist fig)) ) ) ) )
            '((l)
               (mapc2 *mark l
                  '((fig l)
                     (rplaca (class fig) (car l))
                     (setplist fig (cdr l))
                     (invalFig fig) ) ) )
            (list x gRes)
            '((x gRes)
               (mapc *mark
                  '((fig)
                     (rplaca (class fig) 'gradated)
                     (put fig 'gradation x)
                     (put fig 'gRes gRes)
                     (invalFig fig) >


(object fixMenu window)

<to init (obj)
   (localPort
      (put obj 'winPtr
         (NewWindow nil *fixWinRect nil nil plainDBox -1 nil obj) )
      (put obj 'cmdWin
         (NewWindow
            nil
            (OffsetRect
               *pictRect
               (caar *fixWinRect)
               (add 10 (cddr *fixWinRect)) )
            nil nil altDBoxProc ) )
      (initFixMenu)
      [#(not $debug) (off initFixMenu) ]
      >

<to update (obj)
   (from window update obj
      '(()
         (mapc *fixCmds
            '((x)
               (FrameRect (get x 'rect))
               (DrawPicture (get x 'pict) (get x 'rect)) >

<to content (obj pt)
   (local (*app w cmd)
      (with obj
         (setq
            *app (slot app)
            w (slot cmdWin) )
         (localPort (slot winPtr)
            (GlobalToLocal pt)
            (setq cmd
               (find *fixCmds
                  '((x) (PtInRect pt (get x 'rect))) ) ) )
         (SetWindowPic w (get cmd 'pict))
         (ShowWindow w)
         ((value 'cmd))
         (HideWindow w) >

t
