[gradDlg.l 23feb90]

(setq $point (0 . 0))
(setq $gLines)
(setq $gl)

(setq $gradEditItems (3 4 5 6))

<de cornToCent (n pt)
   (cons2
     (sub (car pt) n)
     (sub (cdr pt) n)
     (add (car pt) n)
     (add (cdr pt) n) >

<de drawGl (gl)
   (local (s)
      (setq s (if (eq gl $gl) 3 1))
      (PenNormal)
      (PenMode patXor)
      (PenSize s s)
      (if (pointp (caar gl))
         (line2 (caar gl) (cdar gl))
         (FrameOval (cornToCent (caar gl) (cdar gl))) >

<de gCols ()
   (list
      (min 100 (number (GetIText (d-item 3))))
      (min 100 (number (GetIText (d-item 4))))
      (min 100 (number (GetIText (d-item 5))))
      (min 100 (number (GetIText (d-item 6)))) >

<de set$gl (n)
   (local (o c)
      (when (setq o $gl)
         (drawGl o)
         (rplacd o (gCols)) )
      (when (memq n $gLines)
         (drawGl n) )
      (setq $gl n)
      (when o
         (drawGl o) )
      (when n
         (drawGl n)
         (setq c (cdr n))
         (PenNormal)
         (SetIText (d-item 3) (format (pop c)))
         (SetIText (d-item 4) (format (pop c)))
         (SetIText (d-item 5) (format (pop c)))
         (SetIText (d-item 6) (format (pop c)))
         (SelIText *dlg 3 0 9999) )
      n >

<de showGrads ()
   (PenNormal)
   (PenSize 2 2)
   (FrameRect rct)
   (PenSize 1 1)
   (FrameRgn rgn)
   (mapc $gLines drawGl) >

<de gradDialog (fig gRes $gLines)
   (local (*grid *spot bb bez rct rct1 itemHit col l rgn f fmax bx by h v s)
      (off *grid *spot)
      (setq $gl)
      (default gRes 2)
      (when fig
         (setq bb (get fig 'rgnBBox))
         (setq col)
         (setq rct (cons (200.10)(590.400)))
         (setq rct1 (cons (0.0)(200.200)))
         (setq fmax
            (max
               (sub (right bb) (left bb))
               (sub (bottom bb) (top bb)) ) )
         (setq f
            (div
               (add fmax (sub1 (sub (right rct1) (left rct1))))
               (sub (right rct1) (left rct1)) ) )
         (setq bx (cons (div (left bb) f) (div (top bb) f)))
         (setq by (cons (div (right bb) f) (div (bottom bb) f)))
         (setq by
            (cons
               (sub (car by) (car bx))
               (sub (cdr by) (cdr bx)) ) )
         (setq bx (0.0))
         (setq h
            (add
               (div2 (sub (right rct1) (car by)))
               (caar rct)
               (div2
                  (sub
                     (sub (right rct) (left rct))
                     (sub (right rct1) (left rct1)) ) ) ) )
         (setq v
            (add
               (div2 (sub (bottom rct1) (cdr by)))
               (top rct)
               (div2
                  (sub
                     (sub (bottom rct) (top rct))
                     (sub (bottom rct1) (top rct1) ) ) ) ) )
         (setq s (mul gRes (get *app 'scale)))
         (setq $gLines
            (mapcar $gLines
               '((l)
                  (cons
                     (cons
                        (if (numberp (caar l))
                           (div (mul s (caar l)) f)
                           (cons
                              (add h (div (mul s (caaar l)) f))
                              (add v (div (mul s (cdaar l)) f)) ) )
                        (cons
                           (add h (div (mul s (cadar l)) f))
                           (add v (div (mul s (cddar l)) f)) ) )
                     (cdr l) ) ) ) )
         (setq bez (copyBez
               (get fig 'bezier)
               (scale (car bb))(scale (cdr bb))
               (scale bx) (scale by) ) )
         (setq rgn (bezrgn bez (get *app 'scale)))
         (setq *dlgEditItems $gradEditItems)
         (setq *dlg (GetNewDialog gradDlg nil -1) )
         (localPort *dlg
            (OffsetRgn rgn h v)
            (showGrads)
            (case gRes
               (1 (SetCtlValue (d-item 19) 1))
               (2 (SetCtlValue (d-item 20) 1))
               (4 (SetCtlValue (d-item 18) 1)) )
            (set$gl (car $gLines))
            (while (lessp 2 (ModalDialog gradFilter itemHit))
               (case itemHit
                  (15
                     (and
                        (setq l (inLine))
                        (push (set$gl (cons l (gCols))) $gLines) ) )
                  (16
                     (and
                        (setq l (inCircle))
                        (push (set$gl (cons l (gCols))) $gLines) ) )
                  (17
                     (when $gl
                        (drawGl $gl)
                        (setq $glines (delete $gl $glines))
                        (setq $gl)
                        (set$gl (car $glines)) ) )
                  (18 (SetCtlValue (d-item 18) 1)
                     (SetCtlValue (d-item 19) 0)
                     (SetCtlValue (d-item 20) 0)
                     (setq gRes 4) )
                  (19 (SetCtlValue (d-item 19) 1)
                     (SetCtlValue (d-item 18) 0)
                     (SetCtlValue (d-item 20) 0)
                     (setq gRes 1) )
                  (20 (SetCtlValue (d-item 18) 0)
                     (SetCtlValue (d-item 19) 0)
                     (SetCtlValue (d-item 20) 1)
                     (setq gRes 2) ) ) )
            (prog1
               (when (eq 1 itemHit)
                  (set$gl)
                  (setq s (mul gRes (get *app 'scale)))
                  (cons
                     gRes
                     (cons
                        (cons2 0 0
                           (div (mul f (car by)) s)
                           (div (mul f (cdr  by)) s) )
                        (mapcar $gLines
                           '((l)
                              (cons
                                 (cons
                                    (if (numberp (caar l))
                                       (div (mul f (caar l)) s)
                                       (cons
                                          (div (mul f (sub (caaar l) h)) s)
                                          (div (mul f (sub (cdaar l) v)) s) ) )
                                    (cons
                                       (div (mul f (sub (cadar l) h)) s)
                                       (div (mul f (sub (cddar l) v)) s) ) )
                                 (cdr l) ) ) ) ) ) )
               (DisposDialog *dlg)
               (DisposeRgn rgn  >

<de gradFilter (theDialog theEvent itemHit)
   (local (gl bp1 bp2 h v lpt r pt1 pt2 hptx hpty)
      (gc 1000)
      (GetMouse $point)
      (setq gl
         (find $gLines
            '((c)
               (and
                  (PtInRect $point rct)
                  (if (pointp (caar c))
                     (and
                        (setq lpt (lotPoint (caar c) (cdar c) $point))
                        (lessp (distPt $point lpt) 3) )
                     (lessp
                        (sub2 (caar c))
                        (distpt $point (cdar c))
                        (add2 (caar c)) ) ) ) ) ) )
      (SetCursor
         (if (find *dlgEditItems '((x) (mouseInCtl theDialog x)))
            (ptr (GetCursor iBeamCursor))
            (if gl (ptr (GetCursor crossCursor)) *arrow) ) )
      (unless gl
         (setq gl
            (and
               (numberp (caar $gl))
               (lessp (distPt $point (cdar $gl)) (sub2 (caar $gl)))
               $gl ) ) )
      (when (and gl (eq mouseDown (ev-what theEvent)))
         (if (neq gl $gl)
            (set$gl gl)
            (progn
               (drawGl $gl) [+ weg +]
               (if (pointp (caar $gl))
                  (progn
                     (setq bp1 (caar $gl))
                     (setq bp2 (cdar $gl))
                     (PenNormal)
                     (line2 bp1 bp2)
                     (cond
                        ((lessp (distpt bp1 $point) 3)
                           (setq bp1
                              (drag bp1
                                 '((oldpt newpt)
                                    (line2 oldPt bp2)
                                    (line2 newPt bp2) ) ) ) )
                        ((lessp (distpt bp2 $point) 3)
                           (setq bp2
                              (drag bp2
                                 '((oldpt newpt)
                                    (line2 bp1 oldPt)
                                    (line2 bp1 newpt) ) ) ) )
                        (t
                           (drag $point
                              '((oldPt newPt)
                                 (line2 bp1 bp2)
                                 (setq
                                    h (sub (car newpt) (car oldpt))
                                    v (sub (cdr newpt) (cdr oldpt))
                                    bp1 (cons
                                       (add h (car bp1))
                                       (add v (cdr bp1)) )
                                    bp2 (cons
                                       (add h (car bp2))
                                       (add v (cdr bp2)) ) )
                                 (line2 bp1 bp2) ) ) ) )
                     (line2 bp1 bp2)
                     (rplaca $gl (cons bp1 bp2)) )
                  (progn
                     (setq r (cornToCent (caar $gl) (cdar $gl)))
                     (PenNormal)
                     (FrameOval r)
                     (if
                        (lessp
                           (distpt (cdar $gl) $point)
                           (sub2 (caar $gl)) )
                        (drag $point
                           '((oldPt newPt)
                              (FrameOval r)
                              (setq
                                 h (sub (car newpt) (car oldpt))
                                 v (sub (cdr newpt) (cdr oldpt))
                                 r (cons2
                                    (add h (caar r))
                                    (add v (cdar r))
                                    (add h (cadr r))
                                    (add v (cddr r)) ) )
                              (FrameOval r) ) )
                        (drag $point
                           '((oldPt newPt)
                              (FrameOval r)
                              (setq r
                                 (cornToCent
                                    (distPt newPt (cdar $gl))
                                    (cdar $gl) ) )
                              (FrameOval r) ) ) )
                     (FrameOval r)
                     (setq pt2
                        (cons (cadr r)
                           (add (sub (cadr r)(caar r))(cdar r) ) ) )
                     (setq hptx
                        (add
                           (caar r)
                           (div2 (sub (car pt2) (caar r))) ) )
                     (setq hpty
                        (add (cdar r)
                           (div2 (sub (cdr pt2) (cdar r))) ) )
                     (setq pt1 (cons hptx hpty))
                     (rplaca $gl
                        (cons (sub (car pt2) (car pt1)) pt1) ) ) )
               (drawGl $gl) ) ) )
   [(and
      (eq nullEvent (ev-what theEvent))
      (GetNextEvent app1Mask theEvent)
      (ev-what theEvent mouseDown) )]
   (when (eq keyDown (ev-what theEvent))
      (case (bitand charCodeMask (ev-message theEvent))
         ((3 13) (word itemHit 1))
         (#helpKey
            (*help)
            (showGrads)
            (word itemHit 9999) >

t [gradDlg.l]
