[minput.l 07nov89rf]

[++ New figure in page ++]
<de newFigure (cl pt)
   (local (fig)
      (setq fig (new (list 'empty cl)))
      (when (do input fig pt (if (get *app 'digi) 'digi 'mouse))
         (make
            "Figure"
            (list *mark)
            '((m)
               (removeFig *mark)
               (setq *mark)
               (mapc m mark) )
            (list fig)
            '((fig)
               (mapc *mark unMark)
               (adjBez fig (get fig 'bezier))
               (InvalRect (get fig 'frame2))
               (put *app 'figures
                  (append (get *app 'figures) (list fig)) )
               (mark fig) >

<de polyLine (pt)
   (when (setq pt (or pt (click)))
      (setq *poly (list (scale pt)))
      (while
         (or
            (setq pt
               (click
                  (unScale (car *poly))
                  '((oldPt newPt)
                     (line2 oldPt newPt) )
                  '((oldPt newPt)
                     (if (listp (caadr *poly))
                        (line2 oldPt newPt)
                        (hybArc
                           (cadr *poly)
                           (scale newPt)
                           (scale oldPt) ) ) )
                  t ) )
            (c-key) )
         (if (c-key)
            (drawBack)
            (progn
               (setq pt (scale pt))
               (if (and (not (listp (caadr *poly))) *click)
                  (progn
                     (line2 (unScale (car *poly)) (unScale (cadr *poly)))
                     (hybArc (cadr *poly) pt (car *poly))
                     (rplacd *poly (cons (list pt) (cdr *poly))) )
                  (progn
                     (line2 (unScale (car *poly)) (unScale pt))
                     (push pt *poly) >


<de fix-line (pt)
   (setq *lastFix fix-line)
   (newFigure 'linePoly pt) >

<de rightorder (p1 p2 )       [+++ orders the coordinates of a rectangle in top                                     left, bottom right+++]
   (setq pt1
      (cons
         (min (car p1) (car p2))
         (min (cdr p1) (cdr p2)) ) )
   (setq pt2
      (cons
         (max (car p1) (car p2))
         (max (cdr p1) (cdr p2)) >

<de fix-rect (pt)
   (setq *lastFix fix-rect)
   (newFigure 'rectangle pt) >


<de fix-circle (pt)
   (setq *lastFix fix-circle)
   (newFigure 'Circle pt) >

[Let user input a polygon]
<de hybArc (pt1 pt pt2)
   (setq
      pt1 (unScale pt1)
      pt (unScale pt)
      pt2 (unScale pt2) )
   (local (c r rct arc)
      (when (setq c (centre pt1 pt pt2))
         (setq
            r (distPt c pt)
            rct
            (cons2
               (sub (car c) r)
               (sub (cdr c) r)
               (add (car c) r 1)
               (add (cdr c) r 1) )
            pt (PtToAngle rct pt)
            pt1 (PtToAngle rct pt1)
            pt2 (PtToAngle rct pt2)
            arc (mod (sub pt2 pt1 -360) 360) )
         (FrameArc
            rct
            pt1
            (if (lessp (mod (sub pt pt1 -360) 360) arc)
               arc
               (sub arc 360) >

<de drawBack ()
   (when (lessp 1 (length *poly))
      (if (listp (caadr *poly))
         (hybArc (pop *poly) (car (pop *poly)) (car *poly))
         (line2 (unScale (pop *poly)) (unScale (car *poly))) >

<de makePoly (fig)
   (dPoly
      (setq *poly (reverse *poly)) )
   (when (lessp 2 (length *poly))
         (put fig 'bezier (bzHybrid *poly)) >


<de fix-poly (pt)
   (setq *lastFix fix-poly)
   (newFigure 'shape pt) >

<de circlePoint (pt r a)
   (setq a (div (add a 500) 1000))
   (cons
      (div
         (add (mul 10000 (car pt)) (mul r (sin a)))
         (mul 100 (get *app 'scale)) )
      (div
         (add (mul 10000 (cdr pt)) (mul r (minus (cos a))))
         (mul 100 (get *app 'scale)) >


<de ptOnCircle (p1 p2 pc)
   (local (r d)
      (setq
         r (distPt p1 p2)
         d (distPt p1 pc) )
      (if (zerop d)
         p1
         (cons
            (add
               (car p1)
               (div
                  (mul
                     r
                     (sub (car pc) (car p1)) )
                  d ) )
            (add
               (cdr p1)
               (div
                  (mul
                     r
                     (sub (cdr pc) (cdr p1)) )
                  d >

<de fanRect (c pt)
   (local(r rct)
      (setq
         r (distPt c pt)
         rct
         (cons2
            (sub (car c) r)
            (sub (cdr c) r)
            (add (car c) r 1)
            (add (cdr c) r 1) ) )
      rct >


<de fix-fan (pt)
   (setq *lastFix fix-fan)
   (newFigure 'Fan pt) >



[++++++calculates the mouseoblong-coordinates and returns the points in the right order++++]

<de mOblcoord (p1 p2 flg)
   (local (pt1 pt2 ptc ptd)
      (when (and (lessp (cdr p1) (cdr p2)) (lessp (car p1) (car p2)))  [rectangle was dragged to  bottom right]
         (setq ptd p1)
         (setq pt1 (cons (car ptd) (cdr p2)) )
         (setq ptc (cons (car p2) (cdr ptd)) )
         (surrect (scale pt1) (scale p2) (scale ptc) (scale ptd) flg) )
      (when (and (lessp (cdr p2) (cdr p1)) (lessp (car p2) (car p1)))  [rectangle was dragged to top left ]
          (setq ptd p2)
          (setq pt2 p1)
          (setq pt1 (cons (car p2)(cdr p1)) )
          (setq ptc (cons (car p1)(cdr p2)) )
          (surrect (scale pt1) (scale pt2) (scale ptc) (scale ptd) flg) )
       (when (and (lessp (car p2)(car p1)) (lessp (cdr p1)(cdr p2)))    [rectangle was dragged to bottom left]
          (setq ptc p1)
          (setq pt1 p2)
          (setq pt2 (cons (car p1)(cdr p2)))
          (setq ptd (cons (car p2)(cdr p1)))
          (surrect (scale pt1) (scale pt2) (scale ptc) (scale ptd) flg) )
       (when (and (lessp (car p1)(car p2)) (lessp (cdr p2)(cdr p1)))    [rectangle was dragged to top right]
          (setq ptc p2)
          (setq pt2 (cons (car p2)(cdr p1)))
          (setq ptd (cons (car p1)(cdr p2)))
          (surrect (scale p1) (scale pt2) (scale ptc) (scale  ptd) flg) )

>

<de surrect (a b c d flg)           [surounded rectangle of oblong normal]
   (local (n pa pb pc pd paa pba pda pca)
      (setq paa)
      (setq pba)
      (setq pca)
      (setq pda)
      (setq pa a
          pb b
          pc c
          pd d )            [ horizontal rectangle]
      (when (lessp (sub (cdr a) (cdr c))  (sub (car b)(car a)))
         (setq n (div2 (sub (cdr a) (cdr d))))
         (when (and (not flg) (not (c-key)))
          (setq pa (cons (add (car a) n) (cdr a)))
          (setq pd (cons (add (car d) n) (cdr d)))
          (setq pc (cons (sub (car c) n) (cdr c)))
          (setq pb (cons (sub (car b) n) (cdr b))) )
         (setq pba (list (cons (if (or flg (c-key))
                             (sub (car pb) n)
                             (add n (car pb)) )
                             (sub (cdr pb) n))))
         (setq pda (list (cons (if (or flg (c-key))
                            (add (car pd) n)
                            (sub (car pd) n) )
                            (add (cdr pd) n))))
         (setq points (list pb pba pc pd pda pa )) )

         [vertical rectangle]

       (when (lessp (sub (car b)(car a)) (sub (cdr a) (cdr c)))
         (setq n (div2 (sub (car c) (car d))))
        (when (and (not flg) (not (c-key)))
           (setq pa (cons (car a) (sub (cdr a) n)))
           (setq pb (cons (car b) (sub (cdr b) n)))
           (setq pc (cons (car c) (add (cdr c) n)))
           (setq pd (cons (car d) (add (cdr d) n))) )
         (setq paa (list (cons (add n (car pa))
                           (if (or flg (c-key))
                             (sub (cdr pa) n)
                             (add n (cdr pa)) ) ) ) )
         (setq pca (list (cons (sub (car pc) n)
                              (if (or flg (c-key))
                                 (add (cdr pc) n)
                                 (sub (cdr pc) n) ) ) ) )
         (setq points (list pa paa pb pc pca pd )) )


>
[+returns the centerpoint of a rectangle, geven by two points, topleft,botri++]
<de zentrum (a b)
   (cons
      (add (car a)(div2(sub (car b)(car a))))
      (add (cdr a)(div2(sub (cdr b)(cdr a)))) )
 >

<de quadrat (pt1 pt2)
   (if (eq (abs(sub (car pt2)(car pt1)))
         (abs(sub (cdr pt2)(cdr pt1))) )
      t
      nil
>


<de fix-oblong (pt)
   (setq *lastFix fix-oblong)
   (newFigure 'Oblong pt) >


<de fix-ellipse (pt)
   (setq *lastFix fix-ellipse)
   (newFigure 'ellipse pt) >

t [mInput.l]
