[pagePrim.l 20nov89abu]

<de tolTest (a b)
   (if (lessp 0 (abs (sub a b)) 100) t) >

<de pTest (a b c d)
   (local (s1 s2)
      (when (and a b c d)
         (cond
            ((and
               (eq 0 (abs (sub (car b)(car a))))
               (eq 0 (abs (sub (car d)(car c)))) )t )
            ((and
               (eq 0 (abs (sub (cdr a)(cdr b))))
               (eq 0 (abs (sub (cdr c)(cdr d)))) )t )

            ((eq 0 (abs (sub (car b)(car a)))) nil)

            ((eq 0 (abs (sub (car d)(car c)))) nil)

            (t
               (setq s1 (div (sub (cdr a)(cdr b))
                               (sub (car b)(car a))))
               (setq s2 (div (sub (cdr c)(cdr d))
                               (sub (car d)(car c))))
               (if (eq s1 s2) t nil) >

<de findFigure (pt)
   (local (fig)
      (setq fig nil)
      (mapc (get *app 'figures)
         '((x)
            (when
               (if (memq x *mark)
                  (PtInRect pt (get x 'frame2))
                  (PtInRgn pt (getFigRgn x)) )
               (setq fig x) ) ) )
      fig >

<de invalFig (fig)
   (invalCorner fig)
   (when (get fig 'rule)
      (InvalRgn (ref (get fig 'rRgn))) )
   (InvalRect (get fig 'frame2)) >

<de invalMarked ()
   (mapc *mark invalFig) >

<de scale1 (n)
   (div (mul 100 n) (get *app 'scale)) >

<de scale (pt)
   (cons
      (scale1 (car pt))
      (scale1 (cdr pt)) >

<de putFig (lst)
   (mapc *mark unMark)
   (mapc lst
      '((fig)
         (adjBez fig (get fig 'bezier)) ) )
   (put *app 'figures
      (append (get *app 'figures) lst) )
   (mapc lst mark) >

<de removeFig (lst)
   (mapc lst
      '((fig)
         (put *app 'figures
            (delete fig (get *app 'figures)) )
         (invalFig fig) ) ) >

<de setPageColor (p)
   (RGBBackColor (apply rgb (get p 'backColor))) >

<de arac (bez)
(local (a b)
   (off a)
   (while bez
      (if (pointp (setq b (pop bez)))
         (push b a)
         (while b
            (push (pop b) a)
            (pop b)
            (pop b) ) ) )
   (setq a (reverse a))
   (eq a (areacalc a)) >

<de revbez (bez)
   (if (leq (length bez) 1)
      (list (cons (caar bez) (reverse (cdar bez))))
      (local (spf a b c p1)
         (off a spf)
         (while bez
            (if (pointp (car bez))
               (push (pop bez) a)
               (progn
                  (setq c (pop bez))
                  (setq p1 (pop c))
                  (setq b (reverse c))
                  (if
                     (or
                        spf
                        (pointp (car a))
                        (not a) )
                     (progn
                        (push p1 a)
                        (setq spf) ) )
                  (if     [single line between dim3s ]
                     (and
                        (pointp (car bez))
                        (pointp (caadr bez)) )
                     (setq spf t) )
                  (push
                     (if (pointp (car bez))
                        (pop bez)
                        (caar bez) )
                     b )
                  (push b a) ) ) )
         a >

<de mirror (bez x)
   (revBez
      (mapcar bez '((z)
            (if (pointp z)
               (cons (sub x (sub (car z) x))
                  (cdr z) )
               (mapcar z '((y)
                     (cons (sub x (sub (car y) x))
                        (cdr y) >

<de pt-bez (pt)
   (cons
      (mul 100 (car pt))
      (mul 100 (cdr pt)) >

<de bez-pt (pt)
   (cons
      (div (car pt) 100)
      (div (cdr pt) 100) >

<de ecke (a b d e)
   (local (pt)
      (and
         (lessp (distPt b d) (distPt a e))
         (setq pt (intsec a b d e t))
         (inView (unScale (bez-pt pt)) *port)
         pt >

<de putFigRgn (fig x)
   (put fig 'region (dynamo DisposeRgn x)) >

<de getFigRgn (fig)
   (ref (get fig 'region)) >

<de offsetBez (bez h v)
   (mapcar bez
      '((x)
         (if (pointp x)
            (cons
               (add (car x) h)
               (add (cdr x) v) )
            (mapcar x
               '((y)
                  (cons
                     (add (car y) h)
                     (add (cdr y) v) ) ) >

[++++++++++++
[++ Give figure a new bezier ++]
<de aBez (fig bez)
   (invalFig fig)
   (putFigRgn fig
      (bezRgn (put fig 'bezier bez) (get *app 'scale)) )
   (adjFig fig)
   (invalFig fig) >

[++ Adjust misc. properties ++]
<de adjFig (fig)
   (local (r h v)
      (when (EmptyRgn (getFigRgn fig))
         (generalAlert
            "Warning!"
            "Figure was reduced to an empty area."
            "Please UNDO this operation!" ) )
      (when (get fig 'graf)
         (put fig 'graf
            (graf (bezPlot (get fig 'bezier) (get *app 'scale))) ) )
      (when (get fig 'text1)
         (formText fig) )
      (when (get fig 'rule)
         (put fig 'rRgn
            (dynamo
               DisposeRgn
               (bezRgn
                  (put fig 'rBez
                     (border
                        (get fig 'bezier)
                        (get fig 'rule) ) )
                  (get *app 'scale) ) ) )
         (XorRgn
            (getFigRgn fig)
            (ref (get fig 'rRgn))
            (ref (get fig 'rRgn)) ) )
      (setq r (rgnBBox (getFigRgn fig)))
      (put fig 'rgnBBox r)
      (put fig 'frame1 (InsetRect r -2 -2))
      (setq r
         (put fig 'frame2 (InsetRect r -4 -4)) )
      (setq
         h (div2 (add (left r) (right r)))
         v (div2 (add (bottom r) (top r))) )
      (put fig 'mark
         (list
            (cons (left r) (top r))
            (cons h (top r))
            (cons (sub (right r) dotSiz)  (top r))
            (cons (left r) v)
            (cons (sub (right r) dotSiz) v)
            (cons (left r) (sub (bottom r) dotSiz))
            (cons h (sub (bottom r) dotSiz))
            (cons (sub (right r) dotSiz) (sub (bottom r) dotSiz)) >
++++++++++++]

<de adjBez (fig bez)
   (local (r h v x)
      (when bez
         (putFigRgn fig
            (bezRgn (put fig 'bezier bez) (get *app 'scale)) ) )
      (when (EmptyRgn (getFigRgn fig))
         (generalAlert
            "Warning!"
            "Figure was reduced to an empty area."
            "Please UNDO this operation!" ) )
      (when (get fig 'graf)
         (put fig 'graf
            (graf
               (list
                  (bezPlot (get fig 'bezier) (get *app 'scale)) ) ) ) )
      (when (get fig 'text1)
         (formText fig) )
      (when (get fig 'rule)
         (put fig 'rRgn
            (dynamo
               DisposeRgn
               (bezRgn
                  (put fig 'rBez
                     (border
                        (get fig 'bezier)
                        (get fig 'rule) ) )
                  (get *app 'scale) ) ) )
         (XorRgn
            (getFigRgn fig)
            (ref (get fig 'rRgn))
            (ref (get fig 'rRgn)) ) )
      (setq r (rgnBBox (getFigRgn fig)))
      (put fig 'rgnBBox r)
      (put fig 'frame1 (InsetRect r -2 -2))
      (setq r
         (put fig 'frame2 (InsetRect r -4 -4)) )
      (setq
         h (div2 (add (left r) (right r)))
         v (div2 (add (bottom r) (top r))) )
      (put fig 'mark
         (list
            (cons (left r) (top r))
            (cons h (top r))
            (cons (sub (right r) dotSiz)  (top r))
            (cons (left r) v)
            (cons (sub (right r) dotSiz) v)
            (cons (left r) (sub (bottom r) dotSiz))
            (cons h (sub (bottom r) dotSiz))
            (cons (sub (right r) dotSiz) (sub (bottom r) dotSiz)) ) )
      (until (eq (cadr (class fig)) (setq x (may figtyp fig)))
         (store x (class fig) 1) )
      (invalFig fig) >

[+++ Change page scale +++]
<de changedPageBase ()
   (with *app
      (do change *app
         (dots (car (slot size)))
         (dots (cdr (slot size)))
         (slot name) >

<de doScale (n)
   (with *app
      (slot scale n)
      (mapc (slot figures)
         '((x) (adjBez x (get x 'bezier))) )
      (changedPageBase) >

<de chgScale (n)
   (when (neq n (get *app 'scale))
      (make
         "Change Layout Size"
         (list (get *app 'scale))
         '((x)
            (doScale x) )
         (list n)
         '((y)
            (doScale y) >

t [pagePrim.l]
