[peep.l 160390gr]

(setq $peepHMax 300)            [ max. possible pixelnumber per side ]
(setq $peepVMax 300)

(setq $point (0 . 0))

[+ position peepwindow +]
(setq $peeppos
   (#fmLeft . #(sub (cddr (rect (add 6 *screenBits))) 310)) )

[++ Flush dirty tiles to file ++]
<de flushTiles (h1 v1 h2 v2)
   (local (l b tile cols)
      (with (get *peep 'app)
         (setq
            l (slot* dirty)
            b (slot* base)
            cols (slot* cols)
            tile
            (add
               (slot* pos-h)
               (mul cols (slot* pos-v)) ) )
         (for (row v1 v2)
            (for (col h1 h2)
               (when (bit col (access l row))
                  (wrTile
                     (slot* fd)
                     (add tile col (mul row cols))
                     b
                     col
                     row )
                  (store (bitoff col (access l row)) l row) >

[++ Move in tile file  to new position ++]
<de mvPeep (dh dv)
   (unless (and (zerop dh) (zerop dv))
      (zapUndo)
      (local (h v b l)
         (with (get *peep 'app)
            (slot* pos-h
               (setq h (add dh (slot* pos-h))) )
            (slot* pos-v
               (setq v (add dv (slot* pos-v))) )
            (setq
               b (slot* base)
               l (slot* dirty) )
            (cond
               ((or (lessp 20 (abs dh)) (lessp 20 (abs dv)))
                  (flushTiles 0 0 20 20)
                  (readTiles (get *peep 'app) h v) )
               ((and (minusp dh) (minusp dv))
                  (flushTiles (add 20 dh) 0 20 20)
                  (flushTiles 0 (add 20 dv) 20 20)
                  (reptn (minus dv)
                     (shift l)
                     (push 0 l) )
                  (map l
                     '((x) (rplaca x (bitr (minus dh) (car x)))) )
                  (slot* dirty l)
                  <for (row (add 19 dv) -1 (sub1 row))
                     (for (col (add 19 dh) -1 (sub1 col))
                        (mvTile b col row (minus dh) (minus dv)) >
                  (readTiles (get *peep 'app) h v 0 0 (minus dh) 20)
                  (readTiles (get *peep 'app) h v 0 0 20 (minus dv)) )
               ((minusp dh)
                  (flushTiles (add 20 dh) 0 20 20)
                  (flushTiles 0 0 20 dv)
                  (chop dv l)
                  (reptn dv (nconc1 l 0))
                  (map l
                     '((x) (rplaca x (bitr (minus dh) (car x)))) )
                  (slot* dirty l)
                  <for (row dv 20)
                     (for (col (add 19 dh) -1 (sub1 col))
                        (mvTile b col row (minus dh) (minus dv)) >
                  (readTiles (get *peep 'app) h v 0 0 (minus dh) 20)
                  (readTiles (get *peep 'app) h v 0 (sub 20 dv)) )
               ((minusp dv)
                  (flushTiles 0 0 dh 20)
                  (flushTiles 0 (add 20 dv) 20 20)
                  (reptn (minus dv)
                     (shift l)
                     (push 0 l) )
                  (map l
                     '((x) (rplaca x (bitl dh (car x)))) )
                  (slot* dirty l)
                  <for (row (add 19 dv) -1 (sub1 row))
                     (for (col dh 20)
                        (mvTile b col row (minus dh) (minus dv)) >
                  (readTiles (get *peep 'app) h v (sub 20 dh) 0)
                  (readTiles (get *peep 'app) h v 0 0 20 (minus dv)) )
               (t
                  (flushTiles 0 0 dh 20)
                  (flushTiles 0 0 20 dv)
                  (chop dv l)
                  (reptn dv (nconc1 l 0))
                  (map l
                     '((x) (rplaca x (bitl dh (car x)))) )
                  (slot* dirty l)
                  <for (row dv 20)
                     (for (col dh 20)
                        (mvTile b col row (minus dh) (minus dv)) >
                  (readTiles (get *peep 'app) h v (sub 20 dh) 0)
                  (readTiles (get *peep 'app) h v 0 (sub 20 dv)) ) )
            (when *poly
               (rplaca clickAnchor
                  (sub
                     (car clickAnchor)
                     (mul 32 dh (slot zoom)) ) )
               (rplacd clickAnchor
                  (sub
                     (cdr clickAnchor)
                     (mul 32 dv (slot zoom)) ) ) )
            (refreshCmyks (slot home)) >

[++ Move Peep around ++]
<de dragPeep1 (pt)
   (local (sc rct1 rct2 h v dh dv)
      (with *peep
         (setq
            sc (slot scale)
            rct1 (portRect (slot winPtr)) )
         (with (slot app)
            (setq
               h (slot* pos-h)
               v (slot* pos-v) ) ) )
      (while (StillDown)
         (setq rct2 (peep1 h v))
         (GetMouse $point)
         (setq
            dh
            (sub
               (if (lessp (car $point) (car pt))
                  (sub
                     (max
                        (car $point)
                        (sub (car pt) (left rct2)) )
                     (div2 sc) )
                  (add
                     (min
                        (car $point)
                        (sub
                           (right rct1)
                           (sub (right rct2) (car pt)) ) )
                     (div2 sc) ) )
               (car pt) )
            dv
            (sub
               (if (lessp (cdr $point) (cdr pt))
                  (sub
                     (max
                        (cdr $point)
                        (sub (cdr pt) (top rct2)) )
                     (div2 sc) )
                  (add
                     (min
                        (cdr $point)
                        (sub
                           (bottom rct1)
                           (sub (bottom rct2) (cdr pt)) ) )
                     (div2 sc) ) )
               (cdr pt) )
            dh (sub dh (mod dh sc))
            dv (sub dv (mod dv sc)) )
         (drawPeep h v)
         (inc h (div dh sc))
         (inc v (div dv sc))
         (drawPeep h v)
         (setq pt
            (cons
               (add dh (car pt))
               (add dv (cdr pt)) ) ) )
      (with (get *peep 'app)
         (mvPeep
            (sub h (slot* pos-h))
            (sub v (slot* pos-v)) >

<de dragPeep2 (pt)
   (local (z ph pv rct hScl vScl h v h1 v1)
      (with (get *peep 'app)
         (setq
            z (slot zoom)
            ph (slot* pos-h)
            pv (slot* pos-v)
            rct (peep1 ph pv)
            hScl
            (div
               [(mul z 640000)]
               (mul z 1000 32 (min 20 (slot* cols)))
               (sub (right rct) (left rct)) )
            vScl
            (div
               [(mul z 640000)]
               (mul z 1000 32 (min 20 (slot* rows)))
               (sub (bottom rct) (top rct)) )
            rct (peep2 ph pv)
            h (mul 1000 (GetCtlValue (slot hsBar)))
            v (mul 1000 (GetCtlValue (slot vsBar)))
            h1 (mul 1000 (GetCtlMax (slot hsBar)))
            v1 (mul 1000 (GetCtlMax (slot vsBar))) ) )
      (while (StillDown)
         (GetMouse $point)
         (setq
            dh
            (limit
               (sub (car $point) (car pt))
               (div (minus (add 1000 h)) hScl)
               (div (sub h1 h) hScl) )
            dv
            (limit
               (sub (cdr $point) (cdr pt))
               (div (minus (add 1000 v)) vScl)
               (div (sub v1 v) vScl) ) )
         (FrameRect rct)
         (setq rct (OffsetRect rct dh dv))
         (FrameRect rct)
         (inc h (mul dh hScl))
         (inc v (mul dv vScl))
         (setq pt
            (cons
               (add dh (car pt))
               (add dv (cdr pt)) ) ) )
      (FrameRect rct)
      (setq
         h (div h 1000)
         v (div v 1000) )
      (with *peep
         (localPort (get (slot app) 'winPtr)
            (with (slot app)
               (SetCtlValue (slot hsBar) h)
               (SetCtlValue (slot vsBar) v) )
            (do refresh (slot app))
            (SetOrigin h v)
            (fixSBars (slot app)) ) )
      (FrameRect (peep2 ph pv)) >

[+++ Create new peep +++]
[++ Return outer peepRectangle in peepwindow ++]
<de peep1 (h v)
   (local (sc)
      (with *peep
         (setq sc (slot scale))
         (cons2
            (setq h (mul h sc))
            (setq v (mul v sc))
            (add h
               (mul sc (min 20 (slot* cols))) )
            (add v
               (mul sc (min 20 (slot* rows))) >

[++ Calculate inner peepRectangle ++]
<de peep2 (h v)
   (local (rct z dh dv zh zv)
      (with (get *peep 'app)
         (setq
            rct '((32767 . 32767) 32767 . 32767)
            z (slot zoom) )
         (unless
            (and
               (zerop (GetCtlMax (slot hsBar)))
               (zerop (GetCtlMax (slot vsBar))) )
            (setq
               rct (peep1 h v)
               [z (mul z 640)]
               zv (mul z 32 (min 20 (slot* cols)))
               zh (mul z 32 (min 20 (slot* rows)))
               dh (sub (right rct) (left rct))
               dv (sub (bottom rct) (top rct)) )
            (rplaca (car rct)
               (add 1
                  (left rct)
                  (div (mul dh (GetCtlValue (slot hsBar))) zv) ) )
            (rplacd (car rct)
               (add 1
                  (top rct)
                  (div (mul dv (GetCtlValue (slot vsBar))) zh) ) )
            (rplaca (cdr rct)
               (add
                  (left rct)
                  (sub1 (div (mul dh (dots-h (slot winPtr))) zv)) ) )
            (rplacd (cdr rct)
               (add
                  (top rct)
                  (sub1 (div (mul dv (dots-v (slot winPtr))) zh)) ) ) )
         rct >

[++ Show 1 or 2 peep rectangles ++]
<de drawPeep (h v)
   (FrameRect (peep1 h v))
   (FrameRect (peep2 h v)) >

<de xorPeep2 ()
   (localPort (get *peep 'winPtr)
      (PenNormal)
      (PenMode PatXor)
      (with (get *peep 'app)
         (FrameRect
            (peep2 (slot* pos-h) (slot* pos-v)) >


(object peep window)

<to t (obj hm nm cols rows)
   (local (sc h v tmp pm p)
      (setq
         tmp (readPixMap (append nm ".8"))
         sc (min (div #$peepHMax cols) (div #$peepVMax rows))
         h (bitand -2 (add1 (mul cols sc)))
         v (mul rows sc)
         pm (newOffMap h v) )
      (with obj
         (slot home hm)
         (localPort
            (slot winPtr
               (NewCWindow
                  nil
                  (cons
                     #$peeppos
                     (cons
                        (add #(car $peepPos) h)
                        (add #(cdr $peepPos) v) ) )
                  nm t altDBoxProc -1 nil obj ) )
            (put obj 'scale sc)
            (CopyBits
               (ptr tmp)
               (ptr pm)
               (rect (add 6 (ptr tmp)))
               (rect (add 6 (ptr pm)))
               srcCopy )
            (free (ptr (ptr tmp)))
            (zapMap tmp)
            (put obj 'base
               (PtrToHand
                  (setq p (ptr (ptr pm)))
                  (GetPtrSize p) ) )
            (free p)
            (put obj 'pixMap pm) >

<to close (obj)
   (DisposHandle (get obj 'base))
   (zapMap (get obj 'pixMap))
   (from window close obj) >

<to content (*peep pt)
   (with *peep
      (localPort (slot winPtr)
         (GlobalToLocal pt)
         (PenNormal)
         (PenMode PatXor)
         (with (slot app)
            (if
               (PtInRect
                  pt
                  (peep2 (slot* pos-h) (slot* pos-v)) )
               (dragPeep2 pt)
               (dragPeep1 pt) >

<to update (*peep)
   (from window update *peep
      '(()
         (local (pm)
            (setq pm (get *peep 'pixMap))
            (ptr
               (ptr pm)
               (HLock (get *peep 'base)) )
            (CopyBits
               (ptr pm)
               (portMap *port)
               (rect (add 6 (ptr pm)))
               (portRect *port)
               srcCopy )
            (HUnlock (get *peep 'base))
            (PenMode PatXor)
            (with *peep
               (drawPeep (slot* pos-h) (slot* pos-v)) >

t [peep.l]
