[shape.l 07nov89]


<de invalCorner (fig)
   (local (i c)
      (and
         (setq i (get fig 'corner))
         (setq c (getCorner i (get fig 'bezier)))
         (InvalRect
            (sqRect (unScale (bez-pt c)) dotSiz)) >

<de putCorner (fig c)
   (invalCorner fig)
   (put fig 'corner c)
   (invalCorner fig) >

<de doCorner (olst nlst)
   [+++olst, nlst enspricht (cons fig bezier)+++]
      (make
         "Change Corner"
         (list olst)
            '((x)
               (Invalfig (car x))
               (adjBez (car x) (cdr x))
               [(put (car x) 'type (figType (car x)))] )
         (list nlst)
            '((y)
               (Invalfig (car y))
               (adjBez (car y) (cdr y))
               [(put (car y) 'type (figType (car y)))] ) ) >

<de onCorner (pt fig)
   (local (c pt1)
      (and
         (setq c (get fig 'corner))
         (pointp (setq pt1 (nth c (get fig 'bezier))))
         (lessp (distPt pt (bez-pt pt1)) (scale1 dotSiz))
         c >


<de dragFigure (pt lst)
   (local (rct newPt h v rgn l)
      (setq l (mapcar *mark '((fig) (copy (plist fig)))))
      (PenNormal)
      (PenMode patXor)
      (FrameRect
         (setq rct (srect lst)) )
      (when (eq 1 (length lst))
         (CopyRgn
            (getFigRgn (car lst))
            (setq rgn (NewRgn)) ) )
      (setq newPt
         (drag pt
            '((oldPt newPt)
               (setq
                  h (sub (car newPt) (car oldPt))
                  v (sub (cdr newPt) (cdr oldPt)) )
               (FrameRect rct)
               (when (eq 1 (length lst))
                  (FrameRgn rgn)
                  (OffsetRgn rgn h v)
                  (FrameRgn rgn) )
               (setq rct (Offsetrect rct h v))
               (FrameRect rct) ) ) )
      (FrameRect rct)
      (when (eq 1 (length lst))
         (DisposeRgn rgn) )
      (mapc lst
         '((fig)
            (offsetFig
               fig
               (sub (car newPt) (car pt))
               (sub (cdr newPt) (cdr pt)) ) ) )
      (make
         "Drag"
         (list l)
            '((x)
                  (mapc2 *mark x
                  '((fig pl)
                     (invalFig fig)
                     (setplist fig pl)
                     (invalFig fig) ) ) )
         (list (mapcar *mark '((fig) (copy (plist fig)))))
            '((y)
               (mapc2 *mark y
                  '((f li)
                     (invalFig f)
                     (setplist f li)
                     (invalFig f) ) ) ) )
 >


<de sizeFigure (x pt fig)
   (local (rct)
      (setq rct (srect *mark))
      (PenNormal)
      (PenMode patXor)
      (invalMarked)
      (FrameRect rct)
      (case (index (onMark x fig) (get fig 'mark))
         (0 (sizeTopleft fig))
         (1 (sizeTop fig))
         (2 (sizeTopright fig))
         (3 (sizeLeft fig))
         (4 (sizeRight fig))
         (5 (sizeBotleft fig))
         (6 (sizeBottom fig))
         (7 (sizeBotright fig)) )
      (FrameRect rct)
      (invalMarked) >


<de chgCorner (pt fig i)
   (local (olst nlst bz a ptx c l)
      (InvalFig fig)
      (setq olst
         (cons fig (get fig 'bezier)) )
      (setq
         bz (copy (get fig 'bezier))
         l (length bz)
         ptx (nth i bz)
         c
            (if (eq i (sub1 l))
               (car bz)
               (nth (add1 i) bz) ) )
      (when (not (pointp c))
         (setq c (car c)) )
      (setq a
         (nth
            (if (zerop i) (sub1 l) (sub1 i))
            bz ) )
      (setq
         a (bez-pt (unscale a))
         c (bez-pt (unscale c))
         ptx (bez-pt (unscale ptx)) )
      (PenNormal)
      (PenMode patXor)
      (setq pt
         (drag pt
            '((oldPt newPt)
               (line2 a oldPt)
               (line2 oldPt c)
               (line2 a newPt)
               (line2 newPt c) ) ) )
      (store (pt-bez (scale pt)) bz i)
      (adjBez fig bz)
      [(put fig 'type (figType fig))]
      (setq nlst
         (cons fig (get fig 'bezier)))
      (doCorner olst nlst) >

<de onFrame(pt fig)
   (and
      (PtInRect pt (get fig 'frame2))
      (not
         (PtInRect pt (get fig 'rgnBBox)) >

<de onMark (pt fig)
   (find (get fig 'mark)
      '((x)
         (and
            (lessp
               (sub (car x) dotSiz)
               (car pt)
               (add dotSiz (car x)))
            (lessp
               (sub (cdr x) dotSiz)
               (cdr pt)
               (add dotSiz (cdr x)) >


<de offsetFig (fig h v)
   (when (get fig 'pixBox)
      (put fig 'pixBox
         (OffsetRect (get fig 'pixBox) (scale1 h) (scale1 v)) ) )
   (setq
      h (scale1 h)
      v (scale1 v) )
   (InvalFig fig)
   (adjBez
      fig
      (copyBez
         (get fig 'bezier)
         (0 . 0)
         (4096 . 4096)
         (cons h v)
         (cons
            (add 4096 h)
            (add 4096 v) >




<de rBezAll (rct1 rct2)
   (mapc *mark
      '((fig)
         (rBez
            fig
            (scale (car rct1))
            (scale (cdr rct1))
            (scale (car rct2))
            (scale (cdr rct2)) >

<de rplRight ()
   (rplaca
      (cdr rct)
      (add (right rct) (sub (car newPt) (car pt))) >

<de rplLeft ()
   (rplaca
      (car rct)
      (add (left rct) (sub (car newPt) (car pt))) >

<de rplTop ()
   (rplacd
      (car rct)
      (add (top rct) (sub (cdr newPt) (cdr pt))) >
[++++++
      (add
         (div
            (mul
               (sub (cdr newPt) (cdr pt))
               (sub (bottom rct) (top rct)) )
            (sub (bottom rct) (cdr pt)) )
         (top rct) >
++++++]

<de rplBottom ()
   (rplacd
      (cdr rct)
      (add (bottom rct) (sub (cdr newPt) (cdr pt))) >

<de sizeUndo (rct r)
   (make
      "Resize"
      (list (mapcar *mark
               '((i)
                  (cons i (copy (plist i))) ) ) )
         '((x)
            (mapc x
               '((y)
                  (InvalFig (car y))
                  (setplist (car y)(cdr y))
                  (InvalFig (car y)) ) ) )
      (list rct r)
         '((y z)
            (rBezAll y z) ) >


<de sizeRight (fig)
   (drag pt
     '((pt newPt)
         (FrameRect rct)
         (rplRight)
         (FrameRect rct) ) )
   (sizeUndo (srect *mark) rct)
   [(rBezAll (srect *mark) rct)]
>

<de sizeLeft (fig)
   (drag pt
     '((pt newPt)
         (FrameRect rct)
         (rplLeft)
         (FrameRect rct) ) )
   (sizeUndo (srect *mark) rct)
   [(rBezAll (srect *mark) rct)] >

<de sizeTop (fig)
   (drag pt
     '((pt newPt)
         (FrameRect rct)
         (rplTop)
         (FrameRect rct) ) )
   (sizeUndo (srect *mark) rct)
   [(rBezAll (srect *mark) rct)] >

<de sizeBottom (fig)
   (drag pt
     '((pt newPt)
         (FrameRect rct)
         (rplBottom)
         (FrameRect rct) ) )
   (sizeUndo (srect *mark) rct)
   [(rBezAll (srect *mark) rct)] >

<de sizeBotright (fig)
   (drag pt
      '((pt newPt)
         (FrameRect rct)
         (rplRight)
         (rplBottom)
         (FrameRect rct) ) )
   (sizeUndo (srect *mark) rct)
   [(rBezAll (srect *mark) rct)] >

<de sizeTopright (fig)
   (drag pt
     '((pt newPt)
         (FrameRect rct)
         (rplTop)
         (rplRight)
         (FrameRect rct) ) )
   (sizeUndo (srect *mark) rct)
   [(rBezAll (srect *mark) rct)] >

<de sizeTopleft (fig)
   (drag pt
     '((pt newPt)
         (FrameRect rct)
         (rplTop)
         (rplLeft)
         (FrameRect rct) ) )
   (sizeUndo (srect *mark) rct)
   [(rBezAll (srect *mark) rct)] >

<de sizeBotleft (fig)
   (drag pt
     '((pt newPt)
         (FrameRect rct)
         (rplBottom)
         (rplLeft)
         (FrameRect rct) ) )
   (sizeUndo (srect *mark) rct)
   [(rBezAll (srect *mark) rct)] >

<de rBez (fig ax ay bx by)
   (invalFig fig)
   (put fig 'bezier
      (copyBez
         (get fig 'bezier)
         ax
         ay
         bx
         by))
   (adjBez fig (get fig 'bezier))
   [(subst (figtype fig) (nth 1 (class fig)) (class fig))]  >

<de srect (lst)
   (local (rct a b c d)
      (setq a 32767)
      (setq b 32767)
      (setq c 0)
      (setq d 0)
      (mapc lst
         '((fig)
            (setq rct (get fig 'rgnBBox))
            (if (lessp (left rct) a )
               (setq a (left rct)) )
            (if (lessp  (top rct) b)
               (setq b (top rct)) )
            (if (lessp c (right rct))
               (setq c (right rct)) )
            (if (lessp d (bottom rct))
               (setq d (bottom rct)) ) ) )
      (cons2 a b c d) >


(object shape figure)

<to input (obj pt f)
   (case f
      (mouse (mousePoly obj pt))
      (digi (digiPoly obj pt)) >


<to figTyp (fig)
   (local (bez d)
      (setq bez (get fig 'bezier))
      (setq d (not (find bez '((x) (not (pointp x))))))
      (cond
			((and (eq (length bez) 4)
					(not (dim1 (car bez)))
					(dim1 (cadr bez))
					(not (dim1 (caddr bez)))
					(dim1 (last bez))
					(ptest (last bez)(nth 0 (car bez)) (cadr bez) (nth 0 (caddr  bez)))
					(ptest (last bez) (nth 0 (caddr bez))  (nth 0 (car bez))(cadr bez)) )
		
				'Oblong )
			((and
				  (not d)
				  (eq (length bez) 3)
				  (not (dim1 (car bez)))
				  (dim1 (cadr bez))
				  (dim1 (last bez)) )
			   'Fan )
			((and
				  (not d)
				  (eq (length bez) 4)
				  (not (dim1 (car bez)))
				  (dim1 (cadr bez))
				  (not (dim1 (caddr bez)))
				  (dim1 (last bez))
				  (not (ptest (last bez)(nth 0 (car bez)) (cadr bez) (nth 0 (caddr  bez))) ) )
			   'Fan )
			(d
				 'Polygon)
			
			(t 'shape) >

t [shape.l]
