[textPrim.l 09jan90]

<de textScroll (h v)
   (local (r d)
      (localClip (setq r (portRect *port))
         (setq d (te-destRect (ptr (slot teRec))))
         (TEScroll h v textH)
         (te-destRect (ptr (slot teRec)) d)
         (SetOrigin
            (sub (left r) h)
            (sub (top r) v) )
         (fixSBars *app)
         (adjSBars *app) >

<de clikFun ()
   <local (pos textH lhgt vrct hs vs)
      (with *app
         (setq
            textH (slot teRec)
            lhgt 4 [(te-lineHeight textH)]
            vrct (te-viewRect (ptr textH))
            hs (slot hsBar)
            vs (slot vsBar)
            pos (GetMouse) )
         (cond
            ((lessp (cdr pos) (top vrct))
               (when (plusp (GetCtlValue vs))
                  (textScroll 0 lhgt) ) )
            ((lessp (bottom vrct) (cdr pos))
               (when (lessp (GetCtlValue vs) (GetCtlMax vs))
                  (textScroll 0 (minus lhgt)) ) )
            ((lessp (car pos) (left vrct) )
               (when (plusp (GetCtlValue hs))
                  (textScroll lhgt 0) ) )
            ((lessp (right vrct) (car pos))
               (when (lessp (GetCtlValue hs) (GetCtlMax hs))
                  (textScroll (minus lhgt) 0) >
   t >

<de pCol (p)
   (bitand 03FF (bitr 6 (word p))) >

<de teStyles (h)
   (local (p l)
      (setq
         p (ptr (ptr (add 4 (ptr h))))
         l )
      (reptn (word (add2 (ptr h)))
         (push
            (list
               (word (add2 p))
               (word (add 4 p))
               (word (add 6 p))
               (word (add 8 p))
               (word (add 10 p))
               (pack
                  (pCol (add 12 p))
                  (pCol (add 14 p))
                  (pCol (add 16 p)) ) )
            l )
         (inc p 18) )
      (reverse l) >

<de teRuns (h)
   (local (p l)
      (setq
         p (add #(sub2 20) (ptr h))
         l )
      (reptn (word (ptr h))
         (push
            (cons
               (word (inc p 2))
               (word (inc p 2)) )
            l ) )
      (cons
         (sub1 (word (inc p 2)))
         (reverse l) >

<de killBlanks (s)
   (local (s)
      (while s
         (if (neq 32 (car s))
            (pop s)
            (progn
               (rplaca s -1)
               (while (eq 32 (cadr s))
                  (rplacd s (cddr s))
                  (rplaca s (sub1 (car s))) ) ) ) ) )
   s >

<de teType (c)
   (local (teH s e)
      (setq
         teH (get *app 'teRec)
         s (te-selStart (ptr teH))
         e (te-selEnd (ptr teH)) )
      (if (eq c \^H)
         (unless (and (zerop s) (zerop e))
            (make
               "Backspace"
               (progn
                  (when (eq s e)
                     (TESetSelect (sub1 s) e teH) )
                  (list s e (getSelText teH)) )
               '((s e x)
                  (local (teH)
                     (setq teH (get *app 'teRec))
                     (doTEInsert x)
                     (TESetSelect s e teH)
                     (teProp *app) ) )
               nil
               '(nil
                  (TEKey \^H (get *app 'teRec))
                  (teProp *app) ) ) )
         (make
            "Key"
            (if (eq s e)
               (list s)
               (list
                  (te-selStart (ptr teH))
                  (te-selEnd (ptr teH))
                  (getSelText teh) ) )
            (if (eq s e)
               '((s)
                  (local (teH)
                     (setq teH (get *app 'teRec))
                     (TESetSelect s (add1 s) teH)
                     (TEDelete teH)
                     (teProp *app) ) )
               '((s e x)
                  (local (teH)
                     (setq teH (get *app 'teRec))
                     (TESetSelect s (add1 s) teH)
                     (doTEInsert x)
                     (TESetSelect s e teH)
                     (teProp *app) ) ) )
            (list c)
            '((c)
               (TEKey c (get *app 'teRec))
               (teProp *app) >

<de teProp (obj)
   (local (l)
      (with obj
         (setq l
            (TEGetStyle
               (sub1 (te-selStart (ptr (slot teRec))))
               (slot teRec) ) )
         (slot height (pop l))
         (slot ascent (pop l))
         (slot font (pop l))
         (slot face (pop l))
         (slot size (pop l))
         (slot color (pop l)) >

<de chgTESel (s e)
   (TESetSelect s e (get *app 'teRec))
   (teProp *app) >

<de doTEInsert (x)
   (with *app
      (unless
         (eq
            (te-selStart (ptr (slot teRec)))
            (te-selEnd (ptr (slot teRec))) )
         (TEDelete (slot teRec)) )
      (TEInsert
         (ref2 (car x))
         (GetHandleSize (ref (car x)))
         (ref (cdr x))
         (slot teRec) >

<de doTEFont (n)
   (with *app
      (TESetStyle 1
         (list (slot font n) 0 0 0)
         t
         (slot teRec) >

<de doTEFace (n)
   (with *app
      (slot face
         (if (zerop n)
            0
            (bitxor n (slot face)) ) )
      (TESetStyle 2 (0 0 0 0) t (slot teRec)) [?]
      (TESetStyle 2
         (list 0 (slot face) 0 0)
         t
         (slot teRec) >

<de doTESize (n)
   (with *app
      (TESetStyle 4
         (list 0 0 (slot size n) 0)
         t
         (slot teRec) >

<de doTEColor (n)
   (with *app
      (TESetStyle 8
         (list 0 0 0 (slot color (apply rgb n)))
         t
         (slot teRec) >

t [textPrim.l]
