/* HyperXCmd.h
 * 05dec89
 */

typedef struct XCmdBlock {
    integer paramCount;
    Handle params[16];
    Handle returnValue;
    bool passFlag;
    void (*entryPoint)();
    integer request;
    integer result;
    long inArgs[8];
    long outArgs[4];
} XCmdBlock;

typedef struct Str31 {
	char	guts[32];
} Str31, *Str31Ptr;

typedef XCmdBlock *XCmdPtr;

  /*result codes */
#define	xresSucc 		0
#define	xresFail 		1 
#define	xresNotImp 		2 
  
  /* request codes */
#define	xreqSendCardMessage		1 
#define	xreqEvalExpr			2 
#define	xreqStringLength		3 
#define	xreqStringMatch			4 
#define xreqSendHCMessage     	5
#define	xreqZeroBytes         	6 
#define	xreqPasToZero			7 
#define	xreqZeroToPas			8 
#define	xreqStrToLong			9 
#define	xreqStrToNum			10 
#define	xreqStrToBool			11 
#define	xreqStrToExt			12 
#define	xreqLongToStr			13 
#define	xreqNumToStr			14 
#define	xreqNumToHex			15 
#define	xreqBoolToStr			16 
#define	xreqExtToStr			17 
#define	xreqGetGlobal			18 
#define	xreqSetGlobal			19 
#define	xreqGetFieldByName		20 
#define	xreqGetFieldByNum		21 
#define	xreqGetFieldByID		22 
#define	xreqSetFieldByName		23 
#define	xreqSetFieldByNum		24 
#define	xreqSetFieldByID		25 
#define	xreqStringEqual       	26 
#define	xreqReturnToPas       	27 
#define	xreqScanToReturn      	28 
#define	xreqScanToZero        	39   /* was supposed to be 29!  Oops! */
