/* macDlg.c
 * 18jul90
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pascal bool modalProc(DialogPtr, EventRecord*, integer*);

static pico pGetNewDialog(pico);
static pico pDisposDialog(pico);
static pico pModalDialog(pico);
static pico pIsDialogEvent(pico);
static pico pDialogSelect(pico);
static pico pDlgCut(pico);
static pico pDlgCopy(pico);
static pico pDlgPaste(pico);
static pico pDlgDelete(pico);
static pico pDrawDialog(pico);
static pico pAlert(pico);
static pico pStopAlert(pico);
static pico pNoteAlert(pico);
static pico pCautionAlert(pico);
static pico pParamText(pico);
static pico pGetDItem(pico);
static pico pSetDItem(pico);
static pico pGetIText(pico);
static pico pSetIText(pico);
static pico pSelIText(pico);
static pico pHideDItem(pico);
static pico pShowDItem(pico);

symInit dlgSyms[] = {
	{"GETNEWDIALOG",	pGetNewDialog},
	{"DISPOSDIALOG",	pDisposDialog},
	{"MODALDIALOG",		pModalDialog},
	{"ISDIALOGEVENT",	pIsDialogEvent},
	{"DIALOGSELECT",	pDialogSelect},
	{"DLGCUT",			pDlgCut},
	{"DLGCOPY",			pDlgCopy},
	{"DLGPASTE",		pDlgPaste},
	{"DLGDELETE",		pDlgDelete},
	{"DRAWDIALOG",		pDrawDialog},
	{"ALERT",			pAlert},
	{"STOPALERT",		pStopAlert},
	{"NOTEALERT",		pNoteAlert},
	{"CAUTIONALERT",	pCautionAlert},
	{"PARAMTEXT",		pParamText},
	{"GETDITEM",		pGetDItem},
	{"SETDITEM",		pSetDItem},
	{"GETITEXT",		pGetIText},
	{"SETITEXT",		pSetIText},
	{"SELITEXT",		pSelIText},
	{"HIDEDITEM",		pHideDItem},
	{"SHOWDITEM",		pShowDItem},
	NULL
};

pico pGetNewDialog(x)
pico x;
{
	integer dialogID;
	Ptr dStorage;

	dialogID = (integer)nextNum(&x);
	dStorage = nextPtr(&x);
	return boxPtr(GetNewDialog(dialogID, dStorage, (WindowPtr)nextNum(&x)));
}

pico pDisposDialog(x)
pico x;
{
	DisposDialog((WindowPtr)nextNum(&x));
	return tSym;
}

pico modalDef;

pascal bool modalProc(theDialog, theEvent, itemHit)
DialogPtr theDialog;
EventRecord *theEvent;
integer *itemHit;
{
	return isNil(apply3(modalDef,
				boxNum(theDialog), boxNum(theEvent), boxNum(itemHit))) ?
			NO : YES;
}

pico pModalDialog(x)
pico x;
{
	integer itemHit;

	ModalDialog(nextProc(&x, &modalDef, modalProc), &itemHit);
	return setVal(nextVar(&x), boxNum(itemHit));
}

pico pIsDialogEvent(x)
pico x;
{
	return boxBool(IsDialogEvent((EventRecord*)nextNum(&x)));
}

pico pDialogSelect(x)
pico x;
{
	DialogPtr *theDialog;
	integer itemHit;
	bool res;

	res = DialogSelect((EventRecord*)nextNum(&x), &theDialog, &itemHit);
	setVal(nextVar(&x), boxPtr(theDialog));
	setVal(nextVar(&x), boxNum(itemHit));
	return boxBool(res);
}

pico pDlgCut(x)
pico x;
{
	DlgCut((DialogPtr)nextNum(&x));
	return tSym;
}

pico pDlgCopy(x)
pico x;
{
	DlgCopy((DialogPtr)nextNum(&x));
	return tSym;
}

pico pDlgPaste(x)
pico x;
{
	DlgPaste((DialogPtr)nextNum(&x));
	return tSym;
}

pico pDlgDelete(x)
pico x;
{
	DlgDelete((DialogPtr)nextNum(&x));
	return tSym;
}

pico pDrawDialog(x)
pico x;
{
	DrawDialog((DialogPtr)nextNum(&x));
	return tSym;
}

pico pAlert(x)
pico x;
{
	integer alertID;

	alertID = (integer)nextNum(&x);
	return boxNum(Alert(alertID, (ProcPtr)nextPtr(&x)));
}

pico pStopAlert(x)
pico x;
{
	integer alertID;

	alertID = (integer)nextNum(&x);
	return boxNum(StopAlert(alertID, (ProcPtr)nextPtr(&x)));
}

pico pNoteAlert(x)
pico x;
{
	integer alertID;

	alertID = (integer)nextNum(&x);
	return boxNum(NoteAlert(alertID, (ProcPtr)nextPtr(&x)));
}

pico pCautionAlert(x)
pico x;
{
	integer alertID;

	alertID = (integer)nextNum(&x);
	return boxNum(CautionAlert(alertID, (ProcPtr)nextPtr(&x)));
}

pico pParamText(x)
pico x;
{
	Str255 param0, param1, param2, param3;

	nextString(&x,param0);
	nextString(&x,param1);
	nextString(&x,param2);
	nextString(&x,param3);
	ParamText(param0, param1, param2, param3);
	return tSym;
}

pico pGetDItem(x)
pico x;
{
	DialogPtr theDialog;
	integer itemType;
	Handle item;
	Rect box;

	theDialog = (DialogPtr)nextNum(&x);
	GetDItem(theDialog, (integer)nextNum(&x), &itemType, &item, &box);
	setVal(nextVar(&x), boxNum(itemType));
	setVal(nextVar(&x), boxRect(&box));
	return boxPtr(item);
}

pico pSetDItem(x)
pico x;
{
	DialogPtr theDialog;
	integer itemNo;
	integer itemType;
	Handle item;
	Rect boxVar;

	theDialog = (DialogPtr)nextNum(&x);
	itemNo = (integer)nextNum(&x);
	itemType = (integer)nextNum(&x);
	item = (Handle)nextNum(&x);
	nextRect(&x, &boxVar);
	SetDItem(theDialog, itemNo, itemType, item, &boxVar);
	return tSym;
}

pico pGetIText(x)
pico x;
{
	Handle item;
	unsigned char text[256];

	item = (Handle)nextNum(&x);
	GetIText(item, text);
	return unBufString(text);
}

pico pSetIText(x)
pico x;
{
	Handle item;
	Str255 text;

	item = (Handle)nextNum(&x);
	nextString(&x,text);
	SetIText(item,text);
	return tSym;
}

pico pSelIText(x)
pico x;
{
	DialogPtr theDialog;
	integer itemNo, strtSel;

	theDialog = (DialogPtr)nextNum(&x);
	itemNo = (integer)nextNum(&x);
	strtSel = (integer)nextNum(&x);
	SelIText(theDialog, itemNo, strtSel, (integer)nextNum(&x));
	return tSym;
}

pico pHideDItem(x)
pico x;
{
	DialogPtr theDialog;

	theDialog = (DialogPtr)nextNum(&x);
	HideDItem(theDialog, (integer)nextNum(&x));
	return tSym;
}

pico pShowDItem(x)
pico x;
{
	DialogPtr theDialog;

	theDialog = (DialogPtr)nextNum(&x);
	ShowDItem(theDialog, (integer)nextNum(&x));
	return tSym;
}
