/* macEvent.c
 * 29may90abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pico pGetNextEvent(pico);
static pico pEventAvail(pico);
static pico pGetMouse(pico);
static pico pButton(void);
static pico pStillDown(void);
static pico pWaitMouseUp(void);
static pico pTickCount(void);
static pico aKey(void);
static pico cKey(void);
static pico oKey(void);
static pico sKey(void);
static pico evWhat(pico);
static pico evMessage(pico);
static pico evWhen(pico);
static pico evWhere(pico);
static pico evModifiers(pico);
static pico pPostEvent(pico);
static pico pFlushEvents(pico);

symInit eventSyms[] = {
	{"GETNEXTEVENT",	pGetNextEvent},
	{"EVENTAVAIL",		pEventAvail},
	{"GETMOUSE",		pGetMouse},
	{"BUTTON",			pButton},
	{"STILLDOWN",		pStillDown},
	{"WAITMOUSEUP",		pWaitMouseUp},
	{"TICKCOUNT",		pTickCount},
	{"A-KEY",			aKey},
	{"C-KEY",			cKey},
	{"O-KEY",			oKey},
	{"S-KEY",			sKey},
	{"EV-WHAT",			evWhat},
	{"EV-MESSAGE",		evMessage},
	{"EV-WHEN",			evWhen},
	{"EV-WHERE",		evWhere},
	{"EV-MODIFIERS",	evModifiers},
	{"POSTEVENT",		pPostEvent},	/* OSEvent */
	{"FLUSHEVENTS",		pFlushEvents},
	NULL
};

pico pGetNextEvent(x)
pico x;
{
	integer eventMask;

	eventMask = (integer)nextNum(&x);
	return boxBool(GetNextEvent(eventMask,(EventRecord*)nextNum(&x)));
}

pico pEventAvail(x)
pico x;
{
	integer eventMask;

	eventMask = (integer)nextNum(&x);
	return boxBool(EventAvail(eventMask,(EventRecord*)nextNum(&x)));
}

pico pGetMouse(x)
register pico x;
{
	Point pt;

	GetMouse(&pt);
	if (!isCell(x))
		return boxPoint(pt);
	x = EVAL1(x);
	needPoint(x);
	setCar(x, boxNum(pt.h));
	setCdr(x, boxNum(pt.v));
	return x;
}

pico pButton()
{
	return boxBool(Button());
}

pico pStillDown()
{
	return boxBool(StillDown());
}

pico pWaitMouseUp()
{
	return boxBool(WaitMouseUp());
}

pico pTickCount()
{
	return boxNum(TickCount());
}

pico aKey()
{
	KeyMap map;

	GetKeys(&map);
	return boxBool(map.Key[1] & 0x8000);
}

pico cKey()
{
	KeyMap map;

	GetKeys(&map);
	return boxBool(map.Key[1] & 8);
}

pico oKey()
{
	KeyMap map;

	GetKeys(&map);
	return boxBool(map.Key[1] & 4);
}

pico sKey()
{
	KeyMap map;

	GetKeys(&map);
	return boxBool(map.Key[1] & 1);
}

pico evWhat(x)
pico x;
{
	return fetchW(x,0);
}

pico evMessage(x)
pico x;
{
	return fetchL(x,2);
}

pico evWhen(x)
pico x;
{
	return fetchL(x,6);
}

pico evWhere(x)
pico x;
{
	return fetchPoint(x,10);
}

pico evModifiers(x)
pico x;
{
	return fetchW(x,14);
}

/* OSEvent */
pico pPostEvent(x)
pico x;
{
	integer eventCode;

	eventCode = (integer)nextNum(&x);
	return boxNum(PostEvent(eventCode, nextNum(&x)));
}

pico pFlushEvents(x)
pico x;
{
	integer eventMask;

	eventMask = (integer)nextNum(&x);
	FlushEvents(eventMask, (integer)nextNum(&x));
	return tSym;
}
