/* macMenu.c
 * 26jun89abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pico pNewMenu(pico);
static pico pGetMenu(pico);
static pico pDisposeMenu(pico);
static pico pAppendMenu(pico);
static pico pAddResMenu(pico);
static pico pInsertMenu(pico);
static pico pDrawMenuBar(void);
static pico pDeleteMenu(pico);
static pico pClearMenuBar(void);
static pico pGetNewMBar(pico);
static pico pGetMenuBar(void);
static pico pSetMenuBar(pico);
static pico pMenuSelect(pico);
static pico pMenuKey(pico);
static pico pHiliteMenu(pico);
static pico pSetItem(pico);
static pico pGetItem(pico);
static pico pDisableItem(pico);
static pico pEnableItem(pico);
static pico pCheckItem(pico);
static pico pSetItemStyle(pico);
static pico pInsMenuItem(pico);
static pico pDelMenuItem(pico);
static pico pGetMCEntry(pico);
static pico pSetMCEntry(pico);
static pico pPopUpMenuSelect(pico);

symInit menuSyms[] = {
	{"NEWMENU",			pNewMenu},
	{"GETMENU",			pGetMenu},
	{"DISPOSEMENU",		pDisposeMenu},
	{"APPENDMENU",		pAppendMenu},
	{"ADDRESMENU",		pAddResMenu},
	{"INSERTMENU",		pInsertMenu},
	{"DRAWMENUBAR",		pDrawMenuBar},
	{"DELETEMENU",		pDeleteMenu},
	{"CLEARMENUBAR",	pClearMenuBar},
	{"GETNEWMBAR",		pGetNewMBar},
	{"GETMENUBAR",		pGetMenuBar},
	{"SETMENUBAR",		pSetMenuBar},
	{"MENUSELECT",		pMenuSelect},
	{"MENUKEY",			pMenuKey},
	{"HILITEMENU",		pHiliteMenu},
	{"SETITEM",			pSetItem},
	{"GETITEM",			pGetItem},
	{"DISABLEITEM",		pDisableItem},
	{"ENABLEITEM",		pEnableItem},
	{"CHECKITEM",		pCheckItem},
	{"SETITEMSTYLE",	pSetItemStyle},
	{"INSMENUITEM",		pInsMenuItem},
	{"DELMENUITEM",		pDelMenuItem},
	{"GETMCENTRY",		pGetMCEntry},
	{"SETMCENTRY",		pSetMCEntry},
	{"POPUPMENUSELECT",	pPopUpMenuSelect},
	NULL
};

pico pNewMenu(x)
pico x;
{
	integer menuID;
	Str255 name;

	menuID = (integer)nextNum(&x);
	return boxPtr(NewMenu(menuID, nextString(&x,name)));
}

pico pGetMenu(x)
pico x;
{
	return boxPtr(GetMenu((integer)nextNum(&x)));
}

pico pDisposeMenu(x)
pico x;
{
	DisposeMenu((MenuHandle)nextNum(&x));
	return checkMemErr();
}

pico pAppendMenu(x)
pico x;
{
	MenuHandle theMenu;
	Str255 name;

	theMenu = (MenuHandle)nextNum(&x);
	AppendMenu(theMenu, nextString(&x,name));
	return tSym;
}

pico pAddResMenu(x)
pico x;
{
	MenuHandle theMenu;

	theMenu = (MenuHandle)nextNum(&x);
	AddResMenu(theMenu, nextPLong(&x));
	return tSym;
}

pico pInsertMenu(x)
pico x;
{
	MenuHandle theMenu;

	theMenu = (MenuHandle)nextNum(&x);
	InsertMenu(theMenu, (integer)nextNum(&x));
	return tSym;
}

pico pDrawMenuBar()
{
	DrawMenuBar();
	return tSym;
}

pico pDeleteMenu(x)
pico x;
{
	DeleteMenu((integer)nextNum(&x));
	return tSym;
}

pico pClearMenuBar()
{
	ClearMenuBar();
	return tSym;
}

pico pGetNewMBar(x)
pico x;
{
	return boxPtr(GetNewMBar((integer)nextNum(&x)));
}

pico pGetMenuBar()
{
	return boxPtr(GetMenuBar());
}

pico pSetMenuBar(x)
pico x;
{
	SetMenuBar((Handle)nextNum(&x));
	return tSym;
}

pico pMenuSelect(x)
pico x;
{
	Point pt;

	nextPoint(&x,&pt);
	return boxHiLo(MenuSelect(pt));
}

pico pMenuKey(x)
pico x;
{
	return boxHiLo(MenuKey((char)nextNum(&x)));
}

pico pHiliteMenu(x)
pico x;
{
	HiliteMenu((integer)nextNum(&x));
	return tSym;
}

pico pSetItem(x)
pico x;
{
	MenuHandle theMenu;
	integer item;
	Str255 name;

	theMenu = (MenuHandle)nextNum(&x);
	item = (integer)nextNum(&x);
	SetItem(theMenu, item, nextString(&x,name));
	return tSym;
}

pico pGetItem(x)
pico x;
{
	MenuHandle theMenu;
	integer item;
	unsigned char text[256];

	theMenu = (MenuHandle)nextNum(&x);
	item = (integer)nextNum(&x);
	GetItem(theMenu, item, text);
	return unBufString(text);
}

pico pDisableItem(x)
pico x;
{
	MenuHandle theMenu;

	theMenu = (MenuHandle)nextNum(&x);
	DisableItem(theMenu,(integer)nextNum(&x));
	return tSym;
}

pico pEnableItem(x)
pico x;
{
	MenuHandle theMenu;

	theMenu = (MenuHandle)nextNum(&x);
	EnableItem(theMenu,(integer)nextNum(&x));
	return tSym;
}

pico pCheckItem(x)
pico x;
{
	MenuHandle theMenu;
	integer item;

	theMenu = (MenuHandle)nextNum(&x);
	item = (integer)nextNum(&x);
	CheckItem(theMenu, item, nextBool(&x));
	return tSym;
}

pico pSetItemStyle(x)
pico x;
{
	MenuHandle theMenu;
	integer item;

	theMenu = (MenuHandle)nextNum(&x);
	item = (integer)nextNum(&x);
	SetItemStyle(theMenu, item, (integer)nextNum(&x));
	return tSym;
}

pico pInsMenuItem(x)
pico x;
{
	MenuHandle theMenu;
	Str255 itemString;

	theMenu = (MenuHandle)nextNum(&x);
	nextString(&x, itemString);
	InsMenuItem(theMenu, itemString, (integer)nextNum(&x));
	return tSym;
}

pico pDelMenuItem(x)
pico x;
{
	MenuHandle theMenu;

	theMenu = (MenuHandle)nextNum(&x);
	DelMenuItem(theMenu, (integer)nextNum(&x));
	return tSym;
}

pico pGetMCEntry(x)
pico x;
{
	integer menuID;
	register MCEntryPtr p;

	menuID = (integer)nextNum(&x);
	if (!(p = GetMCEntry(menuID, (integer)nextNum(&x))))
		return nilSym;
	return newCell(boxNum(p->mctID),
		newCell(boxNum(p->mctItem),
			newCell(boxColor(p->mctRGB1.red, p->mctRGB1.green, p->mctRGB1.blue),
				newCell(boxColor(p->mctRGB2.red, p->mctRGB2.green, p->mctRGB2.blue),
					newCell(boxColor(p->mctRGB3.red, p->mctRGB3.green, p->mctRGB3.blue),
						newCell(boxColor(p->mctRGB4.red, p->mctRGB4.green, p->mctRGB4.blue),
							nilSym ))))));
}

pico pSetMCEntry(x)
pico x;
{
	MCEntry mc[2];

	mc[1].mctID = -99;
	mc[0].mctID = (integer)nextNum(&x);
	mc[0].mctItem = (integer)nextNum(&x);
	nextColor(&x, &mc[0].mctRGB1);
	nextColor(&x, &mc[0].mctRGB2);
	nextColor(&x, &mc[0].mctRGB3);
	nextColor(&x, &mc[0].mctRGB4);
	SetMCEntries(1,mc);
	return tSym;
}

pico pPopUpMenuSelect(x)
pico x;
{
	MenuHandle theMenu;
	integer top, left;

	theMenu = (MenuHandle)nextNum(&x);
	top = (integer)nextNum(&x);
	left = (integer)nextNum(&x);
	return boxHiLo(PopUpMenuSelect(theMenu, top, left, (integer)nextNum(&x)));
}
