/* macQd.c
 * 16jan90abu
 */

#include "pico.h"
#include "stack.h"
#include "mac.h"

pico portSym;

/* Prototypes */
static pico qdPortMap(pico);
static pico qdPortRect(pico);
static pico qdVisRgn(pico);
static pico qdClipRgn(pico);
static pico qdRgnBBox(pico);
static pico pSetPort(pico);
static pico pGetPort(pico);
static pico pSetPortBits(pico);
static pico pSetOrigin(pico);
static pico pSetClip(pico);
static pico pGetClip(pico);
static pico pClipRect(pico);
static pico pBackPat(pico);
static pico pSetCursor(pico);
static pico pHideCursor(pico);
static pico pShowCursor(pico);
static pico pObscureCursor(pico);
static pico pHidePen(void);
static pico pShowPen(void);
static pico pGetPen(pico);
static pico pPenSize(pico);
static pico pPenMode(pico);
static pico pPenPat(pico);
static pico pPenNormal(void);
static pico pMoveTo(pico);
static pico pMove(pico);
static pico pLineTo(pico);
static pico pLine(pico);
static pico pTextFont(pico);
static pico pTextFace(pico);
static pico pTextSize(pico);
static pico pDrawChar(pico);
static pico pDrawString(pico);
static pico pCharWidth(pico);
static pico pStringWidth(pico);
static pico pGetFontInfo(void);
static pico pOffsetRect(pico);
static pico pInsetRect(pico);
static pico pPtInRect(pico);
static pico pPtToAngle(pico);
static pico pFrameRect(pico);
static pico pPaintRect(pico);
static pico pEraseRect(pico);
static pico pInvertRect(pico);
static pico pFrameOval(pico);
static pico pPaintOval(pico);
static pico pEraseOval(pico);
static pico pFrameRoundRect(pico);
static pico pPaintRoundRect(pico);
static pico pEraseRoundRect(pico);
static pico pFrameArc(pico);
static pico pPaintArc(pico);
static pico pEraseArc(pico);
static pico pNewRgn(void);
static pico pOpenRgn(void);
static pico pCloseRgn(pico);
static pico pDisposeRgn(pico);
static pico pCopyRgn(pico);
static pico pSetEmptyRgn(pico);
static pico pSetRectRgn(pico);
static pico pRectRgn(pico);
static pico pOffsetRgn(pico);
static pico pInsetRgn(pico);
static pico pSectRgn(pico);
static pico pUnionRgn(pico);
static pico pDiffRgn(pico);
static pico pXorRgn(pico);
static pico pPtInRgn(pico);
static pico pRectInRgn(pico);
static pico pEqualRgn(pico);
static pico pEmptyRgn(pico);
static pico pFrameRgn(pico);
static pico pPaintRgn(pico);
static pico pEraseRgn(pico);
static pico pInvertRgn(pico);
static pico pScrollRect(pico);
static pico pCopyBits(pico);
static pico pOpenPicture(pico);
static pico pClosePicture(void);
static pico pDrawPicture(pico);
static pico pKillPicture(pico);
static pico pOpenPoly(void);
static pico pClosePoly(void);
static pico pKillPoly(pico);
static pico pFramePoly(pico);
static pico pPaintPoly(pico);
static pico pLocalToGlobal(pico);
static pico pGlobalToLocal(pico);

symInit qdSyms[] = {
	{"PORTMAP",			qdPortMap},
	{"PORTRECT",		qdPortRect},
	{"VISRGN",			qdVisRgn},
	{"CLIPRGN",			qdClipRgn},
	{"RGNBBOX",			qdRgnBBox},
	{"SETPORT",			pSetPort},
	{"GETPORT",			pGetPort},
	{"SETPORTBITS",		pSetPortBits},
	{"SETORIGIN",		pSetOrigin},
	{"SETCLIP",			pSetClip},
	{"GETCLIP",			pGetClip},
	{"CLIPRECT",		pClipRect},
	{"BACKPAT",			pBackPat},
	{"SETCURSOR",		pSetCursor},
	{"HIDECURSOR",		pHideCursor},
	{"SHOWCURSOR",		pShowCursor},
	{"OBSCURECURSOR",	pObscureCursor},
	{"HIDEPEN",			pHidePen},
	{"SHOWPEN",			pShowPen},
	{"GETPEN",			pGetPen},
	{"PENSIZE",			pPenSize},
	{"PENMODE",			pPenMode},
	{"PENPAT",			pPenPat},
	{"PENNORMAL",		pPenNormal},
	{"MOVETO",			pMoveTo},
	{"MOVE",			pMove},
	{"LINETO",			pLineTo},
	{"LINE",			pLine},
	{"TEXTFONT",		pTextFont},
	{"TEXTFACE",		pTextFace},
	{"TEXTSIZE",		pTextSize},
	{"DRAWCHAR",		pDrawChar},
	{"DRAWSTRING",		pDrawString},
	{"CHARWIDTH",		pCharWidth},
	{"STRINGWIDTH",		pStringWidth},
	{"GETFONTINFO",		pGetFontInfo},
	{"OFFSETRECT",		pOffsetRect},
	{"INSETRECT",		pInsetRect},
	{"PTINRECT",		pPtInRect},
	{"PTTOANGLE",		pPtToAngle},
	{"FRAMERECT",		pFrameRect},
	{"PAINTRECT",		pPaintRect},
	{"ERASERECT",		pEraseRect},
	{"INVERTRECT",		pInvertRect},
	{"FRAMEOVAL",		pFrameOval},
	{"PAINTOVAL",		pPaintOval},
	{"ERASEOVAL",		pEraseOval},
	{"FRAMEROUNDRECT",	pFrameRoundRect},
	{"PAINTROUNDRECT",	pPaintRoundRect},
	{"ERASEROUNDRECT",	pEraseRoundRect},
	{"FRAMEARC",		pFrameArc},
	{"PAINTARC",		pPaintArc},
	{"ERASEARC",		pEraseArc},
	{"NEWRGN",			pNewRgn},
	{"OPENRGN",			pOpenRgn},
	{"CLOSERGN",		pCloseRgn},
	{"DISPOSERGN",		pDisposeRgn},
	{"COPYRGN",			pCopyRgn},
	{"SETEMPTYRGN",		pSetEmptyRgn},
	{"SETRECTRGN",		pSetRectRgn},
	{"RECTRGN",			pRectRgn},
	{"OFFSETRGN",		pOffsetRgn},
	{"INSETRGN",		pInsetRgn},
	{"SECTRGN",			pSectRgn},
	{"UNIONRGN",		pUnionRgn},
	{"DIFFRGN",			pDiffRgn},
	{"XORRGN",			pXorRgn},
	{"PTINRGN",			pPtInRgn},
	{"RECTINRGN",		pRectInRgn},
	{"EQUALRGN",		pEqualRgn},
	{"EMPTYRGN",		pEmptyRgn},
	{"FRAMERGN",		pFrameRgn},
	{"PAINTRGN",		pPaintRgn},
	{"ERASERGN",		pEraseRgn},
	{"INVERTRGN",		pInvertRgn},
	{"SCROLLRECT",		pScrollRect},
	{"COPYBITS",		pCopyBits},
	{"OPENPICTURE",		pOpenPicture},
	{"CLOSEPICTURE",	pClosePicture},
	{"DRAWPICTURE",		pDrawPicture},
	{"KILLPICTURE",		pKillPicture},
	{"OPENPOLY",		pOpenPoly},
	{"CLOSEPOLY",		pClosePoly},
	{"KILLPOLY",		pKillPoly},
	{"FRAMEPOLY",		pFramePoly},
	{"PAINTPOLY",		pPaintPoly},
	{"LOCALTOGLOBAL",	pLocalToGlobal},
	{"GLOBALTOLOCAL",	pGlobalToLocal},
	NULL
};

/* Return pointer to port's BitMap or PixelMap */
pico qdPortMap(x)
pico x;
{
	register long *p;

	p = (long*)(unBox(EVAL1(x)) + 2);
	if (*(p+1) < 0) {
		return boxNum(*(long*)*p);
	}
	return boxNum(p);
}

pico qdPortRect(x)
pico x;
{
	return fetchRect(x,16);
}

pico qdVisRgn(x)
pico x;
{
	return fetchL(x,24);
}

pico qdClipRgn(x)
pico x;
{
	return fetchL(x,28);
}

pico qdRgnBBox(x)
pico x;
{
	return boxRect(&(*((RgnHandle)nextNum(&x)))->rgnBBox);
}

pico pSetPort(x)
pico x;
{
	SetPort((GrafPtr)nextNum(&x));
	return setVal(portSym, boxNum(thePort));
}

pico pGetPort(x)
pico x;
{
	GrafPtr port;

	GetPort(&port);
	return setVal(nextVar(&x), boxNum(port));
}

pico pSetPortBits(x)
pico x;
{
	SetPortBits((BitMap*)nextPtr(&x));
	return tSym;
}

pico pSetOrigin(x)
pico x;
{
	integer h;

	h = (integer)nextNum(&x);
	SetOrigin(h, (integer)nextNum(&x));
	return tSym;
}

pico pSetClip(x)
pico x;
{
	SetClip((RgnHandle)nextNum(&x));
	return tSym;
}

pico pGetClip(x)
pico x;
{
	GetClip((RgnHandle)nextNum(&x));
	return tSym;
}

pico pClipRect(x)
pico x;
{
	Rect rect;

	nextRect(&x,&rect);
	ClipRect(&rect);
	return tSym;
}

pico pBackPat(x)
pico x;
{
	BackPat((Pattern*)nextNum(&x));
	return tSym;
}

pico pSetCursor(x)
pico x;
{
	SetCursor((CursPtr)nextNum(&x));
	return tSym;
}

pico pHideCursor(x)
pico x;
{
	HideCursor();
	return tSym;
}

pico pShowCursor(x)
pico x;
{
	ShowCursor();
	return tSym;
}

pico pObscureCursor(x)
pico x;
{
	ObscureCursor();
	return tSym;
}

pico pHidePen()
{
	HidePen();
	return tSym;
}

pico pShowPen()
{
	ShowPen();
	return tSym;
}

pico pGetPen(x)
pico x;
{
	Point pt;

	GetPen(&pt);
	return newCell(boxNum(pt.h),boxNum(pt.v));
}

pico pPenSize(x)
pico x;
{
	integer width;

	width = (integer)nextNum(&x);
	PenSize(width, (integer)nextNum(&x));
	return tSym;
}

pico pPenMode(x)
pico x;
{
	PenMode((integer)nextNum(&x));
	return tSym;
}

pico pPenPat(x)
pico x;
{
	PenPat((Pattern*)nextNum(&x));
	return tSym;
}

pico pPenNormal()
{
	PenNormal();
	return tSym;
}


pico pMoveTo(x)
pico x;
{
	integer h;

	h = (integer)nextNum(&x);
	MoveTo(h, (integer)nextNum(&x));
	return tSym;
}

pico pMove(x)
pico x;
{
	integer dh;

	dh = (integer)nextNum(&x);
	Move(dh, (integer)nextNum(&x));
	return tSym;
}

pico pLineTo(x)
pico x;
{
	integer h;

	h = (integer)nextNum(&x);
	LineTo(h, (integer)nextNum(&x));
	return tSym;
}

pico pLine(x)
pico x;
{
	integer dh;

	dh = (integer)nextNum(&x);
	Line(dh, (integer)nextNum(&x));
	return tSym;
}

pico pTextFont(x)
register pico x;
{
	x = EVAL1(x);
	NEEDNUM(x);
	TextFont((integer)unBox(x));
	return x;
}

pico pTextFace(x)
register pico x;
{
	x = EVAL1(x);
	NEEDNUM(x);
	TextFace((Style)unBox(x));
	return x;
}

pico pTextSize(x)
register pico x;
{
	x = EVAL1(x);
	NEEDNUM(x);
	TextSize((integer)unBox(x));
	return x;
}

pico pDrawChar(x)
pico x;
{
	DrawChar((char)nextNum(&x));
	return tSym;
}

pico pDrawString(x)
pico x;
{
	Str255 s;

	nextString(&x,s);
	DrawString(s);
	return tSym;
}

pico pCharWidth(x)
pico x;
{
	return boxNum(CharWidth((char)nextNum(&x)));
}

pico pStringWidth(x)
pico x;
{
	Str255 s;

	nextString(&x,s);
	return boxNum(StringWidth(s));
}

pico pGetFontInfo()
{
	FontInfo f;

	GetFontInfo(&f);
	push(newCell(boxNum(f.leading),nilSym));
	tos = newCell(boxNum(f.widMax),tos);
	tos = newCell(boxNum(f.descent),tos);
	return newCell(boxNum(f.ascent),pop());
}

pico pOffsetRect(x)
pico x;
{
#if 0
	Rect rect;
	integer dh;

	nextRect(&x,&rect);
	dh = (integer)nextNum(&x);
	OffsetRect(&rect, dh, (integer)nextNum(&x));
	return boxRect(&rect);
#else
	register pico y;
	register number dh,dv;

	y = EVAL1(x);
	x = cdr(x);
	needRect(y);
	dh = nextNum(&x);
	dv = nextNum(&x);
	return newCell2(
		boxNum(unBox(car(car(y)))+dh),
		boxNum(unBox(cdr(car(y)))+dv),
		boxNum(unBox(car(cdr(y)))+dh),
		boxNum(unBox(cdr(cdr(y)))+dv) );
#endif
}

pico pInsetRect(x)
pico x;
{
#if 0
	Rect rect;
	integer dh;

	nextRect(&x,&rect);
	dh = (integer)nextNum(&x);
	InsetRect(&rect, dh, (integer)nextNum(&x));
	return boxRect(&rect);
#else
	register pico y;
	register number dh,dv;

	y = EVAL1(x);
	x = cdr(x);
	needRect(y);
	dh = nextNum(&x);
	dv = nextNum(&x);
	return newCell2(
		boxNum(unBox(car(car(y)))+dh),
		boxNum(unBox(cdr(car(y)))+dv),
		boxNum(unBox(car(cdr(y)))-dh),
		boxNum(unBox(cdr(cdr(y)))-dv) );
#endif
}

pico pPtInRect(x)
#if 0
pico x;
{
	Point pt;
	Rect r;

	nextPoint(&x,&pt);
	nextRect(&x,&r);
	return boxBool(PtInRect(pt,&r));
#else
register pico x;
{
	register pico y;
	register number h,v;

	y = EVAL1(x);
	x = cdr(x);
	needPoint(y);
	h = unBox(car(y));
	v = unBox(cdr(y));
	x = EVAL1(x);
	needRect(x);
	return boxBool(
		unBox(car(car(x))) <= h  &&
		h < unBox(car(cdr(x)))  &&
		unBox(cdr(car(x))) <= v  &&
		v < unBox(cdr(cdr(x))) );
#endif
}

pico pPtToAngle(x)
pico x;
{
	Rect r;
	Point pt;
	integer angle;

	nextRect(&x,&r);
	nextPoint(&x,&pt);
	PtToAngle(&r,pt,&angle);
	return boxNum(angle);
}

pico pFrameRect(x)
pico x;
{
	Rect rect;

	nextRect(&x,&rect);
	FrameRect(&rect);
	return tSym;
}

pico pPaintRect(x)
pico x;
{
	Rect rect;

	nextRect(&x,&rect);
	PaintRect(&rect);
	return tSym;
}

pico pEraseRect(x)
pico x;
{
	Rect rect;

	nextRect(&x,&rect);
	EraseRect(&rect);
	return tSym;
}

pico pInvertRect(x)
pico x;
{
	Rect rect;

	nextRect(&x,&rect);
	InvertRect(&rect);
	return tSym;
}

pico pFrameOval(x)
pico x;
{
	Rect rect;

	nextRect(&x,&rect);
	FrameOval(&rect);
	return tSym;
}

pico pPaintOval(x)
pico x;
{
	Rect rect;

	nextRect(&x,&rect);
	PaintOval(&rect);
	return tSym;
}

pico pEraseOval(x)
pico x;
{
	Rect rect;

	nextRect(&x,&rect);
	EraseOval(&rect);
	return tSym;
}

pico pFrameRoundRect(x)
pico x;
{
	Rect rect;
	integer ovalWidth;

	nextRect(&x,&rect);
	ovalWidth = (integer)nextNum(&x);
	FrameRoundRect(&rect,ovalWidth, (integer)nextNum(&x));
	return tSym;
}

pico pPaintRoundRect(x)
pico x;
{
	Rect rect;
	integer ovalWidth;

	nextRect(&x,&rect);
	ovalWidth = (integer)nextNum(&x);
	PaintRoundRect(&rect,ovalWidth, (integer)nextNum(&x));
	return tSym;
}

pico pEraseRoundRect(x)
pico x;
{
	Rect rect;
	integer ovalWidth;

	nextRect(&x,&rect);
	ovalWidth = (integer)nextNum(&x);
	EraseRoundRect(&rect,ovalWidth, (integer)nextNum(&x));
	return tSym;
}

pico pFrameArc(x)
pico x;
{
	Rect rect;
	integer startAngle;

	nextRect(&x,&rect);
	startAngle = (integer)nextNum(&x);
	FrameArc(&rect,startAngle, (integer)nextNum(&x));
	return tSym;
}

pico pPaintArc(x)
pico x;
{
	Rect rect;
	integer startAngle;

	nextRect(&x,&rect);
	startAngle = (integer)nextNum(&x);
	PaintArc(&rect,startAngle, (integer)nextNum(&x));
	return tSym;
}

pico pEraseArc(x)
pico x;
{
	Rect rect;
	integer startAngle;

	nextRect(&x,&rect);
	startAngle = (integer)nextNum(&x);
	EraseArc(&rect,startAngle, (integer)nextNum(&x));
	return tSym;
}

pico pNewRgn()
{
	return boxPtr(NewRgn());
}

pico pOpenRgn()
{
	OpenRgn();
	return tSym;
}

pico pCloseRgn(x)
pico x;
{
	RgnHandle rgn;

	CloseRgn(rgn = (RgnHandle)nextNum(&x));
	return boxNum(rgn);	
}

pico pDisposeRgn(x)
pico x;
{
	DisposeRgn((RgnHandle)nextNum(&x));
	return tSym;	
}

pico pCopyRgn(x)
pico x;
{
	RgnHandle srcRgn, dstRgn;

	srcRgn = (RgnHandle)nextNum(&x);
	CopyRgn(srcRgn, dstRgn = (RgnHandle)nextNum(&x));
	return boxPtr(dstRgn);	
}

pico pSetEmptyRgn(x)
pico x;
{
	SetEmptyRgn((RgnHandle)nextNum(&x));
	return tSym;	
}

pico pSetRectRgn(x)
pico x;
{
	RgnHandle rgn;
	integer left, top, right;

	rgn = (RgnHandle)nextNum(&x);
	left = (integer)nextNum(&x);
	top = (integer)nextNum(&x);
	right = (integer)nextNum(&x);
	SetRectRgn(rgn, left, top, right, (integer)nextNum(&x));
	return tSym;	
}

pico pRectRgn(x)
pico x;
{
	RgnHandle rgn;
	Rect r;

	rgn = (RgnHandle)nextNum(&x);
	nextRect(&x,&r);
	RectRgn(rgn, &r);
	return tSym;
}

pico pOffsetRgn(x)
pico x;
{
	RgnHandle rgn;
	integer dh;

	rgn = (RgnHandle)nextNum(&x);
	dh = (integer)nextNum(&x);
	OffsetRgn(rgn, dh, (integer)nextNum(&x));
	return tSym;
}

pico pInsetRgn(x)
pico x;
{
	RgnHandle rgn;
	integer dh;

	rgn = (RgnHandle)nextNum(&x);
	dh = (integer)nextNum(&x);
	InsetRgn(rgn, dh, (integer)nextNum(&x));
	return tSym;
}

pico pSectRgn(x)
pico x;
{
	RgnHandle srcRgnA, srcRgnB;

	srcRgnA = (RgnHandle)nextNum(&x);
	srcRgnB = (RgnHandle)nextNum(&x);
	SectRgn(srcRgnA, srcRgnB, (RgnHandle)nextNum(&x));
	return tSym;
}

pico pUnionRgn(x)
pico x;
{
	RgnHandle srcRgnA, srcRgnB;

	srcRgnA = (RgnHandle)nextNum(&x);
	srcRgnB = (RgnHandle)nextNum(&x);
	UnionRgn(srcRgnA, srcRgnB, (RgnHandle)nextNum(&x));
	return tSym;
}

pico pDiffRgn(x)
pico x;
{
	RgnHandle srcRgnA, srcRgnB;

	srcRgnA = (RgnHandle)nextNum(&x);
	srcRgnB = (RgnHandle)nextNum(&x);
	DiffRgn(srcRgnA, srcRgnB, (RgnHandle)nextNum(&x));
	return tSym;
}

pico pXorRgn(x)
pico x;
{
	RgnHandle srcRgnA, srcRgnB;

	srcRgnA = (RgnHandle)nextNum(&x);
	srcRgnB = (RgnHandle)nextNum(&x);
	XorRgn(srcRgnA, srcRgnB, (RgnHandle)nextNum(&x));
	return tSym;
}

pico pPtInRgn(x)
pico x;
{
	Point pt;
	
	nextPoint(&x,&pt);
	return boxBool(PtInRgn(pt, (RgnHandle)nextNum(&x)));
}

pico pRectInRgn(x)
pico x;
{
	Rect r;
	
	nextRect(&x,&r);
	return boxBool(RectInRgn(&r, (RgnHandle)nextNum(&x)));
}

pico pEqualRgn(x)
pico x;
{
	RgnHandle rgn;

	rgn = (RgnHandle)nextNum(&x);
	return boxBool(EqualRgn(rgn, (RgnHandle)nextNum(&x)));
}

pico pEmptyRgn(x)
pico x;
{
	return boxBool(EmptyRgn((RgnHandle)nextNum(&x)));
}

pico pFrameRgn(x)
pico x;
{
	FrameRgn((RgnHandle)nextNum(&x));
	return tSym;
}

pico pPaintRgn(x)
pico x;
{
	PaintRgn((RgnHandle)nextNum(&x));
	return tSym;
}

pico pEraseRgn(x)
pico x;
{
	EraseRgn((RgnHandle)nextNum(&x));
	return tSym;
}

pico pInvertRgn(x)
pico x;
{
	InvertRgn((RgnHandle)nextNum(&x));
	return tSym;
}

pico pScrollRect(x)
pico x;
{
	Rect r;
	integer dh, dv;

	nextRect(&x,&r);
	dh = (integer)nextNum(&x);
	dv = (integer)nextNum(&x);
	ScrollRect(&r, dh, dv, (RgnHandle)nextNum(&x));
	return tSym;
}

pico pCopyBits(x)
pico x;
{
	BitMap *srcBits, *dstBits;
	Rect srcRect, dstRect;
	integer mode;

	srcBits = (BitMap*)nextNum(&x);
	dstBits = (BitMap*)nextNum(&x);
	nextRect(&x,&srcRect);
	nextRect(&x,&dstRect);
	mode = (integer)nextNum(&x);
	CopyBits(srcBits,dstBits,&srcRect,&dstRect,mode,(RgnHandle)nextPtr(&x));
	return tSym;
}


pico pOpenPicture(x)
pico x;
{
	Rect picFrame;

	nextRect(&x,&picFrame);
	return boxPtr(OpenPicture(&picFrame));
}

pico pClosePicture()
{
	ClosePicture();
	return tSym;
}

pico pDrawPicture(x)
pico x;
{
	PicHandle myPicture;
	Rect dstRect;

	myPicture = (PicHandle)nextNum(&x);
	nextRect(&x,&dstRect);
	DrawPicture(myPicture, &dstRect);
	return tSym;
}

pico pKillPicture(x)
pico x;
{
	KillPicture((PicHandle)nextNum(&x));
	return tSym;
}

pico pOpenPoly()
{
	return boxPtr(OpenPoly());
}

pico pClosePoly()
{
	ClosePoly();
	return tSym;
}

pico pKillPoly(x)
pico x;
{
	KillPoly((PolyHandle)nextNum(&x));
	return tSym;
}

pico pFramePoly(x)
pico x;
{
	FramePoly((PolyHandle)nextNum(&x));
	return tSym;
}

pico pPaintPoly(x)
pico x;
{
	PaintPoly((PolyHandle)nextNum(&x));
	return tSym;
}

pico pLocalToGlobal(x)
pico x;
{
	pico sym;
	Point pt;

	sym = nextVar(&x);
	unBoxPoint(val(sym),&pt);
	LocalToGlobal(&pt);
	return setVal(sym, boxPoint(pt));
}

pico pGlobalToLocal(x)
pico x;
{
	pico sym;
	Point pt;

	sym = nextVar(&x);
	unBoxPoint(val(sym),&pt);
	GlobalToLocal(&pt);
	return setVal(sym, boxPoint(pt));
}
