/* macText.c
 * 18jul90abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pascal bool clikProc(void);

static pico txLine(pico);
static pico teDestRect(pico);
static pico teViewRect(pico);
static pico teLineHeight(pico);
static pico teSelStart(pico);
static pico teSelEnd(pico);
static pico teClikLoop(pico);
static pico teTeLength(pico);
static pico teHText(pico);
static pico teNLines(pico);
static pico pTEStylNew(pico);
static pico pTEDispose(pico);
static pico pTESetText(pico);
static pico pTEGetText(pico);
static pico pTEIdle(pico);
static pico pTEClick(pico);
static pico pTESetSelect(pico);
static pico pTEActivate(pico);
static pico pTEDeactivate(pico);
static pico pTEKey(pico);
static pico pTECut(pico);
static pico pTECopy(pico);
static pico pTEStylPaste(pico);
static pico pTEDelete(pico);
static pico pTEStylInsert(pico);
static pico pTESetJust(pico);
static pico pTEUpdate(pico);
static pico pTEScroll(pico);
static pico pTECalText(pico);
static pico pTESelView(pico);
static pico pTEPinScroll(pico);
static pico pTEAutoView(pico);
static pico pSetStylHandle(pico);
static pico pGetStylHandle(pico);
static pico pGetStylScrap(pico);
static pico pTEGetOffset(pico);
static pico pTEGetPoint(pico);
static pico pTEGetHeight(pico);
static pico pTEGetStyle(pico);
static pico pTESetStyle(pico);
static pico pTEReplaceStyle(pico);

symInit textSyms[] = {
	{"TXLINE",			txLine},
	{"TE-DESTRECT",		teDestRect},
	{"TE-VIEWRECT",		teViewRect},
	{"TE-LINEHEIGHT",	teLineHeight},
	{"TE-SELSTART",		teSelStart},
	{"TE-SELEND",		teSelEnd},
	{"TE-CLIKLOOP",		teClikLoop},
	{"TE-TELENGTH",		teTeLength},
	{"TE-HTEXT",		teHText},
	{"TE-NLINES",		teNLines},
	{"TENEW",			pTEStylNew},
	{"TEDISPOSE",		pTEDispose},
	{"TESETTEXT",		pTESetText},
	{"TEGETTEXT",		pTEGetText},
	{"TEIDLE",			pTEIdle},
	{"TECLICK",			pTEClick},
	{"TESETSELECT",		pTESetSelect},
	{"TEACTIVATE",		pTEActivate},
	{"TEDEACTIVATE",	pTEDeactivate},
	{"TEKEY",			pTEKey},
	{"TECUT",			pTECut},
	{"TECOPY",			pTECopy},
	{"TEPASTE",			pTEStylPaste},
	{"TEDELETE",		pTEDelete},
	{"TEINSERT",		pTEStylInsert},
	{"TESETJUST",		pTESetJust},
	{"TEUPDATE",		pTEUpdate},
	{"TESCROLL",		pTEScroll},
	{"TECALTEXT",		pTECalText},
	{"TESELVIEW",		pTESelView},
	{"TEPINSCROLL",		pTEPinScroll},
	{"TEAUTOVIEW",		pTEAutoView},
	{"SETSTYLHANDLE",	pSetStylHandle},
	{"GETSTYLHANDLE",	pGetStylHandle},
	{"GETSTYLSCRAP",	pGetStylScrap},
	{"TEGETOFFSET",		pTEGetOffset},
	{"TEGETPOINT",		pTEGetPoint},
	{"TEGETHEIGHT",		pTEGetHeight},
	{"TEGETSTYLE",		pTEGetStyle},
	{"TESETSTYLE",		pTESetStyle},
	{"TEREPLACESTYLE",	pTEReplaceStyle},
	NULL
};

pico txLine(x)
pico x;
{
	TEHandle teH;
	register number n,i;
	register Ptr p;

	teH = (TEHandle)nextNum(&x);
	n = nextNum(&x);
	i = 0;
	HLock(TEGetText(teH));
	p = *TEGetText(teH);
	while (--n >= 0)
		if (*p++ == '\r')
			++i;
	HUnlock(TEGetText(teH));
	return boxNum(i);
}

pico teDestRect(x)
pico x;
{
	return fetchRect(x,0);
}

pico teViewRect(x)
pico x;
{
	return fetchRect(x,8);
}

pico teLineHeight(x)
pico x;
{
	return fetchW(x,24);
}

pico teSelStart(x)
pico x;
{
	return fetchW(x,32);
}

pico teSelEnd(x)
pico x;
{
	return fetchW(x,34);
}

pico clikDef;

pascal bool clikProc()
{
	return isNil(apply0(clikDef)) ?  NO : YES;
}

pico teClikLoop(x)
pico x;
{
	TERec *te;

	te = (TERec*)nextNum(&x);
	te->clikLoop = nextProc(&x, &clikDef, clikProc);
	return clikDef;
}

pico teTeLength(x)
pico x;
{
	return fetchW(x,60);
}

pico teHText(x)
pico x;
{
	return fetchL(x,62);
}

pico teNLines(x)
pico x;
{
	return fetchW(x,94);
}

pico pTEStylNew(x)
pico x;
{
	Rect destRect,viewRect;

	nextRect(&x,&destRect);
	nextRect(&x,&viewRect);
	return boxPtr(TEStylNew(&destRect,&viewRect));
}

pico pTEDispose(x)
pico x;
{
	TEDispose((TEHandle)nextNum(&x));
	return tSym;
}

pico pTESetText(x)
pico x;
{
	Ptr text;
	long length;

	text = (Ptr)nextNum(&x);
	length = nextNum(&x);
	TESetText(text,length,(TEHandle)nextNum(&x));
	return tSym;
}

pico pTEGetText(x)
pico x;
{
	return boxPtr(TEGetText((TEHandle)nextNum(&x)));
}

pico pTEIdle(x)
pico x;
{
	TEIdle((TEHandle)nextNum(&x));
	return tSym;
}

pico pTEClick(x)
pico x;
{
	Point pt;
	bool fExtend;

	nextPoint(&x,&pt);
	fExtend = nextBool(&x);
	TEClick(pt,fExtend,(TEHandle)nextNum(&x));
	return tSym;
}

pico pTESetSelect(x)
pico x;
{
	long selStart,selEnd;

	selStart = nextNum(&x);
	selEnd = nextNum(&x);
	TESetSelect(selStart,selEnd,(TEHandle)nextNum(&x));
	return tSym;
}

pico pTEActivate(x)
pico x;
{
	TEActivate((TEHandle)nextNum(&x));
	return tSym;
}

pico pTEDeactivate(x)
pico x;
{
	TEDeactivate((TEHandle)nextNum(&x));
	return tSym;
}

pico pTEKey(x)
pico x;
{
	char key;

	key = (char)nextNum(&x);
	TEKey(key,(TEHandle)nextNum(&x));
	return tSym;
}

pico pTECut(x)
pico x;
{
	TECut((TEHandle)nextNum(&x));
	return tSym;
}

pico pTECopy(x)
pico x;
{
	TECopy((TEHandle)nextNum(&x));
	return tSym;
}

pico pTEStylPaste(x)
pico x;
{
	TEStylPaste((TEHandle)nextNum(&x));
	return tSym;
}

pico pTEDelete(x)
pico x;
{
	TEDelete((TEHandle)nextNum(&x));
	return tSym;
}

pico pTEStylInsert(x)
pico x;
{
	Ptr text;
	long length;
	StScrpHandle hST;
	
	text = (Ptr)nextNum(&x);
	length = nextNum(&x);
	hST = (StScrpHandle)nextPtr(&x);
	TEStylInsert(text,length,hST,(TEHandle)nextNum(&x));
	return tSym;
}

pico pTESetJust(x)
pico x;
{
	integer just;

	just = (integer)nextNum(&x);
	TESetJust(just,(TEHandle)nextNum(&x));
	return tSym;
}

pico pTEUpdate(x)
pico x;
{
	Rect rUpdate;

	nextRect(&x,&rUpdate);
	TEUpdate(&rUpdate,(TEHandle)nextNum(&x));
	return tSym;
}

pico pTEScroll(x)
pico x;
{
	integer dh,dv;

	dh = (integer)nextNum(&x);
	dv = (integer)nextNum(&x);
	TEScroll(dh,dv,(TEHandle)nextNum(&x));
}

pico pTECalText(x)
pico x;
{
	TECalText((TEHandle)nextNum(&x));
	return tSym;
}

pico pTESelView(x)
pico x;
{
	TESelView((TEHandle)nextNum(&x));
	return tSym;
}

pico pTEPinScroll(x)
pico x;
{
	integer dh,dv;

	dh = (integer)nextNum(&x);
	dv = (integer)nextNum(&x);
	TEPinScroll(dh,dv,(TEHandle)nextNum(&x));
	return tSym;
}

pico pTEAutoView(x)
pico x;
{
	bool f;

	f = nextBool(&x);
	TEAutoView(f, (TEHandle)nextNum(&x));
	return tSym;
}

pico pSetStylHandle(x)
pico x;
{
	TEStyleHandle h;

	h = (TEStyleHandle)nextNum(&x);
	SetStylHandle(h, (TEHandle)nextNum(&x));
	return tSym;
}

pico pGetStylHandle(x)
pico x;
{
	return boxPtr(GetStylHandle((TEHandle)nextNum(&x)));
}

pico pGetStylScrap(x)
pico x;
{
	return boxPtr(GetStylScrap((TEHandle)nextNum(&x)));
}

pico pTEGetOffset(x)
pico x;
{
	Point pt;

	nextPoint(&x,&pt);
	return boxNum(TEGetOffset(pt,(TEHandle)nextNum(&x)));
}

pico pTEGetPoint(x)
pico x;
{
	integer offset;
	union {
		Point pt;
		long n;
	} LSCstupid;

	offset = (integer)nextNum(&x);
	LSCstupid.n = TEGetPoint(offset,(TEHandle)nextNum(&x));
	return boxPoint(LSCstupid.pt);
}

pico pTEGetHeight(x)
pico x;
{
	long endLine,startLine;

	endLine = nextNum(&x);
	startLine = nextNum(&x);
	return boxNum(TEGetHeight(endLine,startLine,(TEHandle)nextNum(&x)));
}

pico pTEGetStyle(x)
pico x;
{
	integer offset;
	TextStyle theStyle;
	integer lineHeight, fontAscent;

	offset = (integer)nextNum(&x);
	TEGetStyle(offset,&theStyle,&lineHeight,&fontAscent,(TEHandle)nextNum(&x));
	return 
		newCell(boxNum(lineHeight),
			newCell(boxNum(fontAscent),
				boxStyle(&theStyle) ) );
}

pico pTESetStyle(x)
pico x;
{
	integer mode;
	TextStyle newStyle;
	bool redraw;

	mode = (integer)nextNum(&x);
	nextStyle(&x,&newStyle);
	redraw = nextBool(&x);
	TESetStyle(mode,&newStyle,redraw,(TEHandle)nextNum(&x));
	return tSym;
}

pico pTEReplaceStyle(x)
pico x;
{
	integer mode;
	TextStyle oldStyle,newStyle;
	bool redraw;

	mode = (integer)nextNum(&x);
	nextStyle(&x,&oldStyle);
	nextStyle(&x,&newStyle);
	redraw = nextBool(&x);
	TEReplaceStyle(mode,&oldStyle,&newStyle,redraw,(TEHandle)nextNum(&x));
	return tSym;
}
