/* pico.h
 * 29dec90abu
 */

#include "appl.h"

#define _MC68881_
#include <math.h>

/* setjmp.h */
typedef long jmp_buf[11];	/*  D3-D7,PC,A2-A4,A6,SP  */
int setjmp(jmp_buf env);
void longjmp(jmp_buf env, int val);

#define ASM68K		1
#define ROUND		0.5

#define VERSION 	210
#define NULL		0L
#define FAIL		1					/* Termination results */
#define SUCCESS		0
#define YES			-1					/* Boolean values */
#define NO			0
#define ctrl(c)		(c - '@')			/* Control key */
#define CELLSIZE	8					/* Size of one object */
#define BUFSIZE		512
#define LBSIZE		1024				/* Line buffer size */
#define CR			13					/* Carriage Return */
#define NL			10					/* NewLine */
#define BREAK		0x7F				/* Break with DEL key */
#define ESCAPE		27					/* Escape key */
#define EOL			'\r'				/* End of line character */
#define APPLYMAX	32					/* Max number of args for SUBR-APPPLY */
#define FILENAME	64					/* Max file name length */
#define MAXNUM		0x1FFFFFFF			/* Max pos. representable number */
#define MAXNEG		-0x20000000			/* Max neg. representable number */
#define MAXLIST		1000000				/* Maximum list length */
#define THREADS		1024				/* Hash table size */
#define TABLEN		3					/* Tab char expansion */
#define DYNAMO		((pico)0xEF7BDEF6)	/* 0xEF7BDEF6 = '$$$$$$' */

typedef int integer;
typedef long number;
typedef int bool;
typedef unsigned long bits32;

typedef struct cell {				/* Pico primary data type */
	struct cell *data;
	struct cell *link;
} cell;

typedef cell *pico;
typedef pico (*fun)();

typedef struct {
	pico threads[THREADS+1];	/* First to relocate */
	pico run;					/* Last to relocate */
	char genSeed[8];
} picoEnv;

typedef struct stkFrame {
	struct stkFrame *link;
	pico *sp;
	pico self;
	long cnt;
} stkFrame;

typedef struct catchFrame {
	struct catchFrame *link;
	pico tag;
	pico *sp, *with;
	stkFrame *stkBase;
	jmp_buf env;
} catchFrame;

typedef struct symInit {			/* Symbol initialization */
	char *nameInit;
	fun funInit;
} symInit;

typedef struct {
	integer fd;
	bool dirty;
	integer cnt,max;
	long pos;
	char buf[BUFSIZE];
} file;

typedef struct {
	double x,y,z;
} vector;

typedef struct {
	vector a,b,c;
} matrix, **matHandle;

/* Macros */
#define loop			for (;;)
#define num(x)			((number)(x))

#define cellPtr(x)		((pico)(num(x) & ~7))
#define clr(x)			((pico)(num(x) & ~1L))

#define car(x)			(clr((x)->data))
#define cdr(x)			((x)->link)
#define tail(x)			(clr(((x)-1)->link))
#define val(x)			((x)->data)

#define isNil(x)		((x) == nilSym)
#define isNum(x)		(num(x)&2)
#define isZero(x)		(num(x)==2)
#define isSym(x)		(num(x)&4)
#define isCell(x)		(!(num(x)&6))

#define NEEDNUM(x)		if (!isNum(x)) numberError((pico)x)
#define NEEDSYM(x)		if (isNum(x) || !isSym(x)) symbolError(x)
#define NEEDCELL(x)		if (!isCell(x)) cellError(x)
#define NEEDLIST(x)		if (!isNil(x) && !isCell(x)) listError(x)
#define NEEDSTRING(x)	if (!isNil(x) && !isCell(x)) strError(x)
#define NEEDFUN(x)		if (!funp(x)) funError(x)
#define NEEDDYNAMO(x)	if (!isSym(x) || getPname(x)!=DYNAMO) dynamoError(x)
#define CHECKSYM(x)		if (x<=tSym) protected(x)

#define boxNum(n)		((pico)((num(n) << 2) + 2))
#define boxFun(n)		((pico)((num(n) << 2) + 3))
#define unBox(n)		(num(n) >> 2)
#define mkSym(x)		((pico)(num(x) + 4))
#define mkCell(sym)		((pico)(num(sym) - 4))
#define newSym(nam,val)	(mkSym(newCell(nam,val)))
#define packNum(h,m,l)	(boxNum((num(h) & 1023L)<<20 | (num(m) & 1023L)<<10 | num(l)&1023L))
#define markPtr(x)		((char*)(x) + 3)
#define isFree(x)		(*markPtr(x) & 1)

/* Grafs */
#define packPt(h,v)		((pico)(((h) & 0x7FFFL)<<17 | num(boxNum((v) & 0x7FFFL))))
#define ptH(x)			(num(x) >> 17 & 0x7FFFL)
#define ptV(x)			(unBox(x) & 0x7FFFL)

#define EVAL(x)			(isNum(x)? x : (isSym(x)? val(x) : eval0(x)))
#define EVAL1(x)		(EVAL(car(x)))
#define EVAL2(x,a)		(push(EVAL1(x)), a=EVAL1(cdr(x)), pop())

/* Globals */
extern pico applyList, mapCell, mapSym, mapCell2, mapSym2, mapCell3, mapSym3;
extern pico nilSym, voidSym, tSym, quoteSym, lambdaSym, shareFlg, objectSym, classSym;
extern pico star1Sym, star2Sym, star3Sym, star4Sym, star5Sym, star6Sym;
extern pico dolSym, fkeySym, againSym, taskSym, quitSym, fileSym, loadSym, editSym;
extern pico echoFlg, srcFlg, logFlg, macFlg;

extern picoEnv env;

extern Ptr heapMem;
extern pico heap, heapEnd;
extern pico avail;
extern pico dynamos;				/* Dynamic memory objects */
extern jmp_buf errRst;				/* Error restart longjump */
extern pico *stkPtr;				/* Stack pointer */
extern stkFrame *stkBase;			/* Stack frame base */
extern catchFrame *catchBase;		/* Catch frame base */
extern pico *withPtr;				/* Current WITH-pointer */
extern pico loadPos;				/* Start of definition in source file */
extern pico loadName;
extern pico theMessage;				/* Current message */

extern char lBuff[LBSIZE];			/* Line buffer */
extern char *lbp;
extern file *stream;				/* The current input stream */
extern int nextChar;				/* Char look ahead on input */
extern integer inTTY, outTTY;		/* Serial channels */
extern integer inAux,outAux;
extern int traceLevel;				/* Trace recursion level */
extern int revaLevel;				/* Nesting level of read-eval-loops */
extern bool fresh;					/* Fresh start or loading freeze file */
extern integer saveMask;			/* Keep SysEvtMask */

/* Prototypes */
void accumulate(char,number*);
pico append(pico,pico);
pico apply0(pico);
pico apply1(pico,pico);
pico apply2(pico,pico,pico);
pico apply3(pico,pico,pico,pico);
pico applyMethod(pico,pico,pico);
pico applySexpr(pico,pico);
void backTask(void);
pico boxBool(bool);
pico boxDouble(double);
pico boxHiLo(long);
pico boxLong(long);
pico boxPoint(Point);
pico boxPtr(void*);
pico boxRect(Rect*);
pico boxVector(vector*);
pico bufPLong(long);
char *bufString(pico,char*,long);
void cBreak(void);
void cellError(pico);
char chrIn(void);
void chrOut(char);
void circError(void);
void closeAll(void);
void closeFile(file*);
pico compressName(char*);
pico compressString(pico);
pico copy(pico);
void crlf(void);
void cutPr(pico);
pico delete(pico,pico);
double distPt(double,double,double,double);
void divError(void);
void doBreak(pico);
void doError(void);
pico dynamo(pico,pico);
void dynamoError(pico);
pico dynHandle(Handle);
bool equal(pico,pico);
void err(char*);
void error(char*,char*);
void errObj(pico,char*);
void errStrObj(pico,char*);
pico eval0(pico);
pico evalBody(pico);
void exitPico(int);
char *expShort(number,char*);
pico find(pico);
char firstChar(pico);
void funError(pico);
bool funp(pico);
pico gensym(pico);
pico get(pico,pico);
char *getLine(char*,char*);
pico getPname(pico);
void giveup(char*);
void hexChar(char);
pico init1Sym(char*,bool,pico);
void initApplication(void);
void initAppVars(void);
void initSerial(int,bool);
void initSymbols(void);
void initSymTab(symInit*);
void initSysSyms(void);
void initSysVars(void);
pico intern(pico);
void internErr(char*);
bool isRect(pico);
void keyBreak(void);
bool keyHit(void);
number length(pico);
void listError(pico);
number maxNumber(number,number);
bool member(pico,pico);
number minNumber(number,number);
pico nconc(pico,pico);
void needPoint(pico);
void needRect(pico);
pico newCell(pico,pico);
pico newCell2(pico,pico,pico,pico);
void *nextDynamo(pico*);
number nextNum(pico*);
long nextPLong(pico*);
void *nextPtr(pico*);
void numberError(pico);
void objError(pico);
pico picoErase(StringPtr);
pico plist(pico);
void prin0(pico);
void prName(pico);
void prNumber(number);
void prHexNum(unsigned long);
void protected(pico);
void prString(char*);
pico put(pico);
pico read0(bool);
void record(pico,pico);
void redefine(pico,pico);
void redefMsg(pico,pico);
void reset(void);
void resetGC(void);
void revalo(pico);
bool sameDef(pico,pico);
int serialStat(void);
int serialIn(void);
void serialOut(int);
pico setCdr(pico,pico);
pico setCar(pico,pico);
void setPlist(pico,pico);
void setFlags(pico,pico);
pico setVal(pico,pico);
pico setTail(pico,pico);
pico share(pico,pico);
pico shareList(pico);
void space(void);
void stopApplication(void);
void strError(pico);
int strLength(pico);
void symbolError(pico);
void tab(void);
void transform(matrix*,vector*,vector*);
void ttyOut(char);
void unBoxPoint(pico,Point*);
void unBoxRect(pico,Rect*);
void unBoxVector(pico,vector*);
pico unBufCString(char*);
pico unBufString(unsigned char*);
bool unFreeze(StringPtr,integer);
void unwind(void);
char upc(char);

/* SUBR prototypes */
pico Abs(pico);
pico AccByte(pico);
pico Access(pico);
pico AccPoint(pico);
pico AccPtr(pico);
pico AccRect(pico);
pico AccString(pico);
pico AccWord(pico);
pico Add(pico);
pico Add1(pico);
pico Add2(pico);
pico All(pico);
pico Alloc(pico);
pico And(pico);
pico Append(pico);
pico Apply(pico);
pico Array(pico);
pico Assoc(pico);
pico Ascii(pico);
pico Atom(pico);
pico Avail(void);
pico Backsp(pico);
pico Baud(pico);
pico Bell(pico);
pico pBench(pico);
pico Best(pico);
pico pBit(pico);
pico Bitl(pico);
pico Bitr(pico);
pico pBitAnd(pico);
pico pBitNot(pico);
pico pBitOff(pico);
pico pBitOn(pico);
pico pBitOr(pico);
pico pBitXor(pico);
pico Block(pico);
pico Boundp(pico);
pico Bounds(pico);
pico BreakFun(pico);
pico Camera(pico);
pico Car(pico);
pico Catch(pico);
pico Cdr(pico);
pico Caar(pico);
pico Cadr(pico);
pico Cdar(pico);
pico Cddr(pico);
pico Caaar(pico);
pico Caadr(pico);
pico Cadar(pico);
pico Caddr(pico);
pico Cdaar(pico);
pico Cdadr(pico);
pico Cddar(pico);
pico Cdddr(pico);
pico Cadddr(pico);
pico Cddddr(pico);
pico Case(pico);
pico Check(void);
pico Chop(pico);
pico Class(pico);
pico Close(pico);
pico Comment(pico);
pico Cond(pico);
pico Cons(pico);
pico Cons2(pico);
pico Copy(pico);
pico Cos(pico);
pico Crash(pico);
pico Creat(pico);
pico Cut(pico);
pico CutPr(pico);
pico pDate(void);
pico De(pico);
pico Dec(pico);
pico Default(pico);
pico Define(pico);
pico DeGraf(pico);
pico DelayTicks(pico);
pico Delete(pico);
pico Delim(pico);
pico Demon(pico);
pico Depth(pico);
pico Diff(pico);
pico Digit(pico);
pico Dir(pico);
pico DistPt(pico);
pico Div(pico);
pico Div2(pico);
pico Do(pico);
pico Draw(pico);
pico Dump(pico);
pico Dynamo(pico);
pico Enum(pico);
pico Eq(pico);
pico Equal(pico);
pico Erase(pico);
pico Error(pico);
pico Eval(pico);
pico Filter(pico);
pico Find(pico);
pico Flag(pico);
pico Flagp(pico);
pico Flags(pico);
pico For(pico);
pico Format(pico);
pico Free(pico);
pico Freeze(pico);
pico From(pico);
pico FType(pico);
pico Funp(pico);
pico Gc(pico);
pico Gensym(void);
pico Get(pico);
pico Getc(pico);
pico Getd(pico);
pico GetFile(pico);
pico GetLine(pico);
pico pGetVol(void);
pico Graf(pico);
pico GrafPt(pico);
pico High(pico);
pico HitKey(void);
pico How(pico);
pico If(pico);
pico Inc(pico);
pico Index(pico);
pico InGraf(pico);
pico Insert(pico);
pico Intsec(pico);
pico Key(void);
pico Lambda(pico);
pico Last(pico);
pico Last2(pico);
pico Length(pico);
pico Leq(pico);
pico Lessp(pico);
pico Letter(pico);
pico Limit(pico);
pico List(pico);
pico Listp(pico);
pico Load(pico);
pico Loc(pico);
pico Local(pico);
pico Loop(pico);
pico Low(pico);
pico Lowc(pico);
pico Map(pico);
pico Map2(pico);
pico Mapc(pico);
pico Mapc2(pico);
pico Mapcan(pico);
pico Mapcan2(pico);
pico Mapcar(pico);
pico Mapcar2(pico);
pico Mapcon(pico);
pico Mapcon2(pico);
pico Maplist(pico);
pico Maplist2(pico);
pico Match(pico);
pico Max(pico);
pico May(pico);
pico Member(pico);
pico Memq(pico);
pico Method(pico);
pico Middle(pico);
pico Min(pico);
pico Minus(pico);
pico Minusp(pico);
pico Mod(pico);
pico Mul(pico);
pico Mul2(pico);
pico Muldiv(pico);
pico MvGraf(pico);
pico Nand(pico);
pico Nconc(pico);
pico Nconc1(pico);
pico Neq(pico);
pico New(pico);
pico NextPt(pico);
pico Nth(pico);
pico Nthcdr(pico);
pico Number(pico);
pico Numberp(pico);
pico Nor(pico);
pico Not(pico);
pico Object(pico);
pico Oblist(pico);
pico Off(pico);
pico On(pico);
pico OnGraf(pico);
pico OnLine(pico);
pico Open(pico);
pico Or(pico);
pico Pack(pico);
pico Path(void);
pico Paint(pico);
pico Pairp(pico);
pico Parall(pico);
pico Pipe(pico);
pico Plist(pico);
pico Plot(pico);
pico Plusp(pico);
pico Pname(pico);
pico Pointp(pico);
pico Pop(pico);
pico PrHex(pico);
pico Prin1(pico);
pico Prin2(pico);
pico Print(pico);
pico PrLine(pico);
pico Prog1(pico);
pico Prog2(pico);
pico Push(pico);
pico Push1(pico);
pico Put(pico);
pico Putc(pico);
pico Putd(pico);
pico PutFile(pico);
pico Quit(pico);
pico Quote(pico);
pico pRandom(pico);
pico Raster(pico);
pico Read(pico);
pico ReadBlock(pico);
pico Rectp(pico);
pico Ref(pico);
pico Ref2(pico);
pico Remob(pico);
pico Remove(pico);
pico fRename(pico);
pico Repeat(pico);
pico Reptn(pico);
pico Revalo(pico);
pico Reverse(pico);
pico Rplaca(pico);
pico Rplacd(pico);
pico Scan(pico);
pico Sect(pico);
pico Seek(pico);
pico Serial(pico);
pico Set(pico);
pico SetFlags(pico);
pico Setplist(pico);
pico Setq(pico);
pico pSetVol(pico);
pico Shift(pico);
pico Sin(pico);
pico pSize(pico);
pico Slot(pico);
pico SlotStar(pico);
pico Sort(pico);
pico Space(pico);
pico Square(pico);
pico Sqrt(pico);
pico Store(pico);
pico Stringp(pico);
pico StrLen(pico);
pico Stuff(pico);
pico Sub(pico);
pico Sub1(pico);
pico Sub2(pico);
pico Subst(pico);
pico Super(pico);
pico Swap(pico);
pico Symbol(pico);
pico Symbolp(pico);
pico Sysp(pico);
pico Tab(pico);
pico Tail(pico);
pico Tan(pico);
pico Terpri(pico);
pico Throw(pico);
pico pTime(void);
pico To(pico);
pico Toggle(pico);
pico TraceFun(pico);
pico Track(pico);
pico Trail(void);
pico Tty(pico);
pico Unless(pico);
pico UnPack(pico);
pico Until(pico);
pico Upc(pico);
pico Value(pico);
pico Varp(pico);
pico When(pico);
pico Where(pico);
pico While(pico);
pico Who(pico);
pico Wild(pico);
pico With(pico);
pico Worst(pico);
pico WriteBlock(pico);
pico Xchg(pico);
pico Zap(void);
pico Zero(pico);
pico Zerop(pico);
