/* picoPred.c
 * 30may90abu
 */

#include "pico.h"
#include "stack.h"

static bool match(pico,pico);
static pico picoUpc(pico);
static bool wild(pico,pico);

/* Check if 3 points lie on one line */
pico OnLine(x)
register pico x;
{
	register pico y;
	register double a,b,ax,ay,bx,by,cx,cy;

	y = EVAL1(x);
	needPoint(y);
	ax = (double)unBox(car(y));
	ay = (double)unBox(cdr(y));
	x = cdr(x);
	y = EVAL1(x);
	needPoint(y);
	bx = (double)unBox(car(y));
	by = (double)unBox(cdr(y));
	x = cdr(x);
	y = EVAL1(x);
	needPoint(y);
	cx = (double)unBox(car(y));
	cy = (double)unBox(cdr(y));
	a = distPt(ax,ay,bx,by);
	b = ((cx-ax)*(bx-ax) + (cy-ay)*(by-ay)) / distPt(ax,ay,cx,cy);
	/* Add epsilon for rounding error */
	return boxBool(sqrt(a*a - b*b + 0.000001) < 0.7072);
}

pico Stringp(x)
register pico x;
{
	x = EVAL1(x);
	if (isNum(x) || isSym(x) && !isNil(x))
		return nilSym;
	while (isCell(x)) {
		if (!isNum(car(x)))
			return nilSym;
		x = cdr(x);
	}
	return isNil(x)? tSym:nilSym;
}

pico Pointp(x)
register pico x;
{
	x = EVAL1(x);
	return (!isCell(x) || !isNum(car(x)) || !isNum(cdr(x))) ? nilSym:tSym;
}

pico Rectp(x)
register pico x;
{
	register pico y;

	x = EVAL1(x);
	return (!isCell(x) || !isCell(y = car(x)) || !isCell(cdr(x)) ||
				!isNum(car(y)) || !isNum(cdr(y)) || !isNum(cdr(car(x))) || !isNum(cdr(cdr(x))) )
		? nilSym:tSym;
}

bool match(p,d)
register pico p,d;
{
	register pico x;

	loop {
		if (!isCell(p) && !isCell(d))
			return p == d;
		if (!isCell(p))
			return NO;
		x = car(p);
		if (!isNum(x) && isSym(x) && firstChar(x)=='*') {
			if (!isCell(d)) {
				if (d == cdr(p)) {
					setVal(x, nilSym);
					return YES;
				}
				return NO;
			}
			if (match(cdr(p),cdr(d))) {
				setVal(x, newCell(car(d),nilSym));
				return YES;
			}
			if (match(cdr(p),d)) {
				setVal(x,nilSym);
				return YES;
			}
			if (match(p,cdr(d))) {
				setVal(x, newCell(car(d),val(x)));
				return YES;
			}
		}
		if (!isCell(d) || !(match(x,car(d))))
			return NO;
		p = cdr(p);
		d = cdr(d);
	}
}

pico Match(x)
register pico x;
{
	push(EVAL1(x));   /* Pattern */
	x = cdr(x);
	push(EVAL1(x));   /* Data */
	x  =  match(nos,tos)? tSym : nilSym;
	drop2();
	return x;
}

pico picoUpc(c)
register pico c;
{
	return (c<boxNum('a') || c>boxNum('z'))? c : (pico)(num(c)-(32<<2));
}

bool wild(p,d)
register pico p,d;
{
	loop {
		if (!isCell(p) && !isCell(d))
			return YES;
		if (!isCell(p))
			return NO;
		if (!isCell(d))
			return car(p) == boxNum('?') && !isCell(cdr(p));
		if (picoUpc(car(p)) != picoUpc(car(d)))
			break;
		p = cdr(p);
		d = cdr(d);
	}
	if (car(p) == boxNum('?'))
		return !isCell(cdr(p)) || wild(cdr(p),d) || wild(p,cdr(d));
	return NO;
}

pico Wild(x)
register pico x;
{
	push(EVAL1(x));    /* Pattern */
	x = EVAL1(cdr(x)); /* Data */
	return wild(pop(),x)? tSym : nilSym;
}

pico Member(x)
register pico x;
{
	register pico y;
	register number count;

	x = EVAL2(x,y);
	count = MAXLIST;
	while (isCell(y)) {
		if (equal(x,car(y)))
			return y;
		if (--count < 0)
			circError();
		y = cdr(y);
	}
	return nilSym;
}

pico Memq(x)
register pico x;
{
	register pico y;
	register number count;

	x = EVAL2(x,y);
	count = MAXLIST;
	while (isCell(y)) {
		if (x == car(y))
			return y;
		if (--count < 0)
			circError();
		y = cdr(y);
	}
	return nilSym;
}

pico Eq(x)
register pico x;
{
	register pico y;

	push(EVAL1(x));
	while (isCell(x = cdr(x)))
		if (tos != EVAL1(x)) {
			drop();
			return nilSym;
		}
	drop();
	return tSym;
}

pico Neq(x)
register pico x;
{
	register pico y;

	push(EVAL1(x));
	while (isCell(x = cdr(x)))
		if (tos != EVAL1(x)) {
			drop();
			return tSym;
		}
	drop();
	return nilSym;
}

pico Equal(x)
register pico x;
{
	register pico y;

	push(EVAL1(x));
	while (isCell(x = cdr(x)))
		if (!equal(tos,EVAL1(x))) {
			drop();
			return nilSym;
		}
	drop();
	return tSym;
}

pico Atom(x)
pico x;
{
	return isCell(EVAL1(x))? nilSym:tSym;
}

pico Pairp(x)
pico x;
{
	return isCell(EVAL1(x))? tSym:nilSym;
}

pico Listp(x)
register pico x;
{
	return isCell(x = EVAL1(x)) || isNil(x) ?  tSym : nilSym;
}

pico Numberp(x)
pico x;
{
	return isNum(EVAL1(x))? tSym:nilSym;
}

pico Symbolp(x)
register pico x;
{
	return (isNum(x=EVAL1(x)) || !isSym(x))? nilSym:tSym;
}

bool funp(x)
register pico x;
{
	register pico y;
	register number n;

	if (isNum(x))
		return (bool)(num(x) & 1);
	if (isSym(x))
		return NO;
	x = car(x);
	n = MAXLIST;
	while (isCell(x)) {
		if (isNum(y = car(x)) || isCell(y) || y<=tSym)
			return NO;
		if (--n < 0)
			circError();
		x = cdr(x);
	}
	return isNil(x) || !isNum(x) && x>tSym;
}

pico Funp(x)
register pico x;
{
	x = EVAL1(x);
	return funp(x)? tSym:nilSym;
}

pico Varp(x)
register pico x;
{
	if (isNum(x = EVAL1(x)) || !isSym(x))
		return nilSym;
	return (firstChar(x) == '*') ?  tSym : nilSym;
}

pico Sysp(x)
register pico x;
{
	if (isNum(x = EVAL1(x)) || !isSym(x))
		return nilSym;
	return (firstChar(x) == '$') ?  tSym : nilSym;
}

pico Boundp(x)
register pico x;
{
	x = EVAL1(x);
	NEEDSYM(x);
	return  val(x)==voidSym?  nilSym : tSym;
}

pico Zerop(x)
register pico x;
{
	return (isNum(x=EVAL1(x)) && isZero(x))? tSym:nilSym;
}

pico Minusp(x)
register pico x;
{
	return (isNum(x=EVAL1(x)) && unBox(x)<0)? tSym:nilSym;
}

pico Plusp(x)
register pico x;
{
	return (isNum(x=EVAL1(x)) && unBox(x)>0)? tSym:nilSym;
}

pico Lessp(x)
register pico x;
{
	register number n;
	register pico y;

	y = EVAL1(x);
	NEEDNUM(y);
	while (isCell(x = cdr(x))) {
		n = num(y);
		y = EVAL1(x);
		NEEDNUM(y);
		if (num(y) <= n)
			return nilSym;
	}
	return tSym;
}

pico Leq(x)
register pico x;
{
	register number n;
	register pico y;

	y = EVAL1(x);
	NEEDNUM(y);
	while (isCell(x = cdr(x))) {
		n = num(y);
		y = EVAL1(x);
		NEEDNUM(y);
		if (num(y) < n)
			return nilSym;
	}
	return tSym;
}
