/* picoSym.c
 * 14may90abu
 */

#include "pico.h"
#include "stack.h"

pico Pname(x)
register pico x;
{
	register pico y;
	register char *s;
	char buf[8];

	x = EVAL1(x);
	NEEDSYM(x);
	push(x = getPname(x));
	if (isNum(x)) {
		s = expShort(unBox(x), buf);
		push(y = newCell(boxNum(*s++), nilSym));
		while (*s) {
			setCdr(y, newCell(boxNum(*s++), nilSym));
			y = cdr(y);
		}
	}
	else {
		s = expShort(unBox(car(x)), buf);
		x = cdr(x);
		push(y = newCell(boxNum(*s++), nilSym));
		while (*s) {
			setCdr(y, newCell(boxNum(*s++), nilSym));
			y = cdr(y);
		}
		while (!isNum(x)) {
			s = expShort(unBox(car(x)), buf);
			x = cdr(x);
			while (*s) {
				setCdr(y, newCell(boxNum(*s++), nilSym));
				y = cdr(y);
			}
		}
		s = expShort(unBox(x), buf);
		while (*s) {
			setCdr(y, newCell(boxNum(*s++), nilSym));
			y = cdr(y);
		}
	}	
	x = pop();
	drop();
	return x;
}

pico Set(x)
register pico x;
{
	register pico sym;

	sym = EVAL2(x,x);
	NEEDSYM(sym);
	CHECKSYM(sym);
	return setVal(sym,clr(x));
}

pico Setq(x)
register pico x;
{
	register pico sym;

	do {
		sym = car(x);
		x = cdr(x);
		NEEDSYM(sym);
		CHECKSYM(sym);
		setVal(sym,clr(EVAL1(x)));
	} while (isCell(x = cdr(x)));
	return val(sym);
}

pico Xchg(x)
register pico x;
{
	register pico y,temp;

	y = car(x);
	NEEDSYM(y);
	CHECKSYM(y);
	x = car(cdr(x));
	NEEDSYM(x);
	CHECKSYM(x);
	temp = val(x);
	setVal(x, val(y));
	return setVal(y,temp);
}

pico Value(x)
register pico x;
{
	x = EVAL1(x);
	NEEDSYM(x);
	return val(x);
}

pico Off(x)
register pico x;
{
	register pico sym;

	do {
		sym = car(x);
		NEEDSYM(sym);
		CHECKSYM(sym);
		setVal(sym, nilSym);
	} while (isCell(x = cdr(x)));
	return nilSym;
}

pico On(x)
register pico x;
{
	register pico sym;

	do {
		sym = car(x);
		NEEDSYM(sym);
		CHECKSYM(sym);
		setVal(sym, tSym);
	} while (isCell(x = cdr(x)));
	return tSym;
}

pico Toggle(x)
register pico x;
{
	register pico sym;
	register pico res;

	do {
		sym = car(x);
		NEEDSYM(sym);
		CHECKSYM(sym);
		setVal(sym,  res = (val(sym) == nilSym)? tSym : nilSym);
	} while (isCell(x = cdr(x)));
	return res;
}

pico Default(x)
register pico x;
{
	register pico sym;

	do {
		sym = car(x);
		NEEDSYM(sym);
		CHECKSYM(sym);
		x = cdr(x);
		if (isNil(val(sym)) || val(sym)==voidSym)
			setVal(sym, EVAL1(x));
	} while (isCell(x = cdr(x)));
	return val(sym);
}

pico Push(x)
register pico x;
{
	register pico sym;

	sym = car(cdr(x));
	NEEDSYM(sym);
	CHECKSYM(sym);
	x = EVAL1(x);
	return setVal(sym, newCell(x,val(sym)));
}

pico Push1(x)
register pico x;
{
	register pico y, sym;

	sym = car(cdr(x));
	NEEDSYM(sym);
	CHECKSYM(sym);
	x = EVAL1(x);
	y = val(sym);
	while (isCell(y)) {
		if (equal(x, car(y)))
			return val(sym);
		y = cdr(y);
	}
	return setVal(sym, newCell(x,val(sym)));
}

pico Pop(x)
register pico x;
{
	register pico sym;

	sym = car(x);
	NEEDSYM(sym);
	if (isCell(x = val(sym))) {
		setVal(sym, cdr(val(sym)));
		return car(x);
	}
	return x;
}

pico Shift(x)
register pico x;
{
	register pico y, sym;
	register number n;

	sym = car(x);
	NEEDSYM(sym);
	if (!isCell(x = val(sym)))
		return x;
	if (!isCell(cdr(x))) {
		setVal(sym, cdr(x));
		return car(x);
	}
	n = MAXLIST;
	do {
		if (--n <= 0)
			circError();
		y = x;
	} while (isCell(cdr(x = cdr(x))));
	setCdr(y, cdr(x));
	return car(x);
}

pico Chop(x)
register pico x;
{
	register number n;
	register pico y, sym;

	n = num(EVAL1(x));
	NEEDNUM(n);
	if (!(n = unBox(n)))
		return nilSym;
	sym = car(cdr(x));
	NEEDSYM(sym);
	x = val(sym);
	NEEDCELL(x);
	push(y = newCell(car(x),nilSym));
	while (isCell(x = cdr(x))  &&  --n > 0) {
		setCdr(y, newCell(car(x),nilSym));
		y = cdr(y);
	}
	setVal(sym,x);
	return pop();
}

pico put(prop)
pico prop;
{
	register pico x, y, key;

	key = tos;
	x = nos;
	NEEDSYM(x);
	CHECKSYM(x);
	if (isNum(y = tail(x)) || !isCell(car(y))) {
		y = newCell(key,prop);
		setTail(x, newCell(y,tail(x)));
		return prop;
	}
	do {
		if (car(car(y)) == key)
			return setCdr(car(y),prop);
		x = y;
	} while (!isNum(y = cdr(x)) && isCell(car(y)));
	y = newCell(key,prop);
	setCdr(x, newCell(y,cdr(x)));
	return prop;
}

pico Put(x)
register pico x;
{
	push(EVAL1(x)); /* Sym */
	x = cdr(x);
	push(EVAL1(x)); /* Key */
	x = put(EVAL1(cdr(x)));
	drop2();
	return x;
}

pico Flag(x)
register pico x;
{
	register pico y, f;

	push(EVAL1(x)); /* Sym */
	f = EVAL1(cdr(x));
	x = tos;
	NEEDSYM(x);
	CHECKSYM(x);
	NEEDSYM(f);
	if (isNum(y = tail(x)) || isNum(car(y))) {
		setTail(x, newCell(f,y));
		drop();
		return f;
	}
	while (!isNum(x = cdr(y)) && isCell(car(x)))
		y = x;
	while (!isNum(x = cdr(y)) && !isNum(car(x))) {
		if (car(x) == f) {
			drop();
			return f;
		}
		y = x;
	}
	setCdr(y, newCell(f,x));
	drop();
	return f;
}

pico get(x,key)
register pico x,key;
{
	NEEDSYM(x);
	x = tail(x);
	while (!isNum(x) && isCell(car(x))) {
		if (car(car(x)) == key)
			return cdr(car(x));
		x = cdr(x);
	}
	return nilSym;
}

pico Get(x)
register pico x;
{
	register pico y;

	push(EVAL1(x));
	x = cdr(x);
	y = EVAL1(x);
	while (isCell(x = cdr(x))) {
		tos = get(tos,y);
		y = EVAL1(x);
	}
	x = pop();
	return get(x,y);
}

pico Flagp(x)
register pico x;
{
	register pico f;

	push(EVAL1(x));
	f = EVAL1(cdr(x));
	x = pop();
	NEEDSYM(x);
	NEEDSYM(f);
	x = tail(x);
	while (!isNum(x) && isCell(car(x)))
		x = cdr(x);
	while (!isNum(x) && !isNum(car(x))) {
		if (car(x) == f)
			return tSym;
		x = cdr(x);
	}
	return nilSym;
}

pico plist(x)
register pico x;
{
	register pico y;

	NEEDSYM(x);
	if (isNum(x = tail(x)) || !isCell(car(x)))
		return nilSym;
	push(x);
	push(y = newCell(car(x),nilSym));
	while (!isNum(x = cdr(x)) && isCell(car(x))) {
		setCdr(y, newCell(car(x),nilSym));
		y = cdr(y);
	}
	x = pop();
	drop();
	return x;
}

pico Plist(x)
pico x;
{
	return plist(EVAL1(x));
}

pico Flags(x)
register pico x;
{
	register pico y;

	x = EVAL1(x);
	NEEDSYM(x);
	x = tail(x);
	while (!isNum(x) && isCell(car(x)))
		x = cdr(x);
	if (isNum(x) || isNum(car(x)))
		return nilSym;
	push(x);
	push(y = newCell(car(x),nilSym));
	while (!isNum(x = cdr(x)) && !isNum(car(x))) {
		setCdr(y, newCell(car(x),nilSym));
		y = cdr(y);
	}
	x = pop();
	drop();
	return x;
}

void setPlist(x,list)
register pico x,list;
{
	register pico y;

	NEEDSYM(x);
	CHECKSYM(x);
	NEEDLIST(list);
	list = copy(list);
	y = tail(x);
	while (!isNum(y) && isCell(car(y)))
		y = cdr(y);
	if (!isCell(list))
		setTail(x,y);
	else {
		setTail(x,list);
		while (isCell(cdr(list)))
			list = cdr(list);
		setCdr(list,y);
	}
}

pico Setplist(x)
register pico x;
{
	register pico list;

	push(EVAL1(x));		/* Symbol */
	x = cdr(x);
	list = EVAL1(x);	/* Plist */
	setPlist(tos,list);
	drop();
	return list;
}

void setFlags(x,list)
register pico x,list;
{
	register pico y;

	NEEDSYM(x);
	CHECKSYM(x);
	NEEDLIST(list);
	list = copy(list);
	if (isNum(y = tail(x)) || isNum(car(y))) {
		if (isCell(list)) {
			setTail(x,list);
			while (isCell(cdr(list)))
				list = cdr(list);
			setCdr(list,y);
		}
		return;
	}
	while (!isNum(x = cdr(y)) && isCell(car(x)))
		y = x;
	while (!isNum(x) && !isNum(car(x)))
		x = cdr(x);
	if (!isCell(list))
		setCdr(y,x);
	else {
		setCdr(y,list);
		while (isCell(cdr(list)))
			list = cdr(list);
		setCdr(list,x);
	}
}

pico SetFlags(x)
register pico x;
{
	register pico list;

	push(EVAL1(x));		/* Symbol */
	x = cdr(x);
	list = EVAL1(x);	/* Flags */
	setFlags(tos,list);
	drop();
	return list;
}

pico Remove(x)
register pico x;
{
	register pico y,z;

	push(EVAL1(x));
	y = EVAL1(cdr(x));
	x = pop();
	NEEDSYM(x);
	if (isNum(z = tail(x)) || isNum(car(z)))
		return nilSym;
	if (car(z) == y) {
		setTail(x,cdr(z));
		return y;
	}
	while (!isNum(x = cdr(z)) && !isNum(car(x))) {
		if (car(x) == y) {
			setCdr(z,cdr(x));
			return y;
		}
		z = x;
	}
	return nilSym;
}
